/*
 * Decompiled with CFR 0.152.
 */
package com.ximad.zuminja.component;

import com.ximad.zuminja.component.Bitmap;
import com.ximad.zuminja.engine.Application;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public abstract class Screen {
    public void onShow() {
        Screen.repaint();
    }

    public void onHide() {
    }

    public void onPaint(Graphics g) {
    }

    public void onIdle() {
        Screen.sleep(150L);
    }

    public void onKeyPressed(int keyCode) {
    }

    public void onKeyReleased(int keyCode) {
    }

    public void onKeyRepeated(int keyCode) {
    }

    protected void onPointerPressed(int x, int y) {
    }

    protected void onPointerReleased(int x, int y) {
    }

    protected void onPointerDragged(int x, int y) {
    }

    public static void repaint() {
        Application.canvas.repaint();
    }

    public Bitmap takeScreenshot() {
        Image fon = Image.createImage((int)Application.screenWidth, (int)Application.screenHeight);
        Graphics g = fon.getGraphics();
        this.onPaint(g);
        return new Bitmap(fon);
    }

    public static void sleep(long ms) {
        try {
            Thread.sleep(ms);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

