/*
 * Decompiled with CFR 0.152.
 */
package com.ximad.zuminja.engine;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import javax.microedition.rms.RecordEnumeration;
import javax.microedition.rms.RecordStore;
import javax.microedition.rms.RecordStoreException;

public class AppSettings {
    private byte[] cache = new byte[0];
    private String key;
    private ByteArrayInputStream bais;
    private DataInputStream is;
    private ByteArrayOutputStream baos;
    private DataOutputStream os;

    public void init(String key) {
        this.key = key;
    }

    public int readInt(int defaultValue) {
        try {
            return this.is.readInt();
        }
        catch (Exception e) {
            return defaultValue;
        }
    }

    public double readDouble(double defaultValue) {
        try {
            return this.is.readDouble();
        }
        catch (Exception e) {
            return defaultValue;
        }
    }

    public boolean[] readBooleanArray(int size) {
        boolean[] array = new boolean[size];
        try {
            for (int i = 0; i < size; ++i) {
                array[i] = this.readBoolean(false);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return array;
    }

    public int[] readIntArray(int size) {
        int[] array = new int[size];
        try {
            for (int i = 0; i < size; ++i) {
                array[i] = this.readInt(0);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return array;
    }

    public double[] readDoubleArray(int size) {
        double[] array = new double[size];
        try {
            for (int i = 0; i < size; ++i) {
                array[i] = this.readDouble(0.0);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return array;
    }

    public boolean readBoolean(boolean defaultValue) {
        boolean k;
        try {
            k = this.is.readBoolean();
        }
        catch (Exception e) {
            k = defaultValue;
        }
        return k;
    }

    public long readLong(long defaultValue) {
        try {
            return this.is.readLong();
        }
        catch (Exception e) {
            return defaultValue;
        }
    }

    public long[] readLongArray(int size) {
        long[] array = new long[size];
        try {
            for (int i = 0; i < size; ++i) {
                array[i] = this.readLong(0L);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return array;
    }

    public String readUTF(String defaultValue) {
        try {
            return this.is.readUTF();
        }
        catch (Exception e) {
            return defaultValue;
        }
    }

    public String[] readStringArray(int size, String defaultValue) {
        String[] array = new String[size];
        try {
            for (int i = 0; i < size; ++i) {
                array[i] = this.readUTF(defaultValue);
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        return array;
    }

    public void writeInt(int data) {
        try {
            this.os.writeInt(data);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void writeDouble(double data) {
        try {
            this.os.writeDouble(data);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void writeLong(long data) {
        try {
            this.os.writeLong(data);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void writeBoolean(boolean data) {
        try {
            this.os.writeBoolean(data);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void writeUTF(String data) {
        try {
            this.os.writeUTF(data);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void writeStringArray(String[] array, int size) {
        try {
            for (int i = 0; i < size; ++i) {
                this.os.writeUTF(array[i]);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void writeDoubleArray(double[] array, int size) {
        try {
            for (int i = 0; i < size; ++i) {
                this.os.writeDouble(array[i]);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void writeIntArray(int[] array, int size) {
        try {
            for (int i = 0; i < size; ++i) {
                this.os.writeInt(array[i]);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void writeLongArray(long[] array, int size) {
        try {
            for (int i = 0; i < size; ++i) {
                this.os.writeLong(array[i]);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void writeBooleanArray(boolean[] array, int size) {
        try {
            for (int i = 0; i < size; ++i) {
                this.os.writeBoolean(array[i]);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void start() {
        try {
            RecordStore rms = RecordStore.openRecordStore((String)this.key, (boolean)true);
            try {
                RecordEnumeration re = rms.enumerateRecords(null, null, false);
                if (re.hasNextElement()) {
                    this.cache = re.nextRecord();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            rms.closeRecordStore();
            this.bais = new ByteArrayInputStream(this.cache);
            this.is = new DataInputStream(this.bais);
            this.baos = new ByteArrayOutputStream();
            this.os = new DataOutputStream(this.baos);
        }
        catch (Exception rse) {
            System.out.println("!! error in AppSettings.init() : " + rse.getMessage());
        }
    }

    public boolean isElementExists(String key) {
        boolean result = false;
        try {
            RecordStore rms = RecordStore.openRecordStore((String)key, (boolean)true);
            RecordEnumeration re = rms.enumerateRecords(null, null, false);
            result = re.hasNextElement();
            rms.closeRecordStore();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return result;
    }

    public void removeElement(String key) {
        try {
            RecordStore rms = RecordStore.openRecordStore((String)key, (boolean)true);
            RecordEnumeration re = rms.enumerateRecords(null, null, false);
            while (re.hasNextElement()) {
                rms.deleteRecord(re.nextRecordId());
            }
            rms.closeRecordStore();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void commit() {
        try {
            RecordStore rms = RecordStore.openRecordStore((String)this.key, (boolean)true);
            try {
                RecordEnumeration re = rms.enumerateRecords(null, null, false);
                while (re.hasNextElement()) {
                    rms.deleteRecord(re.nextRecordId());
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.cache = this.baos.toByteArray();
            rms.addRecord(this.cache, 0, this.cache.length);
            rms.closeRecordStore();
        }
        catch (RecordStoreException rse) {
            System.out.println("!! error in AppSettings.commit : ()" + rse.getMessage());
        }
    }
}

