/*
 * Decompiled with CFR 0.152.
 */
package com.ximad.zuminja.screen;

import com.ximad.zuminja.component.Bitmap;
import com.ximad.zuminja.component.CustomButton;
import com.ximad.zuminja.component.Screen;
import com.ximad.zuminja.component.UiScreen;
import com.ximad.zuminja.engine.Application;
import com.ximad.zuminja.engine.Consts;
import com.ximad.zuminja.engine.DataManager;
import com.ximad.zuminja.engine.Resources;
import com.ximad.zuminja.game.Ball;
import com.ximad.zuminja.game.FlyingBall;
import com.ximad.zuminja.game.Game;
import com.ximad.zuminja.game.GameThread;
import com.ximad.zuminja.game.Launcher;
import com.ximad.zuminja.game.Level;
import com.ximad.zuminja.game.PackedGame;
import com.ximad.zuminja.game.Path;
import com.ximad.zuminja.game.Point;
import com.ximad.zuminja.game.Track;
import com.ximad.zuminja.screen.MainMenuScreen;
import java.util.Timer;
import java.util.TimerTask;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;

public class GameScreen
extends UiScreen {
    Game game;
    Path path;
    Bitmap onImage;
    Bitmap offImage;
    CustomButton menuBtn;
    CustomButton soundBtn;
    CustomButton fakeBtn;
    GameThread mainThread;
    Timer timer;
    private long timeForDebug = 0L;
    private long currentTime = 0L;
    private long startTime = -1L;
    private long tick = 0L;
    private boolean repainted = true;
    private long systemTime = System.currentTimeMillis();
    int gameIdentifier;

    public void soundClick() {
        if (System.currentTimeMillis() - this.systemTime <= 500L) {
            return;
        }
        this.systemTime = System.currentTimeMillis();
        DataManager.setSoundState(!DataManager.getSoundState());
        if (DataManager.getSoundState()) {
            this.soundBtn.setOffImage(this.onImage);
            if (!this.game.isFinished()) {
                DataManager.playGameSound(this.game.getLevel() / 5);
            }
        } else {
            this.soundBtn.setOffImage(this.offImage);
        }
    }

    public void menuClick() {
        this.finalize();
        if (this.game.isFinished()) {
            this.game.endLevel();
            return;
        }
        this.saveGame(false);
        Application.setScreen(new MainMenuScreen());
    }

    public GameScreen(boolean loadLevel, int level) {
        this.onImage = Resources.gameSoundOn;
        this.offImage = Resources.gameSoundOff;
        this.game = new Game(loadLevel, this, level);
        this.path = this.game.getPath();
        this.mainThread = new GameThread();
        this.mainThread.start();
        this.menuBtn = new CustomButton(Resources.gameMenuButtonOff, Resources.gameMenuButtonOn, null){

            public void touchAction() {
                GameScreen.this.menuClick();
            }
        };
        this.soundBtn = new CustomButton(Resources.gameSoundOff, Resources.gameSoundOn, null){

            public void touchAction() {
                GameScreen.this.soundClick();
            }
        };
        if (DataManager.getSoundState()) {
            this.soundBtn.setOffImage(this.onImage);
        }
        this.add(this.soundBtn, 3, 1);
        this.add(this.menuBtn, -2, 587);
        this.timer = new Timer();
        this.timer.schedule(new TimerTask(){

            public void run() {
                GameScreen.this.mainThread.invokeLater(new Runnable(){

                    public void run() {
                        if (!Application.foreground) {
                            return;
                        }
                        if (GameScreen.this.startTime == -1L) {
                            GameScreen.this.startTime = System.currentTimeMillis();
                            GameScreen.this.tick = 0L;
                        }
                        (this).GameScreen.this.game.tick();
                        GameScreen.this.tick++;
                        GameScreen.this.currentTime = System.currentTimeMillis();
                        if (!(this).GameScreen.this.mainThread.eventsCount()) {
                            Screen.repaint();
                        }
                        if ((this).GameScreen.this.game.isStopped()) {
                            try {
                                (this).GameScreen.this.timer.cancel();
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                        }
                    }
                });
            }
        }, 40L, 40L);
        this.backgroundBitmap = DataManager.getLevelWithBackgroundAt(this.game.getLevel()).getBackground();
        DataManager.playGameSound(this.game.getLevel() / 5);
    }

    public void onPaint(Graphics g) {
        Ball testBall;
        super.onPaint(g);
        g.setColor(0xFFFFFF);
        Bitmap ballBitmap = null;
        for (int trackIndex = 0; trackIndex < this.game.getTracksCount(); ++trackIndex) {
            Track game = this.game.getTrack(trackIndex);
            Level thisLevel = DataManager.getLevelWithBackgroundAt(this.game.getLevel()).getLevel(trackIndex);
            if (game.getPortalState() != -1) {
                Bitmap portal = Resources.getPortalEnd(game.getPortalState());
                portal.draw(g, game.getLastPoint().x - portal.getWidth() / 2, game.getLastPoint().y - portal.getHeight() / 2);
            }
            for (int i = 0; !(i >= game.getBallsCount() || game.getBallsCount() <= 1 && game.finishSpeed >= 0.0); ++i) {
                testBall = game.getBall(i);
                if (!testBall.isVisible() || !thisLevel.isInDeathZone(testBall.getCurrentX()) || (ballBitmap = testBall.getBallImage()) == null) continue;
                ballBitmap.draw(g, testBall.getCX() - ballBitmap.getWidth() / 2, testBall.getCY() - ballBitmap.getHeight() / 2);
                if (testBall.getBonus() == -1 || testBall.getState() != -1) continue;
                ballBitmap = Resources.bonus[testBall.getBonus()][Consts.BONUS_FRAMES_COUNT[testBall.getBonus()] - 1 - testBall.getBonusTick() / 2 % Consts.BONUS_FRAMES_COUNT[testBall.getBonus()]];
                ballBitmap.draw(g, testBall.getCX() - ballBitmap.getWidth() / 2, testBall.getCY() - ballBitmap.getHeight() / 2);
            }
            if (game.getBridgeIndex() != -1) {
                Bitmap bridge = Resources.bridges[game.getBridgeIndex()];
                bridge.draw(g, game.getBridgePoint().x, game.getBridgePoint().y);
            }
            for (int i = 0; !(i >= game.getBallsCount() || game.getBallsCount() <= 1 && game.finishSpeed >= 0.0); ++i) {
                testBall = game.getBall(i);
                if (!testBall.isVisible() || thisLevel.isInDeathZone(testBall.getCurrentX()) || (ballBitmap = testBall.getBallImage()) == null) continue;
                ballBitmap.draw(g, testBall.getCX() - ballBitmap.getWidth() / 2, testBall.getCY() - ballBitmap.getHeight() / 2);
                if (testBall.getBonus() == -1 || testBall.getState() != -1) continue;
                ballBitmap = Resources.bonus[testBall.getBonus()][Consts.BONUS_FRAMES_COUNT[testBall.getBonus()] - 1 - testBall.getBonusTick() / 2 % Consts.BONUS_FRAMES_COUNT[testBall.getBonus()]];
                ballBitmap.draw(g, testBall.getCX() - ballBitmap.getWidth() / 2, testBall.getCY() - ballBitmap.getHeight() / 2);
            }
            Bitmap pipeBmp = Resources.pipes[game.getPipeIndex()];
            pipeBmp.draw(g, game.getPipePoint().x, game.getPipePoint().y);
        }
        Launcher launcher = this.game.getLauncher();
        int angle = (launcher.getAngle() + 353) % 360;
        int angle90 = 5 - angle % 90 / 15;
        Resources.getGun(angle90).drawRotatedCenterWithFix(g, launcher.getCanonPoint().x, launcher.getCanonPoint().y, angle / 90 * 90);
        testBall = launcher.getCurrentBall();
        if (testBall != null) {
            ballBitmap = Resources.getFlyingBallImage(testBall.getType());
            int distance = (launcher.getBallPoint().x - launcher.getPoint().x) * (launcher.getBallPoint().x - launcher.getPoint().x) + (launcher.getBallPoint().y - launcher.getPoint().y) * (launcher.getBallPoint().y - launcher.getPoint().y);
            if (distance > 10) {
                ballBitmap.draw(g, launcher.getBallPoint().x - ballBitmap.getWidth() / 2, launcher.getBallPoint().y - ballBitmap.getHeight() / 2);
            }
        }
        testBall = launcher.getNextBall();
        ballBitmap = Resources.getBallImage(testBall.getType());
        ballBitmap.draw(g, launcher.getPoint().x - ballBitmap.getWidth() / 2, launcher.getPoint().y - ballBitmap.getHeight() / 2);
        Resources.getOpenGun(angle90).drawRotatedCenterWithFix(g, launcher.getCanonPoint().x, launcher.getCanonPoint().y, angle / 90 * 90);
        if (this.game.getGunExplodeFrame() != -1) {
            Resources.gunExplode[this.game.getGunExplodeFrame()].drawRotatedCenter(g, launcher.getPoint().x, launcher.getPoint().y, angle / 90 * 90);
        }
        Bitmap bmp = Resources.getBallImage(launcher.getNextBallType());
        bmp.draw(g, 312 - bmp.getWidth() / 2, 39 - bmp.getHeight() / 2);
        String score = String.valueOf(this.game.getScore());
        g.setFont(Font.getFont((int)0, (int)0, (int)16));
        g.drawString(score, 166, 7, 17);
        Bitmap x2 = Resources.x2Bonus;
        if (this.game.getX2Tick() != 0) {
            x2.draw(g, 319, 162);
        }
        Bitmap slow = Resources.pauseBonus;
        if (this.game.getSlowTick() != 0) {
            slow.draw(g, 319, 93);
        }
        int color = 0xFFFFFF;
        if (this.game.getLifesLeftTick() % 10 < 5) {
            g.setFont(Font.getFont((int)0, (int)0, (int)8));
            g.drawString("" + this.game.getLifesCount(), 246, 11, 17);
        }
        g.setColor(0xFFFFFF);
    }

    protected void onPointerReleased(final int x, final int y) {
        if (x >= -2 && x <= -2 + this.menuBtn.getWidth() && y >= 587 && y <= 587 + this.menuBtn.getHeight() || x >= 3 && x <= 3 + this.soundBtn.getWidth() && y >= 1 && y <= 1 + this.soundBtn.getHeight()) {
            super.onPointerReleased(x, y);
            return;
        }
        this.mainThread.invokeLater(new Runnable(){

            public void run() {
                GameScreen.this.game.launchBall(new Point(x, y));
            }
        });
        super.onPointerReleased(x, y);
    }

    public void saveGame(boolean continueGame) {
        int nextNextBallType;
        int nextBallType;
        int currentBallType;
        boolean[] endedLevels = this.game.getEndedLevels();
        int tracksCount = this.game.getTracksCount();
        int[] ballsLeft = new int[tracksCount];
        int[] ballsCount = new int[tracksCount];
        int ballsTotal = 0;
        for (int i = 0; i < tracksCount; ++i) {
            ballsLeft[i] = this.game.getTrack(i).getBallsLeft();
            ballsCount[i] = this.game.getTrack(i).getBallsCount();
            ballsTotal += ballsCount[i];
        }
        double[] coords = new double[ballsTotal];
        int[] types = new int[ballsTotal];
        int[] states = new int[ballsTotal];
        boolean[] movable = new boolean[ballsTotal];
        boolean[] visible = new boolean[ballsTotal];
        int[] bonus = new int[ballsTotal];
        int[] bonusTick = new int[ballsTotal];
        int add = 0;
        for (int track = 0; track < tracksCount; ++track) {
            for (int i = 0; i < this.game.getTrack(track).getBallsCount(); ++i) {
                types[add + i] = this.game.getTrack(track).getBall(i).getType();
                coords[add + i] = this.game.getTrack(track).getBall(i).getCurrentX();
                states[add + i] = this.game.getTrack(track).getBall(i).getState();
                visible[add + i] = this.game.getTrack(track).getBall(i).isVisible();
                movable[add + i] = this.game.getTrack(track).getBall(i).isMovable();
                bonus[add + i] = this.game.getTrack(track).getBall(i).getBonus();
                bonusTick[add + i] = this.game.getTrack(track).getBall(i).getBonusTick();
            }
            add += this.game.getTrack(track).getBallsCount();
        }
        FlyingBall nextBall = this.game.getLauncher().getNextBall();
        FlyingBall currentBall = this.game.getLauncher().getCurrentBall();
        if (currentBall != null) {
            currentBallType = currentBall.getType();
            nextBallType = nextBall.getType();
            nextNextBallType = this.game.getLauncher().getNextBallType();
        } else {
            currentBallType = nextBall.getType();
            nextBallType = this.game.getLauncher().getNextBallType();
            nextNextBallType = -1;
        }
        PackedGame game = new PackedGame(coords, types, states, visible, movable, tracksCount, ballsLeft, ballsCount, currentBallType, nextBallType, nextNextBallType, this.game.getScore(), this.game.getLevel(), endedLevels, this.game.getDeep(), bonus, bonusTick, this.game.getBonusAddTick(), this.game.getSlowTick(), this.game.getX2Tick(), this.game.getLifesCount(), continueGame);
        DataManager.saveLevel(game);
    }

    public void finalize() {
        try {
            this.game.finalize();
            this.timer.cancel();
            this.mainThread.stop();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void invokeLater(Runnable runnable) {
        this.mainThread.invokeLater(runnable);
    }
}

