/*
 * Decompiled with CFR 0.152.
 */
package com.ximad.zuminja.screen;

import com.ximad.zuminja.component.BitmapField;
import com.ximad.zuminja.component.CustomButton;
import com.ximad.zuminja.component.UiScreen;
import com.ximad.zuminja.engine.DataManager;
import com.ximad.zuminja.engine.Resources;
import com.ximad.zuminja.screen.ConfirmScreen;
import com.ximad.zuminja.screen.MainMenuScreen;

public class SettingsScreen
extends UiScreen {
    CustomButton backButton;
    CustomButton soundOffButton;
    CustomButton soundOnButton;
    CustomButton resetScoreButton;
    BitmapField soundOff;
    BitmapField soundOn;
    BitmapField settingsField;

    public void menuClick() {
        this.openScreen(new MainMenuScreen());
    }

    public void soundOff() {
        DataManager.setSoundState(false);
        this.soundOnButton.set_btn_state(true);
        this.soundOffButton.set_btn_state(false);
        this.soundOnButton.setCheckState(false);
        this.soundOffButton.setCheckState(true);
    }

    public void soundOn() {
        DataManager.setSoundState(true);
        this.soundOnButton.set_btn_state(false);
        this.soundOffButton.set_btn_state(true);
        this.soundOnButton.setCheckState(true);
        this.soundOffButton.setCheckState(false);
    }

    public void resetScore() {
        this.openScreen(new ConfirmScreen(Resources.confirmResetScores, 304){

            public void yesClick() {
                DataManager.resetScores();
                this.openScreen(new SettingsScreen());
            }

            public boolean onClose() {
                this.openScreen(new SettingsScreen());
                return false;
            }

            public void noClick() {
                this.openScreen(new SettingsScreen());
            }
        });
    }

    public SettingsScreen() {
        this.backgroundBitmap = Resources.getSettingsBackground();
        this.backButton = new CustomButton(Resources.menuBackOff, Resources.menuBackOn, null){

            protected void touchAction() {
                SettingsScreen.this.openScreen(new MainMenuScreen());
            }
        };
        this.soundOffButton = new CustomButton(Resources.soundOffOff, Resources.soundOffOn, null, Resources.soundOffUn){

            public void touchAction() {
                SettingsScreen.this.soundOff();
            }
        };
        this.soundOnButton = new CustomButton(Resources.soundOnOff, Resources.soundOnOn, null, Resources.soundOnUn){

            public void touchAction() {
                SettingsScreen.this.soundOn();
            }
        };
        this.resetScoreButton = new CustomButton(Resources.resetScoresOff, Resources.resetScoresOn, null, null){

            public void touchAction() {
                SettingsScreen.this.resetScore();
            }
        };
        if (DataManager.getSoundState()) {
            this.soundOnButton.set_btn_state(false);
            this.soundOnButton.setCheckState(true);
        } else {
            this.soundOffButton.set_btn_state(false);
            this.soundOffButton.setCheckState(true);
        }
        this.add(this.soundOffButton, (360 - this.soundOffButton.getWidth()) / 2, 257);
        this.add(this.soundOnButton, (360 - this.soundOnButton.getWidth()) / 2, 292);
        this.add(this.resetScoreButton, (360 - this.resetScoreButton.getWidth()) / 2, 348);
        this.add(this.backButton, 139, 437);
    }
}

