/*
 * Decompiled with CFR 0.152.
 */
package se.krka.kahlua.stdlib;

import se.krka.kahlua.vm.JavaFunction;
import se.krka.kahlua.vm.LuaCallFrame;
import se.krka.kahlua.vm.LuaClosure;
import se.krka.kahlua.vm.LuaException;
import se.krka.kahlua.vm.LuaPrototype;
import se.krka.kahlua.vm.LuaState;
import se.krka.kahlua.vm.LuaTable;
import se.krka.kahlua.vm.LuaThread;

public final class BaseLib
implements JavaFunction {
    private static final Runtime RUNTIME = Runtime.getRuntime();
    private static final int PCALL = 0;
    private static final int PRINT = 1;
    private static final int SELECT = 2;
    private static final int TYPE = 3;
    private static final int TOSTRING = 4;
    private static final int TONUMBER = 5;
    private static final int GETMETATABLE = 6;
    private static final int SETMETATABLE = 7;
    private static final int ERROR = 8;
    private static final int UNPACK = 9;
    private static final int NEXT = 10;
    private static final int SETFENV = 11;
    private static final int GETFENV = 12;
    private static final int RAWEQUAL = 13;
    private static final int RAWSET = 14;
    private static final int RAWGET = 15;
    private static final int COLLECTGARBAGE = 16;
    private static final int DEBUGSTACKTRACE = 17;
    private static final int BYTECODELOADER = 18;
    private static final int NUM_FUNCTIONS = 19;
    private static final String[] names;
    private static final Object MODE_KEY;
    private static final Object INTEGER_ONE;
    public static final String TYPE_NIL = "nil";
    public static final String TYPE_STRING = "string";
    public static final String TYPE_NUMBER = "number";
    public static final String TYPE_BOOLEAN = "boolean";
    public static final String TYPE_FUNCTION = "function";
    public static final String TYPE_TABLE = "table";
    public static final String TYPE_THREAD = "thread";
    public static final String TYPE_USERDATA = "userdata";
    private int index;
    private static BaseLib[] functions;

    public BaseLib(int index) {
        this.index = index;
    }

    public static void register(LuaState state) {
        BaseLib.initFunctions();
        for (int i2 = 0; i2 < 19; ++i2) {
            state.getEnvironment().rawset(names[i2], (Object)functions[i2]);
        }
    }

    private static synchronized void initFunctions() {
        if (functions == null) {
            functions = new BaseLib[19];
            for (int i2 = 0; i2 < 19; ++i2) {
                BaseLib.functions[i2] = new BaseLib(i2);
            }
        }
    }

    public String toString() {
        return names[this.index];
    }

    public int call(LuaCallFrame callFrame, int nArguments) {
        switch (this.index) {
            case 0: {
                return BaseLib.pcall(callFrame, nArguments);
            }
            case 1: {
                return BaseLib.print(callFrame, nArguments);
            }
            case 2: {
                return BaseLib.select(callFrame, nArguments);
            }
            case 3: {
                return BaseLib.type(callFrame, nArguments);
            }
            case 4: {
                return BaseLib.tostring(callFrame, nArguments);
            }
            case 5: {
                return BaseLib.tonumber(callFrame, nArguments);
            }
            case 6: {
                return BaseLib.getmetatable(callFrame, nArguments);
            }
            case 7: {
                return BaseLib.setmetatable(callFrame, nArguments);
            }
            case 8: {
                return this.error(callFrame, nArguments);
            }
            case 9: {
                return this.unpack(callFrame, nArguments);
            }
            case 10: {
                return this.next(callFrame, nArguments);
            }
            case 11: {
                return this.setfenv(callFrame, nArguments);
            }
            case 12: {
                return this.getfenv(callFrame, nArguments);
            }
            case 13: {
                return this.rawequal(callFrame, nArguments);
            }
            case 14: {
                return this.rawset(callFrame, nArguments);
            }
            case 15: {
                return this.rawget(callFrame, nArguments);
            }
            case 16: {
                return BaseLib.collectgarbage(callFrame, nArguments);
            }
            case 17: {
                return this.debugstacktrace(callFrame, nArguments);
            }
            case 18: {
                return BaseLib.bytecodeloader(callFrame, nArguments);
            }
        }
        return 0;
    }

    private int debugstacktrace(LuaCallFrame callFrame, int nArguments) {
        LuaThread thread = (LuaThread)BaseLib.getOptArg(callFrame, 1, TYPE_THREAD);
        if (thread == null) {
            thread = callFrame.thread;
        }
        Integer levelInteger = (Integer)BaseLib.getOptArg(callFrame, 2, TYPE_NUMBER);
        int level = 0;
        if (levelInteger != null) {
            level = levelInteger;
        }
        Integer countInteger = (Integer)BaseLib.getOptArg(callFrame, 3, TYPE_NUMBER);
        int count = Integer.MAX_VALUE;
        if (countInteger != null) {
            count = countInteger;
        }
        Integer haltAtInteger = (Integer)BaseLib.getOptArg(callFrame, 4, TYPE_NUMBER);
        int haltAt = 0;
        if (haltAtInteger != null) {
            haltAt = haltAtInteger;
        }
        return callFrame.push(thread.getCurrentStackTrace(level, count, haltAt));
    }

    private int rawget(LuaCallFrame callFrame, int nArguments) {
        BaseLib.luaAssert(nArguments >= 2, "Not enough arguments");
        LuaTable t = (LuaTable)callFrame.get(0);
        Object key = callFrame.get(1);
        callFrame.push(t.rawget(key));
        return 1;
    }

    private int rawset(LuaCallFrame callFrame, int nArguments) {
        BaseLib.luaAssert(nArguments >= 3, "Not enough arguments");
        LuaTable t = (LuaTable)callFrame.get(0);
        Object key = callFrame.get(1);
        Object value = callFrame.get(2);
        t.rawset(key, value);
        callFrame.setTop(1);
        return 1;
    }

    private int rawequal(LuaCallFrame callFrame, int nArguments) {
        BaseLib.luaAssert(nArguments >= 2, "Not enough arguments");
        Object o1 = callFrame.get(0);
        Object o2 = callFrame.get(1);
        callFrame.push(BaseLib.toBoolean(LuaState.luaEquals(o1, o2)));
        return 1;
    }

    private static final Boolean toBoolean(boolean b2) {
        if (b2) {
            return LuaPrototype.bTRUE;
        }
        return LuaPrototype.bFALSE;
    }

    private int setfenv(LuaCallFrame callFrame, int nArguments) {
        BaseLib.luaAssert(nArguments >= 2, "Not enough arguments");
        LuaTable newEnv = (LuaTable)callFrame.get(1);
        BaseLib.luaAssert(newEnv != null, "expected a table");
        LuaClosure closure = null;
        Object o2 = callFrame.get(0);
        if (o2 instanceof LuaClosure) {
            closure = (LuaClosure)o2;
        } else {
            BaseLib.luaAssert((o2 = BaseLib.rawTonumber(o2)) != null, "expected a lua function or a number");
            int level = (Integer)o2;
            if (level == 0) {
                callFrame.thread.environment = newEnv;
                return 0;
            }
            LuaCallFrame parentCallFrame = callFrame.thread.getParent(level);
            if (!parentCallFrame.isLua()) {
                BaseLib.fail("No closure found at this level: " + level);
            }
            closure = parentCallFrame.closure;
        }
        closure.env = newEnv;
        callFrame.setTop(1);
        return 1;
    }

    private int getfenv(LuaCallFrame callFrame, int nArguments) {
        Object o2 = INTEGER_ONE;
        if (nArguments >= 1) {
            o2 = callFrame.get(0);
        }
        LuaTable res = null;
        if (o2 == null || o2 instanceof JavaFunction) {
            res = callFrame.thread.environment;
        } else if (o2 instanceof LuaClosure) {
            LuaClosure closure = (LuaClosure)o2;
            res = closure.env;
        } else {
            Integer d2 = BaseLib.rawTonumber(o2);
            BaseLib.luaAssert(d2 != null, "Expected number");
            int level = d2;
            BaseLib.luaAssert(level >= 0, "level must be non-negative");
            LuaCallFrame callFrame2 = callFrame.thread.getParent(level);
            res = callFrame2.getEnvironment();
        }
        callFrame.push(res);
        return 1;
    }

    private int next(LuaCallFrame callFrame, int nArguments) {
        Object nextKey;
        BaseLib.luaAssert(nArguments >= 1, "Not enough arguments");
        LuaTable t = (LuaTable)callFrame.get(0);
        Object key = null;
        if (nArguments >= 2) {
            key = callFrame.get(1);
        }
        if ((nextKey = t.next(key)) == null) {
            callFrame.setTop(1);
            callFrame.set(0, null);
            return 1;
        }
        Object value = t.rawget(nextKey);
        callFrame.setTop(2);
        callFrame.set(0, nextKey);
        callFrame.set(1, value);
        return 2;
    }

    private int unpack(LuaCallFrame callFrame, int nArguments) {
        int i2;
        int j2;
        int nReturnValues;
        BaseLib.luaAssert(nArguments >= 1, "Not enough arguments");
        LuaTable t = (LuaTable)callFrame.get(0);
        Object di = null;
        Object dj = null;
        if (nArguments >= 2) {
            di = callFrame.get(1);
        }
        if (nArguments >= 3) {
            dj = callFrame.get(2);
        }
        if ((nReturnValues = 1 + (j2 = dj != null ? LuaState.fromInt(dj) : t.len()) - (i2 = di != null ? LuaState.fromInt(di) : 1)) <= 0) {
            callFrame.setTop(0);
            return 0;
        }
        callFrame.setTop(nReturnValues);
        for (int b2 = 0; b2 < nReturnValues; ++b2) {
            callFrame.set(b2, t.rawget(LuaState.toInt(i2 + b2)));
        }
        return nReturnValues;
    }

    private int error(LuaCallFrame callFrame, int nArguments) {
        if (nArguments >= 1) {
            String stacktrace = (String)BaseLib.getOptArg(callFrame, 2, TYPE_STRING);
            if (stacktrace == null) {
                stacktrace = "";
            }
            callFrame.thread.stackTrace = stacktrace;
            throw new LuaException(callFrame.get(0));
        }
        return 0;
    }

    public static int pcall(LuaCallFrame callFrame, int nArguments) {
        return callFrame.thread.state.pcall(nArguments - 1);
    }

    private static int print(LuaCallFrame callFrame, int nArguments) {
        LuaState state = callFrame.thread.state;
        LuaTable env = state.getEnvironment();
        Object toStringFun = state.tableGet(env, "tostring");
        StringBuffer sb = new StringBuffer();
        for (int i2 = 0; i2 < nArguments; ++i2) {
            Object res = state.call(toStringFun, callFrame.get(i2), null, null);
            sb.append(res);
            if (i2 >= nArguments) continue;
            sb.append("\t");
        }
        state.out.println(sb.toString());
        return 0;
    }

    private static int select(LuaCallFrame callFrame, int nArguments) {
        BaseLib.luaAssert(nArguments >= 1, "Not enough arguments");
        Object arg1 = callFrame.get(0);
        if (arg1 instanceof String && ((String)arg1).startsWith("#")) {
            callFrame.push(LuaState.toInt(nArguments - 1));
            return 1;
        }
        Integer d_indexInteger = BaseLib.rawTonumber(arg1);
        int d_index = LuaState.fromInt(d_indexInteger);
        int index = d_index;
        if (index >= 1 && index <= nArguments - 1) {
            int nResults = nArguments - index;
            return nResults;
        }
        return 0;
    }

    public static void luaAssert(boolean b2, String msg) {
        if (!b2) {
            BaseLib.fail(msg);
        }
    }

    public static void fail(String msg) {
        throw new RuntimeException(msg);
    }

    public static String numberToString(Integer num) {
        return num.toString();
    }

    public static Object getArg(LuaCallFrame callFrame, int n2, String type, String function) {
        String isType;
        Object o2 = callFrame.get(n2 - 1);
        if (o2 == null) {
            throw new RuntimeException("bad argument #" + n2 + "to '" + function + "' (" + type + " expected, got no value)");
        }
        if (type == TYPE_STRING) {
            String res = BaseLib.rawTostring(o2);
            if (res != null) {
                return res;
            }
        } else if (type == TYPE_NUMBER) {
            Integer d2 = BaseLib.rawTonumber(o2);
            if (d2 != null) {
                return d2;
            }
            throw new RuntimeException("bad argument #" + n2 + " to '" + function + "' (number expected, got string)");
        }
        if (type != null && type != (isType = BaseLib.type(o2))) {
            BaseLib.fail("bad argument #" + n2 + " to '" + function + "' (" + type + " expected, got " + isType + ")");
        }
        return o2;
    }

    public static Object getOptArg(LuaCallFrame callFrame, int n2, String type) {
        if (n2 - 1 >= callFrame.getTop()) {
            return null;
        }
        Object o2 = callFrame.get(n2 - 1);
        if (o2 == null) {
            return null;
        }
        if (type == TYPE_STRING) {
            return BaseLib.rawTostring(o2);
        }
        if (type == TYPE_NUMBER) {
            return BaseLib.rawTonumber(o2);
        }
        return o2;
    }

    private static int getmetatable(LuaCallFrame callFrame, int nArguments) {
        BaseLib.luaAssert(nArguments >= 1, "Not enough arguments");
        Object o2 = callFrame.get(0);
        Object metatable = callFrame.thread.state.getmetatable(o2, false);
        callFrame.push(metatable);
        return 1;
    }

    private static int setmetatable(LuaCallFrame callFrame, int nArguments) {
        BaseLib.luaAssert(nArguments >= 2, "Not enough arguments");
        Object o2 = callFrame.get(0);
        LuaTable newMeta = (LuaTable)callFrame.get(1);
        BaseLib.setmetatable(callFrame.thread.state, o2, newMeta, false);
        callFrame.setTop(1);
        return 1;
    }

    public static void setmetatable(LuaState state, Object o2, LuaTable newMeta, boolean raw) {
        LuaTable oldMeta;
        BaseLib.luaAssert(o2 != null, "Expected table, got nil");
        LuaTable to = null;
        Class<?> co = null;
        if (o2 instanceof LuaTable) {
            to = (LuaTable)o2;
            oldMeta = to.getMetatable();
        } else {
            co = o2.getClass();
            oldMeta = (LuaTable)state.userdataMetatables.rawget(co);
        }
        if (!raw && oldMeta != null && state.tableGet(oldMeta, "__metatable") != null) {
            throw new RuntimeException("Can not set metatable of protected object");
        }
        if (to != null) {
            Object modeObj;
            to.setMetatable(newMeta);
            boolean weakKeys = false;
            boolean weakValues = false;
            if (newMeta != null && (modeObj = newMeta.rawget(MODE_KEY)) != null && modeObj instanceof String) {
                String mode = (String)modeObj;
                weakKeys = mode.indexOf(107) >= 0;
                weakValues = mode.indexOf(118) >= 0;
            }
            to.updateWeakSettings(weakKeys, weakValues);
        } else {
            state.userdataMetatables.rawset(co, (Object)newMeta);
        }
    }

    private static int type(LuaCallFrame callFrame, int nArguments) {
        BaseLib.luaAssert(nArguments >= 1, "Not enough arguments");
        Object o2 = callFrame.get(0);
        callFrame.push(BaseLib.type(o2));
        return 1;
    }

    public static String type(Object o2) {
        if (o2 == null) {
            return TYPE_NIL;
        }
        if (o2 instanceof String) {
            return TYPE_STRING;
        }
        if (o2 instanceof Integer) {
            return TYPE_NUMBER;
        }
        if (o2 instanceof Boolean) {
            return TYPE_BOOLEAN;
        }
        if (o2 instanceof JavaFunction || o2 instanceof LuaClosure) {
            return TYPE_FUNCTION;
        }
        if (o2 instanceof LuaTable) {
            return TYPE_TABLE;
        }
        if (o2 instanceof LuaThread) {
            return TYPE_THREAD;
        }
        return TYPE_USERDATA;
    }

    private static int tostring(LuaCallFrame callFrame, int nArguments) {
        BaseLib.luaAssert(nArguments >= 1, "Not enough arguments");
        Object o2 = callFrame.get(0);
        String res = BaseLib.tostring(o2, callFrame.thread.state);
        callFrame.push(res);
        return 1;
    }

    public static String tostring(Object o2, LuaState state) {
        if (o2 == null) {
            return TYPE_NIL;
        }
        if (o2 instanceof String) {
            return (String)o2;
        }
        if (o2 instanceof Integer) {
            return BaseLib.rawTostring(o2);
        }
        if (o2 instanceof Boolean) {
            return o2 == LuaPrototype.bTRUE ? "true" : "false";
        }
        if (o2 instanceof JavaFunction) {
            return "function 0x" + System.identityHashCode(o2);
        }
        if (o2 instanceof LuaClosure) {
            return "function 0x" + System.identityHashCode(o2);
        }
        Object tostringFun = state.getMetaOp(o2, "__tostring");
        if (tostringFun != null) {
            String res = (String)state.call(tostringFun, o2, null, null);
            return res;
        }
        if (o2 instanceof LuaTable) {
            return "table 0x" + System.identityHashCode(o2);
        }
        throw new RuntimeException("no __tostring found on object");
    }

    private static int tonumber(LuaCallFrame callFrame, int nArguments) {
        int dradix;
        BaseLib.luaAssert(nArguments >= 1, "Not enough arguments");
        Object o2 = callFrame.get(0);
        if (nArguments == 1) {
            callFrame.push(BaseLib.rawTonumber(o2));
            return 1;
        }
        String s2 = (String)o2;
        Object radixObj = callFrame.get(1);
        Integer radixInteger = BaseLib.rawTonumber(radixObj);
        BaseLib.luaAssert(radixInteger != null, "Argument 2 must be a number");
        int radix = dradix = LuaState.fromInt(radixInteger);
        if (radix != dradix) {
            throw new RuntimeException("base is not an integer");
        }
        Integer res = BaseLib.tonumber(s2, radix);
        callFrame.push(res);
        return 1;
    }

    public static Integer tonumber(String s2) {
        return BaseLib.tonumber(s2, 10);
    }

    public static Integer tonumber(String s2, int radix) {
        if (radix < 2 || radix > 36) {
            throw new RuntimeException("base out of range");
        }
        return Integer.valueOf(s2, radix);
    }

    public static int collectgarbage(LuaCallFrame callFrame, int nArguments) {
        Object option = null;
        if (nArguments > 0) {
            option = callFrame.get(0);
        }
        if (option == null || option.equals("step") || option.equals("collect")) {
            System.gc();
            return 0;
        }
        if (option.equals("count")) {
            long freeMemory = RUNTIME.freeMemory();
            long totalMemory = RUNTIME.totalMemory();
            callFrame.setTop(3);
            callFrame.set(0, BaseLib.toKiloBytes(totalMemory - freeMemory));
            callFrame.set(1, BaseLib.toKiloBytes(freeMemory));
            callFrame.set(2, BaseLib.toKiloBytes(totalMemory));
            return 3;
        }
        throw new RuntimeException("invalid option: " + option);
    }

    private static Integer toKiloBytes(long freeMemory) {
        return LuaState.toInt((int)freeMemory / 1024);
    }

    public static String rawTostring(Object o2) {
        if (o2 instanceof String) {
            return (String)o2;
        }
        if (o2 instanceof Integer) {
            return BaseLib.numberToString((Integer)o2);
        }
        return null;
    }

    public static Integer rawTonumber(Object o2) {
        if (o2 instanceof Integer) {
            return (Integer)o2;
        }
        if (o2 instanceof String) {
            return BaseLib.tonumber((String)o2);
        }
        return null;
    }

    private static int bytecodeloader(LuaCallFrame callFrame, int nArguments) {
        String modname = (String)BaseLib.getArg(callFrame, 1, TYPE_STRING, "loader");
        LuaTable packageTable = (LuaTable)callFrame.getEnvironment().rawget("package");
        String classpath = (String)packageTable.rawget("classpath");
        int index = 0;
        while (index < classpath.length()) {
            String path;
            int nextIndex = classpath.indexOf(";", index);
            if (nextIndex == -1) {
                nextIndex = classpath.length();
            }
            if ((path = classpath.substring(index, nextIndex)).length() > 0) {
                LuaClosure closure;
                if (!path.endsWith("/")) {
                    path = path + "/";
                }
                if ((closure = callFrame.thread.state.loadByteCodeFromResource(path + modname, callFrame.getEnvironment())) != null) {
                    return callFrame.push(closure);
                }
            }
            index = nextIndex;
        }
        return callFrame.push("Could not find the bytecode for '" + modname + "' in classpath");
    }

    static {
        MODE_KEY = "__mode";
        INTEGER_ONE = new Integer(1);
        names = new String[19];
        BaseLib.names[0] = "pcall";
        BaseLib.names[1] = "print";
        BaseLib.names[2] = "select";
        BaseLib.names[3] = "type";
        BaseLib.names[4] = "tostring";
        BaseLib.names[5] = "tonumber";
        BaseLib.names[6] = "getmetatable";
        BaseLib.names[7] = "setmetatable";
        BaseLib.names[8] = "error";
        BaseLib.names[9] = "unpack";
        BaseLib.names[10] = "next";
        BaseLib.names[11] = "setfenv";
        BaseLib.names[12] = "getfenv";
        BaseLib.names[13] = "rawequal";
        BaseLib.names[14] = "rawset";
        BaseLib.names[15] = "rawget";
        BaseLib.names[16] = "collectgarbage";
        BaseLib.names[17] = "debugstacktrace";
        BaseLib.names[18] = "bytecodeloader";
    }
}

