/*
 * Decompiled with CFR 0.152.
 */
import java.io.DataInputStream;
import java.io.IOException;
import java.util.Vector;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public final class Map {
    static int screenWidth = 640;
    static int screenHeight = 360;
    static byte tileWidth;
    static byte tileHight;
    static int mapSize_width;
    static int mapSize_hight;
    static int mapW;
    static int mapH;
    static int setOffX;
    static int setOffY;
    static byte sceneState;
    static final byte SS_STOP = 0;
    static final byte SS_MOVE = 1;
    public static int SCEEN_MOVE;
    int adjustX;
    int adjustY;
    static boolean isMoveScreen;
    Event event;
    short pathIndex;
    static byte[][] mData;
    static short[][] mProperties;
    static String[][] mName;
    static int layer;
    public static final byte ITEM_TYPE = 0;
    public static final byte ITEM_X = 1;
    public static final byte ITEM_Y = 2;
    public static final byte ITEM_TR = 3;
    public static final byte OBJ_ID = 0;
    public static final byte OBJ_IMG = 1;
    public static final byte OBJ_DL = 2;
    public static final byte OBJ_ADDX = 3;
    public static final byte OBJ_ADDY = 4;
    public static final byte OBJ_W = 5;
    public static final byte OBJ_H = 6;
    static short[][] objData;
    static short[][] decData;
    static int weatherId;
    int weatherIndex;
    static int offsetX;
    static int offsetY;
    Image mapBuffer;
    int bufferWidth;
    int bufferHeight;
    Graphics bufferG;
    boolean isBufferNull;
    int lastStartX;
    int lastStartY;
    int lastEndX;
    int lastEndY;

    public static short getLayer(int dl) {
        switch (dl) {
            case 0: {
                return 0;
            }
            case 1: {
                return 1000;
            }
            case 2: {
                return 2000;
            }
        }
        return 8000;
    }

    public Map(int sw, int sh) {
        screenWidth = sw;
        screenHeight = sh;
        Map.setOff(0, 0);
    }

    public void free() {
        this.mapBuffer = null;
        mData = null;
        mProperties = null;
        mName = null;
        weatherId = 0;
        this.weatherIndex = 0;
        System.gc();
    }

    public void moveSrceen(int x, int y) {
        setOffX = Math.abs(x - setOffX - this.adjustX) > SCEEN_MOVE ? (x - setOffX >= this.adjustX ? (setOffX += SCEEN_MOVE) : (setOffX -= SCEEN_MOVE)) : (int)((short)(x - this.adjustX));
        setOffX = (short)Math.max(setOffX, 0);
        int w = mapW;
        setOffX = w >= screenWidth ? (int)((short)Math.min(setOffX, w - screenWidth)) : (w - screenWidth) / 2;
        setOffY = Math.abs(y - setOffY - this.adjustY) > SCEEN_MOVE ? (y - setOffY >= this.adjustY ? (setOffY += SCEEN_MOVE) : (setOffY -= SCEEN_MOVE)) : (int)((short)(y - this.adjustY));
        setOffY = (short)Math.max(setOffY, 0);
        int h = mapH;
        setOffY = h >= screenHeight ? (int)((short)Math.min(setOffY, h - screenHeight)) : (h - screenHeight) / 2;
        if (isMoveScreen && this.checkMoveScreen(x, y)) {
            isMoveScreen = false;
            this.finish();
        }
    }

    public boolean checkMoveScreen(int x, int y) {
        int tempx = x - this.adjustX;
        tempx = (short)Math.max(tempx, 0);
        int w = mapW;
        tempx = w >= screenWidth ? (int)Math.min(tempx, w - screenWidth) : (short)(w - screenWidth) / 2;
        int tempy = y - this.adjustY;
        tempy = (short)Math.max(tempy, 0);
        int h = mapH;
        tempy = h > screenHeight ? (int)((short)Math.min(tempy, h - screenHeight)) : (h - screenHeight) / 2;
        return setOffX == tempx && setOffY == tempy;
    }

    public void sender(Event event, short pathIndex) {
        this.event = event;
        this.pathIndex = pathIndex;
    }

    public void finish() {
        if (this.event != null) {
            this.event.setEnd(this.pathIndex);
            this.event = null;
        }
    }

    public void createMap(String mapDat, String decDat) throws IOException {
        this.free();
        this.createMapBuff();
        this.loadMapDat(mapDat);
        this.loadDecorationDat(decDat);
        this.initWeather();
        offsetY = 0;
        offsetX = 0;
    }

    void loadDecorationDat(String decDat) throws IOException {
        decData = Data.readArray("/data/deck.pak", decDat);
        Rank.initDeck(decData, objData);
        this.loadDeckImg();
        decData = null;
    }

    void loadMapDat(String mapDat) {
        this.loadMap(mapDat);
        Tools.createImage(mName);
    }

    public void loadMap(String file) {
        DataInputStream dis = Tools.openFile("/data/map.pak");
        int fileLen = Data.searchFile(dis, file);
        try {
            if (fileLen == -1) {
                System.out.println("/data/map.pak\u6587\u4ef6\u4e0d\u5728~~~~");
                dis.close();
                return;
            }
            layer = Map.bToi(dis.readByte());
            mData = new byte[layer][];
            mProperties = new short[layer][];
            mName = new String[layer][];
            int i = 0;
            while (i < layer) {
                mapSize_width = Map.bToi(dis.readByte());
                mapSize_hight = Map.bToi(dis.readByte());
                tileWidth = dis.readByte();
                tileHight = dis.readByte();
                mapW = mapSize_width * tileWidth;
                mapH = mapSize_hight * tileHight;
                int size = mapSize_width * mapSize_hight;
                Map.mData[i] = new byte[size];
                dis.read(mData[i]);
                int len = dis.readShort();
                Map.mName[i] = new String[len];
                Map.mProperties[i] = new short[len];
                int j = 0;
                while (j < len) {
                    byte nameLen = dis.readByte();
                    byte[] names = new byte[nameLen];
                    dis.read(names);
                    Map.mName[i][j] = new String(names);
                    Map.mProperties[i][j] = dis.readShort();
                    ++j;
                }
                ++i;
            }
            dis.close();
        }
        catch (IOException ex) {
            System.out.println("************* Read Map Error !!! ******************");
        }
    }

    static int getFullTileX(int x) {
        return x / tileWidth * tileWidth + tileWidth / 2;
    }

    static int getFullTileY(int y) {
        return y / tileHight * tileHight + tileHight / 2;
    }

    public void panit(Graphics g) {
        if (mData != null) {
            this.drawMapBuffer(g, setOffX, setOffY);
            this.drawMapFG();
        }
        this.drawSideMap();
    }

    public void drawSideMap() {
        int verCount = 4;
        int imageIndex = 75;
        if (Engine.gameSeason == 0 && !Engine.isChallengeMode()) {
            imageIndex = 75;
        } else if (Engine.gameSeason == 1 && !Engine.isChallengeMode()) {
            imageIndex = 76;
        } else if (Engine.gameSeason == 2 && !Engine.isChallengeMode()) {
            imageIndex = 77;
        } else if (Engine.gameSeason == 3 && !Engine.isChallengeMode()) {
            imageIndex = 78;
        } else if (Window.windowIndex / 3 == 0 && Engine.isChallengeMode()) {
            imageIndex = 75;
        } else if (Window.windowIndex / 3 == 1 && Engine.isChallengeMode()) {
            imageIndex = 76;
        } else if (Window.windowIndex / 3 == 2 && Engine.isChallengeMode()) {
            imageIndex = 77;
        } else if (Window.windowIndex / 3 == 3 && Engine.isChallengeMode()) {
            imageIndex = 78;
        }
        int i = 0;
        while (i < verCount + 1) {
            Tools.addImage(0, imageIndex, 0 + setOffX, 0 + i * 80 + setOffY, (byte)0, (byte)0, 0);
            Tools.addImage(0, imageIndex, 560 + setOffX, 0 + i * 80 + setOffY, (byte)0, (byte)1, 0);
            ++i;
        }
        int horCount = 33;
        int i2 = 0;
        while (i2 < horCount + 1) {
            Tools.addImage(0, 74, 0 + i2 * 19 + setOffX, 0 + setOffY, (byte)0, (byte)0, 0);
            Tools.addImage(0, 74, 0 + i2 * 19 + setOffX, 360 + setOffY, (byte)2, (byte)2, 0);
            ++i2;
        }
    }

    public void drawMapBG(Graphics g) {
        g.setColor(0);
        g.fillRect(0, 0, 640, 360);
    }

    public void drawMapFG() {
        this.drawWeather();
    }

    private void drawBlackSide() {
        int tempw = (screenWidth - mapW) / 2;
        int temph = (screenHeight - mapH) / 2;
        if (tempw > 0) {
            Tools.addRect(setOffX, setOffY, tempw, screenHeight, true, (byte)0, 0, 3000);
            Tools.addRect(setOffX + mapW + tempw, setOffY, tempw, screenHeight, true, (byte)0, 0, 3000);
        }
        if (temph > 0) {
            Tools.addRect(setOffX, setOffY, screenWidth, temph, true, (byte)0, 0, 3000);
            Tools.addRect(setOffX, setOffY + mapH + temph, screenWidth, temph, true, (byte)0, 0, 3000);
        }
    }

    static int getObjIndex(int id) {
        int i = 0;
        while (i < objData.length) {
            if (objData[i][0] == id) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    static int getDeckDrawLevel(int dl, int y) {
        int drawLevel = y;
        switch (dl) {
            case 0: {
                drawLevel = 0;
                break;
            }
            case 1: {
                drawLevel = y + 1000;
                break;
            }
            case 2: {
                drawLevel = 3000;
                break;
            }
            case 3: {
                drawLevel = y + 1000 - 18;
            }
        }
        return drawLevel;
    }

    public void drawDecorations() {
        if (decData == null) {
            return;
        }
        int i = 0;
        while (i < decData.length) {
            short type = decData[i][0];
            short x = (short)(decData[i][1] + offsetX);
            int y = decData[i][2] + offsetY;
            byte trans = (byte)decData[i][3];
            int id = Map.getObjIndex(type);
            if (id != -1) {
                short addx = objData[id][3];
                short addy = objData[id][4];
                short img = objData[id][1];
                short dl = objData[id][2];
                int drawLevel = y;
                switch (dl) {
                    case -2: {
                        drawLevel = 0;
                        break;
                    }
                    case -1: {
                        drawLevel = 0;
                        break;
                    }
                    case 0: {
                        drawLevel = (short)(y + 1000);
                        break;
                    }
                    case 2: {
                        drawLevel = 3000;
                    }
                }
                boolean index = false;
                Tools.addImage(2, img, x + addx, y + addy, (byte)2, trans, drawLevel);
            }
            ++i;
        }
    }

    void loadDeckImg() {
        if (decData == null) {
            return;
        }
        Vector<String> v = new Vector<String>();
        int i = 0;
        while (i < Rank.deck.length) {
            String type = Rank.deck[i].imgIndex + "";
            if (!v.contains(type)) {
                v.addElement(type);
            }
            ++i;
        }
        Object[] str = new String[v.size()];
        v.copyInto(str);
        v = null;
        Tools.loadImages(2, (String[])str);
    }

    void initWeather() {
    }

    void drawWeather() {
        switch (weatherId) {
            case 0: {
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                break;
            }
        }
    }

    public static void setOff(int x, int y) {
        setOffX = x;
        setOffY = y;
    }

    public boolean canRun(int x, int y) {
        return true;
    }

    public static byte inMapData(int x, int y, int index) {
        int n = x / tileWidth * mapSize_hight + y / tileHight;
        if (n < 0 || n >= mData[index].length) {
            return -1;
        }
        return mData[index][n];
    }

    public static void setMapData(int x, int y, int index) {
        int n = x / tileWidth * mapSize_hight + y / tileHight;
        Map.mData[index][n] = -1;
    }

    public static int getTrans(int v) {
        return v >> 6 & 3;
    }

    public static int get2nd(int v) {
        return v << 1 >> 7 & 1;
    }

    public static int getLow(int v) {
        return v & 0x3F;
    }

    static int bToi(byte byte0) {
        int i = byte0;
        if (byte0 < 0) {
            i += 256;
        }
        return i;
    }

    public static int getIndex(int v) {
        return v & 0x3F;
    }

    public int getIndex(int x, int y, int index) {
        return Map.getIndex(Map.inMapData(x, y, index));
    }

    private int repaint(int data, int layer) {
        if (data == -1) {
            return -1;
        }
        return 0;
    }

    public void drawTile() {
        Engine.drawColorScreenBG(0, 0);
        int n = setOffX / tileWidth * mapSize_hight + setOffY / tileHight;
        int nw = screenWidth / tileWidth + 2;
        int nh = screenHeight / tileHight + 2;
        int j = 0;
        while (j < nw) {
            int s;
            int i = s = n + j * mapSize_hight;
            while (i < s + nh) {
                block6: {
                    if (i >= mData[0].length || i < 0) break block6;
                    int x = offsetX + i / mapSize_hight * tileHight;
                    int y = offsetY + i % mapSize_hight * tileWidth;
                    int k = 0;
                    while (k < layer) {
                        block7: {
                            int dataTemp = Map.getLow(mData[k][i]);
                            int temp = this.repaint(mData[k][i], k);
                            int lev = 0;
                            switch (temp) {
                                case 0: {
                                    lev = 0;
                                    break;
                                }
                                default: {
                                    break block7;
                                }
                            }
                            Tools.addImage(Tools.mapGroup + k, dataTemp, x, y, 0, 0, (int)tileWidth, (int)tileHight, (byte)0, (byte)Map.getTrans(mData[k][i]), lev);
                        }
                        ++k;
                    }
                }
                ++i;
            }
            ++j;
        }
    }

    void createMapBuff() {
        this.isBufferNull = true;
        if (this.mapBuffer == null) {
            tileWidth = (byte)40;
            tileHight = (byte)40;
            this.bufferWidth = ((screenWidth + tileWidth - 1) / tileWidth + 1) * tileWidth;
            this.bufferHeight = ((screenHeight + tileHight - 1) / tileHight + 1) * tileHight;
            this.mapBuffer = Image.createImage((int)this.bufferWidth, (int)this.bufferHeight);
            this.bufferG = this.mapBuffer.getGraphics();
        }
    }

    void drawBuffer(Graphics g, int clipX, int clipY, int clipW, int clipH, int x, int y) {
        if (this.mapBuffer != null) {
            g.setClip(x, y, clipW, clipH);
            g.drawImage(this.mapBuffer, x - clipX, y - clipY, 20);
            g.setClip(0, 0, screenWidth, screenHeight);
        } else {
            g.setClip(0, 0, screenWidth, screenHeight);
        }
    }

    void drawMapBuffer(Graphics g, int setOffX, int setOffY) {
        int startX = setOffX / tileWidth;
        int endX = startX + (screenWidth + tileWidth - 1) / tileWidth;
        int startY = setOffY / tileHight;
        int endY = startY + (screenHeight + tileHight - 1) / tileHight;
        if (this.isBufferNull) {
            this.isBufferNull = false;
            this.updateBuffer(this.bufferG, startX, startY, endX, endY);
            this.lastStartX = startX;
            this.lastStartY = startY;
            this.lastEndX = endX;
            this.lastEndY = endY;
        }
        if (this.lastStartX != startX) {
            int tmp2;
            int tmp1;
            if (this.lastStartX < startX) {
                tmp1 = this.lastEndX + 1;
                tmp2 = endX;
            } else {
                tmp1 = startX;
                tmp2 = this.lastStartX - 1;
            }
            this.updateBuffer(this.bufferG, tmp1, startY, tmp2, endY);
            this.lastStartX = startX;
            this.lastEndX = endX;
        }
        if (this.lastStartY != startY) {
            int tmp4;
            int tmp3;
            if (this.lastStartY < startY) {
                tmp3 = this.lastEndY + 1;
                tmp4 = endY;
            } else {
                tmp3 = startY;
                tmp4 = this.lastStartY - 1;
            }
            this.updateBuffer(this.bufferG, startX, tmp3, endX, tmp4);
            this.lastStartY = startY;
            this.lastEndY = endY;
        }
        int t1 = setOffX % this.bufferWidth;
        int t2 = setOffY % this.bufferHeight;
        int t3 = (setOffX + screenWidth) % this.bufferWidth;
        int t4 = (setOffY + screenHeight) % this.bufferHeight;
        if (t3 > t1) {
            if (t4 > t2) {
                this.drawBuffer(g, t1, t2, screenWidth, screenHeight, 0, 0);
            } else {
                this.drawBuffer(g, t1, t2, screenWidth, screenHeight - t4, 0, 0);
                this.drawBuffer(g, t1, 0, screenWidth, t4, 0, screenHeight - t4);
            }
        } else if (t4 > t2) {
            this.drawBuffer(g, t1, t2, screenWidth - t3, screenHeight, 0, 0);
            this.drawBuffer(g, 0, t2, t3, screenHeight, screenWidth - t3, 0);
        } else {
            this.drawBuffer(g, t1, t2, screenWidth - t3, screenHeight - t4, 0, 0);
            this.drawBuffer(g, t1, 0, screenWidth - t3, t4, 0, screenHeight - t4);
            this.drawBuffer(g, 0, t2, t3, screenHeight - t4, screenWidth - t3, 0);
            this.drawBuffer(g, 0, 0, t3, t4, screenWidth - t3, screenHeight - t4);
        }
    }

    void updateBuffer(Graphics g, int startX, int startY, int endX, int endY) {
        int y = startY * tileHight % this.bufferHeight;
        int i = startY;
        while (i <= endY) {
            int x = startX * tileWidth % this.bufferWidth;
            int j = startX;
            while (j <= endX) {
                int k = 0;
                while (k < layer) {
                    byte mapIndex = Map.inMapData(j * tileWidth, i * tileHight, k);
                    int dataTemp = Map.getIndex(mapIndex);
                    int transData = Map.getTrans(mapIndex);
                    if ((byte)mapIndex != -1) {
                        g.setClip(x, y, (int)tileWidth, (int)tileHight);
                        Tools.drawClipImage(g, (Tools.mapGroup + k) * 600 + dataTemp, x, y, 0, 0, tileWidth, tileHight, (byte)0, transData, 0);
                        g.setClip(0, 0, this.bufferWidth, this.bufferHeight);
                    } else if (k == 0) {
                        g.setClip(x, y, (int)tileWidth, (int)tileHight);
                        g.setColor(0);
                        g.fillRect(x, y, (int)tileWidth, (int)tileHight);
                        g.setClip(0, 0, this.bufferWidth, this.bufferHeight);
                    }
                    ++k;
                }
                if ((x += tileWidth) >= this.bufferWidth) {
                    x -= this.bufferWidth;
                }
                ++j;
            }
            if ((y += tileHight) >= this.bufferHeight) {
                y -= this.bufferHeight;
            }
            ++i;
        }
    }

    static {
        mapW = 480;
        mapH = 320;
        SCEEN_MOVE = 16;
        weatherId = 0;
    }
}

