/*
 * Decompiled with CFR 0.152.
 */
public class Tower {
    String name;
    String info;
    int type;
    int id;
    short mode;
    byte biuIndex;
    int biuSound;
    int hitSound;
    short upgrade;
    short attack;
    short aspe;
    short range;
    byte atkPow;
    byte speedPow;
    byte rangePow;
    short priceCreate;
    short priceSell;
    byte level;
    byte flashMode;
    short buffId;
    byte dropLevel;
    byte icon;
    byte space;
    short[][] buff = new short[8][2];
    int attackFrequency;
    boolean isSelect;
    Sprite s;
    public static final byte LEVEL_MAX = 3;
    int buffImage = -1;
    int tempFrame = 0;
    int buffImageId = 0;
    int lastBuffImageId = 0;
    int aimIndex = -1;
    byte aimType;
    static final byte AT_ENEMY = 0;
    static final byte AT_DECK = 1;
    Event event;
    short pathIndex;
    int rangeIndex;
    int rangeMax = 6;
    int towerIndex;
    byte leftIcon;
    short leftMoney;
    int leftOffX;
    int leftOffY;
    byte rightIcon;
    short rightMoney;
    int rightOffX;
    int rightOffY;
    short rangeSpace = (short)40;

    public Tower() {
    }

    public Tower(int id) {
        this.id = id;
    }

    public void initFromSoldier(Tower soldier) {
        this.s = new Sprite(soldier.mode);
        this.name = soldier.name;
        this.info = soldier.info;
        this.mode = soldier.mode;
        this.type = soldier.type;
        this.attack = soldier.attack;
        this.aspe = soldier.aspe;
        this.range = (short)(soldier.range * 3 / 4);
        this.priceCreate = soldier.priceCreate;
        this.priceSell = soldier.priceSell;
        this.upgrade = soldier.upgrade;
        this.level = soldier.level;
        this.flashMode = soldier.flashMode;
        this.buffId = soldier.buffId;
        this.dropLevel = soldier.dropLevel;
        this.biuIndex = soldier.biuIndex;
        this.initBiuSound();
    }

    private void initBiuSound() {
        switch (this.biuIndex) {
            case 0: {
                this.space = (byte)15;
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                this.space = (byte)15;
                break;
            }
            case 3: {
                this.space = (byte)15;
                return;
            }
            case 4: {
                this.space = (byte)10;
                break;
            }
            case 5: {
                break;
            }
            case 6: 
            case 10: {
                this.space = (byte)15;
                break;
            }
            case 7: {
                break;
            }
            case 8: {
                break;
            }
            case 9: {
                this.space = (byte)25;
                break;
            }
            case 11: 
            case 12: 
            case 13: {
                break;
            }
            case 14: 
            case 15: 
            case 16: {
                break;
            }
            default: {
                this.biuSound = -1;
                this.hitSound = -1;
                this.space = 0;
            }
        }
    }

    short getRange() {
        return this.range;
    }

    short getSpeed() {
        return this.aspe;
    }

    short getAttack() {
        return this.attack;
    }

    int getDegrees() {
        if (this.s == null || this.s.degrees == null) {
            return 0;
        }
        return this.s.degrees[0];
    }

    short getBuffVaule(int buffType) {
        if (this.buff == null || this.buff[buffType][0] == 0 || this.buff[buffType][1] == 0) {
            return 0;
        }
        return this.buff[buffType][0];
    }

    void addBuff(byte buffType, int buffVaule, int buffTime) {
        if (!this.canAddBuff(buffType, buffVaule)) {
            return;
        }
        this.buff[buffType][0] = (short)buffVaule;
        this.buff[buffType][1] = (short)(buffTime * 24);
    }

    boolean canAddBuff(byte buffType, int buffVaule) {
        return this.buff != null && (this.buff[buffType][1] <= 0 || this.buff[buffType][0] <= buffVaule);
    }

    public void init(byte st, int sx, int sy) {
        this.s.x = sx;
        this.s.y = sy;
        this.s.setMotionVaules((byte)0, false);
        this.s.sx += this.s.x;
        this.s.sy += this.s.y;
        this.s.level = this.level;
        this.s.curStatus = this.s.nextStatus = st;
        this.s.dir = 2;
        this.s.index = 0;
        this.s.visible = true;
        this.s.isGeneral = false;
        this.s.frameTimes = 0;
        this.s.flashMode = this.flashMode;
        this.attackFrequency = 0;
        switch (this.flashMode) {
            case 1: 
            case 4: {
                this.s.degrees = new int[]{180, this.s.x, this.s.y};
            }
        }
        this.setOffDegrees();
    }

    private void setOffDegrees() {
        switch (this.type / 3) {
            default: 
        }
        this.s.offDegrees = 180;
    }

    void run() {
        if (Rank.isPause()) {
            return;
        }
        this.clearDeadTarget();
        this.getAim();
        this.setFace();
        this.runAttackFrequency();
        if (this.s.attackFrame) {
            this.attackEnemy();
        }
        this.s.run();
    }

    void clearDeadTarget() {
        if (this.aimIsDeck()) {
            if (Rank.deck[this.aimIndex].isDead()) {
                this.s.setStatus((byte)-1);
                this.aimIndex = -1;
            }
            return;
        }
        if (this.aimIsEnemy()) {
            if (Rank.enemy[this.aimIndex].isDead()) {
                this.s.setStatus((byte)-1);
                this.aimIndex = -1;
            }
            return;
        }
    }

    void setFace() {
        if (this.aimIndex == -1) {
            return;
        }
        if (this.aimIsDeck()) {
            this.s.setFace(Rank.deck[this.aimIndex].hitX, Rank.deck[this.aimIndex].hitY);
            return;
        }
        if (this.aimIsEnemy()) {
            this.s.setFace(Rank.enemy[this.aimIndex].s.x, Rank.enemy[this.aimIndex].s.y);
        }
    }

    void drawBuff() {
        if (this.buff == null) {
            return;
        }
        int num = 0;
        int buffImageIndex = -1;
        int i = 0;
        while (i < this.buff.length) {
            if (this.buff[i][0] != 0 && this.buff[i][1] > 0) {
                ++num;
                if (!Rank.isPause() && this.buff[i][1] > 0) {
                    short[] sArray = this.buff[i];
                    sArray[1] = (short)(sArray[1] - Rank.gameSpeed);
                }
            }
            ++i;
        }
        if (num == 1) {
            buffImageIndex = 0;
        } else if (num > 1 && num < 4) {
            buffImageIndex = 41;
        } else if (num >= 4) {
            buffImageIndex = 82;
        }
        if (buffImageIndex != -1) {
            Tools.addImage(0, 26, this.s.x + 12, this.s.y - Map.tileHight / 2 - 45, buffImageIndex, 0, 41, 49, (byte)0, (byte)0, this.s.y + 1000);
        }
    }

    public static int getNum(int[] array) {
        if (array == null) {
            return -1;
        }
        int temp = 0;
        int i = 0;
        while (i < array.length) {
            if (array[i] != -1) {
                ++temp;
            }
            ++i;
        }
        return temp;
    }

    boolean aimIsEnemy() {
        return this.aimType == 0 && this.aimIndex != -1;
    }

    boolean aimIsDeck() {
        return this.aimType == 1 && this.aimIndex != -1 && this.aimIndex == Rank.focus;
    }

    private void targetFocus(byte aimType) {
        if (this.aimIndex != Rank.focus || this.aimType != aimType) {
            this.aimType = aimType;
            this.aimIndex = Rank.focus;
            if (this.s.isAttack()) {
                this.s.setStatus((byte)-1);
            }
        }
    }

    private boolean canTargetFocus() {
        return this.targetDeckFocus() || this.targetEnemyFocus();
    }

    private boolean targetDeckFocus() {
        if (!Rank.isDeckFocus()) {
            return false;
        }
        if (!Tower.canAttack(Rank.deck[Rank.focus])) {
            Rank.focusType = 0;
            Rank.focus = (short)-1;
            return false;
        }
        if (!Tower.inAttackRange(Rank.deck[Rank.focus].hitX, Rank.deck[Rank.focus].hitY, this.s.x, this.s.y, this.getRange(), Rank.deck[Rank.focus].offRange)) {
            return false;
        }
        this.targetFocus((byte)1);
        return true;
    }

    private boolean targetEnemyFocus() {
        if (!Rank.isEnemyFocus()) {
            return false;
        }
        if (!Tower.canAttack(Rank.enemy[Rank.focus])) {
            Rank.focusType = 0;
            Rank.focus = (short)-1;
            return false;
        }
        if (!Tower.inAttackRange(Rank.enemy[Rank.focus].s.x, Rank.enemy[Rank.focus].s.y, this.s.x, this.s.y, this.getRange(), EnemyTD.OFFRANGE)) {
            return false;
        }
        this.targetFocus((byte)0);
        return true;
    }

    void getAim() {
        if (this.canTargetFocus()) {
            return;
        }
        if (this.s.curStatus != -1) {
            return;
        }
        if (Rank.enemy == null) {
            this.aimIndex = -1;
            return;
        }
        boolean hasAim = this.mode != 12 ? this.setNormalAim() : this.setNoBuffAim();
        if (!hasAim) {
            this.aimIndex = -1;
        }
    }

    private boolean setNormalAim() {
        int i = 0;
        while (i < Rank.enemySort.length) {
            int aimIndex = Rank.enemySort[i];
            if (!Rank.enemy[aimIndex].isFocus() && Tower.canAttack(Rank.enemy[aimIndex]) && Tower.inAttackRange(Rank.enemy[aimIndex].s.x, Rank.enemy[aimIndex].s.y, this.s.x, this.s.y, this.getRange(), EnemyTD.OFFRANGE)) {
                this.aimIndex = aimIndex;
                this.aimType = 0;
                return true;
            }
            ++i;
        }
        return false;
    }

    private boolean setNoBuffAim() {
        int aim = -1;
        int i = 0;
        while (i < Rank.enemySort.length) {
            int aimIndex = Rank.enemySort[i];
            if (!Rank.enemy[aimIndex].isFocus() && Tower.canAttack(Rank.enemy[aimIndex]) && Tower.inAttackRange(Rank.enemy[aimIndex].s.x, Rank.enemy[aimIndex].s.y, this.s.x, this.s.y, this.getRange(), EnemyTD.OFFRANGE)) {
                int[] buff_poison;
                if (aim == -1) {
                    aim = aimIndex;
                }
                if ((buff_poison = Rank.enemy[aimIndex].buff[2]) == null || buff_poison[1] <= 0) {
                    this.aimIndex = aimIndex;
                    this.aimType = 0;
                    return true;
                }
            }
            ++i;
        }
        if (aim > -1) {
            this.aimIndex = aim;
            this.aimType = 0;
            return true;
        }
        return false;
    }

    public static boolean canAttack(EnemyTD enemyTD) {
        return enemyTD.s.visible && !enemyTD.isDead();
    }

    public static boolean canAttack(Deck deck) {
        return deck.visible && !deck.isDead();
    }

    static boolean inAttackRange(int ex, int ey, int tx, int ty, int trange, int offSetRange) {
        return Tools.pointAndCircle(ex, ey, tx, ty, trange + offSetRange);
    }

    void attackEnemy() {
        if (Rank.isPause()) {
            return;
        }
        if (this.aimIndex == -1) {
            this.s.setStatus((byte)-1);
            return;
        }
        if (this.biuSound != -1) {
            // empty if block
        }
        switch (this.biuIndex) {
            case 3: {
                byte[] bulletNum = new byte[]{2, 3, 5};
                Bullet.addBullet(this, bulletNum[this.level], 30 - this.level * 5);
                return;
            }
            case 4: {
                int effID = 0;
                int degrees = this.s.degrees == null ? 0 : this.s.degrees[0];
                int[] offXY = Tools.getDegreesXYOfSpace(degrees, this.space);
                degrees = (degrees + 180) % 360;
                switch (this.s.dir) {
                    case 0: {
                        degrees = 0;
                        break;
                    }
                    case 1: {
                        degrees = 90;
                        break;
                    }
                    case 2: {
                        degrees = 180;
                        break;
                    }
                    case 3: {
                        degrees = 270;
                    }
                }
                Effect.addEffect(this.s.x + offXY[0], this.s.y + offXY[1], effID, degrees, 0, this.s.trans, 2000);
            }
        }
        Bullet.addBullet(this);
    }

    static int getHurtVaule(int att, int def) {
        int hurt = att - def;
        return Math.max(hurt, 5);
    }

    int getAttackFrequency() {
        return Math.max(24 / Rank.gameSpeed * 100 / this.getSpeed(), 1);
    }

    void runAttackFrequency() {
        if (this.attackFrequency > 0) {
            --this.attackFrequency;
            return;
        }
        if (this.aimIndex == -1) {
            return;
        }
        if (!this.s.degreesToAim()) {
            return;
        }
        if (this.s.isAttack()) {
            return;
        }
        this.s.setStatus((byte)-3);
        this.attackFrequency = this.getAttackFrequency();
    }

    void paint() {
        int drawLevel = this.s.y + 1000;
        if (this.isSelect) {
            drawLevel = 3002;
        }
        this.s.paint(this.level, drawLevel);
        this.s.drawAttackEffect(this.space, drawLevel);
        this.drawUpgradeIcon();
        this.drawSelect();
        this.drawBuff();
    }

    void drawUpgradeIcon() {
        if (this.upgrade == -1) {
            return;
        }
        Tower nextTower = Engine.soldier[this.upgrade];
        if (nextTower.priceCreate <= Rank.money) {
            int y = Math.max(this.s.y - Map.tileHight / 2 - 17, 0);
            Tools.addGridImage(0, 19, this.s.x, y, 2, 1, (GCanvas.gameTime + this.id) / 4 % 2, 0, (byte)3, (byte)0, 2000);
        }
    }

    void initSelect() {
        this.isSelect = true;
        this.initRange();
    }

    void removeSelect() {
    }

    void drawSelect() {
        this.drawRange(this.isSelect, 4000);
    }

    public void sender(Event event, short pathIndex) {
        this.event = event;
        this.pathIndex = pathIndex;
    }

    public void finish() {
        if (this.event != null) {
            this.event.setEnd(this.pathIndex);
            this.event = null;
        }
    }

    public void initRange() {
        this.towerIndex = Rank.selectUnitIndex;
        this.leftMoney = Rank.tower[Rank.selectUnitIndex].priceSell;
        this.leftIcon = 0;
        if (Rank.tower[Rank.selectUnitIndex].upgrade == -1) {
            this.rightIcon = (byte)3;
        } else {
            this.rightIcon = Engine.soldier[Rank.tower[Rank.selectUnitIndex].upgrade].priceCreate <= Rank.money ? (byte)1 : (byte)2;
            this.rightMoney = Engine.soldier[Rank.tower[Rank.selectUnitIndex].upgrade].priceCreate;
        }
        this.leftOffX = Tools.atArea(this.s.x - this.rangeSpace, 20, 620) - this.s.x;
        this.leftOffY = this.leftOffX == 0 ? (this.s.y < 180 ? 40 : -40) : 0;
        this.rightOffX = Tools.atArea(this.s.x + this.rangeSpace, 20, 620) - this.s.x;
        this.rightOffY = this.rightOffX == 0 ? (this.s.y < 180 ? 40 : -40) : 0;
    }

    private void drawRange(boolean isShow, int drawLevel) {
        if (!isShow && this.rangeIndex == 0) {
            return;
        }
        int r = (this.getRange() + Map.tileWidth / 3) * this.rangeIndex / this.rangeMax;
        Tools.addARC(this.s.x - r, this.s.y - r, r * 2, r * 2, 0, 360, false, (byte)0, -1, drawLevel + 1);
        int scale = Math.max(this.rangeIndex * 1 / this.rangeMax, 0) * 10000 / 10000;
        int index = isShow ? this.rangeIndex - this.rangeMax : this.rangeMax - this.rangeIndex;
        int angle = (40 * index + 360) % 360;
        int[] degrees = new int[]{angle, this.s.x, this.s.y};
        this.rightIcon = Rank.tower[this.towerIndex].upgrade == -1 ? (byte)3 : (Engine.soldier[Rank.tower[this.towerIndex].upgrade].priceCreate <= Rank.money ? (byte)1 : (byte)2);
        this.drawRangeIcon(this.leftIcon, this.leftMoney, this.s.x + this.leftOffX * this.rangeIndex / this.rangeMax, this.s.y + this.leftOffY, scale, degrees, drawLevel);
        this.drawRangeIcon(this.rightIcon, this.rightMoney, this.s.x + this.rightOffX * this.rangeIndex / this.rangeMax, this.s.y + this.rightOffY, scale, degrees, drawLevel);
        if (isShow && this.rangeIndex < this.rangeMax) {
            ++this.rangeIndex;
        }
        if (!isShow && this.rangeIndex > 0) {
            --this.rangeIndex;
        }
    }

    private void drawRangeIcon(int icon, short money, int x, int y, int scale, int[] degrees, int drawLevel) {
        Tools.addGridImage(0, 9, x, y, 4, 1, icon, 0, scale, scale, (byte)4, (byte)0, drawLevel + 1, degrees);
        if (money > 0) {
            Tools.addNum(money, 0, 2, x, y + 8, 10, 0, scale, scale, (byte)3, drawLevel + 1, degrees);
        }
    }

    /*
     * Unable to fully structure code
     */
    static int growFormula(int base, int exponent, int lev) {
        pro = 1;
        temp = base;
        if (exponent != 0) ** GOTO lbl8
        return base;
lbl-1000:
        // 1 sources

        {
            temp *= exponent;
            temp /= 100;
            ++pro;
lbl8:
            // 2 sources

            ** while (pro < lev)
        }
lbl9:
        // 1 sources

        return temp;
    }
}

