/*
 * Decompiled with CFR 0.152.
 */
import java.util.Vector;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class Bullet {
    short type;
    String name;
    int imgIndex;
    short effIndex;
    byte atkType;
    int speed;
    short range;
    int[] degrees;
    int towerIndex;
    byte hitEffId;
    int hitSound;
    Vector aimArray;
    Vector deckArray;
    short hurtInterval;
    short hurtIndex;
    static byte[] SPEED = new byte[]{8, 12, 16};
    int tx;
    int ty;
    int x;
    int y;
    int w;
    int h;
    int dir;
    int aimX;
    int aimY;
    int moveX;
    int moveY;
    int curIndex;
    int frameLen;
    byte anchor;
    int[][] clipData;
    int[] frameData;
    int[] mottionData;
    byte scaleX;
    byte scaleY;
    short space;
    private int attack;
    private int buffId;
    int aimIndex;
    int aimType;

    public Bullet() {
    }

    Bullet(Tower tower) {
        this.towerIndex = tower.id;
        this.aimIndex = tower.aimIndex;
        this.aimType = tower.aimType;
        this.hitSound = tower.hitSound;
        this.space = tower.space;
        this.initTowerData(tower);
        this.init(Engine.bullet[tower.biuIndex], tower.level, tower.s.x, tower.s.y);
        this.dir = tower.s.dir;
    }

    private void initTowerData(Tower tower) {
        this.attack = tower.getAttack();
        this.buffId = tower.buffId;
    }

    private void init(Bullet bullet, int towerLevel, int towerX, int towerY) {
        this.type = bullet.type;
        this.name = bullet.name;
        this.imgIndex = bullet.imgIndex != -1 ? bullet.imgIndex / 3 * 3 : -1;
        this.atkType = bullet.atkType;
        this.speed = SPEED[bullet.speed] * Rank.gameSpeed;
        this.range = bullet.range;
        this.initXY(towerX, towerY);
        this.initImageData();
        this.initMoveData();
        this.initAimArray(this.atkType);
        this.overridesXY();
    }

    private void initXY(int towerX, int towerY) {
        switch (this.type) {
            case 1: {
                this.tx = this.x = towerX;
                this.ty = this.y = towerY - 10;
                break;
            }
            default: {
                this.tx = this.x = towerX;
                this.ty = this.y = towerY;
            }
        }
    }

    private void overridesXY() {
        if (this.space == 0) {
            return;
        }
        int degrees = 0;
        if (Rank.tower[this.towerIndex].s.degrees != null) {
            degrees = Rank.tower[this.towerIndex].s.degrees[0];
        } else if (this.degrees != null) {
            degrees = this.degrees[0];
        }
        int[] offXY = Tools.getDegreesXYOfSpace(degrees, this.space);
        this.x = this.tx + offXY[0];
        this.y = this.ty + offXY[1];
        if (this.degrees != null) {
            this.degrees[1] = this.x;
            this.degrees[2] = this.y;
        }
    }

    private void initAimArray(int atkType) {
        switch (atkType) {
            case 1: 
            case 3: 
            case 8: 
            case 9: {
                int i;
                this.aimArray = new Vector();
                this.deckArray = new Vector();
                if (Rank.enemy != null) {
                    i = 0;
                    while (i < Rank.enemy.length) {
                        if (!Rank.enemy[i].isDead() && Rank.enemy[i].s.visible) {
                            this.aimArray.addElement(new Utils(i));
                        }
                        ++i;
                    }
                }
                if (Rank.deck == null) break;
                i = 0;
                while (i < Rank.deck.length) {
                    if (!Rank.deck[i].isDead() && Rank.deck[i].visible) {
                        this.deckArray.addElement(new Utils(i));
                    }
                    ++i;
                }
                break;
            }
        }
    }

    private void initMoveData() {
        this.aimX = this.getAimX();
        this.aimY = this.getAimY();
        int a2 = this.aimX - this.x;
        int b2 = this.aimY - this.y;
        long r = GMath.sqrt(a2 * a2 + b2 * b2) / 100;
        switch (this.atkType) {
            case 6: 
            case 10: {
                this.hurtInterval = (short)3;
                this.degrees = new int[]{Tools.getDegrees(this.x, this.y, this.aimX, this.aimY), this.x, this.y};
                return;
            }
            case 5: 
            case 7: {
                this.degrees = new int[]{Tools.getDegrees(this.x, this.y, this.aimX, this.aimY), this.x, this.y};
                break;
            }
            case 8: {
                this.scaleX = 1;
                this.scaleY = (byte)(640 / this.h);
                this.degrees = new int[]{Tools.getDegrees(this.x, this.y, this.aimX, this.aimY), this.x, this.y};
                return;
            }
            case 3: 
            case 9: {
                this.degrees = new int[]{Tools.getDegrees(this.x, this.y, this.aimX, this.aimY), this.x, this.y};
            }
        }
        this.scaleX = 1;
        this.scaleY = 1;
        if (a2 != 0) {
            this.moveX = (int)((long)(a2 * this.speed) / r);
        }
        if (b2 != 0) {
            this.moveY = (int)((long)(b2 * this.speed) / r);
        }
    }

    private void initImageData() {
        switch (this.type) {
            case 4: {
                this.frameLen = 2;
                this.anchor = (byte)4;
                this.hitEffId = 1;
                this.mottionData = new int[]{0, 0, 1, 1};
                break;
            }
            case 7: {
                this.frameLen = 3;
                this.anchor = (byte)4;
                this.hitEffId = 1;
                break;
            }
            case 8: {
                this.frameLen = 3;
                this.anchor = (byte)4;
                this.hitEffId = (byte)4;
                break;
            }
            case 14: 
            case 15: 
            case 16: {
                this.mottionData = new int[]{0, 0, 1, 1, 2, 2, 3, 3};
                this.frameLen = this.mottionData.length;
                this.hitEffId = (byte)16;
                return;
            }
            case 11: 
            case 12: 
            case 13: {
                this.mottionData = new int[]{0, 0, 1, 1, 2, 2, 3, 3};
                this.frameLen = this.mottionData.length;
                this.hitEffId = (byte)15;
                return;
            }
            case 6: {
                this.frameLen = 3;
                this.anchor = (byte)4;
                this.hitEffId = (byte)4;
                break;
            }
            case 0: {
                this.frameLen = 3;
                this.anchor = (byte)4;
                this.hitEffId = 1;
                break;
            }
            case 3: {
                this.frameLen = 3;
                this.anchor = (byte)4;
                this.hitEffId = 1;
                break;
            }
            case 5: {
                this.frameLen = 3;
                this.anchor = (byte)4;
                this.hitEffId = 1;
                break;
            }
            case 1: {
                this.frameLen = 1;
                this.anchor = (byte)5;
                this.hitEffId = (byte)-1;
                break;
            }
            case 9: {
                this.frameLen = 2;
                this.anchor = (byte)5;
                this.hitEffId = (byte)-1;
                break;
            }
            case 2: {
                this.frameLen = 3;
                this.anchor = (byte)4;
                this.hitEffId = (byte)10;
                break;
            }
            case 10: {
                this.frameLen = 3;
                this.anchor = (byte)4;
                this.hitEffId = (byte)4;
            }
        }
        this.initClipData(this.frameLen);
    }

    private void initClipData(int frameLen) {
        if (frameLen < 1) {
            return;
        }
        Image img = Tools.getImage(28, this.imgIndex);
        if (img != null) {
            this.w = img.getWidth() / frameLen;
            this.h = img.getHeight();
        }
        this.clipData = new int[frameLen][];
        int i = 0;
        while (i < this.clipData.length) {
            this.clipData[i] = new int[]{this.w * i, 0, this.w, this.h};
            i = (byte)(i + 1);
        }
    }

    public void setDegrees(int degrees) {
        degrees = (degrees + 360) % 360;
        if (this.degrees == null) {
            this.degrees = new int[]{degrees, this.x, this.y};
        } else {
            this.degrees[0] = degrees;
        }
    }

    private void resetMove() {
        if (this.degrees == null) {
            this.moveX = 0;
            this.moveY = this.speed;
            return;
        }
        int radian = this.degrees[0] % 90 * 1 * 1000 / 1000;
        byte qd = Tools.getExactQD(this.degrees[0]);
        switch (qd) {
            case 1: {
                this.moveX = this.speed * GMath.cos(radian) / 4096;
                this.moveY = this.speed * GMath.sin(radian) / 4096;
                break;
            }
            case 2: {
                this.moveX = -this.speed * GMath.sin(radian) / 4096;
                this.moveY = this.speed * GMath.cos(radian) / 4096;
                break;
            }
            case 3: {
                this.moveX = -this.speed * GMath.cos(radian) / 4096;
                this.moveY = -this.speed * GMath.sin(radian) / 4096;
                break;
            }
            case 4: {
                this.moveX = this.speed * GMath.sin(radian) / 4096;
                this.moveY = -this.speed * GMath.cos(radian) / 4096;
                break;
            }
            case 5: {
                this.moveX = 0;
                this.moveY = -this.speed;
                break;
            }
            case 6: {
                this.moveX = this.speed;
                this.moveY = 0;
                break;
            }
            case 7: {
                this.moveX = 0;
                this.moveY = this.speed;
                break;
            }
            case 8: {
                this.moveX = -this.speed;
                this.moveY = 0;
            }
        }
    }

    public int getAttack() {
        return this.attack;
    }

    public short getRange() {
        return this.range;
    }

    public boolean addDegrees(int degrees) {
        if (this.degrees == null) {
            return false;
        }
        this.degrees[0] = (this.degrees[0] + degrees + 360) % 360;
        return true;
    }

    public int getDegrees() {
        if (this.degrees == null) {
            return 0;
        }
        return this.degrees[0];
    }

    public int getAimX() {
        switch (this.aimType) {
            case 0: {
                return Rank.enemy[this.aimIndex].s.x;
            }
            case 1: {
                return Rank.deck[this.aimIndex].hitX;
            }
        }
        return 0;
    }

    public int getAimY() {
        switch (this.aimType) {
            case 0: {
                return Rank.enemy[this.aimIndex].s.y;
            }
            case 1: {
                return Rank.deck[this.aimIndex].hitY;
            }
        }
        return 0;
    }

    public int getAimX(int aimIndex) {
        switch (this.aimType) {
            case 0: {
                return Rank.enemy[aimIndex].s.x;
            }
            case 1: {
                return Rank.deck[aimIndex].hitX;
            }
        }
        return 0;
    }

    public int getAimY(int aimIndex) {
        switch (this.aimType) {
            case 0: {
                return Rank.enemy[aimIndex].s.y;
            }
            case 1: {
                return Rank.deck[aimIndex].hitY;
            }
        }
        return 0;
    }

    void paint(Graphics g) {
        if (this.imgIndex < 0) {
            switch (this.type) {
                case 11: 
                case 12: 
                case 13: {
                    this.drawFireNova(this.mottionData[this.curIndex]);
                    break;
                }
                case 14: 
                case 15: 
                case 16: {
                    this.drawIceNova(this.mottionData[this.curIndex]);
                }
            }
            return;
        }
        if (this.clipData == null) {
            return;
        }
        this.drawAttackEffect();
        int[] clipData = this.mottionData == null ? this.clipData[this.curIndex] : this.clipData[this.mottionData[this.curIndex]];
        if (this.type == 2) {
            switch (this.dir) {
                case 2: {
                    Tools.addImage(28, this.imgIndex, this.x, this.y, clipData, this.anchor, (byte)2, 1500, (int)this.scaleX, (int)this.scaleY, this.degrees);
                    break;
                }
                case 0: {
                    Tools.addImage(28, this.imgIndex, this.x, this.y, clipData, this.anchor, (byte)0, 1500, (int)this.scaleX, (int)this.scaleY, this.degrees);
                    break;
                }
                case 3: {
                    Tools.addImage(28, this.imgIndex, this.x, this.y, clipData, this.anchor, (byte)6, 1500, (int)this.scaleX, (int)this.scaleY, this.degrees);
                    break;
                }
                case 1: {
                    Tools.addImage(28, this.imgIndex, this.x, this.y, clipData, this.anchor, (byte)5, 1500, (int)this.scaleX, (int)this.scaleY, this.degrees);
                }
            }
            return;
        }
        if (this.type == 1) {
            if (GMIDlet.gameIndex % 3 < 2) {
                Tools.addLine(this.x, this.y, this.getAimX(), this.getAimY(), (byte)2, 14486527, 1500);
                Tools.addLine(this.x - 1, this.y, this.getAimX() - 1, this.getAimY(), (byte)2, 14486527, 1500);
                Tools.addLine(this.x + 1, this.y, this.getAimX() + 1, this.getAimY(), (byte)2, 14486527, 1500);
            } else {
                Tools.addLine(this.x, this.y, this.getAimX(), this.getAimY(), (byte)2, 0xFFFFFF, 1500);
                Tools.addLine(this.x - 1, this.y, this.getAimX() - 1, this.getAimY(), (byte)2, 0xFFFFFF, 1500);
                Tools.addLine(this.x + 1, this.y, this.getAimX() + 1, this.getAimY(), (byte)2, 0xFFFFFF, 1500);
            }
            return;
        }
        Tools.addImage(28, this.imgIndex, this.x, this.y, clipData, this.anchor, (byte)0, 1500, (int)this.scaleX, (int)this.scaleY, this.degrees);
    }

    void drawFireNova(int index) {
        int r = 0;
        switch (index) {
            case 0: {
                r = 28;
                break;
            }
            case 1: {
                r = 44;
                break;
            }
            case 2: {
                r = 56;
            }
        }
        if (r == 0) {
            if (Tools.getImage(28, 34) == null) {
                Tools.loadImages(28, new String[]{"34"});
            }
            Tools.addImage(28, 34, this.x, this.y, (byte)7, (byte)0, 0);
            Tools.addImage(28, 34, this.x, this.y, (byte)1, (byte)1, 0);
            return;
        }
        Tools.addARC(this.x, this.y, r, r, 0, 360, true, (byte)4, 16747262, 0);
    }

    void drawIceNova(int index) {
        int r = 0;
        switch (index) {
            case 0: {
                r = 28;
                break;
            }
            case 1: {
                r = 44;
                break;
            }
            case 2: {
                r = 56;
            }
        }
        if (r == 0) {
            if (Tools.getImage(28, 33) == null) {
                Tools.loadImages(28, new String[]{"33"});
            }
            Tools.addImage(28, 33, this.x, this.y, (byte)7, (byte)0, 0);
            Tools.addImage(28, 33, this.x, this.y, (byte)1, (byte)1, 0);
            return;
        }
        Tools.addARC(this.x, this.y, r, r, 0, 360, true, (byte)4, 5422847, 0);
    }

    void drawRange() {
        if (this.range <= 0) {
            return;
        }
        Tools.addMaskCircle(this.x, this.y, this.range, 0x20000000, 1501);
        Tools.addARC(this.x - this.range, this.y - this.range, this.range * 2, this.range * 2, 0, 360, false, (byte)0, -1, 1501);
    }

    void drawAttackEffect() {
        switch (this.type) {
            case 1: {
                if (Tools.getImage(3, 0) == null) {
                    Tools.loadImages(3, new String[]{String.valueOf(0)});
                }
                Tools.addGridImage(3, 0, this.getAimX(), this.getAimY() - 10, 3, 1, GCanvas.gameTime % 3, 0, (byte)4, (byte)0, 2001);
                break;
            }
        }
    }

    void move() {
        switch (this.atkType) {
            case 1: {
                this.run_self();
                break;
            }
            case 2: 
            case 7: {
                this.run_line();
                this.move_line_follow();
                break;
            }
            case 4: {
                this.run_line_range();
                this.move_line_follow();
                break;
            }
            case 3: {
                this.run_through();
                this.move_line();
                break;
            }
            case 8: {
                this.run_line_through_degrees();
                break;
            }
            case 5: {
                this.run_line_more();
                this.move_line_more();
                break;
            }
            case 6: {
                this.run_link();
                this.move_link();
                break;
            }
            case 10: {
                this.run_link_range();
                this.move_link();
                break;
            }
            case 9: {
                this.run_through_bomb();
                this.move_line();
            }
        }
        this.runCurIndex();
        if (!Tools.isDraw(this.x, this.y, 40, 40, (byte)2)) {
            this.remove();
        }
    }

    void runCurIndex() {
        int maxIndex = this.mottionData == null ? this.frameLen : this.mottionData.length;
        ++this.curIndex;
        this.curIndex %= maxIndex;
    }

    private void run_self() {
        int i = 0;
        while (i < this.aimArray.size()) {
            int aimIndex = ((Utils)this.aimArray.elementAt((int)i)).i;
            if (Rank.enemy[aimIndex].isDead()) {
                this.aimArray.removeElementAt(i);
            } else if (Tools.pointAndCircle(Rank.enemy[aimIndex].s.x, Rank.enemy[aimIndex].s.y, this.x, this.y, this.getRange() * (this.curIndex + 1) / this.frameLen + Map.tileWidth / 2)) {
                this.hurtEnemy(0, aimIndex, this.hitEffId);
                this.aimArray.removeElementAt(i);
                --i;
            }
            ++i;
        }
        int i2 = 0;
        while (i2 < this.deckArray.size()) {
            int aimIndex = ((Utils)this.deckArray.elementAt((int)i2)).i;
            if (Rank.deck[aimIndex].isDead()) {
                this.deckArray.removeElementAt(i2);
            } else if (Tools.pointAndCircle(Rank.deck[aimIndex].hitX, Rank.deck[aimIndex].hitY, this.x, this.y, this.getRange() * (this.curIndex + 1) / this.frameLen + Rank.deck[aimIndex].offRange)) {
                this.hurtEnemy(1, aimIndex, this.hitEffId);
                this.deckArray.removeElementAt(i2);
                --i2;
            }
            ++i2;
        }
        if (this.curIndex >= this.frameLen - 1) {
            this.remove();
        }
    }

    private void run_line() {
        if (this.followHit(this.aimX, this.aimY)) {
            this.hurtEnemy(this.aimType, this.aimIndex, this.hitEffId);
            this.remove();
            return;
        }
        if (!Tools.isDraw(this.x, this.y, this.w, this.h, (byte)2)) {
            this.remove();
        }
    }

    private void move_line() {
        this.x += this.moveX;
        this.y += this.moveY;
        if (this.degrees != null) {
            this.degrees[1] = this.x;
            this.degrees[2] = this.y;
        }
    }

    private void move_line_follow() {
        this.aimX = this.getAimX();
        this.aimY = this.getAimY() - 10;
        int a2 = this.aimX - this.x;
        int b2 = this.aimY - this.y;
        int r = (int)Tools.sqrt(a2 * a2 + b2 * b2) / 100;
        if (a2 != 0) {
            this.moveX = a2 * this.speed / r;
        }
        if (b2 != 0) {
            this.moveY = b2 * this.speed / r;
        }
        if (Math.abs(a2) <= Math.abs(this.moveX) && Math.abs(b2) <= Math.abs(this.moveY)) {
            this.x = this.aimX;
            this.y = this.aimY;
        } else {
            this.x += this.moveX;
            this.y += this.moveY;
        }
        if (this.degrees != null) {
            this.degrees[1] = this.x;
            this.degrees[2] = this.y;
        }
    }

    private void run_line_range() {
        if (this.followHit(this.aimX, this.aimY)) {
            this.hurtEnemy(this.aimType, this.aimIndex, 11, 50);
            this.hurtRange(-1);
            this.remove();
        }
    }

    private void run_through() {
        int i = 0;
        while (i < this.aimArray.size()) {
            int aimIndex = ((Utils)this.aimArray.elementAt((int)i)).i;
            if (Rank.enemy[aimIndex].isDead()) {
                this.aimArray.removeElementAt(i);
            } else if (this.hit(0, aimIndex, Rank.enemy[aimIndex].s.x, Rank.enemy[aimIndex].s.y)) {
                this.hurtEnemy(0, aimIndex, this.hitEffId);
                this.aimArray.removeElementAt(i);
                --i;
            }
            ++i;
        }
        int i2 = 0;
        while (i2 < this.deckArray.size()) {
            int aimIndex = ((Utils)this.deckArray.elementAt((int)i2)).i;
            if (Rank.deck[aimIndex].isDead()) {
                this.deckArray.removeElementAt(i2);
            } else if (this.hit(1, aimIndex, Rank.deck[aimIndex].hitX, Rank.deck[aimIndex].hitY)) {
                this.hurtEnemy(1, aimIndex, this.hitEffId);
                this.deckArray.removeElementAt(i2);
                --i2;
            }
            ++i2;
        }
    }

    private void run_through_bomb() {
        int i = 0;
        while (i < this.aimArray.size()) {
            int aimIndex = ((Utils)this.aimArray.elementAt((int)i)).i;
            if (Rank.enemy[aimIndex].isDead()) {
                this.aimArray.removeElementAt(i);
            } else if (this.hit(0, aimIndex, Rank.enemy[aimIndex].s.x, Rank.enemy[aimIndex].s.y)) {
                this.hurtEnemy(0, aimIndex, this.hitEffId, 50);
                this.hurtRange(13);
                this.aimArray.removeElementAt(i);
                --i;
            }
            ++i;
        }
        int i2 = 0;
        while (i2 < this.deckArray.size()) {
            int aimIndex = ((Utils)this.deckArray.elementAt((int)i2)).i;
            if (Rank.deck[aimIndex].isDead()) {
                this.deckArray.removeElementAt(i2);
            } else if (this.hit(1, aimIndex, Rank.deck[aimIndex].hitX, Rank.deck[aimIndex].hitY)) {
                this.hurtEnemy(1, aimIndex, this.hitEffId, 50);
                this.hurtRange(13);
                this.deckArray.removeElementAt(i2);
                --i2;
            }
            ++i2;
        }
        if (!Tools.isDraw(this.x, this.y, 40, 40, (byte)2)) {
            this.remove();
        }
    }

    private void drawHitRange(int x, int y, int r, int layer) {
        Tools.addMaskCircle(x, y, r, 0x20000000, layer + 1);
        Tools.addARC(x - r, y - r, r * 2, r * 2, 0, 360, false, (byte)0, -1, layer + 1);
    }

    private void run_line_through_degrees() {
        if (this.curIndex == 2) {
            int i = 0;
            while (i < this.aimArray.size()) {
                int aimIndex = ((Utils)this.aimArray.elementAt((int)i)).i;
                if (Rank.enemy[aimIndex].isDead()) {
                    this.aimArray.removeElementAt(i);
                } else if (Tools.pointToSegment(this.x, this.y, this.aimX, this.aimY, Rank.enemy[aimIndex].s.x, Rank.enemy[aimIndex].s.y) < EnemyTD.OFFRANGE) {
                    this.hurtEnemy(0, aimIndex, this.hitEffId);
                    this.aimArray.removeElementAt(i);
                    --i;
                }
                ++i;
            }
            int i2 = 0;
            while (i2 < this.deckArray.size()) {
                int aimIndex = ((Utils)this.deckArray.elementAt((int)i2)).i;
                if (Rank.deck[aimIndex].isDead()) {
                    this.deckArray.removeElementAt(i2);
                } else if (Tools.pointToSegment(this.x, this.y, this.aimX, this.aimY, Rank.deck[aimIndex].hitX, Rank.deck[aimIndex].hitY) < Rank.deck[aimIndex].offRange) {
                    this.hurtEnemy(1, aimIndex, this.hitEffId);
                    this.deckArray.removeElementAt(i2);
                    --i2;
                }
                ++i2;
            }
        }
        if (this.curIndex >= this.mottionData.length - 1) {
            this.remove();
        }
    }

    private void move_line_through_degrees() {
        int range;
        int radian = this.degrees[0] % 90 * 10000 / 10000;
        byte qd = Tools.getExactQD(this.degrees[0]);
        int speed = range = 640;
        int moveX = 0;
        int moveY = 0;
        switch (qd) {
            case 1: {
                moveX = speed * Tools.cos(radian);
                moveY = speed * Tools.sin(radian);
                break;
            }
            case 2: {
                moveX = -speed * Tools.sin(radian);
                moveY = speed * Tools.cos(radian);
                break;
            }
            case 3: {
                moveX = -speed * Tools.cos(radian);
                moveY = -speed * Tools.sin(radian);
                break;
            }
            case 4: {
                moveX = speed * Tools.sin(radian);
                moveY = -speed * Tools.cos(radian);
                break;
            }
            case 5: {
                moveX = 0;
                moveY = -speed;
                break;
            }
            case 6: {
                moveX = speed;
                moveY = 0;
                break;
            }
            case 7: {
                moveX = 0;
                moveY = speed;
                break;
            }
            case 8: {
                moveX = -speed;
                moveY = 0;
            }
        }
        this.aimX = this.x + moveX;
        this.aimY = this.y + moveY;
    }

    private void run_line_more() {
        this.touch();
        if (!Tools.isDraw(this.x, this.y, this.w, this.h, (byte)2)) {
            this.remove();
        }
    }

    private void move_line_more() {
        this.x += this.moveX;
        this.y += this.moveY;
        if (this.degrees != null) {
            this.degrees[1] = this.x;
            this.degrees[2] = this.y;
        }
    }

    private void move_link() {
        this.aimX = this.getAimX();
        this.aimY = this.getAimY() - 10;
        int space = Tools.getSpace(this.x, this.y, this.aimX, this.aimY);
        this.degrees = new int[]{Tools.getDegrees(this.x, this.y, this.aimX, this.aimY), this.x, this.y};
        this.overridesXY();
    }

    private void run_link() {
        if (Rank.tower[this.towerIndex] == null) {
            this.remove();
            return;
        }
        if (!Rank.tower[this.towerIndex].s.isAttack()) {
            this.remove();
            Rank.tower[this.towerIndex].s.setStatus((byte)-1);
            return;
        }
        if (!Tower.inAttackRange(this.getAimX(), this.getAimY(), Rank.tower[this.towerIndex].s.x, Rank.tower[this.towerIndex].s.y, Rank.tower[this.towerIndex].getRange(), this.aimType == 1 ? Rank.deck[this.aimIndex].offRange : EnemyTD.OFFRANGE)) {
            this.remove();
            Rank.tower[this.towerIndex].s.setStatus((byte)-1);
            return;
        }
        switch (this.aimType) {
            case 1: {
                if (!Rank.deck[this.aimIndex].isDead()) break;
                Rank.tower[this.towerIndex].s.setStatus((byte)-1);
                this.remove();
                return;
            }
            default: {
                if (!Rank.enemy[this.aimIndex].isDead()) break;
                Rank.tower[this.towerIndex].s.setStatus((byte)-1);
                this.remove();
                return;
            }
        }
        if (this.hurtIndex > this.hurtInterval) {
            this.hurtEnemy(this.aimType, this.aimIndex, this.hitEffId);
            this.hurtIndex = 0;
        } else {
            this.hurtIndex = (short)(this.hurtIndex + Rank.gameSpeed);
        }
        if (this.aimType != Rank.tower[this.towerIndex].aimType || this.aimIndex != Rank.tower[this.towerIndex].aimIndex) {
            this.remove();
            Rank.tower[this.towerIndex].s.setStatus((byte)-1);
            return;
        }
    }

    private void run_link_range() {
        if (this.hurtIndex == this.hurtInterval + 1) {
            this.hurtRange(this.aimX, this.aimY, -1);
        }
        this.run_link();
    }

    static int addBullet(Tower tower) {
        Bullet b2 = new Bullet(tower);
        Rank.bullet.addElement(b2);
        return Rank.bullet.size() - 1;
    }

    static void addBullet(Tower tower, int num, int offDegrees) {
        int start = -offDegrees * (num - 1) / 2;
        int i = 0;
        while (i < num) {
            Bullet b2 = new Bullet(tower);
            b2.setDegrees(start + offDegrees * i + b2.getDegrees());
            b2.resetMove();
            Rank.bullet.addElement(b2);
            ++i;
        }
    }

    static Bullet getBullet(int id) {
        if (id > -1 && id < Rank.bullet.size()) {
            return (Bullet)Rank.bullet.elementAt(id);
        }
        return null;
    }

    void remove() {
        Rank.bullet.removeElement(this);
    }

    private void touch() {
        this.touchEnemy();
        this.touchDeck();
        if (!Tools.isDraw(this.x, this.y, this.w, this.h, (byte)2)) {
            this.remove();
        }
    }

    private void touchEnemy() {
        if (Rank.enemy == null) {
            return;
        }
        int i = 0;
        while (i < Rank.enemy.length) {
            if (!Rank.enemy[i].isDead() && this.hit(0, i, Rank.enemy[i].s.x, Rank.enemy[i].s.y)) {
                this.hurtEnemy(0, i, this.hitEffId);
                this.remove();
                return;
            }
            ++i;
        }
    }

    private void touchDeck() {
        if (Rank.deck == null) {
            return;
        }
        int i = 0;
        while (i < Rank.deck.length) {
            if (!Rank.deck[i].isDead() && this.hit(1, i, Rank.deck[i].hitX, Rank.deck[i].hitY)) {
                this.hurtEnemy(1, i, this.hitEffId);
                this.remove();
                return;
            }
            ++i;
        }
    }

    void hurtEnemy(int aimType, int enemyIndex, int eftIndex) {
        try {
            switch (aimType) {
                case 0: {
                    Rank.enemy[enemyIndex].hurt(Tower.getHurtVaule(this.getAttack(), Rank.enemy[enemyIndex].getDefense()), eftIndex, this.hitSound, this.buffId);
                    break;
                }
                case 1: {
                    Rank.deck[enemyIndex].hurt(Tower.getHurtVaule(this.getAttack(), Rank.deck[enemyIndex].defense), eftIndex, this.hitSound, this.buffId);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    void hurtEnemy(int aimType, int enemyIndex, int eftIndex, int hurtRatio) {
        try {
            switch (aimType) {
                case 0: {
                    Rank.enemy[enemyIndex].hurt(Tower.getHurtVaule(this.getAttack(), Rank.enemy[enemyIndex].getDefense()) * hurtRatio / 100, eftIndex, this.hitSound, this.buffId);
                    break;
                }
                case 1: {
                    Rank.deck[enemyIndex].hurt(Tower.getHurtVaule(this.getAttack(), Rank.deck[enemyIndex].defense) * hurtRatio / 100, eftIndex, this.hitSound, this.buffId);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    void hurtRange(int hurtRangeEffect) {
        this.hurtRange(this.x, this.y, hurtRangeEffect);
    }

    void hurtRange(int aimX, int aimY, int hurtRangeEffect) {
        this.hurtRangeEnemy(aimX, aimY, hurtRangeEffect);
        this.hurtRangeDeck(aimX, aimY, hurtRangeEffect);
    }

    private void hurtRangeEnemy(int aimX, int aimY, int hurtRangeEffect) {
        if (Rank.enemy == null) {
            return;
        }
        int i = 0;
        while (i < Rank.enemy.length) {
            if (!Rank.enemy[i].isDead() && Tools.pointAndCircle(Rank.enemy[i].s.x, Rank.enemy[i].s.y, aimX, aimY, this.getRange() + Map.tileWidth / 2)) {
                this.hurtEnemy(0, i, hurtRangeEffect, 50);
            }
            ++i;
        }
    }

    private void hurtRangeDeck(int aimX, int aimY, int hurtRangeEffect) {
        if (Rank.deck == null) {
            return;
        }
        int i = 0;
        while (i < Rank.deck.length) {
            if (!Rank.deck[i].isDead() && Tools.pointAndCircle(Rank.deck[i].hitX, Rank.deck[i].hitY, aimX, aimY, this.getRange() + Rank.deck[i].offRange)) {
                this.hurtEnemy(1, i, hurtRangeEffect, 50);
            }
            ++i;
        }
    }

    boolean hit(int aimType, int index, int aimX, int aimY) {
        switch (aimType) {
            case 0: {
                return Tools.circleAndCircle(this.x, this.y, 1, aimX, aimY, Rank.enemy[index].s.w / 2);
            }
            case 1: {
                if (Rank.deck[index].w == Rank.deck[index].h) {
                    return Tools.circleAndCircle(this.x, this.y, 1, aimX, aimY, Rank.deck[index].w / 2);
                }
                return Tools.circleAndRect(this.x, this.y, 15, aimX - Rank.deck[index].w / 2, aimY - Rank.deck[index].h / 2, Rank.deck[index].w, Rank.deck[index].h);
            }
        }
        return false;
    }

    boolean followHit(int aimX, int aimY) {
        return Tools.hit(this.x - 5, this.y - 5, 10, 10, aimX - 5, aimY - 10, 10, 10);
    }

    boolean outScreen() {
        return !Tools.isDraw(this.x - 40, this.y - 40, 80, 80, (byte)0);
    }
}

