/*
 * Decompiled with CFR 0.152.
 */
package com.gn4me.waka.menu;

import com.gn4me.waka.Game;
import com.gn4me.waka.Main;
import com.gn4me.waka.Resources;
import com.gn4me.waka.Tasks;
import com.gn4me.waka.menu.Element;
import java.util.Vector;
import javax.microedition.lcdui.Canvas;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class MenuDownload
extends Canvas {
    protected Vector vecElements;
    protected int numberOfElements = -1;
    protected int spacer = 20;
    private int selectedIndex;
    private int menuX;
    private int menuY;
    private int height;
    private int width;
    private Game game;

    public MenuDownload() {
        this.setFullScreenMode(true);
        this.vecElements = new Vector();
        this.game = Main.currentGame;
        this.creatElements();
        this.calculate();
    }

    protected void calculate() {
        Element element = null;
        this.numberOfElements = this.vecElements.size();
        this.height = this.numberOfElements * (40 + this.spacer) - this.spacer;
        this.width = 215;
        this.menuX = 180 - this.width / 2;
        this.menuY = 320 - this.height / 2;
        for (int j = 0; j < this.vecElements.size(); ++j) {
            element = (Element)this.vecElements.elementAt(j);
            element.setX(this.menuX);
            element.setY(this.menuY + j * (40 + this.spacer));
        }
    }

    public void paint(Graphics gg) {
        this.setFullScreenMode(true);
        Image i = null;
        i = this.getWidth() < this.getHeight() ? Image.createImage((int)this.getWidth(), (int)this.getHeight()) : Image.createImage((int)this.getHeight(), (int)this.getWidth());
        Graphics g = i.getGraphics();
        g.setColor(0xFFFFFF);
        g.fillRect(0, 0, this.getWidth(), this.getHeight());
        g.drawImage(Resources.MENU_BACKGROUND, i.getWidth() / 2, i.getHeight() / 2, 3);
        g.drawImage(Resources.FULL_VERSION, 230, 145, 3);
        for (int j = 0; j < this.vecElements.size(); ++j) {
            ((Element)this.vecElements.elementAt(j)).draw(g);
        }
        if (this.getWidth() < this.getHeight()) {
            gg.drawImage(i, 0, 0, 20);
        } else {
            gg.drawRegion(i, 0, 0, i.getWidth(), i.getHeight(), 6, 0, 0, 20);
        }
    }

    public void creatElements() {
        Element element = null;
        element = new Element(12, Resources.MENU_DOWNLOAD, null);
        element.setSelected(true);
        this.vecElements.addElement(element);
        element = new Element(9, Resources.MENU_MAIN_MENU, null);
        this.vecElements.addElement(element);
    }

    public void pointerDragged(int x, int y) {
    }

    public void pointerPressed(int x, int y) {
        if (x < this.menuX || x > this.menuX + 215 || y < this.menuY || y > this.menuY + this.height) {
            return;
        }
        this.selectedIndex = (y -= this.menuY) / (40 + this.spacer);
        switch (this.selectedIndex) {
            case 0: {
                Main.downloadFullVersion();
                break;
            }
            case 1: {
                Tasks.viewMEnu().execute();
            }
        }
    }

    public void pointerReleased(int x, int y) {
    }
}

