/*
 * Decompiled with CFR 0.152.
 */
package com.gn4me.waka.objects;

import com.gn4me.waka.Data;
import com.gn4me.waka.objects.Circle;
import com.gn4me.waka.objects.GameObject;
import com.j2mearmyknife.image.sources.SmartImage;
import com.j2mearmyknife.image.transformations.ImageTransformationRotate;
import javax.microedition.lcdui.Graphics;
import org.jbox2d.common.Vec2;

public class Box
extends GameObject {
    private int lastAngle;
    private SmartImage smartImage;

    public Box(Data data, int x, int y, int angle) {
        super(data);
        this.body = this.world.createBoX((float)x, (float)y, (float)data.width, data.height, -angle);
        this.rotate(angle);
    }

    public Box(Data data, int x, int y, int angle, boolean computeMass) {
        super(data);
        this.computeMass = computeMass;
        this.body = this.world.createBoX(x, y, data.width, data.height, -angle, computeMass);
        this.rotate(angle);
    }

    public Box(Circle circle) {
        switch (circle.getData().type) {
            case 2: {
                this.data = Data.BOX_GREEN_LARGE;
                break;
            }
            case 3: {
                this.data = Data.BOX_GREEN_SMALL;
                break;
            }
            case 0: {
                this.data = Data.BOX_RED_LARGE;
                break;
            }
            case 1: {
                this.data = Data.BOX_RED_SMALL;
            }
        }
        Vec2 linearVelocity = circle.getBody().getLinearVelocity();
        Vec2 position = circle.getBody().getPosition();
        this.body = this.world.createBoX((float)this.data.width, (float)this.data.height, 0, linearVelocity, position);
        this.rotate(0);
    }

    public void cycle() {
        this.setStatus();
        int angle = (int)Math.toDegrees(this.body.getAngle());
        angle *= -1;
        while (angle < 0) {
            angle += 360;
        }
        if (Math.abs((angle = (angle + 360) % 360) - this.lastAngle) > 1) {
            this.rotate(angle);
            this.lastAngle = angle;
        }
    }

    public void draw(Graphics g) {
        int x = this.world.worldToScreenX(this.body.getPosition().x);
        int y = this.world.worldToScreenY(this.body.getPosition().y);
        this.smartImage.drawOnGraphics(g, x, y, 3);
        if (this.data.type != 8 && this.data.type != 9 && this.data.type != 10 && this.data.type != 11) {
            this.drawFace(g, x, y);
        }
    }

    private void rotate(int angle) {
        this.smartImage = new SmartImage(this.data.image);
        ImageTransformationRotate imageTransformationRotate = new ImageTransformationRotate();
        imageTransformationRotate.setAngle(angle);
        this.smartImage = (SmartImage)imageTransformationRotate.process(this.smartImage);
    }

    public Box(Box box) {
        super(box.getData());
        int x = this.world.worldToScreenX(box.getBody().getPosition().x);
        int y = this.world.worldToScreenY(box.getBody().getPosition().y);
        int angle = (int)Math.toDegrees(box.getBody().getAngle());
        this.body = box.computeMass ? this.world.createBoX((float)x, (float)y, (float)this.data.width, this.data.height, angle) : this.world.createBoX(x -= box.getData().width / 2, y -= box.getData().height / 2, this.data.width, this.data.height, angle, false);
        this.rotate(-angle);
    }
}

