/*
 * Decompiled with CFR 0.152.
 */
package com.gn4me.waka;

import com.gn4me.Point;
import com.gn4me.waka.Drawable;
import com.gn4me.waka.Main;
import com.gn4me.waka.Resources;
import com.gn4me.waka.Setting;
import com.gn4me.waka.Tasks;
import com.gn4me.waka.menu.MenuFail;
import com.gn4me.waka.menu.MenuGame;
import com.gn4me.waka.menu.MenuSuccess;
import com.gn4me.waka.menu.Options;
import com.gn4me.waka.objects.Box;
import com.gn4me.waka.objects.Circle;
import com.gn4me.waka.objects.Cross;
import com.gn4me.waka.objects.GameObject;
import com.gn4me.waka.objects.JointWaka;
import com.gn4me.waka.objects.PhysicsWorld;
import java.util.Vector;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import javax.microedition.lcdui.game.GameCanvas;

public abstract class Game
extends GameCanvas
implements Runnable {
    public static Image imgFaceCircleRedSmall;
    public static Image imgFaceCircleRedLarge;
    public static Image imgFaceCircleGreenSmall;
    public static Image imgFaceCircleGreenLarge;
    public static Image imgFaceBoxRedSmall;
    public static Image imgFaceBoxRedLarge;
    public static Image imgFaceBoxGreenSmall;
    public static Image imgFaceBoxGreenLarge;
    protected Image imgBackGround;
    protected Vector vecObjects;
    protected PhysicsWorld world;
    protected int levelNumber;
    private Point pointTouch;
    private final Object InputSync = new Object();
    private Drawable drawable;
    private boolean paused = false;
    private Tasks endTask;
    private long TickTime;
    private final int targetCycleTime;
    private long startTime;
    private long endtime;
    private long cycleTime;
    private boolean running;
    private boolean debug;
    private String debugString = "";
    public static String debugString2;
    private boolean finished;

    public Game() {
        super(true);
        this.targetCycleTime = 100;
        this.setFullScreenMode(true);
        this.vecObjects = new Vector();
        this.world = PhysicsWorld.getNewInstance();
        this.load();
    }

    public void setDrawable(Drawable drawable) {
        this.drawable = drawable;
    }

    public void load() {
        this.imgBackGround = this.levelNumber < 10 ? Resources.BACKGROUND1 : (this.levelNumber < 19 ? Resources.BACKGROUND2 : (this.levelNumber < 28 ? Resources.BACKGROUND3 : (this.levelNumber < 37 ? Resources.BACKGROUND4 : Resources.BACKGROUND5)));
    }

    protected void sortObjects() {
        GameObject gameObject;
        int j;
        Vector<GameObject> vector = new Vector<GameObject>();
        for (j = 0; j < this.vecObjects.size(); ++j) {
            gameObject = (GameObject)this.vecObjects.elementAt(j);
            if (gameObject instanceof JointWaka) continue;
            vector.addElement(gameObject);
        }
        for (j = 0; j < this.vecObjects.size(); ++j) {
            gameObject = (GameObject)this.vecObjects.elementAt(j);
            if (!(gameObject instanceof JointWaka)) continue;
            vector.addElement(gameObject);
        }
        this.vecObjects = vector;
    }

    public void run() {
        Graphics g = this.getGraphics();
        while (this.running) {
            try {
                this.startTime = System.currentTimeMillis();
                this.input();
                if (!this.paused && !this.finished) {
                    this.cycle();
                }
                this.render(g);
                this.endtime = System.currentTimeMillis();
                this.cycleTime = this.endtime - this.startTime;
                this.TickTime = 100L - this.cycleTime;
                this.debugString = this.TickTime + "";
                if (this.TickTime > 0L) {
                    Thread.sleep(this.TickTime);
                }
                if (Main.isForeground() || this.drawable != null) continue;
                this.drawable = new MenuGame();
                this.pause();
                System.gc();
            }
            catch (Exception ex) {
                ex.printStackTrace();
                this.render(g);
            }
        }
        this.render(g);
        this.clean();
        if (this.endTask != null) {
            this.endTask.execute();
        }
    }

    public void setEndTask(Tasks endTask) {
        this.endTask = endTask;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void input() {
        if (this.pointTouch == null) {
            return;
        }
        Point p = null;
        Object object = this.InputSync;
        synchronized (object) {
            p = new Point(this.pointTouch);
            this.pointTouch = null;
        }
        for (int j = this.vecObjects.size() - 1; j >= 0; --j) {
            GameObject gameObject = (GameObject)this.vecObjects.elementAt(j);
            if (!gameObject.containsPoint(p) || gameObject instanceof JointWaka || gameObject instanceof Cross) continue;
            if (gameObject instanceof Box) {
                Box box = (Box)gameObject;
                int type = box.getData().type;
                if (type == 8 || type == 9 || type == 10 || type == 11) continue;
                this.vecObjects.addElement(new Circle(box));
            } else if (gameObject instanceof Circle) {
                this.vecObjects.addElement(new Box((Circle)gameObject));
            }
            gameObject.remove();
            this.vecObjects.removeElement(gameObject);
        }
    }

    public int getLevelNumber() {
        return this.levelNumber;
    }

    public int getStageNumber() {
        int stNumber = -1;
        stNumber = this.levelNumber >= 37 ? 5 : (this.levelNumber >= 28 ? 4 : (this.levelNumber >= 19 ? 3 : (this.levelNumber >= 10 ? 2 : 1)));
        return stNumber;
    }

    public int getNextStageNumber() {
        int stNumber = -1;
        int ln = this.levelNumber + 1;
        stNumber = ln >= 37 ? 5 : (ln >= 28 ? 4 : (ln >= 19 ? 3 : (ln >= 10 ? 2 : 1)));
        return stNumber;
    }

    private void cycle() {
        int type;
        GameObject gameObject;
        int j;
        this.debug = !this.debug;
        this.world.cycle();
        for (int j2 = this.vecObjects.size() - 1; j2 >= 0; --j2) {
            GameObject gameObject2 = (GameObject)this.vecObjects.elementAt(j2);
            gameObject2.cycle();
        }
        boolean redFound = false;
        for (j = this.vecObjects.size() - 1; j >= 0; --j) {
            gameObject = (GameObject)this.vecObjects.elementAt(j);
            if (gameObject instanceof JointWaka) continue;
            type = gameObject.getData().type;
            if ((type == 4 || type == 5 || type == 2 || type == 3) && gameObject.getStatus() == 0) {
                this.setDrawable(new MenuFail());
                Main.vibrate(100);
                this.finished = true;
                return;
            }
            if (type != 6 && type != 7 && type != 0 && type != 1 || gameObject.getStatus() == 0) continue;
            redFound = true;
        }
        if (redFound) {
            return;
        }
        for (j = this.vecObjects.size() - 1; j >= 0; --j) {
            gameObject = (GameObject)this.vecObjects.elementAt(j);
            if (gameObject instanceof JointWaka || (type = gameObject.getData().type) != 4 && type != 5 && type != 2 && type != 3 || gameObject.isSleeping()) continue;
            return;
        }
        Setting setting = Setting.getInstance();
        if (setting.getSavedLevel() < this.levelNumber) {
            setting.setSavedLevel((byte)this.levelNumber);
            setting.save();
        }
        Main.vibrate(100);
        this.finished = true;
        if (this.levelNumber % 9 != 0) {
            this.setDrawable(new MenuSuccess());
        } else {
            this.endTask = this.levelNumber == 45 ? Tasks.viewMEnu() : Tasks.startLevel(this.levelNumber + 1);
            this.stop();
        }
    }

    public void renderNotSupported(Graphics g) {
        g.setColor(6218346);
        g.fillRect(0, 0, this.getWidth(), this.getHeight());
        g.drawImage(Resources.STOP, this.getWidth() / 2 - Resources.STOP.getWidth() / 2, this.getHeight() / 2 - Resources.STOP.getHeight() / 2, 20);
        this.flushGraphics();
    }

    private void render(Graphics g) {
        if (this.getWidth() > this.getHeight()) {
            this.renderNotSupported(g);
            return;
        }
        g.setColor(0xFFFFFF);
        g.fillRect(0, 0, this.getWidth(), this.getHeight());
        g.setColor(0);
        g.drawImage(this.imgBackGround, 0, 0, 20);
        for (int j = 0; j < this.vecObjects.size(); ++j) {
            ((GameObject)this.vecObjects.elementAt(j)).draw(g);
        }
        if (this.drawable == null && this.running) {
            g.drawImage(Resources.MENU_PAUSE, 10, 590, 20);
            g.drawImage(Resources.MENU_RESET, 350 - Resources.MENU_RESET.getWidth(), 590, 20);
        }
        if (this.drawable != null && this.running) {
            if (this.drawable instanceof Options || this.drawable instanceof MenuGame) {
                g.drawImage(Resources.MENU_BAC_LIGHT, 180 - Resources.MENU_BAC_LIGHT.getWidth() / 2, 320 - Resources.MENU_BAC_LIGHT.getHeight() / 2, 20);
            }
            this.drawable.paint(g);
        }
        g.drawImage(Resources.MENU_CLOSE, 360 - Resources.MENU_CLOSE.getWidth() - 10, 10, 20);
        if (!this.running) {
            g.drawImage(Resources.MENU_LOADING, 180 - Resources.MENU_LOADING.getWidth() / 2, 550, 20);
        }
        this.flushGraphics();
    }

    protected void pointerReleased(int x, int y) {
        if (this.getWidth() > this.getHeight()) {
            return;
        }
        if (this.drawable != null) {
            this.drawable.pointerReleased(x, y);
        }
    }

    protected void pointerDragged(int x, int y) {
        if (this.getWidth() > this.getHeight()) {
            return;
        }
        if (this.drawable != null) {
            this.drawable.pointerDragged(x, y);
        }
    }

    protected void keyPressed(int keyCode) {
    }

    protected void pointerPressed(final int x, final int y) {
        if (this.getWidth() > this.getHeight()) {
            return;
        }
        if (x > 305 && y < 50) {
            Main.menuVibrate();
            Main.exit();
            return;
        }
        if (x < 50 && y > 590 && this.drawable == null) {
            Main.menuVibrate();
            this.drawable = new MenuGame();
            this.pause();
            System.gc();
            return;
        }
        if (x > 300 && y > 590 && this.drawable == null) {
            Main.menuVibrate();
            this.setEndTask(Tasks.startLevel(this.levelNumber));
            this.stop();
        }
        if (this.drawable == null) {
            new Thread(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void run() {
                    Object object = Game.this.InputSync;
                    synchronized (object) {
                        Game.this.pointTouch = new Point();
                        Game.this.pointTouch.setX(x);
                        Game.this.pointTouch.setY(y);
                    }
                }
            }.start();
        } else {
            this.drawable.pointerPressed(x, y);
        }
    }

    public void start() {
        this.running = true;
        new Thread(this).start();
    }

    public void pause() {
        this.paused = true;
    }

    public void resume() {
        this.drawable = null;
        System.gc();
        this.paused = false;
    }

    public void restart() {
    }

    public boolean isRunning() {
        return this.running;
    }

    public void stop() {
        this.running = false;
    }

    public void clean() {
        this.vecObjects = null;
        this.imgBackGround = null;
        PhysicsWorld.clean();
        System.gc();
    }

    static {
        debugString2 = "";
    }
}

