/*
 * Decompiled with CFR 0.152.
 */
package com.gn4me.waka.menu;

import com.gn4me.waka.Drawable;
import com.gn4me.waka.Game;
import com.gn4me.waka.Main;
import com.gn4me.waka.Resources;
import com.gn4me.waka.menu.MenuGame;
import com.gn4me.waka.menu.OptionMenu;
import com.gn4me.waka.menu.SoundOptions;
import com.gn4me.waka.menu.VibrateOptions;
import javax.microedition.lcdui.Graphics;

public class Options
implements Drawable {
    private Game game;
    private OptionMenu optionMenu;
    private int xCenter;
    private int yBack = 450;
    private SoundOptions soundOptions;
    private VibrateOptions vibrateOptions;

    public Options(OptionMenu optionMenu, Game game) {
        this.optionMenu = optionMenu;
        this.game = game;
        this.xCenter = 180;
        this.soundOptions = new SoundOptions();
        this.soundOptions.setPosition(0, 200);
        this.vibrateOptions = new VibrateOptions();
        this.vibrateOptions.setX(0);
        this.vibrateOptions.setY(300);
    }

    public void paint(Graphics g) {
        this.soundOptions.paint(g);
        this.vibrateOptions.paint(g);
        g.drawImage(Resources.MENU_BACK, this.xCenter, this.yBack, 3);
    }

    public void pointerDragged(int x, int y) {
        this.soundOptions.pointerDragged(x, y);
    }

    public void pointerPressed(int x, int y) {
        if (y >= this.yBack - 10) {
            Main.menuVibrate();
            if (this.game != null) {
                this.game.setDrawable(new MenuGame());
                System.gc();
            } else {
                this.optionMenu.executeBack();
            }
            return;
        }
        this.soundOptions.pointerPressed(x, y);
        this.vibrateOptions.pointerPressed(x, y);
    }

    public void pointerReleased(int x, int y) {
        this.soundOptions.pointerReleased(x, y);
    }
}

