/*
 * Decompiled with CFR 0.152.
 */
package com.gn4me.waka.objects;

import com.gn4me.Point;
import com.gn4me.waka.Data;
import com.gn4me.waka.Game;
import com.gn4me.waka.Operations;
import com.gn4me.waka.objects.PhysicsWorld;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.TextBox;
import org.jbox2d.dynamics.Body;

public abstract class GameObject {
    public static final int TYPE_CIRCLE_RED_LARGE = 0;
    public static final int TYPE_CIRCLE_RED_SMALL = 1;
    public static final int TYPE_CIRCLE_GREEN_LARGE = 2;
    public static final int TYPE_CIRCLE_GREEN_SMALL = 3;
    public static final int TYPE_BOX_GREEN_LARGE = 4;
    public static final int TYPE_BOX_GREEN_SMALL = 5;
    public static final int TYPE_BOX_RED_LARGE = 6;
    public static final int TYPE_BOX_RED_SMALL = 7;
    public static final int TYPE_BAR1 = 8;
    public static final int TYPE_BAR2 = 9;
    public static final int TYPE_BAR3 = 10;
    public static final int TYPE_BAR4 = 11;
    public static final int TYPE_JOINT = 12;
    public static final int TYPE_CROSS_SMALL = 13;
    public static final int TYPE_CROSS_LARGE = 14;
    public static final int STATUS_OUT = 0;
    public static final int STATUS_SILENT = 1;
    public static final int STATUS_MOVING = 2;
    protected int status = 1;
    private byte silentPeriod = (byte)100;
    protected Body body;
    protected Data data;
    protected PhysicsWorld world;
    protected boolean computeMass = true;

    public Body getBody() {
        return this.body;
    }

    public void setBody(Body body) {
        this.body = body;
    }

    public Data getData() {
        return this.data;
    }

    public GameObject() {
        this.world = PhysicsWorld.getInstance();
    }

    public GameObject(Data data) {
        this.data = data;
        this.world = PhysicsWorld.getInstance();
    }

    public void cycle() {
    }

    public void draw(Graphics g) {
        int x = this.world.worldToScreenX(this.body.getPosition().x);
        int y = this.world.worldToScreenY(this.body.getPosition().y);
        Operations.rotateDrawImage(g, this.data.image, this.body.getAngle(), x, y);
    }

    public boolean containsPoint(Point point) {
        int x = this.world.worldToScreenX(this.body.getPosition().x);
        int y = this.world.worldToScreenY(this.body.getPosition().y);
        return point.getX() > (x -= this.data.width / 2) - 5 && point.getX() < x + this.data.width + 5 && point.getY() > (y -= this.data.height / 2) - 5 && point.getY() < y + this.data.height + 5;
    }

    public void remove() {
        this.world.removeBody(this.body);
    }

    public boolean isComputeMass() {
        return this.computeMass;
    }

    public void printCode(TextBox textBox) {
    }

    public int getStatus() {
        return this.status;
    }

    protected void setStatus() {
        int x = this.world.worldToScreenX(this.body.getPosition().x);
        int y = this.world.worldToScreenY(this.body.getPosition().y);
        this.status = (x -= this.data.width / 2) > 360 || x < 0 - this.data.width || (y -= this.data.height / 2) > 640 || y < 0 - this.data.height ? 0 : (this.body.getAngularVelocity() != 0.0f ? 2 : 1);
        this.silentPeriod = this.status == 1 ? (byte)(this.silentPeriod + 1) : (byte)0;
    }

    public boolean isSleeping() {
        return this.body.isSleeping();
    }

    protected void drawFace(Graphics g, int x, int y) {
        switch (this.data.type) {
            case 4: {
                g.drawImage(Game.imgFaceBoxGreenLarge, x, y, 3);
                break;
            }
            case 5: {
                g.drawImage(Game.imgFaceBoxGreenSmall, x, y, 3);
                break;
            }
            case 6: {
                g.drawImage(Game.imgFaceBoxRedLarge, x, y, 3);
                break;
            }
            case 7: {
                g.drawImage(Game.imgFaceBoxRedSmall, x, y, 3);
                break;
            }
            case 2: {
                g.drawImage(Game.imgFaceCircleGreenLarge, x, y, 3);
                break;
            }
            case 3: {
                g.drawImage(Game.imgFaceCircleGreenSmall, x, y, 3);
                break;
            }
            case 0: {
                g.drawImage(Game.imgFaceCircleRedLarge, x, y, 3);
                break;
            }
            case 1: {
                g.drawImage(Game.imgFaceCircleRedSmall, x, y, 3);
            }
        }
    }
}

