/*
 * Decompiled with CFR 0.152.
 */
import java.io.IOException;
import javax.microedition.lcdui.Graphics;

final class Intro
extends Entity {
    private static final int SPLASH_SHOW_TIME = 40;
    private static final int SPLASH_TRANSITION_SPEED = 16;
    private static final int SPLASH_NUM_SEGMENTS = 32;
    private static final int SPLASH_SEGMENTS_DELTA = 4;
    private static final int SPLASH_TRANSITION_LOWER_LIMIT = -128;
    private static final int SPLASH_TRANSITION_UPPER_LIMIT = 384;
    private int splashCurrent = 1;
    private int splashCnt = 40;
    private int splashTransitionCnt = 0;
    private int splashTransitionDir = 0;
    private Sprite2Data splash = null;

    Intro() {
    }

    void loadResources(int n) throws IOException {
        this.splash = Sprite2Data.load("/splash.s2", (byte[][])null, n);
    }

    void paintOverlay(Graphics graphics) {
        Screen.clear(graphics, 0xFFFFFF);
        if (this.splashCurrent <= this.splash.frameCount) {
            int n = (this.splash.box[3] << 8) / 32;
            int n2 = Screen.top + (Screen.height - this.splash.box[3] >> 1);
            int n3 = Screen.left + (Screen.width - this.splash.box[2] >> 1);
            int n4 = 0;
            Screen.pushClip();
            for (int i = 0; i < 32; ++i) {
                int n5 = this.splashTransitionCnt - i * 4;
                if (n5 < 0) {
                    n5 = 0;
                }
                if (n5 > 256) {
                    n5 = 256;
                }
                int n6 = (256 - Entity.getRestitutedValue2(n5)) * this.splash.box[2] >> 7;
                if ((this.splashTransitionDir & 1) != 0) {
                    n6 = -n6;
                }
                int n7 = n2 + (n * (i + 1) >> 8);
                graphics.setClip(Screen.left, n4, Screen.width, n7 - n4);
                n4 = n7;
                this.splash.paint(graphics, n3 + n6, n2, this.splashCurrent, 0);
            }
            Screen.popClip(graphics, true);
        }
    }

    void update() {
        if (!Screen.isFading()) {
            if (this.is(64)) {
                Screen.setSoftkeyLabel(0, -1);
                if (Screen.isSoftkeyAnimationDone()) {
                    this.set(1, true);
                }
            } else {
                if (this.splashCurrent < this.splash.frameCount) {
                    Screen.setSoftkeyLabel(0, -24);
                }
                if ((Screen.getKeysClicked() & 0x2000300) != 0) {
                    this.set(64, true);
                } else {
                    --this.splashCnt;
                    if (this.splashCnt <= 0) {
                        if (this.splashCnt == 0) {
                            ++this.splashTransitionDir;
                            if (this.splashCurrent == this.splash.frameCount) {
                                Screen.setSoftkeyLabel(0, -1);
                            }
                        }
                        if (this.splashTransitionCnt <= 0) {
                            ++this.splashCurrent;
                            if (this.splashCurrent > this.splash.frameCount) {
                                this.set(64, true);
                            } else {
                                this.splashCnt = 40;
                            }
                        } else {
                            this.splashTransitionCnt -= 16;
                            if (this.splashTransitionCnt < -128) {
                                this.splashTransitionCnt = -128;
                            }
                        }
                    } else {
                        this.splashTransitionCnt += 16;
                        if (this.splashTransitionCnt > 384) {
                            this.splashTransitionCnt = 384;
                        }
                    }
                }
            }
        }
    }
}

