/*
 * Decompiled with CFR 0.152.
 */
import javax.microedition.lcdui.Graphics;

final class SceneActor
extends SceneNode {
    static SceneNode standingOn;
    private static final int PLAYER_ANIMATION_SHIFT = 6;
    static final int TYPE_PLAYER = 0;
    static final int TYPE_AI_01 = 1;
    static final int TYPE_AI_02 = 2;
    static final int AI_ROBOT_HOVER_YOFFSET = 640;
    static final int FLAG_GRAVITY = 256;
    static final int FLAG_DRAG = 512;
    static final int FLAG_AI_01 = 4096;
    static final int STATE_AI_WAITING = 0;
    static final int STATE_AI_MOVING = 1;
    static final int STATE_AI_PERFORM_ACTION = 2;
    static final int STATE_AI_DISABLED = 3;
    static final int STATE_AI_SPAWNING = 4;
    static final int STATE_PLAYER_WALKING = 0;
    static final int STATE_PLAYER_JUMPING = 1;
    static final int STATE_PLAYER_STUNNED = 2;
    static final int STATE_PLAYER_IDLE = 3;
    static final int STATE_PLAYER_INSERT_BRICK = 4;
    private static int[] propertiesSetup;
    private static final int[] DRAGV;
    private static final int[] DRAGH;
    private static final int[] THRUSTH;
    private static final int[] WALKSPEED;
    private static final int[] JUMPVELOCITY;
    private static final int[] BOUNCEPROPERTY;
    private static final int[] GROUNDTHRESHOLD;
    private static final boolean[] PLAYER_ANIM_LOOPING;
    private static final boolean[] PLAYER_ANIM_PER_VELOCITY;
    private static final boolean[] PLAYER_ANIM_CAN_MIRROR;
    int animCount;
    int curFrameSequence;
    boolean isMirrored;
    boolean jumpBoost = false;
    int state;
    private int targetX;
    private int targetY;
    private int fromX;
    private int fromY;
    private int moveCnt;
    private int moveCntDelta;
    private int targetBrickX;
    private int targetBrickY;
    private int ravageCnt;
    private Sprite2Data sprite;

    SceneActor() {
        this.classType = 1;
        this.state = 0;
    }

    void destroy() {
        this.sprite = null;
    }

    /*
     * Unable to fully structure code
     */
    void update() {
        block64: {
            block66: {
                block65: {
                    if (!this.enabled) break block64;
                    if (this.type != 0) break block65;
                    if (this.jumpBoost && this.velY < 0) {
                        var1_1 = Entity.random.nextInt();
                        ((SceneParticles)Game.items[Game.itemOffsetParticlesJumpEx]).emitParticleAbs(this.posX, this.posY, this.velX + (((var1_1 >> 2 & 511) - 256) * 64 >> 8), this.velY, 1, var1_1 & 3);
                    }
                    switch (this.state) {
                        case 0: {
                            if (Math.abs(this.velX) >= 4 || !this.isOnGround) break;
                            this.setState(3);
                            break;
                        }
                        case 3: {
                            if (Math.abs(this.velX) <= 4) break;
                            this.setState(0);
                            break;
                        }
                        case 1: 
                        case 4: {
                            if (this.velY <= 0) break;
                            this.setState(0);
                            break;
                        }
                        case 2: {
                            --this.timer;
                            if (this.timer < 0) {
                                this.setState(3);
                                break;
                            }
                            if (this.velX < -3) {
                                this.isMirrored = false;
                                break;
                            }
                            if (this.velX <= 3) break;
                            this.isMirrored = true;
                        }
                    }
                    if (SceneActor.PLAYER_ANIM_PER_VELOCITY[this.state]) {
                        if (this.isOnGround) {
                            this.animCount += this.velX;
                        }
                    } else {
                        this.animCount = this.state != 3 || this.childNode == null ? (this.animCount += 32) : 0;
                    }
                    var1_1 = this.sprite.frameSequences[this.curFrameSequence].length;
                    if (SceneActor.PLAYER_ANIM_LOOPING[this.state]) {
                        if (this.animCount < 0) {
                            this.animCount += var1_1 << 6;
                        }
                        if (this.animCount >= var1_1 << 6) {
                            this.animCount -= var1_1 << 6;
                        }
                    } else {
                        if (this.animCount < 0) {
                            this.animCount = 0;
                        }
                        if (this.animCount >= var1_1 << 6) {
                            this.animCount = var1_1 - 1 << 6;
                        }
                    }
                    if (this.canPickup != null) {
                        if (this.childNode == null) {
                            this.canPickup.attachTo(this, 0, -this.anchorY);
                            if (this.canPickup.classType == 2) {
                                ((SceneItem)this.canPickup).miscVar[0] = 0;
                                Game.playSound(196613);
                                if (this.canPickup.type == 2) {
                                    Game.brickSetPicked = true;
                                    Game.curBrickSet = ((SceneItem)this.canPickup).miscVar[1];
                                    Game.curBrickSetSubSet = ((SceneItem)this.canPickup).miscVar[2];
                                    Game.tutorialCheckState(1);
                                } else if (Game.tutorialMode) {
                                    Game.tutorialCheckState(9);
                                }
                            }
                            this.canPickup = null;
                        }
                    } else if (this.childNode != null && this.childNode.classType == 2 && this.childNode.type == 2) {
                        ((SceneItem)this.childNode).miscVar[1] = Game.curBrickSet;
                        ((SceneItem)this.childNode).miscVar[2] = Game.curBrickSetSubSet;
                    }
                    break block66;
                }
                if (this.type != 1 && this.type != 2) break block66;
                switch (this.state) {
                    case 0: {
                        ++this.animCount;
                        --this.timer;
                        if (this.timer >= 0) break;
                        var1_1 = 0;
                        if (Game.brickContainer == null) break;
                        if (this.ravageCnt < 0) ** GOTO lbl101
                        if (this.type != 1) ** GOTO lbl88
                        var3_3 = var2_2 = (Entity.random.nextInt() & 255) % Game.brickContainer.cols;
                        for (var4_4 = 0; var4_4 < Game.brickContainer.rows; ++var4_4) {
                            if (Game.brickContainer.bricks[var3_3] == 0) ** GOTO lbl85
                            this.targetBrickX = var2_2;
                            this.targetBrickY = var4_4;
                            this.targetX = Game.brickContainer.posX - Game.brickContainer.cullingRect[4] + 64 * var2_2 + 32;
                            this.targetY = Game.brickContainer.posY - Game.brickContainer.cullingRect[3] + 69 * var4_4;
                            var1_1 = 1;
                            ** GOTO lbl104
lbl85:
                            // 1 sources

                            var3_3 += Game.brickContainer.cols;
                        }
                        ** GOTO lbl104
lbl88:
                        // 1 sources

                        var2_2 = (Entity.random.nextInt() & 255) % (Game.brickContainer.cols - 1);
                        var3_3 = var2_2 + Game.brickContainer.cols;
                        for (var4_4 = 1; var4_4 < Game.brickContainer.rows; ++var4_4) {
                            if (Game.brickContainer.bricks[var3_3] == 0 || var4_4 <= 2 || Game.brickContainer.bricks[var3_3 + 1 - Game.brickContainer.cols] != 0) ** GOTO lbl98
                            this.targetBrickX = var2_2;
                            this.targetBrickY = var4_4 - 1;
                            this.targetX = Game.brickContainer.posX - Game.brickContainer.cullingRect[4] + 64 * var2_2 + 64;
                            this.targetY = Game.brickContainer.posY - Game.brickContainer.cullingRect[3] + 69 * (var4_4 - 1);
                            var1_1 = 1;
                            ** GOTO lbl104
lbl98:
                            // 1 sources

                            var3_3 += Game.brickContainer.cols;
                        }
                        ** GOTO lbl104
lbl101:
                        // 1 sources

                        this.targetX = this.initX;
                        this.targetY = this.initY;
                        var1_1 = 1;
lbl104:
                        // 5 sources

                        if (var1_1 == 0) break;
                        this.fromX = this.posX;
                        this.fromY = this.posY;
                        var2_2 = this.targetX - this.fromX;
                        var3_3 = this.targetY - this.fromY;
                        var4_4 = (int)Entity.fpSqrtFast(var2_2 * var2_2 + var3_3 * var3_3);
                        this.moveCntDelta = var4_4 > 0 ? (int)(0x10000000L / (long)var4_4) : 65536;
                        this.moveCnt = 0;
                        this.state = 1;
                        break;
                    }
                    case 1: {
                        var1_1 = this.targetX - this.fromX;
                        var2_2 = this.targetY - this.fromY;
                        if (this.type == 1 && this.ravageCnt >= 0) {
                            var2_2 -= 640;
                        }
                        this.moveCnt += this.moveCntDelta;
                        if (this.moveCnt > 65536) {
                            this.moveCnt = 65536;
                            if (this.ravageCnt < 0) {
                                this.ravageCnt = 1 + (Entity.random.nextInt() & 1);
                                this.state = 0;
                                this.timer = 256 + (Entity.random.nextInt() & 255);
                            } else {
                                --this.ravageCnt;
                                this.state = 2;
                                this.timer = 20;
                                if (this.type == 1) {
                                    ((SceneParticles)Game.items[Game.itemOffsetParticlesElectricity]).emitElectricity(this.targetX, this.targetY - 640, this.targetX, this.targetY, 10, 8);
                                    Game.playSound(262150);
                                }
                            }
                        }
                        var3_3 = Entity.getRestitutedValue2(this.moveCnt >> 8);
                        this.posX = this.fromX + (var1_1 * var3_3 >> 8);
                        this.posY = this.fromY + (var2_2 * var3_3 >> 8);
                        this.velX = 0;
                        this.velY = 0;
                        this.animCount += 2;
                        break;
                    }
                    case 2: {
                        --this.timer;
                        if (this.timer == 10) {
                            if (this.type == 1) {
                                Game.brickContainer.removeBrick(this.targetBrickX, this.targetBrickY);
                                Screen.vibrate(200);
                                var4_4 = Entity.random.nextInt();
                                ((SceneParticles)Game.items[Game.itemOffsetParticlesSmoke2]).emitParticleAbs(this.targetX, this.targetY, ((var4_4 >> 4 & 511) - 256) * 48 >> 8, ((var4_4 >> 13 & 511) - 256) * 48 >> 8, 1, var4_4 >> 2 & 3);
                                var4_4 = Entity.random.nextInt();
                                ((SceneParticles)Game.items[Game.itemOffsetParticlesSmoke2]).emitParticleAbs(this.targetX, this.targetY, ((var4_4 >> 4 & 511) - 256) * 48 >> 8, ((var4_4 >> 13 & 511) - 256) * 48 >> 8, 1, var4_4 >> 2 & 3);
                            } else {
                                var4_4 = this.targetBrickX + this.targetBrickY * Game.brickContainer.cols;
                                if (Game.brickContainer.bricks[var4_4] == 0 && Game.brickContainer.bricks[var4_4 + 1] == 0) {
                                    Game.brickContainer.insertBrick(this.targetBrickX, this.targetBrickY, 2, (Entity.random.nextInt() & 255) % 3);
                                }
                            }
                        } else if (this.timer > 10) {
                            this.animCount += 4;
                            if (this.type == 2) {
                                var4_4 = Entity.random.nextInt();
                                ((SceneParticles)Game.items[Game.itemOffsetParticlesSmoke]).emitParticleAbs(this.posX, this.posY, ((var4_4 >> 4 & 511) - 256) * 64 >> 8, (var4_4 >> 13 & 255) * 48 >> 8, 1, var4_4 >> 2 & 1);
                            }
                        }
                        if (this.timer >= 0) break;
                        this.state = 0;
                        break;
                    }
                    case 3: {
                        if ((Game.tick & 1) == 0) break;
                        var4_4 = Entity.random.nextInt();
                        ((SceneParticles)Game.items[Game.itemOffsetParticlesSmoke]).emitParticleAbs(this.posX, this.posY, ((var4_4 >> 4 & 511) - 256) * 64 >> 8, (var4_4 >> 13 & 255) * 48 >> 8, 1, var4_4 >> 2 & 1);
                    }
                }
            }
            if (this.parentNode == null) {
                if ((this.properties & 256) != 0) {
                    this.velY += this.gravity;
                }
                this.posX += this.velX;
                this.posY += this.velY;
                if ((this.properties & 512) != 0) {
                    this.velX = this.velX * SceneActor.DRAGH[this.type] >> 8;
                    this.velY = this.velY * SceneActor.DRAGV[this.type] >> 8;
                    if (Math.abs(this.velX) < 8) {
                        this.velX = 0;
                    }
                    if (Math.abs(this.velY) < 8) {
                        this.velY = 0;
                    }
                }
                this.isOnGround = false;
                if ((this.collisionType & 1) != 0 && this.resolveLevelCollision(SceneActor.GROUNDTHRESHOLD[this.type]) && (this.type == 1 || this.type == 2)) {
                    if (this.isOnGround) {
                        Game.setCameraRandomShake(64, 64);
                        for (var1_1 = 0; var1_1 < 6; ++var1_1) {
                            var2_2 = Entity.random.nextInt();
                            ((SceneParticles)Game.items[Game.itemOffsetParticlesSmoke2]).emitParticleAbs(this.posX, this.posY, ((var2_2 & 511) - 256) * 128 >> 8, (((var2_2 & 0x1FF000) >> 12) - 256) * 128 >> 8, 20, 0);
                        }
                        for (var1_1 = 0; var1_1 < 12; ++var1_1) {
                            var2_2 = Entity.random.nextInt();
                            ((SceneParticles)Game.items[Game.itemOffsetParticlesSparks]).emitParticleAbs(this.posX, this.posY, ((var2_2 & 511) - 256) * 96 >> 8, (((var2_2 & 0x1FF000) >> 12) - 256) * 96 >> 8, 20, 0);
                        }
                        ((SceneParticles)Game.items[Game.itemOffsetParticlesLeaves]).applyBlast(this.posX, this.posY, 128, 512);
                        Game.playSound(589832);
                        this.enabled = false;
                        if (Game.levelState == 0) {
                            Game.gameScore += 1000;
                        }
                        Game.setStat(3, Game.gameStats[3] + 1, true);
                    } else {
                        for (var1_1 = 0; var1_1 < 4; ++var1_1) {
                            var2_2 = Entity.random.nextInt();
                            ((SceneParticles)Game.items[Game.itemOffsetParticlesSparks]).emitParticleAbs(this.posX, this.posY, this.velX + (((var2_2 & 511) - 256) * 48 >> 8), this.velY + ((((var2_2 & 0x1FF000) >> 12) - 256) * 96 >> 8), 20, 0);
                        }
                        Game.playSound(458759);
                    }
                }
                if ((this.properties & 4) != 0) {
                    Game.brickContainer.checkCollision(this);
                }
                if (this.collisionType != 0) {
                    this.checkCollision = true;
                }
                if (this.childNode != null) {
                    if (SceneActor.PLAYER_ANIM_CAN_MIRROR[this.state]) {
                        this.attachX = this.sprite.refPoints[this.curFrameSequence + (this.isMirrored != false ? 2 : 1)][0];
                        this.attachY = this.sprite.refPoints[this.curFrameSequence + (this.isMirrored != false ? 2 : 1)][1];
                    } else {
                        this.attachX = this.sprite.refPoints[this.curFrameSequence + 1][0];
                        this.attachY = this.sprite.refPoints[this.curFrameSequence + 1][1];
                    }
                }
                super.update();
            } else {
                this.checkCollision = false;
            }
        }
        this.canPickup = null;
    }

    void paint(Graphics graphics, boolean bl) {
        if (bl && this.parentNode != null) {
            return;
        }
        if (this.enabled && this.visible && this.sprite != null) {
            switch (this.type) {
                case 0: {
                    if (PLAYER_ANIM_CAN_MIRROR[this.state]) {
                        this.sprite.paint(graphics, this.outX, this.outY, this.sprite.frameSequences[this.curFrameSequence + (this.isMirrored ? 1 : 0)][this.animCount >> 6], 0);
                        break;
                    }
                    this.sprite.paint(graphics, this.outX, this.outY, this.sprite.frameSequences[this.curFrameSequence][this.animCount >> 6], 0);
                    break;
                }
                case 1: 
                case 2: {
                    this.sprite.paint(graphics, this.outX, this.outY, this.sprite.frameSequences[this.curFrameSequence][this.animCount >> 2 & 1], 0);
                }
            }
        }
        super.paint(graphics, bl);
    }

    void pressedLeft() {
        if (this.state != 2) {
            this.velX = this.isOnGround ? (this.velX -= WALKSPEED[this.type]) : (this.velX -= THRUSTH[this.type]);
            this.isMirrored = true;
        }
    }

    void pressedRight() {
        if (this.state != 2) {
            this.velX = this.isOnGround ? (this.velX += WALKSPEED[this.type]) : (this.velX += THRUSTH[this.type]);
            this.isMirrored = false;
        }
    }

    void pressedUp() {
        if (this.state != 2) {
            if (this.isOnGround) {
                this.velY = !this.jumpBoost ? (this.velY -= JUMPVELOCITY[this.type]) : (this.velY -= JUMPVELOCITY[this.type] * 320 >> 8);
            }
            if (this.state != 1) {
                this.setState(1);
            }
        }
    }

    void jump(int n) {
        if (this.state != 2 && this.velY >= 0) {
            this.velY -= JUMPVELOCITY[this.type] * n >> 8;
            this.isOnGround = false;
        }
    }

    void switchedEnter() {
    }

    void setState(int n) {
        if (this.state != n) {
            this.state = n;
            switch (this.state) {
                case 0: {
                    this.curFrameSequence = 0;
                    break;
                }
                case 2: {
                    this.curFrameSequence = 2;
                    this.timer = 10;
                    break;
                }
                case 1: {
                    this.curFrameSequence = 4;
                    break;
                }
                case 4: {
                    this.curFrameSequence = 6;
                    break;
                }
                case 3: {
                    this.curFrameSequence = 7;
                }
            }
            this.animCount = 0;
        }
    }

    void respawn() {
        if (this.type != 0) {
            this.setPosition(this.initX, this.initY, false);
            this.ravageCnt = 1 + (Entity.random.nextInt() & 3);
            this.state = 0;
            this.timer = 32;
            this.velX = 0;
            this.velY = 0;
            this.setType(this.type);
            this.enabled = true;
            for (int i = 0; i <= 8; ++i) {
                int n = Entity.random.nextInt();
                ((SceneParticles)Game.items[Game.itemOffsetParticlesJumpEx]).emitParticleAbs(this.posX + (((n >> 22 & 0x1F) - 16) * this.cullingRect[4] >> 4), this.posY - ((n >> 27 & 0x1F) * this.cullingRect[3] >> 5), ((n >> 4 & 0x1FF) - 256) * 48 >> 8, ((n >> 13 & 0x1FF) - 256) * 48 >> 8, 1, n >> 2 & 3);
            }
        }
    }

    boolean isIntersecting(SceneNode sceneNode) {
        if (sceneNode.classType == 2) {
            // empty if block
        }
        return false;
    }

    void setType(int n) {
        super.setType(n);
        this.properties = propertiesSetup[n];
        this.bounce = BOUNCEPROPERTY[n];
        this.collisionType = this.properties & 0x7F;
    }

    void setSprite(Sprite2Data sprite2Data, int n, boolean bl) {
        this.sprite = sprite2Data;
        super.setSprite(sprite2Data, n, bl);
    }

    void eventInsideBombExplosion(int n, int n2, SceneNode sceneNode) {
        int n3 = 256;
        switch (this.type) {
            case 1: 
            case 2: {
                this.properties = 4865;
                this.collisionType = this.properties & 0x7F;
                this.state = 3;
                break;
            }
            case 0: {
                this.setState(2);
                n3 = 64;
            }
        }
        this.velX = this.posX - this.lastX;
        this.velY = this.posY - this.lastY;
        int n4 = (int)Entity.fpSqrtFast(n) >> 8;
        int n5 = (n2 - n4 << 8) / n2;
        int n6 = (this.posX - sceneNode.posX) * n5;
        int n7 = (this.posY - sceneNode.posY) * n5;
        if (n4 > 0) {
            int n8 = n6 / n4;
            int n9 = n7 / n4;
            this.velX += n8 * n3 >> 8;
            this.velY += n9 * n3 >> 8;
            for (int i = 0; i < 6; ++i) {
                int n10 = Entity.random.nextInt();
                ((SceneParticles)Game.items[Game.itemOffsetParticlesSparks]).emitParticleAbs(this.posX, this.posY, n8 + (((n10 & 0x1FF) - 256) * 32 >> 8), n9 + ((((n10 & 0x1FF000) >> 12) - 256) * 32 >> 8), 20, 0);
            }
        }
    }

    static {
        propertiesSetup = new int[]{797, 4096, 4096};
        DRAGV = new int[]{208, 227, 227};
        DRAGH = new int[]{160, 227, 227};
        THRUSTH = new int[]{14, 14, 14};
        WALKSPEED = new int[]{14, 14, 14};
        JUMPVELOCITY = new int[]{128, 128, 128};
        BOUNCEPROPERTY = new int[]{0, 240, 240};
        GROUNDTHRESHOLD = new int[]{0, 32, 32};
        PLAYER_ANIM_LOOPING = new boolean[]{true, false, false, true, false};
        PLAYER_ANIM_PER_VELOCITY = new boolean[]{true, false, false, false, false};
        PLAYER_ANIM_CAN_MIRROR = new boolean[]{true, true, true, false, false};
    }
}

