/*
 * Decompiled with CFR 0.152.
 */
import javax.microedition.lcdui.Graphics;

class SceneBrickContainer
extends SceneNode {
    int projectionX;
    int projectionY;
    boolean projectionValid;
    int insertX;
    int insertY;
    static final int BRICK_FALL_SPEED = 64;
    static final int FILLER_DEPTH = 5;
    static final int FILLER_WIDTH = 3;
    static final int FILLER_MAX_INSERT = 6;
    int[] bricks;
    int cols;
    int rows;
    static final int INSTABILITY_CLEAR_NEXT_DELAY = 15;
    static final int INSTABILITY_BREAK_THRESHOLD = 6;
    int instabilityFactor;
    int unstableBottomLine;
    int instabilityTimer;
    boolean instabilityShaking;
    int instabilityRandomValue;
    int topLineUsed;
    int maxHeight = 5;
    private Sprite2Data sprite;

    SceneBrickContainer() {
        this.classType = 4;
    }

    void destroy() {
        this.bricks = null;
        this.sprite = null;
    }

    void update() {
        if (this.enabled) {
            int n;
            int n2;
            int n3;
            int n4;
            int n5;
            int n6;
            this.instabilityFactor = 0;
            this.unstableBottomLine = -1;
            int n7 = 0;
            this.topLineUsed = 0;
            for (n6 = this.rows - 1; n6 > 0; --n6) {
                n5 = 0;
                n4 = this.cols * n6;
                n3 = 0;
                n2 = 0;
                while (n5 < this.cols) {
                    n = this.bricks[n4];
                    int n8 = n & 0xF;
                    if (n6 == this.rows - 1) {
                        n3 += n8;
                        n2 = 1;
                    } else if (n8 != 0) {
                        if (n8 == 15) {
                            this.bricks[n4] = 0;
                        } else {
                            int n9;
                            boolean bl = false;
                            for (n9 = 0; n9 < n8; ++n9) {
                                if (this.bricks[n4 + this.cols + n9] == 0) continue;
                                bl = true;
                                break;
                            }
                            n9 = this.bricks[n4] >> 8 & 0xFF;
                            if (!bl) {
                                if ((n9 -= 64) < 0) {
                                    int n10;
                                    n9 += 256;
                                    if (n6 < this.rows - 2) {
                                        this.bricks[n4 + this.cols] = this.bricks[n4] & 0x800FF | (n9 & 0xFF) << 8;
                                        this.bricks[n4] = 0;
                                        for (n10 = 1; n10 < n8; ++n10) {
                                            this.bricks[n4 + this.cols + n10] = 524543;
                                            this.bricks[n4 + n10] = 0;
                                        }
                                    } else {
                                        this.bricks[n4 + this.cols] = this.bricks[n4] & 0x800FF;
                                        this.bricks[n4] = 0;
                                        for (n10 = 1; n10 < n8; ++n10) {
                                            this.bricks[n4 + this.cols + n10] = 255;
                                            this.bricks[n4 + n10] = 0;
                                        }
                                    }
                                } else {
                                    this.bricks[n4] = this.bricks[n4] & 0x800FF | (n9 & 0xFF) << 8;
                                }
                            } else if (n9 != 0) {
                                if ((n9 -= 64) < 0) {
                                    n9 = 0;
                                }
                                this.bricks[n4] = this.bricks[n4] & 0x800FF | (n9 & 0xFF) << 8;
                            }
                        }
                        n2 = 1;
                        n3 += n8;
                    }
                    n5 += n8 == 0 ? 1 : n8;
                    n4 += n8 == 0 ? 1 : n8;
                }
                if (n2 != 0) {
                    this.topLineUsed = n6;
                    if (n7 > 0) {
                        this.instabilityFactor += 1 + (n7 >> 2);
                    }
                    if (n7 != 0 && this.unstableBottomLine == -1) {
                        this.unstableBottomLine = n6 + 1;
                    }
                }
                n7 = n3 != 0 && n3 < this.cols ? this.cols - n3 : 0;
            }
            if (this.rows - this.topLineUsed > this.maxHeight) {
                this.instabilityFactor = 7;
                this.unstableBottomLine = this.rows - 1;
                this.instabilityTimer = 15;
            }
            if (this.instabilityFactor > 6) {
                if (this.instabilityTimer < 15) {
                    this.instabilityShaking = true;
                    this.instabilityRandomValue = Entity.random.nextInt();
                    ++this.instabilityTimer;
                } else {
                    this.instabilityShaking = false;
                    this.instabilityTimer = 0;
                    n6 = this.cols * this.unstableBottomLine;
                    Game.playSound(327680);
                    Screen.vibrate(200);
                    ++Game.levelCollapseCount;
                    n5 = -3;
                    n4 = this.posY - this.cullingRect[3] + 34 + this.unstableBottomLine * 69;
                    n3 = this.posX - this.cullingRect[4] + 32;
                    for (n2 = 0; n2 < this.cols; ++n2) {
                        if (this.bricks[n6 + n2] != 0) {
                            n = Entity.random.nextInt();
                            if (n2 - n5 > 2) {
                                n5 = n2;
                                ((SceneParticles)Game.items[Game.itemOffsetParticlesSmash]).emitParticleAbs(n3, n4, 0, 0, 1, n & 3);
                            }
                            ((SceneParticles)Game.items[Game.itemOffsetParticlesSmoke2]).emitParticleAbs(n3, n4, ((n >> 4 & 0x1FF) - 256) * 48 >> 8, ((n >> 13 & 0x1FF) - 256) * 48 >> 8, 1, n >> 2 & 3);
                            n = Entity.random.nextInt();
                            ((SceneParticles)Game.items[Game.itemOffsetParticlesSmoke2]).emitParticleAbs(n3, n4, ((n >> 4 & 0x1FF) - 256) * 48 >> 8, ((n >> 13 & 0x1FF) - 256) * 48 >> 8, 1, n >> 2 & 3);
                        }
                        this.bricks[n6 + n2] = 0;
                        n3 += 64;
                    }
                }
            } else {
                this.instabilityShaking = false;
                this.instabilityTimer = 0;
            }
            super.update();
        }
    }

    void paint(Graphics graphics, boolean bl) {
        if (bl && this.parentNode != null) {
            return;
        }
        if (this.sprite != null && this.enabled && this.visible) {
            int n = this.outY + 13 * this.rows - 17;
            int n2 = this.cols * (this.rows - 1);
            for (int i = this.rows - 1; i >= this.topLineUsed; --i) {
                if (n < Screen.clipBottom) {
                    int n3 = n2;
                    int n4 = this.outX;
                    for (int j = 0; j < this.cols; ++j) {
                        int n5;
                        int n6 = this.bricks[n3] & 0xF;
                        if (n6 != 0 && n6 < 4 && (n5 = n4 + n6 * 12) > Screen.clipLeft) {
                            int n7 = (this.bricks[n3] >> 4 & 7) * 3;
                            int n8 = (this.bricks[n3] >> 8 & 0xFF) * 13 >> 8;
                            if (this.instabilityShaking && i <= this.unstableBottomLine) {
                                int n9 = n3 & 0x1F;
                                this.sprite.paint(graphics, n4 + (this.instabilityRandomValue >> n9 & 1), n - n8, n6 + n7, 0);
                            } else {
                                this.sprite.paint(graphics, n4, n - n8, n6 + n7, 0);
                            }
                        }
                        if ((n4 += 12) >= Screen.clipRight) break;
                        ++n3;
                    }
                }
                n2 -= this.cols;
                n -= 13;
            }
        }
    }

    void postPaint(Graphics graphics) {
        if (Game.canInsertBrick) {
            int n = 4;
            int n2 = this.outX + this.insertX * 12;
            int n3 = this.outY + this.insertY * 13;
            graphics.setColor(0xFFFFFF);
            for (int i = 0; i < Game.BRICK_CONFIGS[Game.curBrickConfig][2]; ++i) {
                graphics.drawRect(n2 + Game.BRICK_CONFIGS[Game.curBrickConfig][n + 1] * 12, n3, Game.BRICK_CONFIGS[Game.curBrickConfig][n + 0] * 12, 13);
                n3 += 13;
                n += 2;
            }
        }
    }

    void setSprite(Sprite2Data sprite2Data, int n, boolean bl) {
        this.sprite = sprite2Data;
    }

    void createContainer(int n, int n2) {
        this.cols = n;
        this.rows = n2;
        this.maxHeight = n2 - 10;
        this.bricks = new int[this.cols * this.rows];
        int n3 = (n * 12 << 8) / 48;
        int n4 = (n2 * 13 << 8) / 48;
        this.anchorX = n3 >> 1;
        this.anchorY = n4;
        this.setRects(0, 0, n3, n4, true);
        this.properties = 128;
    }

    boolean checkCollision(SceneNode sceneNode) {
        if (this.containsPosition(sceneNode)) {
            int n = sceneNode.posX - (this.posX - this.collisionRect[2]);
            int n2 = sceneNode.posY - (this.posY - this.collisionRect[3]);
            int n3 = sceneNode.lastX - (this.posX - this.collisionRect[2]);
            int n4 = sceneNode.lastY - (this.posY - this.collisionRect[3]);
            int n5 = sceneNode.posX - sceneNode.lastX;
            int n6 = sceneNode.posY - sceneNode.lastY;
            int n7 = this.posX - this.collisionRect[2];
            int n8 = this.posY - this.collisionRect[3];
            int n9 = (n * 48 >> 8) / 12;
            int n10 = (n2 * 48 >> 8) / 13;
            int n11 = (n3 * 48 >> 8) / 12;
            int n12 = (n4 * 48 >> 8) / 13;
            if (n10 >= this.rows) {
                n10 = this.rows - 1;
            }
            if (n12 >= this.rows) {
                n12 = this.rows - 1;
            }
            if (n9 == n11 && n10 == n12) {
                if (this.bricks[n9 + n10 * this.cols] != 0) {
                    if (sceneNode.classType == 1 && sceneNode.velY >= 0) {
                        ((SceneActor)sceneNode).jump(256);
                    }
                    return true;
                }
            } else {
                if (n9 != n11 && n10 != n12) {
                    int n13 = n9 < n11 ? (n11 * 12 << 9) / 48 : ((n11 + 1) * 12 << 9) / 48;
                    int n14 = n10 < n12 ? (n12 * 13 << 9) / 48 : ((n12 + 1) * 13 << 9) / 48;
                    int n15 = n13 - n3;
                    int n16 = n14 - n4;
                    int n17 = (n15 - n6) * (n16 - n5);
                    if (n10 > n12) {
                        n17 = -n17;
                    }
                    if (n17 > 0) {
                        if (this.resolveCollisionX(sceneNode, n9, n11, n10, n7)) {
                            this.resolveCollisionY(sceneNode, n11, n10, n12, n8);
                            return true;
                        }
                        return this.resolveCollisionY(sceneNode, n9, n10, n12, n8);
                    }
                    if (this.resolveCollisionY(sceneNode, n11, n10, n12, n8)) {
                        this.resolveCollisionX(sceneNode, n9, n11, n12, n7);
                        return true;
                    }
                    return this.resolveCollisionX(sceneNode, n9, n11, n10, n7);
                }
                if (n9 != n11) {
                    return this.resolveCollisionX(sceneNode, n9, n11, n10, n7);
                }
                return this.resolveCollisionY(sceneNode, n9, n10, n12, n8);
            }
        }
        return false;
    }

    private boolean resolveCollisionX(SceneNode sceneNode, int n, int n2, int n3, int n4) {
        if (n >= this.cols || n3 > this.rows) {
            return false;
        }
        if (this.bricks[n + n3 * this.cols] != 0) {
            sceneNode.posX = n2 < n ? n4 + ((n2 + 1) * 12 << 8) / 48 - 1 : n4 + (n2 * 12 << 8) / 48 + 1;
            sceneNode.velX = -(sceneNode.velX * sceneNode.bounce >> 8);
            return true;
        }
        return false;
    }

    private boolean resolveCollisionY(SceneNode sceneNode, int n, int n2, int n3, int n4) {
        if (this.bricks[n + n2 * this.cols] != 0) {
            sceneNode.velY = -(sceneNode.velY * sceneNode.bounce >> 8);
            if (n3 < n2) {
                sceneNode.posY = n4 + ((n3 + 1) * 13 << 8) / 48 - 1;
                if (sceneNode.velY == 0) {
                    sceneNode.isOnGround = true;
                }
                return true;
            }
            if (sceneNode.classType != 1) {
                sceneNode.posY = n4 + (n3 * 13 << 8) / 48 - 1;
                return true;
            }
        }
        return false;
    }

    boolean projectPosition(SceneNode sceneNode, int n) {
        this.projectionValid = false;
        int n2 = sceneNode.posX;
        int n3 = sceneNode.posY;
        if (this.containsPosition(sceneNode) && Game.brickSetPicked) {
            int n4 = this.posX - this.collisionRect[2];
            int n5 = this.posY - this.collisionRect[3];
            n2 -= n4;
            n3 -= n5;
            if ((Game.BRICK_CONFIGS[Game.curBrickConfig][1] & 1) == 0) {
                n2 -= 32;
            }
            this.projectionX = (n2 * 48 >> 8) / 12;
            this.projectionY = (n3 * 48 >> 8) / 13;
            int n6 = this.projectionY + n < this.rows ? this.projectionY + n : this.rows;
            for (int i = this.projectionY; i < n6; ++i) {
                if (this.bricks[this.projectionX + this.cols * i] != 0) {
                    this.projectionY = i;
                    this.projectionValid = true;
                    break;
                }
                if (i != this.rows - 1) continue;
                this.projectionY = i + 1;
                this.projectionValid = true;
            }
            if (this.projectionValid) {
                this.projectionY -= Game.BRICK_CONFIGS[Game.curBrickConfig][2] - 1;
                this.projectionY = this.projectionY > this.rows - Game.BRICK_CONFIGS[Game.curBrickConfig][2] ? this.rows - Game.BRICK_CONFIGS[Game.curBrickConfig][2] : this.projectionY;
            }
        }
        return this.projectionValid;
    }

    boolean canBrickBePlaced(int n, int n2, int n3) {
        int n4 = Game.BRICK_CONFIGS[n][1];
        int n5 = Game.BRICK_CONFIGS[n][2];
        if ((n2 -= n4 - 1 >> 1) < 0) {
            n2 = 0;
        }
        if (n2 + n4 > this.cols) {
            n2 = this.cols - n4;
        }
        if (n2 + n4 <= this.cols && n3 + n5 <= this.rows) {
            int n6 = n2;
            int n7 = this.cols * n3;
            int n8 = 4;
            boolean bl = true;
            this.insertX = this.projectionX - (Game.BRICK_CONFIGS[Game.curBrickConfig][1] - 1 >> 1);
            this.insertY = this.projectionY;
            if (this.insertX < 0) {
                this.insertX = 0;
            }
            if (this.insertX > this.cols - Game.BRICK_CONFIGS[Game.curBrickConfig][1]) {
                this.insertX = this.cols - Game.BRICK_CONFIGS[Game.curBrickConfig][1];
            }
            for (int i = 0; i < Game.BRICK_CONFIGS[n][0]; ++i) {
                for (int j = 0; j < Game.BRICK_CONFIGS[n][n8 + 0]; ++j) {
                    if (this.bricks[n6 + n7 + j + Game.BRICK_CONFIGS[n][n8 + 1]] == 0) continue;
                    bl = false;
                    break;
                }
                n8 += 2;
                n7 += this.cols;
                if (!bl) break;
            }
            return bl;
        }
        return false;
    }

    int insertBrickConfiguration() {
        int n;
        int n2;
        int n3;
        int n4 = this.insertY * this.cols;
        int n5 = Game.BRICK_CONFIGS[Game.curBrickConfig][3];
        for (n3 = 0; n3 < Game.BRICK_CONFIGS[Game.curBrickConfig][0]; ++n3) {
            n2 = this.insertX + n4 + Game.BRICK_CONFIGS[Game.curBrickConfig][5 + (n3 << 1)];
            int n6 = Game.BRICK_CONFIGS[Game.curBrickConfig][4 + (n3 << 1)];
            this.bricks[n2] = 0x80000 | n5 << 4 | n6;
            for (n = 1; n < n6; ++n) {
                this.bricks[n2 + n] = 524303;
            }
            n4 += this.cols;
        }
        Game.setStat(1, Game.gameStats[1] + Game.BRICK_CONFIGS[Game.curBrickConfig][0], true);
        n2 = this.insertY * this.cols;
        n3 = 0;
        for (n = 0; n < Game.BRICK_CONFIGS[Game.curBrickConfig][2]; ++n) {
            int n7;
            boolean bl = true;
            for (n7 = 0; n7 < this.cols; ++n7) {
                if (this.bricks[n2 + n7] != 0) continue;
                bl = false;
                break;
            }
            if (bl) {
                for (n7 = 0; n7 < this.cols; ++n7) {
                    int n8 = this.posY - this.cullingRect[3] + 138 + (this.insertY + n) * 69;
                    int n9 = Entity.random.nextInt();
                    int n10 = this.posX - this.cullingRect[4] + 32 + n7 * 64;
                    ((SceneParticles)Game.items[Game.itemOffsetParticlesStars]).emitParticleAbs(n10, n8, ((n9 & 0x1FF) - 256) * 32 >> 8, -112, 20, n9 >> 9 & 3);
                }
                ++n3;
            }
            n2 += this.cols;
        }
        return n3;
    }

    boolean insertBrick(int n, int n2, int n3, int n4) {
        int n5;
        if (n3 > 3 || n2 < 0 || n2 >= this.rows || n < 0 || n + n3 > this.cols) {
            return false;
        }
        int n6 = n2 * this.cols + n;
        for (n5 = 0; n5 < n3; ++n5) {
            if (this.bricks[n6 + n5] == 0) continue;
            return false;
        }
        this.bricks[n6] = 0x80000 | n4 << 4 | n3;
        for (n5 = 1; n5 < n3; ++n5) {
            this.bricks[n6 + n5] = 524303;
        }
        return true;
    }

    boolean insertFillers(SceneNode sceneNode) {
        if (this.containsPosition(sceneNode)) {
            int n = sceneNode.posX;
            int n2 = sceneNode.posY;
            int n3 = this.posX - this.collisionRect[2];
            int n4 = this.posY - this.collisionRect[3];
            int n5 = ((n -= n3) * 48 >> 8) / 12;
            int n6 = ((n2 -= n4) * 48 >> 8) / 13;
            int n7 = n6 + 5 < this.rows ? n6 + 5 : this.rows - 1;
            int n8 = n5 - 3;
            int n9 = n5 + 3;
            if (n8 < 0) {
                n8 = 0;
            }
            if (n9 > this.cols) {
                n9 = this.cols;
            }
            int n10 = 0;
            int n11 = n7 * this.cols;
            int n12 = 0x80000 | Game.BRICK_COLORS.length << 4 | 1;
            for (int i = n7; i >= n6; --i) {
                for (int j = n8; j < n9; ++j) {
                    if (this.bricks[n11 + j] == 0) {
                        this.bricks[n11 + j] = n12;
                        ++n10;
                        int n13 = this.posX - this.cullingRect[4] + 32 + j * 64;
                        int n14 = this.posY - this.cullingRect[3] + 34 + i * 69;
                        int n15 = Entity.random.nextInt();
                        ((SceneParticles)Game.items[Game.itemOffsetParticlesFiller]).emitParticleAbs(n13, n14, ((n15 & 0x1FF) - 256) * 96 >> 8, (((n15 & 0x1FF000) >> 12) - 256) * 96 >> 8, 20, n15 & 0xF);
                        n15 = Entity.random.nextInt();
                        ((SceneParticles)Game.items[Game.itemOffsetParticlesFiller]).emitParticleAbs(n13, n14, ((n15 & 0x1FF) - 256) * 96 >> 8, (((n15 & 0x1FF000) >> 12) - 256) * 96 >> 8, 20, n15 & 0xF);
                    }
                    if (n10 >= 6) break;
                }
                n11 -= this.cols;
                if (n10 >= 6) break;
            }
            Game.playSound(262148);
            return true;
        }
        return false;
    }

    void removeBrick(int n, int n2) {
        int n3 = n2 * this.cols + n;
        if (this.bricks[n3] != 0) {
            while ((this.bricks[n3] & 0xF) == 15) {
                --n3;
            }
            int n4 = this.bricks[n3] & 0xF;
            for (int i = 0; i < n4; ++i) {
                this.bricks[n3 + i] = 0;
            }
        }
    }

    void destroyBricks(SceneNode sceneNode, int n) {
        if (this.intersecting(sceneNode)) {
            int n2 = sceneNode.posX - (this.posX - this.collisionRect[2]);
            int n3 = sceneNode.posY - (this.posY - this.collisionRect[3]);
            int n4 = (n2 * 48 >> 8) / 12 - (n >> 1);
            int n5 = (n3 * 48 >> 8) / 13 - (n >> 1);
            int n6 = n;
            int n7 = n;
            if (n4 < 0) {
                n7 += n4;
                n4 = 0;
            } else if (n4 + n7 > this.cols) {
                n7 = this.cols - n4;
            }
            if (n5 < 0) {
                n6 += n5;
                n5 = 0;
            } else if (n5 + n6 > this.rows) {
                n6 = this.rows - n5;
            }
            for (int i = 0; i < n6; ++i) {
                int n8 = (i + n5) * this.cols;
                for (int j = 0; j < n7; ++j) {
                    int n9 = j + n4 + n8;
                    if (this.bricks[n9] == 0) continue;
                    while ((this.bricks[n9] & 0xF) == 15) {
                        --n9;
                    }
                    int n10 = this.bricks[n9] & 0xF;
                    for (int k = 0; k < n10; ++k) {
                        this.bricks[n9 + k] = 0;
                    }
                }
            }
        }
    }
}

