/*
 * Decompiled with CFR 0.152.
 */
import javax.microedition.lcdui.Graphics;

class SceneNode
extends Entity {
    boolean debug;
    static int numVisible;
    private static int segmentShift;
    int ID;
    static final int CLASS_TYPE_NODE = 0;
    static final int CLASS_TYPE_ACTOR = 1;
    static final int CLASS_TYPE_ITEM = 2;
    static final int CLASS_TYPE_PARTICLES = 3;
    static final int CLASS_TYPE_BRICK_CONTAINER = 4;
    static final int COLLIDE_VOID = 0;
    static final int COLLIDE_LEVEL = 1;
    static final int COLLIDE_STATIC = 2;
    static final int COLLIDE_BRICK_CONTAINER = 4;
    static final int COLLIDE_PICKUP = 8;
    static final int COLLIDE_MASK = 15;
    static final int COLLIDE_GROUP_1 = 16;
    static final int COLLIDE_GROUP_2 = 32;
    static final int COLLIDE_GROUP_3 = 64;
    static final int COLLIDE_GROUP_MASK = 112;
    static final int COLLISION_ALL_MASK = 127;
    static final int FLAG_POST_PAINT = 128;
    static final int SIGNAL_VOID = 0;
    static final int SIGNAL_ENTER = 1;
    static final int SIGNAL_UP = 2;
    static final int SIGNAL_DOWN = 3;
    int classType = 0;
    boolean enabled;
    boolean visible;
    int collisionType = 0;
    boolean checkCollision = false;
    boolean isOnGround;
    protected SceneNode childNode;
    protected SceneNode parentNode;
    protected int initX;
    protected int initY;
    protected int attachX;
    protected int attachY;
    protected int anchorX;
    protected int anchorY;
    protected int lastX;
    protected int lastY;
    protected int segmentX;
    protected int segmentY;
    protected int lastSegmentX;
    protected int lastSegmentY;
    protected int velX;
    protected int velY;
    protected int bounce;
    protected int timer;
    protected int frame;
    protected int rootFrame;
    protected int outX;
    protected int outY;
    int gravity = 10;
    int[] cullingRect = new int[]{0, 0, 0, 0, 0, 0};
    int[] collisionRect = new int[]{0, 0, 0, 0, 0};
    int segmentWidth;
    int segmentHeight;
    int radius = 256;
    int type;
    int properties;
    protected int currentFrameSequence;
    protected boolean hasFrameSequence;
    SceneNode canPickup;

    SceneNode() {
    }

    void destroy() {
        this.childNode = null;
    }

    void postUpdate() {
        this.lastX = this.posX;
        this.lastY = this.posY;
        this.lastSegmentX = this.segmentX;
        this.lastSegmentY = this.segmentY;
    }

    void update() {
        if (this.parentNode == null && this.classType != 3) {
            this.segmentX = this.segmentWidth << (this.posX - this.anchorX >> segmentShift);
            this.segmentY = this.segmentHeight << (this.posY - this.anchorY >> segmentShift);
        }
        this.canPickup = null;
    }

    void updateToScreen() {
        int n = 0;
        int n2 = 0;
        if (this.classType != 3) {
            n = this.posX - this.anchorX;
            n2 = this.posY - this.anchorY;
        }
        if (this.childNode != null) {
            this.childNode.updateChild();
        }
        if (Entity.intersectingRect(this.cullingRect, n, n2, Game.currentCameraRect)) {
            this.visible = true;
            this.toScreenSpace();
        } else {
            this.visible = false;
        }
    }

    protected void updateChild() {
        this.checkCollision = false;
        this.velX = this.parentNode.velX;
        this.velY = this.parentNode.velY;
        this.posX = this.parentNode.posX + this.parentNode.attachX;
        this.posY = this.parentNode.posY + this.parentNode.attachY;
        this.segmentX = this.segmentWidth << (this.posX >> segmentShift);
        this.segmentY = this.segmentHeight << (this.posY >> segmentShift);
        this.toScreenSpace();
        if (this.childNode != null) {
            this.childNode.updateChild();
        }
    }

    void paint(Graphics graphics, boolean bl) {
        if (bl && this.parentNode != null) {
            return;
        }
        if (!this.enabled || this.visible) {
            // empty if block
        }
        if (this.childNode != null) {
            this.childNode.paint(graphics, false);
        }
    }

    void postPaint(Graphics graphics) {
        if (this.classType == 1 && this.childNode != null) {
            this.childNode.paint(graphics, false);
        }
    }

    void setSprite(Sprite2Data sprite2Data, int n, boolean bl) {
        if (sprite2Data != null) {
            this.rootFrame = n;
            short[][] sArray = sprite2Data.getFrameRefPoints(n + 1);
            if (sArray == null) {
                sArray = sprite2Data.refPoints;
            }
            if (sArray != null && sArray[0] != null) {
                this.anchorX = sArray[0][0];
                this.anchorY = sArray[0][1];
            }
            short[] sArray2 = n == -1 ? sprite2Data.box : sprite2Data.getImageBoundingRect(n + 1);
            this.setRects((sArray2[0] << 8) / 48, (sArray2[1] << 8) / 48, (sArray2[2] << 8) / 48, (sArray2[3] << 8) / 48, bl);
        }
    }

    void setRects(int n, int n2, int n3, int n4, boolean bl) {
        int n5;
        this.cullingRect[0] = n;
        this.cullingRect[1] = n2;
        this.cullingRect[2] = n3;
        this.cullingRect[3] = n4;
        this.cullingRect[4] = n3 >> 1;
        this.cullingRect[5] = n4 >> 1;
        if (bl) {
            this.setCollisionRect(0, 0, this.cullingRect[2], n4);
        }
        this.radius = (n5 = this.cullingRect[2] * this.cullingRect[2] + this.cullingRect[3] * this.cullingRect[3]) > 0 ? (int)(Entity.fpSqrtFast(n5) >> 9) : 256;
    }

    void setCollisionRect(int n, int n2, int n3, int n4) {
        this.collisionRect[0] = n;
        this.collisionRect[1] = n2;
        this.collisionRect[2] = n3 >> 1;
        this.collisionRect[3] = n4;
        this.collisionRect[4] = n4 >> 1;
    }

    void calcSegmentSize() {
        int n = 1 + (this.cullingRect[2] >> segmentShift);
        int n2 = 1 + (this.cullingRect[3] >> segmentShift);
        this.segmentWidth = (4 << n) - 1;
        this.segmentHeight = (4 << n2) - 1;
    }

    void setPosition(int n, int n2, boolean bl) {
        this.posX = n;
        this.posY = n2;
        this.lastX = n;
        this.lastY = n2;
        if (bl) {
            this.initX = n;
            this.initY = n2;
        }
    }

    void setVelocity(int n, int n2) {
        this.velX = n;
        this.velY = n2;
    }

    void setTimer(int n) {
        this.timer = n;
    }

    void setType(int n) {
        this.type = n;
    }

    void setFrame(int n) {
        this.frame = n;
    }

    void setGravity(int n) {
        this.gravity = n;
    }

    void setCollisionType(int n) {
        this.collisionType = n;
    }

    void toScreenSpace() {
        this.outX = ((this.posX - this.anchorX) * 48 >> 8) - Game.currentCameraX + Screen.left;
        this.outY = ((this.posY - this.anchorY) * 48 >> 8) - Game.currentCameraY + Screen.top;
    }

    void attachTo(SceneNode sceneNode) {
        this.attachTo(sceneNode, sceneNode.posX - this.posX, sceneNode.posY - this.posY);
    }

    void attachTo(SceneNode sceneNode, int n, int n2) {
        if (sceneNode.childNode != null) {
            sceneNode.childNode.parentNode = this;
            this.childNode = sceneNode.childNode;
            sceneNode.childNode = this;
            this.parentNode = sceneNode;
        } else {
            sceneNode.childNode = this;
            this.parentNode = sceneNode;
        }
        this.attachX = n;
        this.attachY = n2;
        this.posX = sceneNode.posX + n;
        this.posY = sceneNode.posY + n2;
        this.velX = sceneNode.velX;
        this.velY = sceneNode.velY;
        this.isOnGround = false;
    }

    void detachFromParent() {
        if (this.parentNode != null) {
            this.parentNode.childNode = null;
            this.parentNode = null;
        }
    }

    SceneNode detachChild() {
        if (this.childNode != null) {
            this.childNode.parentNode = null;
            SceneNode sceneNode = this.childNode;
            this.childNode = null;
            return sceneNode;
        }
        return null;
    }

    boolean intersecting(SceneNode sceneNode) {
        int n;
        int n2;
        int n3 = sceneNode.posX + sceneNode.collisionRect[0];
        int n4 = this.posX + this.collisionRect[0];
        return Math.abs(n3 - n4) <= this.collisionRect[2] + sceneNode.collisionRect[2] && Math.abs((n2 = sceneNode.posY + this.anchorY - sceneNode.collisionRect[4]) - (n = this.posY + this.anchorY - this.collisionRect[4])) <= this.collisionRect[4] + sceneNode.collisionRect[4];
    }

    boolean isIntersecting(SceneNode sceneNode) {
        return false;
    }

    boolean containsPosition(SceneNode sceneNode) {
        int n;
        int n2 = this.posX + this.collisionRect[0];
        return Math.abs(sceneNode.posX - n2) <= this.collisionRect[2] && Math.abs(sceneNode.posY - (n = this.posY - this.collisionRect[4])) <= this.collisionRect[4];
    }

    boolean resolveLevelCollision(int n) {
        int n2 = this.posX >> 8;
        int n3 = this.posY >> 8;
        int n4 = this.lastX >> 8;
        int n5 = this.lastY >> 8;
        int n6 = this.posX - this.lastX;
        int n7 = this.posY - this.lastY;
        if (n2 != n4 || n3 != n5) {
            if (n2 != n4 && n3 != n5) {
                int n8 = n2 < n4 ? n4 << 9 : n4 + 1 << 9;
                int n9 = n3 < n5 ? n5 << 9 : n5 + 1 << 9;
                int n10 = n8 - this.lastX;
                int n11 = n9 - this.lastY;
                int n12 = (n10 - n7) * (n11 - n6);
                if (n3 > n5) {
                    n12 = -n12;
                }
                if (n12 > 0) {
                    if (this.resolveLevelCollisionX(n2, n4, n3)) {
                        this.resolveLevelCollisionY(n4, n3, n5, n);
                        return true;
                    }
                    return this.resolveLevelCollisionY(n2, n3, n5, n);
                }
                if (this.resolveLevelCollisionY(n4, n3, n5, n)) {
                    this.resolveLevelCollisionX(n2, n4, n5);
                    return true;
                }
                return this.resolveLevelCollisionX(n2, n4, n3);
            }
            if (n2 != n4) {
                return this.resolveLevelCollisionX(n2, n4, n3);
            }
            return this.resolveLevelCollisionY(n2, n3, n5, n);
        }
        return false;
    }

    private boolean resolveLevelCollisionX(int n, int n2, int n3) {
        if (Game.collidingMap(n, n3)) {
            this.posX = n2 < n ? (n2 + 1 << 8) - 1 : (n2 << 8) + 1;
            this.velX = -(this.velX * this.bounce >> 8);
            return true;
        }
        return false;
    }

    private boolean resolveLevelCollisionY(int n, int n2, int n3, int n4) {
        if (Game.collidingMap(n, n2)) {
            this.velY = -(this.velY * this.bounce >> 8);
            if (n3 < n2) {
                this.posY = (n3 + 1 << 8) - 1;
                if (Math.abs(this.velY) <= n4) {
                    this.isOnGround = true;
                }
                return true;
            }
            this.posY = (n3 << 8) - 1;
            return true;
        }
        return false;
    }

    protected int sqDistance(SceneNode sceneNode) {
        if (sceneNode != null) {
            int n = this.posX - sceneNode.posX;
            int n2 = this.posY - sceneNode.posY;
            return n * n + n2 * n2;
        }
        return -1;
    }

    public void paintSceneNodeRect(Graphics graphics, int n, int n2) {
        int n3 = (this.cullingRect[0] + this.posX - this.anchorX - n) * 48 >> 8;
        int n4 = (this.cullingRect[1] + this.posY - this.anchorY - n2) * 48 >> 8;
        int n5 = this.cullingRect[2] * 48 >> 8;
        int n6 = this.cullingRect[3] * 48 >> 8;
        int n7 = graphics.getColor();
        graphics.setColor(0xFF2020);
        graphics.drawRect(n3, n4, n5, n6);
        graphics.setColor(n7);
    }

    static {
        segmentShift = 8;
    }
}

