/*
 * Decompiled with CFR 0.152.
 */
import javax.microedition.lcdui.Graphics;

final class SceneParticles
extends SceneNode {
    static final int TYPE_STARS = 0;
    static final int TYPE_SMOKE = 1;
    static final int TYPE_FIRE = 3;
    static final int TYPE_BUBBLES = 4;
    static final int TYPE_ELECTRICITY = 5;
    static final int TYPE_LEAVES = 6;
    static final int TYPE_MENU_BRICKS = 7;
    static final int FLAG_GRAVITY = 1;
    static final int FLAG_TIMEOUT = 2;
    static final int FLAG_COLLIDE_LEVEL = 4;
    static final int FLAG_DRAG = 8;
    static final int FLAG_PLAY_FRAMES = 16;
    static final int SUB_TYPE_VOID = 0;
    static final int SUB_TYPE_LEAVES = 1;
    static final int SUB_TYPE_ELECTRICITY = 2;
    int bounce;
    int drag;
    int animSpeed;
    int subType;
    private Sprite2Data sprite;
    private int[] spriteRect = new int[]{0, 0, 0, 0, 0, 0};
    private static final int PARTICLE_VAR_TIME = 0;
    private static final int PARTICLE_VAR_X = 1;
    private static final int PARTICLE_VAR_Y = 2;
    private static final int PARTICLE_VAR_VELX = 3;
    private static final int PARTICLE_VAR_VELY = 4;
    private static final int PARTICLE_VAR_FRAME = 5;
    private static final int PARTICLE_VAR_OUTX = 6;
    private static final int PARTICLE_VAR_OUTY = 7;
    private static final int PARTICLE_VAR_INITDELAY = 8;
    private static final int PARTICLE_NUM_VAR = 9;
    private int numParticles;
    private int[] particles;
    private boolean noParticles;
    private int spriteOffsetX;
    private int spriteOffsetY;
    int misc1;
    int misc2;
    int misc3;
    private boolean applyGravity;
    private boolean timeOut;
    private boolean collide;
    private boolean applyDrag;
    private boolean playFrames;

    SceneParticles() {
        this.classType = 3;
        this.bounce = 224;
    }

    void create(int n) {
        this.numParticles = n;
        this.particles = new int[9 * n];
    }

    void destroy() {
        this.sprite = null;
        this.particles = null;
    }

    void update() {
        if (this.enabled) {
            int n = 0;
            int n2 = 0;
            int n3 = 0;
            int n4 = 0;
            int n5 = 0;
            boolean bl = true;
            for (int i = 0; i < this.numParticles; ++i) {
                if (this.particles[n + 0] > 0) {
                    if (this.particles[n + 8] > 0) {
                        int n6 = n + 8;
                        this.particles[n6] = this.particles[n6] - 1;
                    } else {
                        int n7;
                        int n8;
                        int n9;
                        if (this.applyGravity) {
                            int n10 = n + 4;
                            this.particles[n10] = this.particles[n10] + this.gravity;
                        }
                        this.posX += this.velX;
                        this.posY += this.velY;
                        if (this.applyDrag) {
                            this.particles[n + 3] = this.particles[n + 3] * this.drag >> 8;
                            this.particles[n + 4] = this.particles[n + 4] * this.drag >> 8;
                        }
                        if (this.timeOut) {
                            int n11 = n + 0;
                            this.particles[n11] = this.particles[n11] - 1;
                        } else {
                            int n12 = n + 0;
                            this.particles[n12] = this.particles[n12] + 1;
                        }
                        if (this.playFrames && this.sprite != null) {
                            n9 = (this.particles[n + 5] & 0xFF00) >> 8;
                            n8 = this.particles[n + 5] & 0xFF;
                            if (n9 == 0) {
                                n9 = this.animSpeed;
                                ++n8;
                                if (this.hasFrameSequence) {
                                    if (n8 >= this.sprite.frameSequences[this.currentFrameSequence].length) {
                                        if (!this.timeOut) {
                                            this.particles[n + 0] = 0;
                                        } else {
                                            n8 = 0;
                                        }
                                    }
                                } else if (n8 >= this.sprite.frameCount) {
                                    if (!this.timeOut) {
                                        this.particles[n + 0] = 0;
                                    } else {
                                        n8 = 0;
                                    }
                                }
                            } else {
                                --n9;
                            }
                            this.particles[n + 5] = n8 & 0xFF | (n9 & 0xFF) << 8;
                        }
                        n9 = this.particles[n + 2] & 0xFFFFFF00;
                        if (this.subType == 1) {
                            if (this.particles[n + 1] > Game.camRect[0] + Game.camRect[2] + 256 || this.particles[n + 2] > Game.camRect[1] + Game.camRect[3] + 256 || this.particles[n + 1] < Game.camRect[0] - 256 || this.particles[n + 2] < Game.camRect[1] - 256) {
                                this.particles[n + 0] = 0;
                            } else {
                                n8 = (this.particles[n + 0] & 0xFFFF) - 32768;
                                if ((n8 += (Entity.random.nextInt() & 0x1FF) - 256) < -2048) {
                                    n8 = -2048;
                                }
                                if (n8 > 2048) {
                                    n8 = 2048;
                                }
                                this.particles[n + 0] = n8 + 32768 | 0x10000;
                                int n13 = n + 3;
                                this.particles[n13] = this.particles[n13] + (Game.windVelX + (Game.windVelX * n8 >> 10));
                                n7 = this.particles[n + 3];
                                if (n7 > 16) {
                                    n7 = 16;
                                }
                                if (n7 < -16) {
                                    n7 = -16;
                                }
                                int n14 = n + 4;
                                this.particles[n14] = this.particles[n14] + (Game.windVelY * (16 - Math.abs(n7)) >> 4);
                                this.particles[n + 5] = (n7 + 16) * (this.sprite.frameCount - 1) >> 5;
                                this.particles[n + 3] = this.particles[n + 3] * this.drag >> 8;
                                this.particles[n + 4] = this.particles[n + 4] * (160 + (Math.abs(n7) << 1)) >> 8;
                            }
                        }
                        int n15 = n + 1;
                        this.particles[n15] = this.particles[n15] + this.particles[n + 3];
                        int n16 = n + 2;
                        this.particles[n16] = this.particles[n16] + this.particles[n + 4];
                        n8 = this.particles[n + 1];
                        n7 = this.particles[n + 2];
                        if (this.collide && (this.particles[n + 2] & 0xFFFFFF00) > n9 && Game.collidingMap(n8, n7)) {
                            this.particles[n + 2] = (n7 &= 0xFFFFFF00) - 1;
                            this.particles[n + 4] = -(this.particles[n + 4] * this.bounce >> 8);
                        }
                        if (bl) {
                            n2 = n4 = n8;
                            n3 = n5 = n7;
                            bl = false;
                        } else {
                            if (n8 < n2) {
                                n2 = n8;
                            } else if (n8 > n4) {
                                n4 = n8;
                            }
                            if (n7 < n3) {
                                n3 = n7;
                            } else if (n7 > n5) {
                                n5 = n7;
                            }
                        }
                        this.particles[n + 6] = ((n8 - this.spriteOffsetX) * 48 >> 8) - Game.currentCameraX;
                        this.particles[n + 7] = ((n7 - this.spriteOffsetY) * 48 >> 8) - Game.currentCameraY;
                    }
                }
                n += 9;
            }
            this.noParticles = bl;
            this.cullingRect[0] = n2;
            this.cullingRect[1] = n3;
            this.cullingRect[2] = n4 - n2;
            this.cullingRect[3] = n5 - n3;
            if (!bl) {
                this.cullingRect[0] = this.cullingRect[0] - this.spriteRect[4];
                this.cullingRect[1] = this.cullingRect[1] - this.spriteRect[5];
                this.cullingRect[2] = this.cullingRect[2] + this.spriteRect[2];
                this.cullingRect[3] = this.cullingRect[3] + this.spriteRect[3];
            }
            this.cullingRect[4] = this.cullingRect[2] >> 1;
            this.cullingRect[5] = this.cullingRect[3] >> 1;
            super.update();
        }
    }

    void paint(Graphics graphics, boolean bl) {
        if (bl && this.parentNode != null) {
            return;
        }
        if (this.enabled && !this.noParticles && this.visible) {
            this.paintParticles(graphics);
        }
    }

    void postPaint(Graphics graphics) {
        if (this.parentNode != null) {
            return;
        }
        if (this.enabled && !this.noParticles && this.visible) {
            this.paintParticles(graphics);
        }
    }

    void paintParticles(Graphics graphics) {
        int n = 0;
        if (this.subType != 2) {
            for (int i = 0; i < this.numParticles; ++i) {
                int n2;
                if (this.particles[n + 0] > 0 && this.particles[n + 8] == 0 && (n2 = this.particles[n + 6]) != -6581) {
                    int n3 = this.particles[n + 7];
                    int n4 = 0;
                    int n5 = this.particles[n + 5] & 0xFF;
                    if (this.hasFrameSequence) {
                        if (n5 < this.sprite.frameSequences[this.currentFrameSequence].length && (n4 = this.sprite.frameSequences[this.currentFrameSequence][n5]) > this.sprite.frameCount) {
                            n4 = 0;
                        }
                    } else {
                        n4 = n5 + 1;
                    }
                    this.sprite.paint(graphics, n2, n3, n4, 0);
                }
                n += 9;
            }
        } else {
            int n6 = 0;
            int n7 = 0;
            int n8 = 0;
            int n9 = 0;
            for (int i = 0; i < this.numParticles - 1; ++i) {
                if (this.particles[n + 0] > 0) {
                    if ((this.particles[n + 5] & 0x80) != 0) {
                        graphics.setColor(n9);
                        graphics.drawLine(n6, n7 + 1, this.particles[n + 6], this.particles[n + 7] + 1);
                        graphics.drawLine(n6, n7 - 1, this.particles[n + 6], this.particles[n + 7] - 1);
                        graphics.setColor(n8);
                        graphics.drawLine(n6, n7, this.particles[n + 6], this.particles[n + 7]);
                    } else {
                        int n10 = 64 + (this.particles[n + 0] << 6);
                        if (n10 > 256) {
                            n10 = 256;
                        }
                        n8 = Entity.scaleColor(0, this.misc1, n10);
                        n9 = Entity.scaleColor(0, this.misc2, n10);
                    }
                    n6 = this.particles[n + 6];
                    n7 = this.particles[n + 7];
                }
                n += 9;
            }
        }
    }

    void emitElectricity(int n, int n2, int n3, int n4, int n5, int n6) {
        boolean bl = false;
        int n7 = 0;
        int n8 = 0;
        int n9 = 0;
        for (int i = 0; i < this.numParticles; ++i) {
            if (this.particles[n9 + 0] == 0) {
                if (!bl) {
                    bl = true;
                    n7 = i;
                    n8 = 1;
                } else {
                    ++n8;
                }
                if (n8 == n6) {
                    n9 = n7 * 9;
                    int n10 = (n3 - n << 8) / (n6 - 1);
                    int n11 = (n4 - n2 << 8) / (n6 - 1);
                    boolean bl2 = false;
                    for (int j = 0; j < n6; ++j) {
                        if (j == 0) {
                            this.particles[n9 + 5] = 0;
                            bl2 = false;
                        } else {
                            this.particles[n9 + 5] = 128;
                            bl2 = j != n6 - 1;
                        }
                        int n12 = n + (n10 * j >> 8);
                        int n13 = n2 + (n11 * j >> 8);
                        if (bl2) {
                            this.particles[n9 + 1] = n12 + (((Entity.random.nextInt() & 0x1FF) - 256) * 64 >> 8);
                            this.particles[n9 + 2] = n13 + (((Entity.random.nextInt() & 0x1FF) - 256) * 64 >> 8);
                            this.particles[n9 + 3] = ((Entity.random.nextInt() & 0x1FF) - 256) * 16 >> 8;
                            this.particles[n9 + 4] = ((Entity.random.nextInt() & 0x1FF) - 256) * 16 >> 8;
                        } else {
                            this.particles[n9 + 1] = n12;
                            this.particles[n9 + 2] = n13;
                            this.particles[n9 + 3] = 0;
                            this.particles[n9 + 4] = 0;
                        }
                        this.particles[n9 + 0] = n5;
                        n9 += 9;
                    }
                    return;
                }
            } else if (bl) {
                bl = false;
            }
            n9 += 9;
        }
    }

    void emitParticle(int n, int n2, int n3, int n4, int n5, int n6) {
        if (n5 > 0) {
            int n7 = 0;
            for (int i = 0; i < this.numParticles; ++i) {
                if (this.particles[n7 + 0] == 0) {
                    this.particles[n7 + 8] = n6;
                    this.particles[n7 + 1] = n + this.posX;
                    this.particles[n7 + 2] = n2 + this.posY;
                    this.particles[n7 + 3] = n3 + this.velX;
                    this.particles[n7 + 4] = n4 + this.velY;
                    this.particles[n7 + 6] = -6581;
                    this.particles[n7 + 5] = this.animSpeed << 8;
                    this.particles[n7 + 0] = n5;
                    return;
                }
                n7 += 9;
            }
        }
    }

    void emitParticleAbs(int n, int n2, int n3, int n4, int n5, int n6) {
        if (n5 > 0) {
            int n7 = 0;
            for (int i = 0; i < this.numParticles; ++i) {
                if (this.particles[n7 + 0] == 0) {
                    this.particles[n7 + 8] = n6;
                    this.particles[n7 + 1] = n;
                    this.particles[n7 + 2] = n2;
                    this.particles[n7 + 3] = n3;
                    this.particles[n7 + 4] = n4;
                    this.particles[n7 + 6] = -6581;
                    this.particles[n7 + 5] = this.animSpeed << 8;
                    this.particles[n7 + 0] = n5;
                    return;
                }
                n7 += 9;
            }
        }
    }

    void applyBlast(int n, int n2, int n3, int n4) {
        int n5 = 0;
        int n6 = n4 * n4;
        for (int i = 0; i < this.numParticles; ++i) {
            int n7;
            int n8;
            int n9;
            int n10;
            if (this.particles[n5 + 0] > 0 && (n10 = (n9 = this.particles[n5 + 1] - n) * n9 + (n8 = this.particles[n5 + 2] - n2) * n8) < n6 && n10 > 0 && (n7 = (int)Entity.fpSqrtFast(n10) >> 8) > 0) {
                int n11 = n5 + 3;
                this.particles[n11] = this.particles[n11] + n9 * n3 / n7;
                int n12 = n5 + 4;
                this.particles[n12] = this.particles[n12] + n8 * n3 / n7;
            }
            n5 += 9;
        }
    }

    void setSprite(Sprite2Data sprite2Data, int n, boolean bl) {
        if (sprite2Data != null) {
            this.sprite = sprite2Data;
            this.hasFrameSequence = sprite2Data.frameSequences != null;
            this.spriteRect[0] = (this.sprite.box[0] << 8) / 48;
            this.spriteRect[1] = (this.sprite.box[1] << 8) / 48;
            this.spriteRect[2] = (this.sprite.box[2] << 8) / 48;
            this.spriteRect[3] = (this.sprite.box[3] << 8) / 48;
            this.spriteRect[4] = this.spriteRect[2] >> 1;
            this.spriteRect[5] = this.spriteRect[3] >> 1;
            this.spriteOffsetX = this.spriteRect[4];
            this.spriteOffsetY = this.spriteRect[5];
        }
    }

    void setProperties(int n) {
        this.applyGravity = (n & 1) != 0;
        this.timeOut = (n & 2) != 0;
        this.collide = (n & 4) != 0;
        this.applyDrag = (n & 8) != 0;
        this.playFrames = (n & 0x10) != 0;
        this.properties = n & 0x80;
    }
}

