/*
 * Decompiled with CFR 0.152.
 */
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import javax.microedition.media.Manager;
import javax.microedition.media.Player;
import javax.microedition.media.control.VolumeControl;

final class Sound {
    static final int TYPE_AMR = 0;
    static final int TYPE_MIDI = 1;
    static final int TYPE_TONE = 2;
    static final int TYPE_WAV = 3;
    private static final int[] MIN_VOLUME = new int[]{30, 10, 10, 10};
    private static final int[] MAX_VOLUME = new int[]{100, 100, 100, 100};
    private static final String[] CONTENT_TYPE = new String[]{"audio/amr", "audio/midi", "audio/x-tone-seq", "audio/x-wav"};
    private Player player = null;
    private static Sound current = null;
    private static boolean unloadCurrentWhenStopped = false;
    private static VolumeControl currentVolume = null;
    private static int currentVolumeLevel = 0;
    private static int fadeStep = 0;
    private static long lastTime = 0L;
    private int priority = 0;
    private static Sound[] realizedSounds;
    private byte[] data = null;
    private int contentType = -1;
    private int usage = 0;
    static final int MUSIC_NO_FADE = 1;
    static final int MUSIC_REPLACE_CURRENT = 2;
    static final int MUSIC_NO_LOOP = 4;
    static Sound music;
    static int musicFlags;
    private static Sound[] sounds;
    private static long musicWasLastPlaying;

    private Sound(byte[] byArray, int n) throws IOException {
        this.data = byArray;
        this.contentType = n;
    }

    static void loadSound(int n, Storage storage, int n2) throws IOException {
        int n3 = n & 0xFFFF;
        int n4 = n3 + n2;
        int n5 = Sound.getTypeFromStorageType(storage.getFileType(n4));
        Sound sound = n5 >= 0 ? new Sound(storage.getData(n4), n5) : null;
        Sound.sounds[n3] = sound;
    }

    static void unloadSound(int n, boolean bl) {
        int n2 = n & 0xFFFF;
        if (sounds[n2] != null) {
            if (bl || !sounds[n2].isPlaying()) {
                sounds[n2].unload();
            } else if (sounds[n2] == current) {
                unloadCurrentWhenStopped = true;
            }
            Sound.sounds[n2] = null;
        }
    }

    static void play(int n, boolean bl, int n2) {
        int n3 = n & 0xFFFF;
        if (sounds[n3] != null) {
            sounds[n3].play(bl, n >>> 16, n2);
        }
    }

    static boolean isLoaded(int n) {
        int n2 = n & 0xFFFF;
        return sounds[n2] != null;
    }

    private static int getTypeFromStorageType(int n) {
        if (n == 6) {
            return 0;
        }
        if (n == 3) {
            return 1;
        }
        if (n == 7) {
            return 2;
        }
        if (n == 8) {
            return 3;
        }
        return -1;
    }

    private void unload() {
        if (this == current) {
            Sound.stopCurrent();
        }
        if (this == music) {
            music = null;
        }
        if (this.player != null) {
            this.player.deallocate();
            this.player.close();
            this.player = null;
        }
        this.data = null;
    }

    private void play(boolean bl, int n, int n2) {
        if (this.data == null || !Storage.isOptionOn(0)) {
            return;
        }
        try {
            if (current != null && Sound.current.priority >= n && current.isPlaying()) {
                return;
            }
            if (Screen.time - lastTime < 100L) {
                return;
            }
            lastTime = Screen.time;
            Screen.watchdog = 0L;
            this.priority = n;
            if (this == current && !bl) {
                this.player.start();
            } else {
                Sound.stopCurrent();
                if (this.player == null) {
                    this.player = Manager.createPlayer((InputStream)new ByteArrayInputStream(this.data), (String)CONTENT_TYPE[this.contentType]);
                }
                current = this;
                if (this.player != null) {
                    if (this.player.getState() == 400) {
                        this.player.deallocate();
                    }
                    this.player.realize();
                    this.player.prefetch();
                    while (this.player.getState() != 300) {
                        Thread.yield();
                    }
                    currentVolume = (VolumeControl)this.player.getControl("VolumeControl");
                    Sound.fade(n2);
                    this.player.start();
                    if (n2 > 0) {
                        Sound.setCurrentVolume(0);
                    } else {
                        Sound.applyVolume();
                    }
                }
            }
        }
        catch (Exception exception) {
            Screen.lastIgnoredException = exception;
        }
        ++this.usage;
    }

    private boolean isPlaying() {
        return this.player != null && this.player.getState() == 400;
    }

    static boolean isAnySoundPlaying() {
        return current != null && current.isPlaying();
    }

    static int _getState() {
        if (Sound.current.player != null) {
            return Sound.current.player.getState();
        }
        return -1;
    }

    static int _getMediaTime() {
        if (Sound.current.player != null) {
            return (int)Sound.current.player.getMediaTime();
        }
        return -99;
    }

    static void stopCurrent() {
        if (current != null) {
            if (Sound.current.player != null) {
                try {
                    Sound.current.player.stop();
                    Sound.current.player.deallocate();
                    while (Sound.current.player.getState() == 400) {
                        Thread.yield();
                    }
                }
                catch (Exception exception) {
                    Screen.lastIgnoredException = exception;
                }
            }
            Sound sound = current;
            current = null;
            currentVolume = null;
            if (unloadCurrentWhenStopped) {
                sound.unload();
                sound = null;
            }
        }
        unloadCurrentWhenStopped = false;
    }

    private static int getVolume() {
        return MAX_VOLUME[Sound.current.contentType];
    }

    static void applyVolume() {
        if (currentVolume != null && current != null) {
            int n;
            currentVolumeLevel = n = Sound.getVolume();
            currentVolume.setLevel(n);
        }
    }

    static void setCurrentVolume(int n) {
        if (currentVolume != null) {
            currentVolumeLevel = n;
            currentVolume.setLevel(n);
        }
    }

    static void onPaused() {
        lastTime = Screen.time;
        Sound.stopCurrent();
    }

    static void fade(int n) {
        fadeStep = n;
    }

    static void updateSound() {
        Sound.updateMusic();
        if (current != null) {
            if (currentVolume != null) {
                if (fadeStep != 0) {
                    int n = currentVolumeLevel + fadeStep;
                    if (fadeStep < 0) {
                        if (n > 0) {
                            Sound.setCurrentVolume(n);
                        }
                        if (n <= 0) {
                            Sound.stopCurrent();
                            fadeStep = 0;
                        }
                    } else {
                        int n2 = Sound.getVolume();
                        if (n > n2) {
                            n = n2;
                            fadeStep = 0;
                        }
                        Sound.setCurrentVolume(n);
                    }
                }
            } else if (fadeStep < 0) {
                Sound.stopCurrent();
                fadeStep = 0;
            }
        }
    }

    static void setMusic(int n, int n2) {
        if (n >= 0) {
            int n3 = n & 0xFFFF;
            music = sounds[n3];
        } else {
            music = null;
        }
        musicFlags = n2;
    }

    private static void updateMusic() {
        boolean bl;
        boolean bl2 = false;
        boolean bl3 = bl = (musicFlags & 1) == 0;
        if (current != null && (bl2 = current.isPlaying()) && (musicFlags & 2) != 0 && current != music) {
            if (bl) {
                Sound.fade(-5);
            } else {
                Sound.stopCurrent();
                bl2 = false;
            }
            musicFlags &= 0xFFFFFFFD;
        }
        if (!(bl2 || music == null || music == current && (musicFlags & 4) != 0)) {
            music.play(true, 127, bl ? 5 : 0);
        }
    }

    static {
        music = null;
        musicFlags = 0;
        sounds = null;
        sounds = new Sound[18];
        musicWasLastPlaying = 0L;
    }
}

