/*
 * Decompiled with CFR 0.152.
 */
import javax.microedition.lcdui.Graphics;

final class SceneItem
extends SceneNode {
    static final int TYPE_STATIC_OBJECT = 0;
    static final int TYPE_BOMB = 1;
    static final int TYPE_CRATE_BRICKCONFIG = 2;
    static final int TYPE_CRATE_FILLER = 3;
    static final int TYPE_CRATE_SHOES = 4;
    static final int TYPE_DOOR = 5;
    static final int TYPE_STATIC_REPEATER = 6;
    static final int FLAG_GRAVITY = 256;
    static final int FLAG_TIMEOUT = 512;
    static final int FLAG_DRAG = 1024;
    static final int FLAG_PLAY_FRAMES = 2048;
    static final int FLAG_UPDATE_WHILE_ATTACHED = 4096;
    static final int FLAG_DIE_ON_COLLISION = 8192;
    static final int FLAG_DISABLE_WHEN_NOT_VISIBLE = 16384;
    static final int MV_TYPE_CRATE_PARSUITE_COUNT = 0;
    static final int MV_TYPE_CRATE_BRICKCONFIG_CUR_SET = 1;
    static final int MV_TYPE_CRATE_BRICKCONFIG_CUR_SUBSET = 2;
    static final int MV_TYPE_CRATE_FRAME = 3;
    static final int MV_TYPE_BLOWER_MOVE_CNT = 0;
    static final int MV_TYPE_BLOWER_MOVE_CNT_DELTA = 1;
    static final int MV_TYPE_BLOWER_STATE = 2;
    static final int MV_TYPE_BLOWER_FROM_Y = 3;
    static final int MV_TYPE_BLOWER_TO_Y = 4;
    static final int BOMB_EXPLODE_RADIUS = 512;
    static final int BOMB_EXPLODE_SQRADIUS = 262144;
    private static final int CRATE_SEQUENCE = 0;
    private static final int CRATE_SEQUENCE_ITEMS = 1;
    private static final int CRATE_SEQUENCE_PARACHUTE = 2;
    private static final int CRATE_ITEM_SHOE = 0;
    private static final int CRATE_ITEM_TROWEL = 1;
    private static int[] propertiesSetup = new int[]{0, 5901, 520, 520, 528, 1043, 0};
    private static final int[] DRAGH = new int[]{0, 232, 232, 232, 232, 0, 0};
    private static final int[] DRAGV = new int[]{0, 220, 179, 179, 179, 248, 0};
    private static final int[] BOUNCEPROPERTY = new int[]{0, 248, 256, 256, 256, 128, 0};
    private Sprite2Data sprite;
    int subType;
    boolean wasOnGround;
    int[] miscVar = new int[5];

    SceneItem() {
        this.classType = 2;
    }

    void destroy() {
        this.sprite = null;
        this.miscVar = null;
    }

    void update() {
        block17: {
            block18: {
                int n;
                block19: {
                    block20: {
                        block21: {
                            if (!this.enabled || this.parentNode != null && (this.properties & 0x1000) == 0) break block17;
                            switch (this.type) {
                                case 1: {
                                    if ((Game.tick & (this.isOnGround ? 3 : 1)) != 0) break;
                                    n = Entity.random.nextInt();
                                    ((SceneParticles)Game.items[Game.itemOffsetParticlesSmoke]).emitParticleAbs(this.posX, this.posY, this.velX + (n & 0xF) - 8, this.velY + ((n & 0xF0) >> 4) - 8, 1, 0);
                                    break;
                                }
                                case 2: 
                                case 3: 
                                case 4: {
                                    if (this.miscVar[0] <= 0) break;
                                    this.miscVar[0] = this.miscVar[0] - 1;
                                    if (this.miscVar[0] != 0) break;
                                    this.properties |= 0x500;
                                }
                            }
                            if ((this.properties & 0x200) != 0) {
                                --this.timer;
                                if (this.timer < 0) {
                                    this.eventTimeOut();
                                    this.disableItem();
                                    return;
                                }
                            }
                            if (this.parentNode != null) {
                                return;
                            }
                            if ((this.properties & 0x100) != 0) {
                                this.velY += this.gravity;
                            }
                            this.posX += this.velX;
                            this.posY += this.velY;
                            if ((this.properties & 0x400) != 0) {
                                this.velX = this.velX < 0 ? -(-this.velX * DRAGH[this.type] >> 8) : this.velX * DRAGH[this.type] >> 8;
                                this.velY = this.velY < 0 ? -(-this.velY * DRAGV[this.type]) >> 8 : this.velY * DRAGV[this.type] >> 8;
                            }
                            if ((this.properties & 0x800) != 0 && this.sprite != null && (this.timer & 1) == 0) {
                                ++this.frame;
                                if (this.hasFrameSequence) {
                                    if (this.frame > this.sprite.frameSequences[this.currentFrameSequence].length) {
                                        this.enabled = false;
                                    }
                                } else if (this.frame - this.rootFrame > this.sprite.frameCount) {
                                    this.enabled = false;
                                }
                            }
                            this.isOnGround = false;
                            if ((this.collisionType & 1) == 0) break block18;
                            if ((this.properties & 4) == 0) break block19;
                            if (Game.brickContainer.checkCollision(this)) break block20;
                            if (!this.resolveLevelCollision(64)) break block18;
                            if ((this.properties & 0x2000) == 0) break block21;
                            this.disableItem();
                            break block18;
                        }
                        if (this.isOnGround && this.wasOnGround || this.type != 1) break block18;
                        Game.playSound(131075);
                        break block18;
                    }
                    if (this.velY >= -16 || this.type != 1) break block18;
                    Game.playSound(131075);
                    break block18;
                }
                if (!(!this.resolveLevelCollision(64) || this.isOnGround && this.wasOnGround)) {
                    for (n = 0; n < 4; ++n) {
                        int n2 = Entity.random.nextInt();
                        ((SceneParticles)Game.items[Game.itemOffsetParticlesSmoke]).emitParticleAbs(this.posX - 128, this.posY, ((n2 & 0x1FF) - 256) * 96 >> 8, (((n2 & 0x1FF000) >> 12) - 256) * 16 >> 8, 20, 0);
                    }
                }
            }
            if (this.collisionType != 0) {
                this.checkCollision = true;
            }
            this.wasOnGround = this.isOnGround;
            super.update();
        }
    }

    boolean isIntersecting(SceneNode sceneNode) {
        switch (this.type) {
            case 4: {
                if (sceneNode.classType != 1 || sceneNode.type != 0) break;
                ((SceneActor)sceneNode).jumpBoost = true;
                Game.tutorialCheckState(3);
                this.enabled = false;
                return true;
            }
            case 5: {
                if (sceneNode.classType != 1 || sceneNode.type != 0 || !this.containsPosition(sceneNode)) break;
                if (sceneNode.lastY > this.lastY) {
                    sceneNode.posY = this.posY;
                    if (Math.abs(this.lastX - sceneNode.lastX) < this.collisionRect[4]) {
                        return true;
                    }
                }
                sceneNode.posX = sceneNode.posX < this.posX ? this.posX - this.collisionRect[2] : this.posX + this.collisionRect[2];
                return true;
            }
        }
        return false;
    }

    void signalUse(SceneNode sceneNode, int n) {
    }

    void disableItem() {
        if (this.enabled) {
            this.detachFromParent();
            this.enabled = false;
            if (this.type == 1) {
                int n;
                int n2;
                Game.setCameraRandomShake(128, 128);
                Screen.vibrate(1000);
                for (n2 = 0; n2 < 5; ++n2) {
                    n = Entity.random.nextInt();
                    ((SceneParticles)Game.items[Game.itemOffsetParticlesStars]).emitParticleAbs(this.posX, this.posY, ((n & 0x1FF) - 256) * 96 >> 8, (((n & 0x1FF000) >> 12) - 256) * 96 >> 8, 20, 0);
                }
                for (n2 = 0; n2 < 5; ++n2) {
                    n = Entity.random.nextInt();
                    ((SceneParticles)Game.items[Game.itemOffsetParticlesSparks]).emitParticleAbs(this.posX, this.posY, ((n & 0x1FF) - 256) * 96 >> 8, (((n & 0x1FF000) >> 12) - 256) * 96 >> 8, 20, 0);
                }
                Game.brickContainer.destroyBricks(this, 3);
                Game.playSound(393217);
                Entity.game.set(512, true);
                for (n = 0; n < Game.items.length; ++n) {
                    if (Game.items[n] == null || Game.items[n].classType != 1 || (n2 = Game.items[n].sqDistance(this)) >= 262144) continue;
                    ((SceneActor)Game.items[n]).eventInsideBombExplosion(n2, 512, this);
                }
                ((SceneParticles)Game.items[Game.itemOffsetParticlesLeaves]).applyBlast(this.posX, this.posY, 128, 512);
                Game.tutorialCheckState(11);
            }
        }
    }

    void updateToScreen() {
        super.updateToScreen();
        if ((this.properties & 0x4000) != 0 && !this.visible) {
            this.disableItem();
        }
    }

    void paint(Graphics graphics, boolean bl) {
        if (bl && this.parentNode != null) {
            return;
        }
        if (this.sprite != null && this.enabled && this.visible) {
            switch (this.type) {
                case 2: {
                    this.sprite.paint(graphics, this.outX, this.outY, this.sprite.frameSequences[0][0], 0);
                    int n = this.outX;
                    int n2 = this.outY;
                    int n3 = Game.BRICK_BINDINGS[this.miscVar[1] << 1] + this.miscVar[2];
                    int n4 = 1 + (Game.crateBrickWidth - 1) * Game.BRICK_CONFIGS[n3][1];
                    int n5 = 1 + (Game.crateBrickHeight - 1) * Game.BRICK_CONFIGS[n3][2];
                    n += Game.sprites[2].box[2] - n4 >> 1;
                    n2 += Game.sprites[2].box[3] - n5 >> 1;
                    int n6 = 4;
                    for (int i = 0; i < Game.BRICK_CONFIGS[n3][0]; ++i) {
                        int n7 = 1 + (Game.crateBrickWidth - 1) * Game.BRICK_CONFIGS[n3][n6 + 0];
                        int n8 = n + Game.BRICK_CONFIGS[n3][n6 + 1] * (Game.crateBrickWidth - 1);
                        graphics.setColor(Game.BRICK_SHADOW_COLORS[Game.BRICK_CONFIGS[n3][3]]);
                        graphics.fillRect(n8, n2, n7, Game.crateBrickHeight);
                        graphics.setColor(Game.BRICK_COLORS[Game.BRICK_CONFIGS[n3][3]]);
                        graphics.fillRect(n8 + 1, n2 + 1, n7 - 2, Game.crateBrickHeight - 2);
                        n2 += Game.crateBrickHeight - 1;
                        n6 += 2;
                    }
                    this.paintParasuite(graphics);
                    break;
                }
                case 3: 
                case 4: {
                    this.miscVar[3] = this.miscVar[3] + 1;
                    if (this.miscVar[3] >= this.sprite.frameSequences[0].length) {
                        this.miscVar[3] = 0;
                    }
                    byte by = this.sprite.frameSequences[0][this.miscVar[3]];
                    this.sprite.paint(graphics, this.outX, this.outY, by, 0);
                    this.sprite.paint(graphics, this.outX, this.outY, this.sprite.frameSequences[1][this.type == 4 ? 0 : 1], 0);
                    this.paintParasuite(graphics);
                    break;
                }
                default: {
                    int n = 0;
                    if (this.hasFrameSequence) {
                        if (this.frame < this.sprite.frameSequences[this.currentFrameSequence].length && (n = this.sprite.frameSequences[this.currentFrameSequence][this.frame]) > this.sprite.frameCount) {
                            n = 0;
                        }
                    } else {
                        n = this.frame + this.rootFrame + 1;
                    }
                    if (this.type == 6) {
                        this.sprite.paintLooped(graphics, this.outX, this.outY, n, 0, 0, 1);
                        break;
                    }
                    this.sprite.paint(graphics, this.outX, this.outY, n, 0);
                }
            }
            super.paint(graphics, false);
        }
    }

    private void paintParasuite(Graphics graphics) {
        if (this.miscVar[0] > 0) {
            int n = this.miscVar[0] >> 2 & 3;
            byte by = this.sprite.frameSequences[2][n];
            this.sprite.paint(graphics, this.outX, this.outY - this.sprite.box[3], by, 0);
        }
    }

    private void eventTimeOut() {
    }

    void setType(int n) {
        super.setType(n);
        this.properties = propertiesSetup[n];
        this.collisionType = this.properties & 0x7F;
        this.bounce = BOUNCEPROPERTY[n];
    }

    void setSprite(Sprite2Data sprite2Data, int n, boolean bl) {
        if (sprite2Data != null) {
            this.sprite = sprite2Data;
            super.setSprite(sprite2Data, n, bl);
            this.hasFrameSequence = sprite2Data.frameSequences != null;
        }
    }
}

