/*
 * Decompiled with CFR 0.152.
 */
import java.io.IOException;
import java.io.InputStream;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

final class Sprite2Data {
    static final byte MIRROR_ROTATE180 = 1;
    static final byte MIRROR = 2;
    static final byte ROTATE180 = 3;
    static final byte MIRROR_ROTATE270 = 4;
    static final byte ROTATE90 = 5;
    static final byte ROTATE270 = 6;
    static final byte MIRROR_ROTATE90 = 7;
    private static final int CHUNK_ID_COLLISION = 1;
    private static final int CHUNK_ID_REFERENCE_POINTS = 2;
    private static final int CHUNK_ID_INDEXED_SPRITE = 3;
    private static final int CHUNK_ID_INDEXED_DIMS = 4;
    private static final int CHUNK_ID_UNPACK_FRAMES_HINT = 5;
    private static final int CHUNK_ID_EXTERNAL_PALETTE = 6;
    private static final int CHUNK_ID_COLLISION_LARGE = 8;
    private static final int CHUNK_ID_FRAME_SEQUENCES = -1;
    private static final int CHUNK_ID_PALETTE = -2;
    private static final int CHUNK_ID_CHARACTER_MAP = -3;
    private static final int CHUNK_ID_MIRROR = -4;
    private static final int CHUNK_ID_MIRRORLIST = -5;
    private static final int CHUNK_ID_REFERENCE_POINTS_LARGE = -8;
    private static final int PNG_IHDR_SIZE = 25;
    private static final byte[] PNG_SIGNATURE = new byte[]{-119, 80, 78, 71, 13, 10, 26, 10};
    private static final byte[] PNG_IEND = new byte[]{0, 0, 0, 0, 73, 69, 78, 68, -82, 66, 96, -126};
    private static final int PALETTE_OFFSET = PNG_SIGNATURE.length + 25;
    Sprite2Data[] altColors = null;
    private Image[] frames = null;
    private Image[] mirroredFrames = null;
    short[] box = null;
    private short[][] frameBoxes = null;
    private short[][] collisionBoxes = null;
    private short[] defaultCollisionBox = null;
    byte[][] frameSequences = null;
    byte[] ticksPerFrame = null;
    short[][] refPoints = null;
    private short[][][] frameRefPoints = null;
    int frameCount = 0;
    private short[] indexedFrameSize = null;
    private int[] indexedFrameOffsets = null;
    static String loadedCharMap = null;
    private static int[] colorBuf = new int[1];

    Sprite2Data() {
    }

    private void _load(InputStream inputStream, byte[][] byArray, int n) throws IOException {
        short s;
        short s2;
        int n2;
        int n3;
        int n4;
        short s3;
        int n5;
        byte by;
        int n6;
        short[] sArray;
        Screen.watchdog = 0L;
        int n7 = byArray == null ? 1 : byArray.length;
        this.frameCount = Storage.readUnsignedByte(inputStream);
        short s4 = (short)Storage.readUnsignedShort(inputStream);
        short s5 = (short)Storage.readUnsignedShort(inputStream);
        if (s4 != 0 && s5 != 0) {
            short[] sArray2 = new short[4];
            sArray2[0] = 0;
            sArray2[1] = 0;
            sArray2[2] = s4;
            sArray = sArray2;
            sArray2[3] = s5;
        } else {
            sArray = Screen.NULL_RECT;
        }
        this.box = sArray;
        int n8 = Storage.readUnsignedByte(inputStream);
        byte[] byArray2 = null;
        Object var11_9 = null;
        boolean bl = false;
        boolean bl2 = true;
        for (n6 = 0; n6 < n8; ++n6) {
            by = (byte)inputStream.read();
            int n9 = n5 = by < 0 ? Storage.readUnsignedShort(inputStream) : (int)Storage.readUnsignedByte(inputStream);
            if (by == 3) {
                this.indexedFrameSize = new short[2];
                this.indexedFrameSize[0] = Storage.readUnsignedByte(inputStream);
                this.indexedFrameSize[1] = Storage.readUnsignedByte(inputStream);
                continue;
            }
            if (by == 2) {
                this.refPoints = new short[n5 / 2][2];
                for (int i = 0; i < this.refPoints.length; ++i) {
                    this.refPoints[i][0] = Storage.readUnsignedByte(inputStream);
                    this.refPoints[i][1] = Storage.readUnsignedByte(inputStream);
                }
                continue;
            }
            if (by == -8) {
                this.refPoints = new short[n5 / 4][2];
                for (int i = 0; i < this.refPoints.length; ++i) {
                    this.refPoints[i][0] = (short)Storage.readUnsignedShort(inputStream);
                    this.refPoints[i][1] = (short)Storage.readUnsignedShort(inputStream);
                }
                continue;
            }
            if (by == 1) {
                this.defaultCollisionBox = new short[]{Storage.readUnsignedByte(inputStream), Storage.readUnsignedByte(inputStream), Storage.readUnsignedByte(inputStream), Storage.readUnsignedByte(inputStream)};
                continue;
            }
            if (by == 8) {
                this.defaultCollisionBox = new short[]{(short)Storage.readUnsignedShort(inputStream), (short)Storage.readUnsignedShort(inputStream), (short)Storage.readUnsignedShort(inputStream), (short)Storage.readUnsignedShort(inputStream)};
                continue;
            }
            if (by == -1) {
                short s6 = Storage.readUnsignedByte(inputStream);
                this.ticksPerFrame = new byte[s6];
                this.frameSequences = new byte[s6][];
                for (s3 = 0; s3 < s6; ++s3) {
                    this.ticksPerFrame[s3] = (byte)Storage.readUnsignedByte(inputStream);
                    n4 = Storage.readUnsignedByte(inputStream);
                    if (n4 > 0) {
                        this.frameSequences[s3] = new byte[n4];
                        Storage.readArray(inputStream, this.frameSequences[s3], 0, this.frameSequences[s3].length, 0);
                        continue;
                    }
                    this.frameSequences[s3] = null;
                }
                continue;
            }
            if (by == -2) {
                byArray2 = new byte[n5];
                Storage.readArray(inputStream, byArray2, 0, byArray2.length, 0);
                continue;
            }
            if (by == 5) {
                bl2 = true;
                continue;
            }
            if (by == 6) {
                Storage.readUnsignedByte(inputStream);
                int n10 = Storage.readUnsignedShort(inputStream);
                if (byArray == null) {
                    throw new IllegalArgumentException("Palette error");
                }
                for (s3 = 0; s3 < byArray.length; ++s3) {
                    if (byArray[s3].length == n10) continue;
                    throw new IllegalArgumentException("Palette size error");
                }
                continue;
            }
            if (by == -3) {
                StringBuffer stringBuffer = new StringBuffer(n5 >> 1);
                for (s3 = 0; s3 < n5; s3 += 2) {
                    stringBuffer.append((char)(inputStream.read() + (inputStream.read() << 8)));
                }
                loadedCharMap = stringBuffer.toString();
                continue;
            }
            Storage.skip(inputStream, n5);
        }
        this.frames = new Image[this.indexedFrameSize == null || bl2 ? this.frameCount : 1];
        if (n7 > 1) {
            this.altColors = new Sprite2Data[n7 - 1];
            for (n6 = 0; n6 < this.altColors.length; ++n6) {
                this.altColors[n6] = new Sprite2Data();
                this.altColors[n6].frames = new Image[this.frames.length];
            }
        }
        short[] sArray3 = null;
        Image[] imageArray = byArray != null && byArray.length > 1 ? new Image[byArray.length - 1] : null;
        this.frameBoxes = new short[this.frameCount][];
        for (n3 = 0; n3 < this.frameBoxes.length; ++n3) {
            this.frameBoxes[n3] = null;
        }
        for (n3 = 0; n3 < this.frameCount; ++n3) {
            n4 = this.indexedFrameSize == null ? n / (this.frameCount - n3) : n;
            n -= n4;
            short s7 = Storage.readUnsignedByte(inputStream);
            if ((s7 | (s3 = Storage.readUnsignedByte(inputStream))) != 0) {
                this.frameBoxes[n3] = new short[]{s7, s3, 0, 0};
            }
            sArray3 = null;
            n8 = Storage.readUnsignedByte(inputStream);
            for (n2 = 0; n2 < n8; ++n2) {
                by = (byte)inputStream.read();
                int n11 = n5 = by < 0 ? Storage.readUnsignedShort(inputStream) : (int)Storage.readUnsignedByte(inputStream);
                if (by == 4) {
                    s2 = Storage.readUnsignedByte(inputStream);
                    s = Storage.readUnsignedByte(inputStream);
                    if (this.frameBoxes[n3] == null) {
                        this.frameBoxes[n3] = new short[]{0, 0, s2, s};
                        continue;
                    }
                    this.frameBoxes[n3][2] = s2;
                    this.frameBoxes[n3][3] = s;
                    continue;
                }
                if (by == 2 || by == -8) {
                    short[][] sArray4;
                    if (by == 2) {
                        sArray4 = new short[n5 / 2][2];
                        for (s = 0; s < sArray4.length; ++s) {
                            sArray4[s][0] = Storage.readUnsignedByte(inputStream);
                            sArray4[s][1] = Storage.readUnsignedByte(inputStream);
                        }
                    } else {
                        sArray4 = new short[n5 / 4][2];
                        for (s = 0; s < sArray4.length; ++s) {
                            sArray4[s][0] = (short)Storage.readUnsignedShort(inputStream);
                            sArray4[s][1] = (short)Storage.readUnsignedShort(inputStream);
                        }
                    }
                    if (this.frameRefPoints == null) {
                        this.frameRefPoints = new short[this.frameCount][][];
                        for (s = 0; s < this.frameRefPoints.length; ++s) {
                            this.frameRefPoints[n3] = null;
                        }
                    }
                    this.frameRefPoints[n3] = sArray4;
                    continue;
                }
                if (by == 1) {
                    sArray3 = new short[]{Storage.readUnsignedByte(inputStream), Storage.readUnsignedByte(inputStream), Storage.readUnsignedByte(inputStream), Storage.readUnsignedByte(inputStream)};
                    continue;
                }
                if (by == 8) {
                    sArray3 = new short[]{(short)Storage.readUnsignedShort(inputStream), (short)Storage.readUnsignedShort(inputStream), (short)Storage.readUnsignedShort(inputStream), (short)Storage.readUnsignedShort(inputStream)};
                    continue;
                }
                if (by == -4) {
                    if (this.mirroredFrames == null) {
                        this.mirroredFrames = new Image[this.frames.length];
                        if (this.altColors != null) {
                            for (s2 = 0; s2 < this.altColors.length; ++s2) {
                                this.altColors[s2].mirroredFrames = new Image[this.frames.length];
                            }
                        }
                    }
                    s2 = n4 / 2;
                    n4 -= s2;
                    this.mirroredFrames[n3] = Sprite2Data.readStrippedImage(inputStream, n5, byArray2, byArray, imageArray, s2);
                    if (this.mirroredFrames[n3] == null || byArray == null) continue;
                    for (s = 0; s < imageArray.length; ++s) {
                        this.altColors[s].mirroredFrames[n3] = imageArray[s];
                    }
                    continue;
                }
                Storage.skip(inputStream, n5);
            }
            if (sArray3 != null) {
                if (this.collisionBoxes == null) {
                    this.collisionBoxes = new short[this.frameCount][];
                    for (n2 = 0; n2 < this.frameCount; ++n2) {
                        this.collisionBoxes[n2] = null;
                    }
                }
                this.collisionBoxes[n3] = sArray3;
            }
            if (this.indexedFrameSize != null && n3 != 0) continue;
            n2 = Storage.readInteger(inputStream);
            if (n2 > 0) {
                this.frames[n3] = Sprite2Data.readStrippedImage(inputStream, n2, byArray2, byArray, imageArray, n4);
                if (byArray != null) {
                    for (s2 = 0; s2 < imageArray.length; ++s2) {
                        this.altColors[s2].frames[n3] = imageArray[s2];
                    }
                }
                if (this.indexedFrameSize != null || this.frameBoxes[n3] == null && this.frames[n3].getWidth() == this.box[2] && this.frames[n3].getHeight() == this.box[3]) continue;
                if (this.frameBoxes[n3] == null) {
                    this.frameBoxes[n3] = new short[]{0, 0, (short)this.frames[n3].getWidth(), (short)this.frames[n3].getHeight()};
                    continue;
                }
                this.frameBoxes[n3][2] = (short)this.frames[n3].getWidth();
                this.frameBoxes[n3][3] = (short)this.frames[n3].getHeight();
                continue;
            }
            if (this.altColors != null) {
                for (s2 = 0; s2 < this.altColors.length; ++s2) {
                    this.altColors[s2].frames[n3] = null;
                }
            }
            this.frames[n3] = null;
            this.frameBoxes[n3] = Screen.NULL_RECT;
        }
        if (this.altColors != null) {
            for (n3 = 0; n3 < this.altColors.length; ++n3) {
                this.altColors[n3].box = this.box;
                this.altColors[n3].frameBoxes = this.frameBoxes;
                this.altColors[n3].collisionBoxes = this.collisionBoxes;
                this.altColors[n3].frameSequences = this.frameSequences;
                this.altColors[n3].ticksPerFrame = this.ticksPerFrame;
                this.altColors[n3].refPoints = this.refPoints;
                this.altColors[n3].frameRefPoints = this.frameRefPoints;
                this.altColors[n3].frameCount = this.frameCount;
                this.altColors[n3].indexedFrameSize = this.indexedFrameSize;
            }
        }
        if (this.indexedFrameSize != null) {
            if (bl2) {
                this.unpackFrames();
                if (this.altColors != null) {
                    for (n3 = 0; n3 < this.altColors.length; ++n3) {
                        this.altColors[n3].unpackFrames();
                    }
                }
            } else {
                this.indexedFrameOffsets = new int[this.frameCount];
                n3 = this.frames[0].getWidth();
                n2 = 0;
                s2 = 0;
                for (s = 0; s < this.indexedFrameOffsets.length; ++s) {
                    this.indexedFrameOffsets[s] = n2 << 16 | s2;
                    if ((n2 += this.indexedFrameSize[0]) < n3) continue;
                    n2 = 0;
                    s2 += this.indexedFrameSize[1];
                }
            }
        }
        Screen.advanceProgress(n);
    }

    static Sprite2Data load(InputStream inputStream, byte[][] byArray, int n) throws IOException {
        Sprite2Data sprite2Data = new Sprite2Data();
        sprite2Data._load(inputStream, byArray, n);
        return sprite2Data;
    }

    static Sprite2Data load(String string, byte[][] byArray, int n) throws IOException {
        Sprite2Data sprite2Data = new Sprite2Data();
        InputStream inputStream = string.getClass().getResourceAsStream(string);
        if (inputStream == null) {
            throw new IOException(string + " not found");
        }
        sprite2Data._load(inputStream, byArray, n);
        inputStream.close();
        inputStream = null;
        return sprite2Data;
    }

    static Image readStrippedImage(InputStream inputStream, int n, byte[] byArray, byte[][] byArray2, Image[] imageArray, int n2) throws IOException {
        Image image = null;
        int n3 = 0;
        int n4 = byArray != null ? byArray.length : (byArray2 != null ? byArray2[0].length : 0);
        int n5 = n2;
        int n6 = n2 * 1 / 2;
        byte[] byArray3 = new byte[n + PNG_SIGNATURE.length + PNG_IEND.length + n4];
        System.arraycopy(PNG_SIGNATURE, 0, byArray3, n3, PNG_SIGNATURE.length);
        Storage.readArray(inputStream, byArray3, n3 += PNG_SIGNATURE.length, 25, 0);
        n3 += 25;
        if (byArray != null) {
            System.arraycopy(byArray, 0, byArray3, n3, byArray.length);
        }
        Storage.readArray(inputStream, byArray3, n3 += n4, n - 25, n6);
        n5 -= n6;
        System.arraycopy(PNG_IEND, 0, byArray3, n3 += n - 25, PNG_IEND.length);
        n3 += PNG_IEND.length;
        if (byArray2 != null) {
            int n7 = n5 / byArray2.length;
            for (int i = 0; i < byArray2.length; ++i) {
                System.arraycopy(byArray2[i], 0, byArray3, PALETTE_OFFSET, byArray2[i].length);
                Image image2 = Image.createImage((byte[])byArray3, (int)0, (int)byArray3.length);
                if (i == 0) {
                    image = image2;
                } else {
                    imageArray[i - 1] = image2;
                }
                n5 -= Screen.advanceProgress(n7);
            }
        } else {
            image = Image.createImage((byte[])byArray3, (int)0, (int)byArray3.length);
        }
        Screen.advanceProgress(n5);
        return image;
    }

    private void unpackFrames() {
        Image image = this.frames[0];
        for (int i = 0; i < this.frameCount; ++i) {
            if (this.frameBoxes[i][2] != 0) {
                int n = image.getWidth() / this.indexedFrameSize[0];
                int n2 = i % n * this.indexedFrameSize[0];
                int n3 = i / n * this.indexedFrameSize[1];
                this.frames[i] = Image.createImage((Image)image, (int)n2, (int)n3, (int)this.frameBoxes[i][2], (int)this.frameBoxes[i][3], (int)0);
                continue;
            }
            this.frames[i] = null;
        }
        this.indexedFrameSize = null;
    }

    private void pretransformFrames(byte[] byArray) {
        int n;
        this.mirroredFrames = new Image[this.frames.length];
        for (n = 0; n < this.mirroredFrames.length; ++n) {
            this.mirroredFrames[n] = null;
        }
        for (n = 0; n < byArray.length; ++n) {
            int n2 = byArray[n] - 1;
            this.mirroredFrames[n2] = Image.createImage((Image)this.frames[n2], (int)0, (int)0, (int)this.frames[n2].getWidth(), (int)this.frames[n2].getHeight(), (int)2);
        }
    }

    private static void scaleShortArray(Object object, int n, int n2) {
        block4: {
            if (object == null) break block4;
            if (object instanceof short[]) {
                short[] sArray = (short[])object;
                for (int i = 0; i < sArray.length; ++i) {
                    sArray[i] = (short)(sArray[i] * n / n2);
                }
            } else {
                Object[] objectArray = (Object[])object;
                for (int i = 0; i < objectArray.length; ++i) {
                    Sprite2Data.scaleShortArray(objectArray[i], n, n2);
                }
            }
        }
    }

    void scaleCoordinates(int n, int n2) {
        Sprite2Data.scaleShortArray(this.defaultCollisionBox, n, n2);
        Sprite2Data.scaleShortArray(this.collisionBoxes, n, n2);
        Sprite2Data.scaleShortArray(this.refPoints, n, n2);
        Sprite2Data.scaleShortArray(this.frameRefPoints, n, n2);
    }

    Sprite2Data getAltColor(int n) {
        if (n == 0) {
            return this;
        }
        return this.altColors[n - 1];
    }

    short[] getImageBoundingRect(int n) {
        if (n != 0) {
            short[] sArray;
            if (n < 0) {
                n = -n;
            }
            if (this.frameBoxes != null && (sArray = this.frameBoxes[--n]) != null) {
                return sArray;
            }
            return this.box;
        }
        return Screen.NULL_RECT;
    }

    short[] getCollisionRect(int n) {
        short[] sArray = Screen.NULL_RECT;
        if (n != 0) {
            int n2 = n;
            if (n2 < 0) {
                n2 = -n2;
            }
            if (this.collisionBoxes != null && this.collisionBoxes[--n2] != null) {
                sArray = this.collisionBoxes[n2];
            } else {
                if (this.defaultCollisionBox != null) {
                    return this.defaultCollisionBox;
                }
                sArray = this.getImageBoundingRect(n);
            }
        }
        return sArray;
    }

    short[][] getFrameRefPoints(int n) {
        if (n != 0 && this.frameRefPoints != null) {
            if (n < 0) {
                n = -n;
            }
            return this.frameRefPoints[--n];
        }
        return null;
    }

    void paintLooped(Graphics graphics, int n, int n2, int n3, int n4, int n5, int n6) {
        int n7 = Screen.clipLeft - n;
        int n8 = n7 + Screen.clipWidth;
        int n9 = Screen.clipTop - n2;
        int n10 = n9 + Screen.clipHeight;
        int n11 = (n7 - (this.box[2] - 1)) / this.box[2];
        int n12 = (n8 - 1) / this.box[2];
        if (n5 > 0) {
            if (n11 < 0) {
                n11 = 0;
            }
            if (n12 > n5 - 1) {
                n12 = n5 - 1;
            }
        } else if (n5 < 0) {
            if (n11 < n5) {
                n11 = n5;
            }
            if (n12 > -1) {
                n12 = -1;
            }
        }
        int n13 = (n9 - (this.box[3] - 1)) / this.box[3];
        int n14 = (n10 - 1) / this.box[3];
        if (n6 > 0) {
            if (n13 < 0) {
                n13 = 0;
            }
            if (n14 > n6 - 1) {
                n14 = n6 - 1;
            }
        } else if (n6 < 0) {
            if (n13 < n6) {
                n13 = n6;
            }
            if (n14 > -1) {
                n14 = -1;
            }
        }
        for (int i = n13; i <= n14; ++i) {
            for (int j = n11; j <= n12; ++j) {
                this.paint(graphics, n + j * this.box[2], n2 + i * this.box[3], n3, n4);
            }
        }
    }

    void paint(Graphics graphics, int n, int n2, int n3, int n4) {
        if (n3 != 0) {
            int n5;
            boolean bl;
            short[] sArray = this.getImageBoundingRect(n3);
            if (sArray == Screen.NULL_RECT) {
                return;
            }
            boolean bl2 = bl = n4 == 2;
            if (n3 < 0) {
                bl = !bl;
                n5 = -n3 - 1;
            } else {
                n5 = n3 - 1;
            }
            n2 += sArray[1];
            if (bl) {
                graphics.drawRegion(this.frames[n5], 0, 0, (int)sArray[2], (int)sArray[3], 2, n += this.box == Screen.NULL_RECT ? sArray[0] : this.box[2] - (sArray[0] + sArray[2]), n2, 0);
            } else {
                graphics.drawImage(this.frames[n5], n += sArray[0], n2, 0);
            }
        }
    }

    int getPixel(int n, int n2, int n3) {
        if (n != 0) {
            short[] sArray = this.getImageBoundingRect(n);
            if (sArray == Screen.NULL_RECT) {
                return 0;
            }
            if ((n2 -= sArray[0]) >= 0 && (n3 -= sArray[1]) >= 0 && n2 < sArray[2] && n3 < sArray[3]) {
                int n4 = n - 1;
                if (this.indexedFrameSize == null) {
                    this.frames[n4].getRGB(colorBuf, 0, 1, n2, n3, 1, 1);
                } else {
                    int n5 = this.frames[0].getWidth() / this.indexedFrameSize[0];
                    this.frames[0].getRGB(colorBuf, 0, 1, n2 += n4 % n5 * this.indexedFrameSize[0], n3 += n4 / n5 * this.indexedFrameSize[1], 1, 1);
                }
                return colorBuf[0];
            }
        }
        return 0;
    }
}

