/*
 * Decompiled with CFR 0.152.
 */
package Kartmania;

import Kartmania.CGBillboardObject;
import Kartmania.CGTrackNode;
import Kartmania.CGTrackPiece;
import Kartmania.FXUtility;
import Kartmania.Game;
import Kartmania.MathEx;
import Kartmania.Matrix22FX;
import Kartmania.MissionParams;
import Kartmania.RandSync;
import Kartmania.SelectGameMode;
import Kartmania.Vector2FX;
import Kartmania.Vector3FX;
import java.io.DataInputStream;
import java.io.IOException;
import java.util.Vector;

class CGTrack {
    public static final int eTrackHalfHeight = 150;
    public static boolean m_bInvertTrackFlag = false;
    public static final long __DEFAULT_CAMERA_ANGLE__ = 12L;
    public long m_fxCameraAngle = 0L;
    public long m_fxCurrentCameraAngle = 4096000L;
    Vector3FX g_v3 = new Vector3FX();
    Vector2FX g_vvv = new Vector2FX();
    Vector arrCurrentPieces = new Vector(3, 2);
    Matrix22FX matTr = new Matrix22FX();
    Vector2FX vecIn = new Vector2FX();
    Vector2FX vecOut = new Vector2FX();
    Vector3FX vecPos3D = new Vector3FX();
    Matrix22FX g_matR = new Matrix22FX();
    public static long __MAX_DISTANCE__ = 50L;
    public static long __MAX_DELTA_ANGLE__ = 8192L;
    public int m_nCurrentCheckPointIndex = 0;
    public int[] m_arrCheckPointsDistance = null;
    public int[] m_arrCheckPointsTime = null;
    public int m_nCurrentStoneIndex = 0;
    public int[] m_arrStonesDistance = new int[200];
    public CGTrackNode m_pFirstTrackNode = null;
    public CGTrackNode m_pSecondTrackNode;
    public CGTrackNode m_pThirdTrackNode;
    public CGTrackNode m_pFourthTrackNode;
    public long m_fxTrackLength;
    public CGTrackPiece[] m_arrTrackPieces;
    public Vector m_arrCurrentObjects = new Vector();
    public Vector2FX m_vecLastCameraDir = new Vector2FX();

    public CGTrackNode FindPlaceOnTrack(long fxDistanceFromStart, long fxRoadStraight, CGTrackNode pStartTrackNode, Vector2FX posVector, Vector2FX dirVector) {
        CGTrackNode pCurNode = pStartTrackNode;
        if (pCurNode == null) {
            pCurNode = fxDistanceFromStart < this.m_fxTrackLength / 4L + 204800L ? this.m_pFirstTrackNode : (fxDistanceFromStart < this.m_fxTrackLength / 2L + 204800L ? this.m_pSecondTrackNode : (fxDistanceFromStart < 3L * this.m_fxTrackLength / 4L + 204800L ? this.m_pThirdTrackNode : this.m_pFourthTrackNode));
        }
        CGTrackNode pSN = pCurNode;
        while (true) {
            if (pCurNode.m_fxDistanceFromStart > fxDistanceFromStart) {
                pCurNode = pCurNode.m_pPrev;
                break;
            }
            if (pCurNode.m_pNext == null || pCurNode.m_pNext.m_fxDistanceFromStart <= pCurNode.m_fxDistanceFromStart) break;
            pCurNode = pCurNode.m_pNext;
        }
        if (pCurNode == null) {
            return null;
        }
        long fxCD = fxDistanceFromStart - pCurNode.m_fxDistanceFromStart;
        dirVector.x = pCurNode.m_pNext.m_fxX - pCurNode.m_fxX;
        dirVector.y = pCurNode.m_pNext.m_fxZ - pCurNode.m_fxZ;
        dirVector.Normalize();
        posVector.x = pCurNode.m_fxX + fxCD * dirVector.x / 4096L;
        posVector.y = pCurNode.m_fxZ + fxCD * dirVector.y / 4096L;
        posVector.x += fxRoadStraight * 150L * dirVector.y / 4096L;
        posVector.y += fxRoadStraight * 150L * -dirVector.x / 4096L;
        return pCurNode;
    }

    public CGTrackNode FindPlaceOnTrack3D(long fxDistanceFromStart, long fxRoadStraight, CGTrackNode pStartTrackNode, Vector3FX posVector, Vector2FX dirVector) {
        CGTrackNode pCurNode = pStartTrackNode;
        if (pCurNode == null) {
            pCurNode = fxDistanceFromStart < this.m_fxTrackLength / 4L + 204800L ? this.m_pFirstTrackNode : (fxDistanceFromStart < this.m_fxTrackLength / 2L + 204800L ? this.m_pSecondTrackNode : (fxDistanceFromStart < 3L * this.m_fxTrackLength / 4L + 204800L ? this.m_pThirdTrackNode : this.m_pFourthTrackNode));
        }
        CGTrackNode pSN = pCurNode;
        while (true) {
            if (pCurNode.m_fxDistanceFromStart > fxDistanceFromStart) {
                pCurNode = pCurNode.m_pPrev;
                break;
            }
            if (pCurNode.m_pNext == null || pCurNode.m_pNext.m_fxDistanceFromStart <= pCurNode.m_fxDistanceFromStart) break;
            pCurNode = pCurNode.m_pNext;
        }
        if (pCurNode == null) {
            return null;
        }
        long fxCD = fxDistanceFromStart - pCurNode.m_fxDistanceFromStart;
        this.g_v3.x = pCurNode.m_pNext.m_fxX - pCurNode.m_fxX;
        this.g_v3.y = pCurNode.m_pNext.m_fxY - pCurNode.m_fxY;
        this.g_v3.z = pCurNode.m_pNext.m_fxZ - pCurNode.m_fxZ;
        this.g_v3.Normalize();
        posVector.x = pCurNode.m_fxX + fxCD * this.g_v3.x / 4096L;
        posVector.y = pCurNode.m_fxY + fxCD * this.g_v3.y / 4096L;
        posVector.z = pCurNode.m_fxZ + fxCD * this.g_v3.z / 4096L;
        dirVector.x = pCurNode.m_pNext.m_fxX - pCurNode.m_fxX;
        dirVector.y = pCurNode.m_pNext.m_fxZ - pCurNode.m_fxZ;
        dirVector.Normalize();
        this.g_vvv.y = Math.abs(pCurNode.m_pNext.m_fxDistanceFromStart - pCurNode.m_fxDistanceFromStart);
        this.g_vvv.x = pCurNode.m_pNext.m_fxY - pCurNode.m_fxY;
        this.g_vvv.Normalize();
        long lAAA = Vector2FX.AngleFromVector(this.g_vvv);
        this.m_fxCameraAngle = lAAA - 49152L;
        if (this.m_fxCameraAngle > 737280L) {
            this.m_fxCameraAngle -= 1474560L;
        }
        posVector.x += fxRoadStraight * 150L * dirVector.y / 4096L;
        posVector.z += fxRoadStraight * 150L * -dirVector.x / 4096L;
        return pCurNode;
    }

    public CGTrackNode PrepareTrackForCamera(long fxDistanceFromStart, long fxRoadStraight, CGTrackNode pStartTrackNode, long fxMaxDistance, Vector2FX vecPos, Vector2FX vecDir, CGBillboardObject[] arrObj, int nObjCount) {
        int i;
        CGTrackNode pTN = this.FindPlaceOnTrack3D(fxDistanceFromStart, fxRoadStraight, pStartTrackNode, this.vecPos3D, vecDir);
        if (pTN == null) {
            return null;
        }
        if (this.m_fxCurrentCameraAngle == 4096000L) {
            this.m_fxCurrentCameraAngle = this.m_fxCameraAngle;
        } else {
            if (this.m_fxCurrentCameraAngle > 737280L) {
                this.m_fxCurrentCameraAngle -= 1474560L;
            }
            if (Math.abs(this.m_fxCurrentCameraAngle - this.m_fxCameraAngle) > 49152L) {
                this.m_fxCameraAngle = this.m_fxCameraAngle > this.m_fxCurrentCameraAngle ? this.m_fxCurrentCameraAngle + 49152L : this.m_fxCurrentCameraAngle - 49152L;
            }
            this.m_fxCurrentCameraAngle = (3L * this.m_fxCurrentCameraAngle + this.m_fxCameraAngle) / 4L;
            if (this.m_fxCurrentCameraAngle < 0L) {
                this.m_fxCurrentCameraAngle += 1474560L;
                if (this.m_fxCurrentCameraAngle < 0L) {
                    this.m_fxCurrentCameraAngle += 1474560L;
                }
            } else if (this.m_fxCurrentCameraAngle >= 1474560L) {
                this.m_fxCurrentCameraAngle -= 1474560L;
                if (this.m_fxCurrentCameraAngle >= 1474560L) {
                    this.m_fxCurrentCameraAngle -= 1474560L;
                }
            }
            if (this.m_fxCurrentCameraAngle > 737280L && this.m_fxCurrentCameraAngle < 0x140000L) {
                this.m_fxCurrentCameraAngle = 0x140000L;
            }
            if (this.m_fxCurrentCameraAngle < 737280L && this.m_fxCurrentCameraAngle > 122880L) {
                this.m_fxCurrentCameraAngle = 122880L;
            }
        }
        this.vecPos3D.y += 20480L;
        if (this.m_vecLastCameraDir.x > -40960L) {
            vecDir.x = (4096L * vecDir.x + 4096L * this.m_vecLastCameraDir.x) / 8192L;
            vecDir.y = (4096L * vecDir.y + 4096L * this.m_vecLastCameraDir.y) / 8192L;
            vecDir.Normalize();
        }
        this.m_vecLastCameraDir.x = vecDir.x;
        this.m_vecLastCameraDir.y = vecDir.y;
        this.arrCurrentPieces.removeAllElements();
        Matrix22FX.GetTransformMatrix(vecDir, this.matTr);
        CGTrackNode pN = pTN;
        if (pN.m_pPrev != null) {
            pN = pN.m_pPrev;
        }
        this.arrCurrentPieces.addElement(pN.m_pTrackPiece);
        CGTrackPiece m_pLastPiece = pN.m_pTrackPiece;
        CGTrackNode pInitTrack = pN;
        int nCount = 0;
        long fxD = 0L;
        while (true) {
            this.vecIn.x = pN.m_fxX - this.vecPos3D.x;
            this.vecIn.y = pN.m_fxZ - this.vecPos3D.z;
            this.matTr.MatrixF22_Mul_VectorF2(this.vecIn, this.vecOut);
            pN.m_fxTrX = this.vecOut.x;
            pN.m_fxTrY = pN.m_fxY - this.vecPos3D.y;
            pN.m_fxTrZ = this.vecOut.y;
            this.g_matR.MatrixF22_Rot(this.m_fxCurrentCameraAngle);
            this.vecIn.x = pN.m_fxTrY;
            this.vecIn.y = pN.m_fxTrZ;
            this.g_matR.MatrixF22_Mul_VectorF2(this.vecIn, this.vecOut);
            pN.m_fxTrY = this.vecOut.x;
            pN.m_fxTrZ = this.vecOut.y;
            if (pN.m_pTrackPiece != m_pLastPiece) {
                this.arrCurrentPieces.addElement(pN.m_pTrackPiece);
                m_pLastPiece = pN.m_pTrackPiece;
            }
            if (pN.m_fxTrZ > fxMaxDistance || fxD > fxMaxDistance || pN.m_pNext == null || pN.m_pNext == pInitTrack) break;
            pN = pN.m_pNext;
            ++nCount;
            fxD += pN.m_fxDistanceFromPrev;
        }
        this.m_arrCurrentObjects.removeAllElements();
        for (int i2 = 0; i2 < nObjCount; ++i2) {
            this.m_arrCurrentObjects.addElement(arrObj[i2]);
        }
        int nS = this.arrCurrentPieces.size();
        for (i = 0; i < nS; ++i) {
            int nSS = ((CGTrackPiece)this.arrCurrentPieces.elementAt(i)).GetObjectsSize();
            for (int j = 0; j < nSS; ++j) {
                this.m_arrCurrentObjects.addElement(((CGTrackPiece)this.arrCurrentPieces.elementAt(i)).GetObject(j));
            }
        }
        nS = this.m_arrCurrentObjects.size();
        for (i = 0; i < nS; ++i) {
            CGBillboardObject pO = (CGBillboardObject)this.m_arrCurrentObjects.elementAt(i);
            this.vecIn.x = pO.m_fxX - this.vecPos3D.x;
            this.vecIn.y = pO.m_fxZ - this.vecPos3D.z;
            this.matTr.MatrixF22_Mul_VectorF2(this.vecIn, this.vecOut);
            pO.m_fxTrX = this.vecOut.x;
            pO.m_fxTrY = pO.m_fxY - this.vecPos3D.y;
            pO.m_fxTrZ = this.vecOut.y;
            this.g_matR.MatrixF22_Rot(this.m_fxCurrentCameraAngle);
            this.vecIn.x = pO.m_fxTrY;
            this.vecIn.y = pO.m_fxTrZ;
            this.g_matR.MatrixF22_Mul_VectorF2(this.vecIn, this.vecOut);
            pO.m_fxTrY = this.vecOut.x;
            pO.m_fxTrZ = this.vecOut.y;
        }
        return pTN;
    }

    public long GetVelocityFactorForDistance(long fxDistanceFromStart, long fxStraight, CGTrackNode pStartTrackNode, Vector2FX posVector, Vector2FX dirVector) {
        CGTrackNode pTN = this.FindPlaceOnTrack(fxDistanceFromStart, fxStraight, pStartTrackNode, posVector, dirVector);
        if (pTN == null) {
            return 4096L;
        }
        pStartTrackNode = pTN;
        return (pTN.m_fxVelocityFactor + pTN.m_pNext.m_fxVelocityFactor + pTN.m_pNext.m_pNext.m_fxVelocityFactor + pTN.m_pNext.m_pNext.m_pNext.m_fxVelocityFactor) / 4L;
    }

    public CGTrackNode GetXForZ(long z, CGTrackNode pStartNode, Vector2FX v) {
        CGTrackNode pNode = pStartNode;
        int nCount = 0;
        while (pNode.m_fxTrZ <= z) {
            pNode = pNode.m_pNext;
            if (++nCount <= 60) continue;
            return null;
        }
        long x1 = pNode.m_pPrev.m_fxTrX;
        long y1 = pNode.m_pPrev.m_fxTrY;
        long z1 = pNode.m_pPrev.m_fxTrZ;
        long x2 = pNode.m_fxTrX;
        long y2 = pNode.m_fxTrY;
        long z2 = pNode.m_fxTrZ;
        v.x = ((x2 - x1) * (z - z1) + x1 * (z2 - z1)) / (z2 - z1);
        v.y = ((y2 - y1) * (z - z1) + y1 * (z2 - z1)) / (z2 - z1);
        return pNode.m_pPrev;
    }

    long GetZForRay(long startY, long startZ, long stopY, long stopZ, CGTrackNode pStartTrackNode) {
        CGTrackNode pNode = this.m_pFirstTrackNode;
        if (pStartTrackNode != null) {
            pNode = pStartTrackNode;
        }
        CGTrackNode pInitNode = pNode;
        do {
            if ((float)pNode.m_fxTrZ >= 0.0f || pNode.m_pNext.m_fxTrZ >= 0L) {
                if (pNode.m_fxTrZ < pNode.m_pNext.m_fxTrZ) {
                    long fxV = MathEx.CheckSections(startY, startZ, stopY, stopZ, pNode.m_fxTrY, pNode.m_fxTrZ, pNode.m_pNext.m_fxTrY, pNode.m_pNext.m_fxTrZ);
                    if (fxV >= 0L) {
                        return startZ + fxV * (stopZ - startZ) / 4096L;
                    }
                } else {
                    int b = 0;
                    ++b;
                }
            }
            if (pNode.m_fxTrZ <= 3686400L) continue;
            return -4096L;
        } while ((pNode = pNode.m_pNext) != null && pNode != pInitNode);
        return -4096L;
    }

    protected void DeleteTrack() {
        this.m_pFirstTrackNode = null;
    }

    protected void InitFirstNode(long x, long y, long z, CGTrackPiece pTrackPiece) {
        this.m_pFirstTrackNode = new CGTrackNode();
        this.m_pFirstTrackNode.m_fxX = x;
        this.m_pFirstTrackNode.m_fxY = y;
        this.m_pFirstTrackNode.m_fxZ = z;
        this.m_pFirstTrackNode.m_fxDistanceFromStart = 0L;
        this.m_pFirstTrackNode.m_pNext = null;
        this.m_pFirstTrackNode.m_pPrev = null;
        this.m_pFirstTrackNode.m_pTrackPiece = pTrackPiece;
        this.m_pFirstTrackNode.m_fxVelocityFactor = 4096L;
        this.m_fxTrackLength = 0L;
        this.m_vecLastCameraDir.x = -409600L;
        this.m_vecLastCameraDir.y = -409600L;
    }

    protected int GetNodesSize() {
        if (this.m_pFirstTrackNode == null) {
            return 0;
        }
        int nSize = 1;
        CGTrackNode pLastNode = this.m_pFirstTrackNode;
        while (pLastNode.m_pNext != null && pLastNode.m_pNext != this.m_pFirstTrackNode) {
            pLastNode = pLastNode.m_pNext;
            ++nSize;
        }
        return nSize;
    }

    CGTrackNode FindFirstNodeOfTrackPiece(CGTrackPiece pTP) {
        if (this.m_pFirstTrackNode == null) {
            return null;
        }
        CGTrackNode pNode = this.m_pFirstTrackNode;
        do {
            if (pNode.m_pTrackPiece != pTP) continue;
            return pNode;
        } while ((pNode = pNode.m_pNext) != null);
        return null;
    }

    CGTrackNode GetNode(int nIndex) {
        if (this.m_pFirstTrackNode == null) {
            return null;
        }
        int nCurIndex = 0;
        CGTrackNode pNode = this.m_pFirstTrackNode;
        while (nCurIndex != nIndex) {
            pNode = pNode.m_pNext;
            if (pNode == null) {
                return null;
            }
            ++nCurIndex;
        }
        return pNode;
    }

    protected CGTrackNode GetLastNode() {
        if (this.m_pFirstTrackNode == null) {
            return null;
        }
        CGTrackNode pN = this.m_pFirstTrackNode;
        while (pN.m_pNext != null && pN.m_pNext != this.m_pFirstTrackNode) {
            pN = pN.m_pNext;
        }
        return pN;
    }

    protected CGTrackNode AddNode(long x, long y, long z) {
        if (this.m_pFirstTrackNode == null) {
            System.out.println("ERROR: m_pFirstTrackNode is null...");
        }
        CGTrackNode pLastNode = this.m_pFirstTrackNode;
        while (pLastNode.m_pNext != null) {
            pLastNode = pLastNode.m_pNext;
        }
        long fxD = FXUtility.Sqrt((x - pLastNode.m_fxX) * (x - pLastNode.m_fxX) / 4096L + (y - pLastNode.m_fxY) * (y - pLastNode.m_fxY) / 4096L + (z - pLastNode.m_fxZ) * (z - pLastNode.m_fxZ) / 4096L);
        pLastNode.m_pNext = new CGTrackNode();
        pLastNode.m_pNext.m_fxX = x;
        pLastNode.m_pNext.m_fxY = y;
        pLastNode.m_pNext.m_fxZ = z;
        pLastNode.m_pNext.m_fxVelocityFactor = 4096L;
        pLastNode.m_pNext.m_fxDistanceFromStart = pLastNode.m_fxDistanceFromStart + fxD;
        pLastNode.m_pNext.m_fxDistanceFromPrev = fxD;
        pLastNode.m_pNext.m_pNext = null;
        pLastNode.m_pNext.m_pPrev = pLastNode;
        this.m_fxTrackLength = pLastNode.m_pNext.m_fxDistanceFromStart;
        return pLastNode.m_pNext;
    }

    protected void AddStraightLine(long fxLength, long fxHeight, CGTrackPiece pTrackPiece) {
        int nNodeSize = this.GetNodesSize();
        if (nNodeSize == 0) {
            this.InitFirstNode(0L, 0L, 0L, pTrackPiece);
            nNodeSize = 1;
        }
        long fxLastX = this.GetLastNode().m_fxX;
        long fxLastY = this.GetLastNode().m_fxY;
        long fxLastZ = this.GetLastNode().m_fxZ;
        long fxElementLength = __MAX_DISTANCE__ * 4096L;
        int nL = (int)(fxLength / fxElementLength);
        long fxCurrentLength = 0L;
        long fxNewY = fxLastY;
        if (nNodeSize == 1) {
            do {
                if ((fxCurrentLength += fxElementLength) > fxLength) {
                    fxCurrentLength = fxLength;
                }
                long fxValue2 = 4096L * fxCurrentLength / fxLength;
                long fxNewY2 = this.GetBezierValueFor(fxValue2);
                fxNewY = fxNewY2 * fxHeight / 4096L;
                CGTrackNode pN = this.AddNode(0L, fxLastY + fxNewY, fxCurrentLength);
                pN.m_pTrackPiece = pTrackPiece;
            } while (fxCurrentLength < fxLength);
        } else {
            CGTrackNode pT1 = this.GetNode(nNodeSize - 2);
            CGTrackNode pT2 = this.GetNode(nNodeSize - 1);
            Vector2FX vec = new Vector2FX();
            vec.x = pT2.m_fxX - pT1.m_fxX;
            vec.y = pT2.m_fxZ - pT1.m_fxZ;
            vec.Normalize();
            do {
                if ((fxCurrentLength += fxElementLength) > fxLength) {
                    fxCurrentLength = fxLength;
                }
                long fxValue2 = 4096L * fxCurrentLength / fxLength;
                long fxNewY2 = this.GetBezierValueFor(fxValue2);
                fxNewY = fxNewY2 * fxHeight / 4096L;
                CGTrackNode pT = this.AddNode(pT2.m_fxX + vec.x * fxCurrentLength / 4096L, pT2.m_fxY + fxNewY, pT2.m_fxZ + vec.y * fxCurrentLength / 4096L);
                pT.m_pTrackPiece = pTrackPiece;
            } while (fxCurrentLength < fxLength);
        }
    }

    protected void AddCurveLine(long fxAngle, long fxLength, long fxHeight, CGTrackPiece pTrackPiece) {
        long fxC = fxAngle * 4096L / __MAX_DELTA_ANGLE__;
        long fxOneLength = FXUtility.abs(fxLength * 4096L / fxC);
        int nNodeSize = this.GetNodesSize();
        long fxStartAngle = 0L;
        if (nNodeSize == 0) {
            this.InitFirstNode(0L, 0L, 0L, pTrackPiece);
            nNodeSize = 1;
        }
        if (nNodeSize != 1) {
            CGTrackNode pT1 = this.GetNode(nNodeSize - 2);
            CGTrackNode pT2 = this.GetNode(nNodeSize - 1);
            Vector2FX vec = new Vector2FX();
            vec.x = pT2.m_fxX - pT1.m_fxX;
            vec.y = pT2.m_fxZ - pT1.m_fxZ;
            vec.Normalize();
            fxStartAngle = Vector2FX.AngleFromVector(vec);
        }
        long fxStopAngle = fxStartAngle + fxAngle;
        CGTrackNode pCurrentLastNode = this.GetNode(nNodeSize - 1);
        CGTrackNode pLastNode = this.GetNode(nNodeSize - 1);
        long fxAAA = 0L;
        while (true) {
            fxAAA += __MAX_DELTA_ANGLE__;
            if (fxAngle > 0L ? (fxStartAngle += __MAX_DELTA_ANGLE__) > fxStopAngle : (fxStartAngle -= __MAX_DELTA_ANGLE__) < fxStopAngle) break;
            Vector2FX vec = new Vector2FX();
            Vector2FX.VectorFromAngle(fxStartAngle, vec);
            long fxValue2 = 4096L * fxAAA / Math.abs(fxAngle);
            long fxNewY2 = this.GetBezierValueFor(fxValue2);
            long fxNewY = fxNewY2 * fxHeight / 4096L;
            CGTrackNode pL = this.AddNode(pLastNode.m_fxX + vec.x * fxOneLength / 4096L, pCurrentLastNode.m_fxY + fxNewY, pLastNode.m_fxZ + vec.y * fxOneLength / 4096L);
            pL.m_pTrackPiece = pTrackPiece;
            if (FXUtility.abs(pL.m_fxX - this.m_pFirstTrackNode.m_fxX) < 819L && FXUtility.abs(pL.m_fxY - this.m_pFirstTrackNode.m_fxY) < 819L && FXUtility.abs(pL.m_fxZ - this.m_pFirstTrackNode.m_fxZ) < 819L) {
                CGTrackNode pPrevL = pL.m_pPrev;
                pPrevL.m_pNext = this.m_pFirstTrackNode;
                this.m_pFirstTrackNode.m_pPrev = pPrevL;
                long fxL = FXUtility.Sqrt((pPrevL.m_fxX - this.m_pFirstTrackNode.m_fxX) * (pPrevL.m_fxX - this.m_pFirstTrackNode.m_fxX) / 4096L + (pPrevL.m_fxZ - this.m_pFirstTrackNode.m_fxZ) * (pPrevL.m_fxZ - this.m_pFirstTrackNode.m_fxZ) / 4096L);
                this.m_fxTrackLength = pPrevL.m_fxDistanceFromStart + fxL;
                break;
            }
            pLastNode = pL;
        }
    }

    protected void AddBezierCurve(int nPieces, CGTrackPiece pTrackPiece) {
        long fxSample;
        int nS = this.GetNodesSize();
        if (nS < 2) {
            return;
        }
        CGTrackNode pLastNode = this.GetLastNode();
        Vector3FX v1 = new Vector3FX();
        v1.x = pLastNode.m_fxX;
        v1.y = pLastNode.m_fxY;
        v1.z = pLastNode.m_fxZ;
        Vector3FX v4 = new Vector3FX();
        v4.x = this.m_pFirstTrackNode.m_fxX;
        v4.y = this.m_pFirstTrackNode.m_fxY;
        v4.z = this.m_pFirstTrackNode.m_fxZ;
        Vector3FX v = new Vector3FX();
        v.x = v4.x - v1.x;
        v.y = v4.y - v1.y;
        v.z = v4.z - v1.z;
        long fxLength = v.Normalize();
        Vector3FX v2 = new Vector3FX();
        v2.x = v1.x - pLastNode.m_pPrev.m_fxX;
        v2.y = v1.y - pLastNode.m_pPrev.m_fxY;
        v2.z = v1.z - pLastNode.m_pPrev.m_fxZ;
        v2.Normalize();
        v2.x *= 1638L * fxLength / 4096L;
        v2.x /= 4096L;
        v2.y *= 1638L * fxLength / 4096L;
        v2.y /= 4096L;
        v2.z *= 1638L * fxLength / 4096L;
        v2.z /= 4096L;
        v2.x += v1.x;
        v2.y += v1.y;
        v2.z += v1.z;
        Vector3FX v3 = new Vector3FX();
        v3.x = v4.x - this.m_pFirstTrackNode.m_pNext.m_fxX;
        v3.y = v4.y - this.m_pFirstTrackNode.m_pNext.m_fxY;
        v3.z = v4.z - this.m_pFirstTrackNode.m_pNext.m_fxZ;
        v3.Normalize();
        v3.x *= 1638L * fxLength / 4096L;
        v3.x /= 4096L;
        v3.y *= 1638L * fxLength / 4096L;
        v3.y /= 4096L;
        v3.z *= 1638L * fxLength / 4096L;
        v3.z /= 4096L;
        v3.x += v4.x;
        v3.y += v4.y;
        v3.z += v4.z;
        long fxLastPointX = v1.x;
        long fxLastPointY = v1.y;
        long fxLastPointZ = v1.z;
        long fxMaxDist = 8192L;
        long fxMaxDelta = fxMaxDist / 10L;
        for (long t = fxSample = (long)(4096 / nPieces); t <= 4096L; t += fxSample) {
            long fx_t2 = t * t / 4096L;
            long fx_t3 = t * fx_t2 / 4096L;
            long fx_1_t = 4096L - t;
            long fx_1_t2 = fx_1_t * fx_1_t / 4096L;
            long fx_1_t3 = fx_1_t * fx_1_t2 / 4096L;
            long fxX = fx_1_t3 * v1.x + 3L * t * fx_1_t2 * v2.x / 4096L + 3L * fx_t2 * fx_1_t * v3.x / 4096L + fx_t3 * v4.x;
            long fxY = fx_1_t3 * v1.y + 3L * t * fx_1_t2 * v2.y / 4096L + 3L * fx_t2 * fx_1_t * v3.y / 4096L + fx_t3 * v4.y;
            long fxZ = fx_1_t3 * v1.z + 3L * t * fx_1_t2 * v2.z / 4096L + 3L * fx_t2 * fx_1_t * v3.z / 4096L + fx_t3 * v4.z;
            long fxLD = FXUtility.Sqrt(((fxX /= 4096L) - fxLastPointX) * (fxX - fxLastPointX) / 4096L + ((fxZ /= 4096L) - fxLastPointZ) * (fxZ - fxLastPointZ) / 4096L);
            fxLastPointX = fxX;
            fxLastPointY = fxY /= 4096L;
            fxLastPointZ = fxZ;
            CGTrackNode pLN = this.AddNode(fxX, fxY, fxZ);
            pLN.m_pTrackPiece = pTrackPiece;
            long fxDDD = FXUtility.Sqrt((pLN.m_fxX - this.m_pFirstTrackNode.m_fxX) * (pLN.m_fxX - this.m_pFirstTrackNode.m_fxX) / 4096L + (pLN.m_fxZ - this.m_pFirstTrackNode.m_fxZ) * (pLN.m_fxZ - this.m_pFirstTrackNode.m_fxZ) / 4096L);
            if (fxDDD > 122880L) continue;
            CGTrackNode pPLN = pLN.m_pPrev;
            fxDDD = FXUtility.Sqrt((pPLN.m_fxX - this.m_pFirstTrackNode.m_fxX) * (pPLN.m_fxX - this.m_pFirstTrackNode.m_fxX) / 4096L + (pPLN.m_fxZ - this.m_pFirstTrackNode.m_fxZ) * (pPLN.m_fxZ - this.m_pFirstTrackNode.m_fxZ) / 4096L);
            this.m_fxTrackLength = pPLN.m_fxDistanceFromStart + fxDDD;
            pPLN.m_pNext = this.m_pFirstTrackNode;
            this.m_pFirstTrackNode.m_pPrev = pPLN;
            this.m_pFirstTrackNode.m_fxDistanceFromPrev = fxDDD;
            return;
        }
    }

    long GetBezierValueFor(long fxParam) {
        long v1_x = 0L;
        long v1_y = 0L;
        long v4_x = 4096L;
        long v4_y = 4096L;
        long v2_y = v1_y;
        long v3_y = v4_y;
        if (fxParam <= 0L) {
            return v1_y;
        }
        if (fxParam >= 4096L) {
            return v4_y;
        }
        long t = fxParam;
        long fx_t2 = t * t / 4096L;
        long fx_t3 = t * fx_t2 / 4096L;
        long fx_1_t = 4096L - t;
        long fx_1_t2 = fx_1_t * fx_1_t / 4096L;
        long fx_1_t3 = fx_1_t * fx_1_t2 / 4096L;
        long fxY = fx_1_t3 * v1_y + 3L * t * fx_1_t2 * v2_y / 4096L + 3L * fx_t2 * fx_1_t * v3_y / 4096L + fx_t3 * v4_y;
        return fxY /= 4096L;
    }

    protected void CreateTrackFromPieces() {
        int nDropPosX = 3;
        int nDropPosY = 10;
        this.DeleteTrack();
        int nSize = this.m_arrTrackPieces.length;
        for (int i = 0; i < nSize; ++i) {
            CGTrackPiece pTP = this.m_arrTrackPieces[i];
            if (pTP.m_nPieceType == CGTrackPiece.TRACK_PIECE_LINE) {
                this.AddStraightLine(pTP.m_nPieceLength * 4096, pTP.m_nPieceHeight * 4096, pTP);
                continue;
            }
            if (pTP.m_nPieceType == CGTrackPiece.TRACK_PIECE_TURN) {
                this.AddCurveLine(pTP.m_nPieceAngle * 4096, pTP.m_nPieceLength * 4096, pTP.m_nPieceHeight * 4096, pTP);
                continue;
            }
            if (pTP.m_nPieceType != CGTrackPiece.TRACK_PIECE_BEZIER) continue;
            this.AddBezierCurve(pTP.m_nPieceBezierSize, pTP);
        }
        this.m_fxTrackLength = this.m_pFirstTrackNode.m_pPrev.m_fxDistanceFromStart + FXUtility.Sqrt((this.m_pFirstTrackNode.m_fxX - this.m_pFirstTrackNode.m_pPrev.m_fxX) * (this.m_pFirstTrackNode.m_fxX - this.m_pFirstTrackNode.m_pPrev.m_fxX) / 4096L + (this.m_pFirstTrackNode.m_fxZ - this.m_pFirstTrackNode.m_pPrev.m_fxZ) * (this.m_pFirstTrackNode.m_fxZ - this.m_pFirstTrackNode.m_pPrev.m_fxZ) / 4096L);
        this.CalculateVelocityFactors();
    }

    void CreateCheckPointsFromMissionParams(MissionParams mission) {
        int i;
        String szKey = "";
        String szValue = "";
        int nSize = 0;
        for (i = 0; i < 1000; ++i) {
            szKey = "ChP_Dist_" + (i + 1);
            szValue = mission.GetValue(szKey);
            if (szValue.length() != 0) continue;
            nSize = i;
            break;
        }
        if (nSize == 0) {
            this.m_arrCheckPointsDistance = new int[2];
            this.m_arrCheckPointsTime = new int[2];
            this.m_arrCheckPointsDistance[0] = 500;
            this.m_arrCheckPointsTime[0] = 99999999;
            this.m_arrCheckPointsDistance[1] = (int)(this.m_fxTrackLength / 4096L) - 3000;
            this.m_arrCheckPointsTime[1] = 99999999;
            return;
        }
        this.m_arrCheckPointsDistance = new int[nSize];
        this.m_arrCheckPointsTime = new int[nSize];
        for (i = 0; i < nSize; ++i) {
            szKey = "ChP_Dist_" + (i + 1);
            szValue = mission.GetValue(szKey);
            int nV = Integer.parseInt(szValue);
            szKey = "ChP_Time_" + (i + 1);
            szValue = mission.GetValue(szKey);
            int nT = Integer.parseInt(szValue);
            this.m_arrCheckPointsDistance[i] = nV;
            this.m_arrCheckPointsTime[i] = nT;
        }
        if (Game.currentTrackID == 0) {
            this.m_arrCheckPointsTime[1] = 45;
            this.m_arrCheckPointsTime[2] = 45;
            this.m_arrCheckPointsTime[3] = 50;
            this.m_arrCheckPointsTime[4] = 45;
        } else if (Game.currentTrackID == 1) {
            this.m_arrCheckPointsTime[1] = 40;
            this.m_arrCheckPointsTime[2] = 50;
            this.m_arrCheckPointsTime[3] = 45;
            this.m_arrCheckPointsTime[4] = 40;
        } else if (Game.currentTrackID == 2) {
            this.m_arrCheckPointsTime[1] = 38;
            this.m_arrCheckPointsTime[2] = 38;
            this.m_arrCheckPointsTime[3] = 32;
            this.m_arrCheckPointsTime[4] = 38;
        } else if (Game.currentTrackID == 3) {
            this.m_arrCheckPointsTime[1] = 37;
            this.m_arrCheckPointsTime[2] = 35;
            this.m_arrCheckPointsTime[3] = 30;
            this.m_arrCheckPointsTime[4] = 39;
        } else if (Game.currentTrackID == 4) {
            this.m_arrCheckPointsTime[1] = 42;
            this.m_arrCheckPointsTime[2] = 39;
            this.m_arrCheckPointsTime[3] = 40;
            this.m_arrCheckPointsTime[4] = 32;
        } else if (Game.currentTrackID == 5) {
            this.m_arrCheckPointsTime[1] = 40;
            this.m_arrCheckPointsTime[2] = 37;
            this.m_arrCheckPointsTime[3] = 41;
            this.m_arrCheckPointsTime[4] = 33;
        } else if (Game.currentTrackID == 6) {
            this.m_arrCheckPointsTime[1] = 39;
            this.m_arrCheckPointsTime[2] = 38;
            this.m_arrCheckPointsTime[3] = 42;
            this.m_arrCheckPointsTime[4] = 44;
        } else if (Game.currentTrackID == 7) {
            this.m_arrCheckPointsTime[1] = 39;
            this.m_arrCheckPointsTime[2] = 45;
            this.m_arrCheckPointsTime[3] = 37;
            this.m_arrCheckPointsTime[4] = 46;
        } else if (Game.currentTrackID == 8) {
            this.m_arrCheckPointsTime[1] = 43;
            this.m_arrCheckPointsTime[2] = 37;
            this.m_arrCheckPointsTime[3] = 34;
            this.m_arrCheckPointsTime[4] = 33;
        } else if (Game.currentTrackID == 9) {
            this.m_arrCheckPointsTime[1] = 38;
            this.m_arrCheckPointsTime[2] = 37;
            this.m_arrCheckPointsTime[3] = 36;
            this.m_arrCheckPointsTime[4] = 37;
        } else if (Game.currentTrackID == 10) {
            this.m_arrCheckPointsTime[1] = 40;
            this.m_arrCheckPointsTime[2] = 44;
            this.m_arrCheckPointsTime[3] = 34;
            this.m_arrCheckPointsTime[4] = 36;
        } else if (Game.currentTrackID == 11) {
            this.m_arrCheckPointsTime[1] = 39;
            this.m_arrCheckPointsTime[2] = 44;
            this.m_arrCheckPointsTime[3] = 34;
            this.m_arrCheckPointsTime[4] = 35;
        }
        if (SelectGameMode.selectedGameMode == 5) {
            this.m_arrCheckPointsTime[1] = 9999999;
            this.m_arrCheckPointsTime[2] = 9999999;
            this.m_arrCheckPointsTime[3] = 9999999;
            this.m_arrCheckPointsTime[4] = 9999999;
        }
    }

    protected void CalculateVelocityFactors() {
        this.m_pSecondTrackNode = null;
        this.m_pThirdTrackNode = null;
        this.m_pFourthTrackNode = null;
        CGTrackNode pLastNode = this.m_pFirstTrackNode;
        while (true) {
            boolean bEnd = false;
            if (pLastNode.m_pNext == null || pLastNode.m_pNext == this.m_pFirstTrackNode) {
                bEnd = true;
            }
            if (this.m_pSecondTrackNode == null && pLastNode.m_fxDistanceFromStart > this.m_fxTrackLength / 4L) {
                this.m_pSecondTrackNode = pLastNode.m_pPrev.m_pPrev.m_pPrev;
            }
            if (this.m_pThirdTrackNode == null && pLastNode.m_fxDistanceFromStart > this.m_fxTrackLength / 2L) {
                this.m_pThirdTrackNode = pLastNode.m_pPrev.m_pPrev.m_pPrev;
            }
            if (this.m_pFourthTrackNode == null && pLastNode.m_fxDistanceFromStart > 3L * this.m_fxTrackLength / 4L) {
                this.m_pFourthTrackNode = pLastNode.m_pPrev.m_pPrev.m_pPrev;
            }
            long fxV = 4096L;
            if (pLastNode.m_pPrev != null && pLastNode.m_pNext != null) {
                Vector2FX v1 = new Vector2FX();
                v1.x = pLastNode.m_fxX - pLastNode.m_pPrev.m_fxX;
                v1.y = pLastNode.m_fxZ - pLastNode.m_pPrev.m_fxZ;
                long fxD1 = v1.Normalize();
                Vector2FX v2 = new Vector2FX();
                v2.x = pLastNode.m_pNext.m_fxX - pLastNode.m_fxX;
                v2.y = pLastNode.m_pNext.m_fxZ - pLastNode.m_fxZ;
                long fxD2 = v2.Normalize();
                long fxAngle = (v1.x * v2.x + v1.y * v2.y) / 4096L;
                if ((fxAngle = FXUtility.ArcCos(fxAngle)) > 737280L) {
                    fxAngle = 1474560L - fxAngle;
                }
                fxV = 4096L * FXUtility.abs(fxAngle) / (fxD2 + fxD1);
                long fxA1 = Vector2FX.AngleFromVector(v1);
                long fxA2 = Vector2FX.AngleFromVector(v2);
                pLastNode.m_fxVelocityFactor = FXUtility.abs(fxV);
                Vector2FX vvv = new Vector2FX();
                vvv.y = Math.abs(pLastNode.m_pNext.m_fxZ - pLastNode.m_fxZ);
                vvv.x = pLastNode.m_pNext.m_fxY - pLastNode.m_fxY;
                vvv.Normalize();
                fxAngle = Vector2FX.AngleFromVector(vvv);
                if (fxAngle > 819200L) {
                    fxAngle -= 1474560L;
                }
                fxAngle = fxAngle > 0L ? (fxAngle /= 180L) : (fxAngle /= 120L);
                pLastNode.m_fxVelocityFactor += (long)((int)fxAngle);
                pLastNode.m_fxVelocityFactor *= 2L;
                pLastNode.m_fxVelocityFactor /= 3L;
                if (pLastNode.m_fxVelocityFactor > 2048L) {
                    pLastNode.m_fxVelocityFactor = 2048L;
                }
                if (pLastNode.m_fxVelocityFactor < 0L) {
                    pLastNode.m_fxVelocityFactor = 0L;
                }
            }
            if (bEnd) break;
            pLastNode = pLastNode.m_pNext;
        }
    }

    public void GenerateObjects_Env(int nEnvironment) {
        int i;
        Vector3FX posVector = new Vector3FX();
        Vector2FX dirVector = new Vector2FX();
        CGTrackNode pTN = null;
        int nS = this.m_arrCheckPointsDistance.length;
        for (i = 0; i < nS; ++i) {
            CGBillboardObject pO;
            if (SelectGameMode.selectedGameMode == 5 && i > 0 && i < nS - 1) continue;
            pTN = this.FindPlaceOnTrack3D(this.m_arrCheckPointsDistance[i] * 4096, 4300L, null, posVector, dirVector);
            if (pTN != null) {
                pO = null;
                pO = i == 0 ? CGBillboardObject.CreateBillboardObject(18, posVector.x, posVector.y, posVector.z) : (i == nS - 1 ? CGBillboardObject.CreateBillboardObject(20, posVector.x, posVector.y, posVector.z) : CGBillboardObject.CreateBillboardObject(19, posVector.x, posVector.y, posVector.z));
                pO.m_fxDistanceFromStart = 4096000L;
                pTN.m_pTrackPiece.AddObject(pO);
            }
            if ((pTN = this.FindPlaceOnTrack3D(this.m_arrCheckPointsDistance[i] * 4096, -4300L, null, posVector, dirVector)) == null) continue;
            pO = null;
            pO = i == 0 ? CGBillboardObject.CreateBillboardObject(18, posVector.x, posVector.y, posVector.z) : (i == nS - 1 ? CGBillboardObject.CreateBillboardObject(20, posVector.x, posVector.y, posVector.z) : CGBillboardObject.CreateBillboardObject(19, posVector.x, posVector.y, posVector.z));
            pO.m_fxDistanceFromStart = 4096000L;
            pTN.m_pTrackPiece.AddObject(pO);
        }
        for (i = 0; i < 200; ++i) {
            this.m_arrStonesDistance[i] = 1000000;
        }
        this.m_nCurrentStoneIndex = 0;
        long fxDir = 0L;
        long fxCurDist = (1000 + RandSync.nextInt() % 2000) * 4096;
        long fxD = 2000L;
        do {
            int nType = 20 + nEnvironment;
            fxDir = FXUtility.abs(RandSync.nextInt()) % 100 > 50 ? -1900L : 1900L;
            if (this.m_nCurrentStoneIndex < 200) {
                this.m_arrStonesDistance[this.m_nCurrentStoneIndex] = fxDir > 0L ? (int)(fxCurDist / 4096L) : (int)(-fxCurDist / 4096L);
                ++this.m_nCurrentStoneIndex;
                pTN = this.FindPlaceOnTrack3D(fxCurDist, fxDir, null, posVector, dirVector);
                if (pTN == null) continue;
                CGBillboardObject pO = CGBillboardObject.CreateBillboardObject(nType, posVector.x, posVector.y, posVector.z);
                pO.m_fxDistanceFromStart = fxCurDist;
                pTN.m_pTrackPiece.AddObject(pO);
                continue;
            }
            int a = 0;
            ++a;
        } while ((fxCurDist += (long)((FXUtility.abs(RandSync.nextInt()) % 1500 + 1500) * 4096)) <= this.m_fxTrackLength);
        this.m_nCurrentStoneIndex = 0;
        System.out.println("End GenerateObjects_Env...");
    }

    public void GenerateObjects_1() {
        Vector3FX posVector = new Vector3FX();
        Vector2FX dirVector = new Vector2FX();
        CGTrackNode pTN = null;
        long fxDir = 0L;
        long fxCurDist = 204800L;
        long fxD = 4096L;
        int nAddV = 5;
        int[] nObjectsID = new int[]{1, 2, 1, 3, 3, 1, 2, 1, 3, 3, 4, 5, 1, 2, 3, 1, 2, 3, 1, 2, 3};
        nObjectsID = new int[]{1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1};
        int i = 0;
        while (i < nObjectsID.length) {
            int n = i++;
            nObjectsID[n] = nObjectsID[n] + nAddV;
        }
        do {
            int nType;
            if ((nType = nObjectsID[FXUtility.abs(RandSync.nextInt()) % nObjectsID.length]) == 1 + nAddV || nType == 2 + nAddV || nType == 3 + nAddV) {
                fxD = 5000L + 1L * (long)(FXUtility.abs(RandSync.nextInt()) % 100 * 4096) / 100L;
                fxDir = 4096L;
                if (FXUtility.abs(RandSync.nextInt()) % 100 > 50) {
                    fxDir = -4096L;
                }
            } else if (nType == 4 + nAddV) {
                fxD = 8000L + 5L * (long)(FXUtility.abs(RandSync.nextInt()) % 100 * 4096) / 100L;
                fxDir = nType == 6 ? -4096L : 4096L;
            } else if (nType == 5 + nAddV) {
                fxD = 6000L;
                fxDir = nType == 6 ? -4096L : 4096L;
            } else if (nType == 6 + nAddV) {
                fxD = 10000L + 5L * (long)(FXUtility.abs(RandSync.nextInt()) % 100 * 4096) / 100L;
                fxDir = nType == 6 ? -4096L : 4096L;
            }
            if ((pTN = this.FindPlaceOnTrack3D(fxCurDist, fxDir * fxD / 4096L, null, posVector, dirVector)) == null) continue;
            CGBillboardObject pO = CGBillboardObject.CreateBillboardObject(nType, posVector.x, posVector.y, posVector.z);
            pO.m_fxDistanceFromStart = fxCurDist;
            pTN.m_pTrackPiece.AddObject(pO);
        } while ((fxCurDist += (long)((FXUtility.abs(RandSync.nextInt()) % 70 + 70) * 4096)) <= this.m_fxTrackLength);
        this.m_nCurrentCheckPointIndex = 0;
    }

    public void GenerateObjects_2() {
        Vector3FX posVector = new Vector3FX();
        Vector2FX dirVector = new Vector2FX();
        CGTrackNode pTN = null;
        long fxDir = 0L;
        long fxCurDist = 204800L;
        long fxD = 4096L;
        int[] nObjectsID = new int[]{1, 2, 1, 3, 3, 1, 2, 1, 3, 3, 4, 5, 1, 2, 3, 1, 2, 3, 1, 2, 3};
        nObjectsID = new int[]{1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1};
        do {
            int nType;
            if ((nType = nObjectsID[FXUtility.abs(RandSync.nextInt()) % nObjectsID.length]) == 1 || nType == 2 || nType == 3) {
                fxD = 5000L + 1L * (long)(FXUtility.abs(RandSync.nextInt()) % 100 * 4096) / 100L;
                fxDir = 4096L;
                if (FXUtility.abs(RandSync.nextInt()) % 100 > 50) {
                    fxDir = -4096L;
                }
            } else if (nType == 4) {
                fxD = 8000L + 5L * (long)(FXUtility.abs(RandSync.nextInt()) % 100 * 4096) / 100L;
                fxDir = nType == 6 ? -4096L : 4096L;
            } else if (nType == 5) {
                fxD = 6000L;
                fxDir = nType == 6 ? -4096L : 4096L;
            } else if (nType == 6) {
                fxD = 10000L + 5L * (long)(FXUtility.abs(RandSync.nextInt()) % 100 * 4096) / 100L;
                fxDir = nType == 6 ? -4096L : 4096L;
            }
            if ((pTN = this.FindPlaceOnTrack3D(fxCurDist, fxDir * fxD / 4096L, null, posVector, dirVector)) == null) continue;
            CGBillboardObject pO = CGBillboardObject.CreateBillboardObject(nType, posVector.x, posVector.y, posVector.z);
            pO.m_fxDistanceFromStart = fxCurDist;
            pTN.m_pTrackPiece.AddObject(pO);
        } while ((fxCurDist += (long)((FXUtility.abs(RandSync.nextInt()) % 70 + 70) * 4096)) <= this.m_fxTrackLength);
        this.m_nCurrentCheckPointIndex = 0;
    }

    public void GenerateObjects_3() {
        Vector3FX posVector = new Vector3FX();
        Vector2FX dirVector = new Vector2FX();
        CGTrackNode pTN = null;
        long fxDir = 0L;
        long fxCurDist = 204800L;
        long fxD = 4096L;
        int nAddV = 10;
        int[] nObjectsID = new int[]{1, 2, 1, 3, 3, 1, 2, 1, 3, 3, 4, 5, 1, 2, 3, 1, 2, 3, 1, 2, 3};
        nObjectsID = new int[]{1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1};
        int i = 0;
        while (i < nObjectsID.length) {
            int n = i++;
            nObjectsID[n] = nObjectsID[n] + nAddV;
        }
        do {
            int nType;
            if ((nType = nObjectsID[FXUtility.abs(RandSync.nextInt()) % nObjectsID.length]) == 1 + nAddV || nType == 2 + nAddV || nType == 3 + nAddV) {
                fxD = 5000L + 1L * (long)(FXUtility.abs(RandSync.nextInt()) % 100 * 4096) / 100L;
                fxDir = 4096L;
                if (FXUtility.abs(RandSync.nextInt()) % 100 > 50) {
                    fxDir = -4096L;
                }
            } else if (nType == 4 + nAddV) {
                fxD = 8000L + 5L * (long)(FXUtility.abs(RandSync.nextInt()) % 100 * 4096) / 100L;
                fxDir = nType == 6 ? -4096L : 4096L;
            } else if (nType == 5 + nAddV) {
                fxD = 6000L;
                fxDir = nType == 6 ? -4096L : 4096L;
            } else if (nType == 6 + nAddV) {
                fxD = 10000L + 5L * (long)(FXUtility.abs(RandSync.nextInt()) % 100 * 4096) / 100L;
                fxDir = nType == 6 + nAddV ? -4096L : 4096L;
            }
            if ((pTN = this.FindPlaceOnTrack3D(fxCurDist, fxDir * fxD / 4096L, null, posVector, dirVector)) == null) continue;
            CGBillboardObject pO = CGBillboardObject.CreateBillboardObject(nType, posVector.x, posVector.y, posVector.z);
            pO.m_fxDistanceFromStart = fxCurDist;
            pTN.m_pTrackPiece.AddObject(pO);
        } while ((fxCurDist += (long)((FXUtility.abs(RandSync.nextInt()) % 50 + 50) * 4096)) <= this.m_fxTrackLength);
        this.m_nCurrentCheckPointIndex = 0;
    }

    public void deSerialize(DataInputStream dis) throws IOException {
        int bTrackPieces = dis.readByte();
        this.m_arrTrackPieces = new CGTrackPiece[bTrackPieces];
        for (int i = 0; i < bTrackPieces; ++i) {
            this.m_arrTrackPieces[i] = new CGTrackPiece();
            this.m_arrTrackPieces[i].deSerialize(dis);
        }
        this.CreateTrackFromPieces();
    }

    public void ResetObj() {
        CGTrackNode pStartNode;
        this.m_pSecondTrackNode = null;
        this.m_pThirdTrackNode = null;
        this.m_pFourthTrackNode = null;
        this.m_arrCurrentObjects.removeAllElements();
        int nS = this.m_arrTrackPieces.length;
        for (int i = 0; i < nS; ++i) {
            this.m_arrTrackPieces[i].ResetObj();
            this.m_arrTrackPieces[i] = null;
        }
        this.m_arrTrackPieces = null;
        CGTrackNode pCurNode = pStartNode = this.m_pFirstTrackNode;
        do {
            pCurNode.m_pPrev = null;
            pCurNode = pCurNode.m_pNext;
            pCurNode.ResetObj();
            pCurNode.m_pPrev = null;
        } while (pCurNode != pStartNode);
        pCurNode.m_pNext = null;
        pCurNode = null;
        this.m_pFirstTrackNode = null;
    }
}

