/*
 * Decompiled with CFR 0.152.
 */
package de.mef.state.concrete;

import de.mef.menu.TextBlock;
import de.mef.menu.TextItem;
import de.mef.state.State;
import de.mef.state.concrete.GameState;
import de.mef.util.Handset;
import de.mef.util.KeyListener;
import de.mef.util.Locale;
import de.mef.util.Refreshable;
import de.mef.util.Updateable;
import de.mef.util.Utility;
import javax.microedition.lcdui.Graphics;

public final class ChooseLevelState
extends State
implements KeyListener,
Refreshable,
Updateable {
    TextBlock prompt = new TextBlock("chooselevel", TextItem.DEFAULT_FONT, State.canvas.getWidth(), TextItem.DEFAULT_FOCUS_COLOR, 1);

    public final void update() throws Exception {
        State.repaint();
    }

    ChooseLevelState() {
        this.prompt.outline = 0;
    }

    public final void enter() throws Exception {
        State.left = Locale.string("command-ok");
        State.right = Locale.string("command-menu");
    }

    public final void leave() throws Exception {
    }

    public final void paint(Graphics graphics) throws Exception {
        char c;
        char c2;
        int n;
        GameState.maxlevel = Math.min(GameState.maxlevel, 29);
        GameState.level = Math.min(GameState.level, 29);
        if (GameState.maxlevel == 0) {
            State.setNamedState("game");
            return;
        }
        State.menuBackground(graphics, false);
        this.prompt.paint(graphics, State.canvas.getWidth() / 2, 4, 17);
        graphics.setFont(Handset.fnt_medium);
        for (n = GameState.level + 1; n < GameState.maxlevel + 1 && State.canvas.getHeight() / 2 - (n + 1 - GameState.level) * Handset.fnt_medium.getHeight() > 4 + this.prompt.getHeight(); ++n) {
            graphics.setColor(Utility.interpolateColor(1125953, 0xCCCCCC, 256 / (n - GameState.level)));
            c2 = (char)(48 + (n + 1) / 10);
            c = (char)(48 + (n + 1) % 10);
            graphics.drawChar(c2, State.canvas.getWidth() / 2 - (n - GameState.level) * 12, State.canvas.getHeight() / 2 - (n - GameState.level) * Handset.fnt_medium.getHeight(), 40);
            graphics.drawChar(c, State.canvas.getWidth() / 2 - (n - GameState.level) * 12, State.canvas.getHeight() / 2 - (n - GameState.level) * Handset.fnt_medium.getHeight(), 36);
        }
        for (n = GameState.level - 1; n >= 0 && State.canvas.getHeight() / 2 + (GameState.level - n) * Handset.fnt_medium.getHeight() < State.canvas.getHeight() - Handset.fnt_small.getHeight(); --n) {
            graphics.setColor(Utility.interpolateColor(1125953, 0xCCCCCC, 256 / (GameState.level - n)));
            c2 = (char)(48 + (n + 1) / 10);
            c = (char)(48 + (n + 1) % 10);
            graphics.drawChar(c2, State.canvas.getWidth() / 2 - (n - GameState.level) * 12, State.canvas.getHeight() / 2 - (n - GameState.level) * Handset.fnt_medium.getHeight(), 24);
            graphics.drawChar(c, State.canvas.getWidth() / 2 - (n - GameState.level) * 12, State.canvas.getHeight() / 2 - (n - GameState.level) * Handset.fnt_medium.getHeight(), 20);
        }
        graphics.setColor(0xFFFFFF);
        graphics.setFont(Handset.fnt_bold);
        n = (char)(48 + (GameState.level + 1) / 10);
        c2 = (char)(48 + (GameState.level + 1) % 10);
        graphics.drawChar((char)n, State.canvas.getWidth() / 2, State.canvas.getHeight() / 2 - Handset.fnt_medium.getHeight() / 2, 24);
        graphics.drawChar(c2, State.canvas.getWidth() / 2, State.canvas.getHeight() / 2 - Handset.fnt_medium.getHeight() / 2, 20);
    }

    public final void keyPressed(int n) {
        if (n == Handset.MENU_LEFT || n == Handset.FIRE || n == Handset.NUM5) {
            State.setNamedState("game");
        }
        if (n == Handset.MENU_RIGHT) {
            State.setNamedState("mainmenu");
        }
        if (n == Handset.UP || n == Handset.NUM2) {
            ++GameState.level;
            GameState.level = Math.min(GameState.level, GameState.maxlevel);
        }
        if (n == Handset.DOWN || n == Handset.NUM8 || n == Handset.NUM0) {
            --GameState.level;
            GameState.level = Math.max(GameState.level, 0);
        }
        State.repaint();
    }

    public final void keyReleased(int n) {
    }

    public final void keyRepeated(int n) {
    }

    public final void refresh() {
        if (this.prompt != null) {
            this.prompt.refresh();
        }
    }
}

