/*
 * Decompiled with CFR 0.152.
 */
package de.mef.state.concrete;

import de.mef.menu.BasicMenu;
import de.mef.menu.Frame;
import de.mef.menu.MenuListener;
import de.mef.menu.Pad;
import de.mef.menu.ScrollArrow;
import de.mef.menu.TextBlock;
import de.mef.menu.TextItem;
import de.mef.menu.Widget;
import de.mef.state.State;
import de.mef.util.Handset;
import de.mef.util.KeyListener;
import de.mef.util.Locale;
import de.mef.util.Refreshable;
import de.mef.util.Updateable;
import java.io.IOException;
import javax.microedition.lcdui.Graphics;

public final class OptionsState
extends State
implements KeyListener,
MenuListener,
Updateable,
Refreshable {
    private BasicMenu menu = new BasicMenu(State.canvas.getHeight() / 4 * 3);
    private TextItem difficulty;
    private TextItem type;
    private TextItem sound;
    private TextItem language;
    TextBlock prompt;
    private ScrollArrow up;
    private ScrollArrow down;

    public final void update() {
        State.repaint();
    }

    public final void menuAction(Widget widget, int n) {
        if (widget == this.type) {
            State.setNamedState("type");
        }
        if (widget == this.difficulty) {
            State.setNamedState("difficulty");
        }
        if (widget == this.sound) {
            State.setNamedState("sound");
        }
        if (widget == this.language) {
            State.setNamedState("language");
        }
    }

    public OptionsState() {
        this.menu.setAlignment(3);
        try {
            this.up = new ScrollArrow(this.menu, 0);
            this.down = new ScrollArrow(this.menu, 1);
            return;
        }
        catch (IOException iOException) {
            return;
        }
    }

    public final void enter() {
        this.menu.setCursor(0);
        this.prompt = new TextBlock("menu-options", TextItem.DEFAULT_FONT, State.canvas.getWidth(), TextItem.DEFAULT_FOCUS_COLOR, 1);
        this.prompt.outline = 0;
        this.type = new TextItem("menu-gametype");
        this.type.setMenuListener(this, 1);
        this.difficulty = new TextItem("menu-difficulty");
        this.difficulty.setMenuListener(this, 1);
        this.sound = new TextItem("menu-sound");
        this.sound.setMenuListener(this, 1);
        this.language = new TextItem("menu-language");
        this.language.setMenuListener(this, 1);
        int n = Math.max(this.difficulty.getWidth(), this.sound.getWidth());
        n = Math.max(n, this.language.getWidth());
        n = Math.max(n, this.type.getWidth());
        this.menu.addElement(new Frame(new Pad(this.type, n += 6, 0, 1)));
        this.menu.addElement(new Frame(new Pad(this.difficulty, n, 0, 1)));
        this.menu.addElement(new Frame(new Pad(this.sound, n, 0, 1)));
        this.menu.addElement(new Frame(new Pad(this.language, n, 0, 1)));
        this.refresh();
        State.right = Locale.string("command-back");
        State.left = Locale.string("command-ok");
        System.currentTimeMillis();
        State.repaint();
    }

    public final void paint(Graphics graphics) {
        State.menuBackground(graphics, false);
        this.prompt.paint(graphics, State.canvas.getWidth() / 2, 0, 17);
        this.menu.paint(graphics, State.canvas.getWidth() / 2, State.canvas.getHeight() / 2, 3);
        this.up.paint(graphics, State.canvas.getWidth() / 2, State.canvas.getHeight() - this.down.getHeight(), 33);
        this.down.paint(graphics, State.canvas.getWidth() / 2, State.canvas.getHeight(), 33);
    }

    public final void leave() {
        this.menu.removeAllElements();
    }

    public final void keyPressed(int n) {
        if (n == Handset.MENU_RIGHT) {
            State.setNamedState("mainmenu");
            return;
        }
        this.menu.keyPressed(n);
    }

    public final void keyRepeated(int n) {
        this.menu.keyRepeated(n);
    }

    public final void keyReleased(int n) {
        this.menu.keyReleased(n);
    }

    public final void refresh() {
        this.menu.refresh();
    }
}

