/*
 * Decompiled with CFR 0.152.
 */
package de.mef.menu;

import de.mef.menu.Anchored;
import de.mef.menu.Widget;
import de.mef.util.Refreshable;
import javax.microedition.lcdui.Graphics;

public final class Pad
extends Widget {
    private int vertical;
    private int horizontal;
    private int alignment = 20;
    private Anchored content;

    private Pad(Anchored anchored, int n, int n2) {
        if (anchored == null) {
            throw new IllegalArgumentException("Pad(...): content must not be null");
        }
        this.content = anchored;
        this.horizontal = n;
        this.vertical = n2;
        this.refresh();
    }

    public Pad(Anchored anchored, int n, int n2, int n3) {
        this(anchored, n, n2);
        this.alignment = n3;
    }

    protected final void display(Graphics graphics) {
        int n = 0;
        int n2 = 0;
        if ((this.alignment & 2) == 2) {
            n2 = this.height / 2;
        }
        if ((this.alignment & 0x20) == 32) {
            n2 = this.height;
        }
        if ((this.alignment & 1) == 1) {
            n = this.width / 2;
        }
        if ((this.alignment & 8) == 8) {
            n = this.width;
        }
        this.content.paint(graphics, n, n2, this.alignment);
    }

    public final void refresh() {
        this.width = Math.max(this.horizontal, this.content.getWidth());
        this.height = Math.max(this.vertical, this.content.getHeight());
        if (this.content instanceof Refreshable) {
            this.content.refresh();
        }
    }

    public final void select() {
        super.select();
        if (this.content instanceof Widget) {
            ((Widget)this.content).select();
        }
    }

    public final void setFocus(boolean bl) {
        super.setFocus(bl);
        if (this.content instanceof Widget) {
            ((Widget)this.content).setFocus(bl);
        }
    }
}

