/*
 * Decompiled with CFR 0.152.
 */
package de.mef.state.concrete;

import de.mef.menu.BasicMenu;
import de.mef.menu.Frame;
import de.mef.menu.MenuListener;
import de.mef.menu.Pad;
import de.mef.menu.TextBlock;
import de.mef.menu.TextItem;
import de.mef.menu.Widget;
import de.mef.sound.SoundPlayer;
import de.mef.state.State;
import de.mef.state.concrete.MainMenu;
import de.mef.util.Handset;
import de.mef.util.KeyListener;
import de.mef.util.Locale;
import de.mef.util.Refreshable;
import de.mef.util.Updateable;
import javax.microedition.lcdui.Graphics;

public final class SoundSetup
extends State
implements KeyListener,
MenuListener,
Updateable,
Refreshable {
    private BasicMenu menu;
    private Widget on;
    private Widget off;
    private TextBlock header;
    private boolean first = true;
    private String first_outcome;
    private String normal_outcome;

    public final void update() {
        State.repaint();
    }

    public final void menuAction(Widget widget, int n) {
        if (n == 1) {
            String string;
            if (widget == this.on) {
                MainMenu.fresh = !SoundPlayer.active;
                SoundPlayer.active = true;
            } else {
                SoundPlayer.active = false;
                SoundPlayer.stopSound();
            }
            if (this.first) {
                this.first = false;
                string = this.first_outcome;
            } else {
                string = this.normal_outcome;
            }
            State.setNamedState(string);
        }
    }

    private SoundSetup() {
    }

    public SoundSetup(String string, String string2) {
        this.first_outcome = string;
        this.normal_outcome = string2;
        this.header = new TextBlock("wantsound", TextItem.DEFAULT_FONT, State.canvas.getWidth(), TextItem.DEFAULT_FOCUS_COLOR, 1);
        this.header.outline = 0;
        this.menu = new BasicMenu(State.canvas.getHeight() / 2);
        this.menu.setAlignment(3);
    }

    public final void enter() {
        TextItem textItem = new TextItem("menu-on");
        TextItem textItem2 = new TextItem("menu-off");
        int n = Math.max(textItem.getWidth(), textItem2.getWidth()) + 6;
        this.on = new Frame(new Pad(textItem, n, 0, 3));
        this.off = new Frame(new Pad(textItem2, n, 0, 3));
        this.on.setMenuListener(this, 1);
        this.off.setMenuListener(this, 1);
        this.menu.addElement(this.on);
        this.menu.addElement(this.off);
        this.menu.setCursor(0);
        if (!this.first) {
            State.right = Locale.string("command-back");
        }
        State.left = Locale.string("ok");
        this.refresh();
        State.repaint();
    }

    public final void paint(Graphics graphics) {
        State.menuBackground(graphics, false);
        this.header.paint(graphics, State.canvas.getWidth() / 2, 0, 17);
        this.menu.paint(graphics, State.canvas.getWidth() / 2, State.canvas.getHeight() / 2, 3);
    }

    public final void leave() {
        this.menu.removeAllElements();
    }

    public final void keyPressed(int n) {
        if (!this.first && n == Handset.MENU_RIGHT) {
            State.setNamedState(this.normal_outcome);
            return;
        }
        this.menu.keyPressed(n);
    }

    public final void keyRepeated(int n) {
        this.menu.keyRepeated(n);
    }

    public final void keyReleased(int n) {
        this.menu.keyReleased(n);
    }

    public final void refresh() {
        this.menu.refresh();
        this.header.refresh();
    }
}

