/*
 * Decompiled with CFR 0.152.
 */
package de.mef.state;

import de.mef.canvas.MIDP2Canvas;
import de.mef.menu.Frame;
import de.mef.menu.TextBlock;
import de.mef.menu.TextItem;
import de.mef.state.State;
import de.mef.state.concrete.GameState;
import de.mef.state.concrete.LanguageSetup;
import de.mef.state.concrete.LoadingSplashState;
import de.mef.state.concrete.SoundSetup;
import de.mef.util.Handset;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Displayable;
import javax.microedition.midlet.MIDlet;
import javax.microedition.midlet.MIDletStateChangeException;
import javax.microedition.rms.RecordEnumeration;
import javax.microedition.rms.RecordStore;
import javax.microedition.rms.RecordStoreException;

public class StateMIDlet
extends MIDlet
implements Runnable {
    private boolean running = false;
    public Thread worker;

    public void run() {
        StateMIDlet.loadOptions();
        TextBlock.DEFAULT_COLOR = 0xCCCCCC;
        Frame.DEFAULT_ENABLED_BACKGROUND = -1;
        Frame.DEFAULT_ENABLED_COLOR = -1;
        Frame.DEFAULT_FOCUS_BACKGROUND = 5284048;
        Frame.DEFAULT_FOCUS_COLOR = 0;
        TextItem.DEFAULT_FONT = State.canvas.getHeight() <= 207 ? Handset.fnt_smallbold : Handset.fnt_bold;
        TextItem.DEFAULT_ENABLED_COLOR = 0xA0A0A0;
        TextItem.DEFAULT_FOCUS_COLOR = 0xFFFFFF;
        TextItem.DEFAULT_FOCUS_OUTLINE = 0;
        LanguageSetup languageSetup = new LanguageSetup("sound", "options");
        SoundSetup soundSetup = new SoundSetup("splash", "options");
        State.registerState("language", languageSetup);
        State.registerState("sound", soundSetup);
        State.registerState("splash", new LoadingSplashState());
        State.setCurrentState(languageSetup);
        while (this.running) {
            State.updateCurrent();
            State.paintCurrent();
            if (State.canvas.isShown()) {
                Thread.yield();
                continue;
            }
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        StateMIDlet.storeOptions();
        this.notifyDestroyed();
    }

    public StateMIDlet() {
        State.display = Display.getDisplay((MIDlet)this);
        State.host = this;
        try {
            State.canvas = new MIDP2Canvas();
            return;
        }
        catch (Exception exception) {
            return;
        }
    }

    protected void startApp() throws MIDletStateChangeException {
        State.display.setCurrent((Displayable)State.canvas);
        if (!this.running) {
            this.running = true;
            this.worker = new Thread(this);
            this.worker.start();
        }
    }

    protected void destroyApp(boolean bl) throws MIDletStateChangeException {
        this.destroy();
    }

    public final void destroy() {
        this.running = false;
    }

    protected void pauseApp() {
    }

    static void loadOptions() {
        try {
            RecordStore recordStore = RecordStore.openRecordStore((String)"MarbleMatrix", (boolean)false);
            RecordEnumeration recordEnumeration = recordStore.enumerateRecords(null, null, false);
            if (recordEnumeration.hasNextElement()) {
                byte[] byArray = recordEnumeration.nextRecord();
                ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
                DataInputStream dataInputStream = new DataInputStream(byteArrayInputStream);
                GameState.difficulty = dataInputStream.readInt();
                GameState.maxlevel = dataInputStream.readInt();
                GameState.gametype = dataInputStream.readInt();
                dataInputStream.close();
            }
            recordStore.closeRecordStore();
            return;
        }
        catch (Exception exception) {
            return;
        }
    }

    static void storeOptions() {
        try {
            RecordStore.deleteRecordStore((String)"MarbleMatrix");
        }
        catch (RecordStoreException recordStoreException) {}
        try {
            RecordStore recordStore = RecordStore.openRecordStore((String)"MarbleMatrix", (boolean)true);
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
            dataOutputStream.writeInt(GameState.difficulty);
            dataOutputStream.writeInt(GameState.maxlevel);
            dataOutputStream.writeInt(GameState.gametype);
            dataOutputStream.flush();
            byte[] byArray = byteArrayOutputStream.toByteArray();
            dataOutputStream.close();
            recordStore.addRecord(byArray, 0, byArray.length);
            recordStore.closeRecordStore();
            return;
        }
        catch (Exception exception) {
            try {
                RecordStore.deleteRecordStore((String)"MarbleMatrix");
                return;
            }
            catch (RecordStoreException recordStoreException) {
                return;
            }
        }
    }
}

