/*
 * Decompiled with CFR 0.152.
 */
package de.mef.menu;

import de.mef.menu.Captioned;
import de.mef.util.Utility;
import java.util.Vector;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;

public final class TextBlock
extends Captioned {
    private Vector lines;
    private Font font = DEFAULT_FONT;
    public int color = DEFAULT_COLOR;
    public int shadow = DEFAULT_SHADOW;
    public int outline = DEFAULT_OUTLINE;
    private int alignment = 20;
    public static int DEFAULT_COLOR = 0xCCCCCC;
    public static int DEFAULT_OUTLINE = -1;
    public static int DEFAULT_SHADOW = -1;
    public static Font DEFAULT_FONT = Font.getDefaultFont();

    protected final void display(Graphics graphics) {
        int n = 0;
        if ((this.alignment & 1) != 0) {
            n = this.width / 2;
        }
        if ((this.alignment & 8) != 0) {
            n = this.width;
        }
        this.alignment &= 0xD;
        this.alignment |= 0x10;
        for (int i = 0; i < this.lines.size(); ++i) {
            graphics.setFont(this.font);
            if (this.shadow != -1) {
                graphics.setColor(this.shadow);
                graphics.drawString((String)this.lines.elementAt(i), 3, 3 + i * this.font.getHeight(), this.alignment);
            }
            if (this.outline != -1) {
                graphics.setColor(this.outline);
                graphics.drawString((String)this.lines.elementAt(i), 1 + n, 0 + i * this.font.getHeight(), this.alignment);
                graphics.drawString((String)this.lines.elementAt(i), 1 + n, 2 + i * this.font.getHeight(), this.alignment);
                graphics.drawString((String)this.lines.elementAt(i), 2 + n, 0 + i * this.font.getHeight(), this.alignment);
                graphics.drawString((String)this.lines.elementAt(i), 2 + n, 2 + i * this.font.getHeight(), this.alignment);
                graphics.drawString((String)this.lines.elementAt(i), 2 + n, 1 + i * this.font.getHeight(), this.alignment);
                graphics.drawString((String)this.lines.elementAt(i), n, 0 + i * this.font.getHeight(), this.alignment);
                graphics.drawString((String)this.lines.elementAt(i), n, 2 + i * this.font.getHeight(), this.alignment);
                graphics.drawString((String)this.lines.elementAt(i), n, 1 + i * this.font.getHeight(), this.alignment);
            }
            graphics.setColor(this.color);
            graphics.drawString((String)this.lines.elementAt(i), n + 1, 1 + i * this.font.getHeight(), this.alignment);
        }
    }

    public final void refresh() {
        String string = this.caption;
        super.refresh();
        if (this.caption != string || this.lines == null) {
            this.lines = Utility.wrapText(this.caption, this.font, this.width - 2);
            this.height = this.lines.size() * this.font.getHeight() + 2;
        }
    }

    private TextBlock(String string, Font font, int n, int n2) {
        super(string);
        if (n < 1) {
            throw new IllegalArgumentException("TextBlock() : width too small");
        }
        this.width = n;
        this.font = font;
        this.color = n2;
        this.refresh();
    }

    public TextBlock(String string, Font font, int n, int n2, int n3) {
        this(string, font, n, n2);
        this.alignment = n3;
    }
}

