/*
 * Decompiled with CFR 0.152.
 */
package de.mef.state.concrete;

import de.mef.menu.ProgressBar;
import de.mef.sound.SoundPlayer;
import de.mef.state.State;
import de.mef.state.concrete.ChooseDifficultyState;
import de.mef.state.concrete.ChooseLevelState;
import de.mef.state.concrete.ChooseTypeState;
import de.mef.state.concrete.EvalState;
import de.mef.state.concrete.GameState;
import de.mef.state.concrete.InfoState;
import de.mef.state.concrete.MainMenu;
import de.mef.state.concrete.ManualState;
import de.mef.state.concrete.OptionsState;
import de.mef.util.KeyListener;
import de.mef.util.Updateable;
import java.io.IOException;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public final class LoadingSplashState
extends State
implements KeyListener,
Updateable {
    private Image splash;
    private Image footer;
    private ProgressBar progress = new ProgressBar(10, State.canvas.getWidth() * 8 / 10, 16);
    private int runlevel = 0;

    public final void update() {
        if (this.runlevel < 10) {
            ++this.runlevel;
            this.progress.setProgress(this.runlevel);
            switch (this.runlevel) {
                case 1: {
                    State.registerState("mainmenu", new MainMenu());
                    break;
                }
                case 2: {
                    State.registerState("manual", new ManualState());
                    break;
                }
                case 3: {
                    State.registerState("info", new InfoState());
                    break;
                }
                case 4: {
                    State.registerState("game", new GameState());
                    break;
                }
                case 5: {
                    State.registerState("eval", new EvalState());
                    break;
                }
                case 6: {
                    State.registerState("chooselevel", new ChooseLevelState());
                    break;
                }
                case 7: {
                    State.registerState("options", new OptionsState());
                    break;
                }
                case 8: {
                    State.registerState("difficulty", new ChooseDifficultyState());
                    break;
                }
                case 9: {
                    State.registerState("type", new ChooseTypeState());
                    break;
                }
                case 10: {
                    SoundPlayer.playSound("/menu.mid", -1);
                    try {
                        this.splash = Image.createImage((String)"/splash.png");
                    }
                    catch (IOException iOException) {
                        try {
                            this.splash = Image.createImage((String)"/splash.jpg");
                        }
                        catch (IOException iOException2) {
                            this.splash = null;
                        }
                    }
                    try {
                        this.footer = Image.createImage((String)"/footer.png");
                        break;
                    }
                    catch (IOException iOException) {
                        this.footer = null;
                    }
                }
            }
        }
        State.repaint();
    }

    public LoadingSplashState() {
        try {
            this.splash = Image.createImage((String)"/powered.png");
            return;
        }
        catch (IOException iOException) {
            this.splash = null;
            return;
        }
    }

    public final void enter() throws Exception {
        State.repaint();
    }

    public final void paint(Graphics graphics) {
        if (this.runlevel < 10) {
            graphics.setColor(0xFFFFFF);
            graphics.fillRect(0, 0, State.canvas.getWidth(), State.canvas.getHeight());
            if (this.splash != null) {
                graphics.drawImage(this.splash, State.canvas.getWidth() / 2, State.canvas.getHeight() / 2, 3);
            }
            this.progress.paint(graphics, State.canvas.getWidth() / 2, State.canvas.getHeight() - 8, 33);
            return;
        }
        graphics.setColor(0);
        graphics.fillRect(0, 0, State.canvas.getWidth(), State.canvas.getHeight());
        if (this.splash != null) {
            graphics.drawImage(this.splash, State.canvas.getWidth() / 2, 0, 17);
        } else {
            graphics.setFont(Font.getDefaultFont());
            graphics.setColor(0xFFFFFF);
            graphics.drawString("No splash!", State.canvas.getWidth() / 2, State.canvas.getHeight() / 2, 17);
        }
        if (this.footer != null) {
            graphics.drawImage(this.footer, State.canvas.getWidth() / 2, State.canvas.getHeight() - 1, 33);
        }
    }

    public final void leave() {
        this.splash = null;
        this.footer = null;
    }

    public final void keyPressed(int n) {
        if (this.runlevel == 10) {
            State.setNamedState("mainmenu");
        }
    }

    public final void keyReleased(int n) {
    }

    public final void keyRepeated(int n) {
    }
}

