/*
 * Decompiled with CFR 0.152.
 */
public final class Real {
    long mantissa;
    int exponent;
    byte sign;
    public static boolean magicRounding = true;
    public static final Real ZERO = new Real(0, 0, 0L);
    public static final Real ONE = new Real(0, 0x40000000, 0x4000000000000000L);
    public static final Real THREE = new Real(0, 0x40000001, 0x6000000000000000L);
    public static final Real FIVE = new Real(0, 0x40000002, 0x5000000000000000L);
    public static final Real TEN = new Real(0, 0x40000003, 0x5000000000000000L);
    public static final Real SQRT2 = new Real(0, 0x40000000, 6521908912666391106L);
    public static final Real SQRT1_2 = new Real(0, 0x3FFFFFFF, 6521908912666391106L);
    public static final Real CBRT1_2 = new Real(0, 0x3FFFFFFF, 7320595236998672907L);
    public static final Real PI2 = new Real(0, 0x40000002, 7244019458077122842L);
    public static final Real PI = new Real(0, 0x40000001, 7244019458077122842L);
    public static final Real PI_2 = new Real(0, 0x40000000, 7244019458077122842L);
    public static final Real PI_4 = new Real(0, 0x3FFFFFFF, 7244019458077122842L);
    public static final Real PI_8 = new Real(0, 0x3FFFFFFE, 7244019458077122842L);
    public static final Real E = new Real(0, 0x40000001, 6267931151224907085L);
    public static final Real LN2 = new Real(0, 0x3FFFFFFF, 6393154322601327830L);
    public static final Real LN10 = new Real(0, 0x40000001, 5309399739799983627L);
    public static final Real LOG10E = new Real(0, 0x3FFFFFFE, 8011319160293570763L);
    public static final Real MAX = new Real(0, Integer.MAX_VALUE, Long.MAX_VALUE);
    public static final Real MIN = new Real(0, 0, 0x4000000000000000L);
    private static final int clz_magic = 130329821;
    private static final byte[] clz_tab = new byte[]{31, 22, 30, 21, 18, 10, 29, 2, 20, 17, 15, 13, 9, 6, 28, 1, 23, 19, 11, 3, 16, 14, 7, 24, 12, 4, 8, 25, 5, 26, 27, 0};
    private static Real tmp0 = new Real();
    private static Real recipTmp = new Real();
    private static Real recipTmp2 = new Real();
    private static Real sqrtTmp = new Real();
    private static Real expTmp = new Real();
    private static Real expTmp2 = new Real();
    private static Real expTmp3 = new Real();
    private static Real tmp1 = new Real();
    private static Real tmp2 = new Real();
    private static Real tmp3 = new Real();
    private static Real tmp4 = new Real();
    private static Real tmp5 = new Real();
    private static StringBuffer ftoaBuf = new StringBuffer(40);
    private static StringBuffer ftoaExp = new StringBuffer(15);
    public static final String hexChar = "0123456789ABCDEF";
    private static NumberFormat tmpFormat = new NumberFormat();

    public Real() {
    }

    public Real(Real real) {
        this.mantissa = real.mantissa;
        this.exponent = real.exponent;
        this.sign = real.sign;
    }

    public Real(int n) {
        this.assign(n);
    }

    public Real(String string) {
        this.assign(string, 10);
    }

    public Real(String string, int n) {
        this.assign(string, n);
    }

    public Real(int n, int n2, long l) {
        this.assign(n, n2, l);
    }

    public void assign(Real real) {
        if (real == null) {
            this.makeZero();
            return;
        }
        this.sign = real.sign;
        this.exponent = real.exponent;
        this.mantissa = real.mantissa;
    }

    public void assign(int n) {
        if (n == 0) {
            this.makeZero();
            return;
        }
        this.sign = 0;
        if (n < 0) {
            this.sign = 1;
            n = -n;
        }
        int n2 = n;
        n2 |= n2 >> 1;
        n2 |= n2 >> 2;
        n2 |= n2 >> 4;
        n2 |= n2 >> 8;
        n2 |= n2 >> 16;
        n2 = clz_tab[n2 * 130329821 >>> 27] - 1;
        this.exponent = 1073741854 - n2;
        this.mantissa = (long)n << 32 + n2;
    }

    public void assign(String string) {
        this.assign(string, 10);
    }

    public void assign(String string, int n) {
        if (string == null || string.length() == 0) {
            this.assign(ZERO);
            return;
        }
        this.atof(string, n);
    }

    public void assign(int n, int n2, long l) {
        this.sign = (byte)n;
        this.exponent = n2;
        this.mantissa = l;
    }

    public void assignFloatBits(int n) {
        this.sign = (byte)(n >>> 31);
        this.exponent = n >> 23 & 0xFF;
        this.mantissa = (long)(n & 0x7FFFFF) << 39;
        if (this.exponent == 0 && this.mantissa == 0L) {
            return;
        }
        if (this.exponent == 0 && this.mantissa != 0L) {
            this.exponent = 1073741698;
            this.normalize();
            return;
        }
        if (this.exponent <= 254) {
            this.exponent += 1073741697;
            this.mantissa |= 0x4000000000000000L;
            return;
        }
        if (this.mantissa == 0L) {
            this.makeInfinity(this.sign);
        } else {
            this.makeNan();
        }
    }

    public void makeZero() {
        this.sign = 0;
        this.mantissa = 0L;
        this.exponent = 0;
    }

    public void makeZero(int n) {
        this.sign = (byte)n;
        this.mantissa = 0L;
        this.exponent = 0;
    }

    public void makeInfinity(int n) {
        this.sign = (byte)n;
        this.mantissa = 0L;
        this.exponent = Integer.MIN_VALUE;
    }

    public void makeNan() {
        this.sign = 0;
        this.mantissa = 0x4000000000000000L;
        this.exponent = Integer.MIN_VALUE;
    }

    public boolean isZero() {
        return this.exponent == 0 && this.mantissa == 0L;
    }

    public boolean isInfinity() {
        return this.exponent < 0 && this.mantissa == 0L;
    }

    public boolean isNan() {
        return this.exponent < 0 && this.mantissa != 0L;
    }

    public boolean isFinite() {
        return this.exponent >= 0;
    }

    public boolean isFiniteNonZero() {
        return this.exponent >= 0 && this.mantissa != 0L;
    }

    public boolean isNegative() {
        return this.sign != 0;
    }

    public void abs() {
        this.sign = 0;
    }

    public void neg() {
        if (this.exponent >= 0 || this.mantissa == 0L) {
            this.sign = (byte)(this.sign ^ 1);
        }
    }

    public void copysign(Real real) {
        if (this.exponent < 0 && this.mantissa != 0L || real.exponent < 0 && real.mantissa != 0L) {
            this.makeNan();
            return;
        }
        this.sign = real.sign;
    }

    public void normalize() {
        if (this.exponent >= 0) {
            if (this.mantissa > 0L) {
                int n = 0;
                int n2 = (int)(this.mantissa >>> 32);
                if (n2 == 0) {
                    n = 32;
                    n2 = (int)this.mantissa;
                }
                n2 |= n2 >> 1;
                n2 |= n2 >> 2;
                n2 |= n2 >> 4;
                n2 |= n2 >> 8;
                n2 |= n2 >> 16;
                this.mantissa <<= (n += clz_tab[n2 * 130329821 >>> 27] - 1);
                this.exponent -= n;
                if (this.exponent < 0) {
                    this.makeZero(this.sign);
                }
            } else if (this.mantissa < 0L) {
                this.mantissa = this.mantissa + 1L >>> 1;
                ++this.exponent;
                if (this.mantissa == 0L) {
                    this.mantissa = 0x4000000000000000L;
                    ++this.exponent;
                }
                if (this.exponent < 0) {
                    this.makeInfinity(this.sign);
                }
            } else {
                this.exponent = 0;
            }
        }
    }

    /*
     * Unable to fully structure code
     */
    public long normalize128(long var1_1) {
        if (this.exponent < 0) {
            return 0L;
        }
        if (this.mantissa == 0L && var1_1 == 0L) {
            this.exponent = 0;
            return 0L;
        }
        if (this.mantissa >= 0L) ** GOTO lbl16
        var1_1 = (this.mantissa << 63) + (var1_1 >>> 1);
        this.mantissa >>>= 1;
        ++this.exponent;
        if (this.exponent < 0) {
            this.makeInfinity(this.sign);
        }
        return var1_1;
lbl-1000:
        // 1 sources

        {
            this.mantissa = (this.mantissa << 16) + (var1_1 >>> 48);
            var1_1 <<= 16;
            this.exponent -= 16;
lbl16:
            // 2 sources

            ** while (this.mantissa >>> 47 == 0L)
        }
lbl17:
        // 2 sources

        while (this.mantissa >>> 59 == 0L) {
            this.mantissa = (this.mantissa << 4) + (var1_1 >>> 60);
            var1_1 <<= 4;
            this.exponent -= 4;
        }
        while (this.mantissa >>> 62 == 0L) {
            this.mantissa = (this.mantissa << 1) + (var1_1 >>> 63);
            var1_1 <<= 1;
            --this.exponent;
        }
        if (this.exponent < 0) {
            this.makeZero(this.sign);
            return 0L;
        }
        return var1_1;
    }

    public void roundFrom128(long l) {
        this.mantissa += l >>> 63;
        this.normalize();
    }

    private int compare(Real real) {
        int n;
        if (this.exponent == 0 && this.mantissa == 0L && real.exponent == 0 && real.mantissa == 0L) {
            return 0;
        }
        if (this.sign != real.sign) {
            return real.sign - this.sign;
        }
        int n2 = n = this.sign == 0 ? 1 : -1;
        if (this.exponent < 0 && this.mantissa == 0L) {
            return n;
        }
        if (real.exponent < 0 && real.mantissa == 0L) {
            return -n;
        }
        if (this.exponent != real.exponent) {
            return this.exponent < real.exponent ? -n : n;
        }
        if (this.mantissa != real.mantissa) {
            return this.mantissa < real.mantissa ? -n : n;
        }
        return 0;
    }

    private boolean invalidCompare(Real real) {
        return this.exponent < 0 && this.mantissa != 0L || real.exponent < 0 && real.mantissa != 0L || this.exponent < 0 && this.mantissa == 0L && real.exponent < 0 && real.mantissa == 0L && this.sign == real.sign;
    }

    public boolean equalTo(Real real) {
        if (this.invalidCompare(real)) {
            return false;
        }
        return this.compare(real) == 0;
    }

    public boolean notEqualTo(Real real) {
        if (this.invalidCompare(real)) {
            return false;
        }
        return this.compare(real) != 0;
    }

    public boolean lessThan(Real real) {
        if (this.invalidCompare(real)) {
            return false;
        }
        return this.compare(real) < 0;
    }

    public boolean lessEqual(Real real) {
        if (this.invalidCompare(real)) {
            return false;
        }
        return this.compare(real) <= 0;
    }

    public boolean greaterThan(Real real) {
        if (this.invalidCompare(real)) {
            return false;
        }
        return this.compare(real) > 0;
    }

    public boolean greaterEqual(Real real) {
        if (this.invalidCompare(real)) {
            return false;
        }
        return this.compare(real) >= 0;
    }

    public boolean absLessThan(Real real) {
        if (this.exponent < 0 && this.mantissa != 0L || real.exponent < 0 && real.mantissa != 0L || this.exponent < 0 && this.mantissa == 0L) {
            return false;
        }
        if (real.exponent < 0 && real.mantissa == 0L) {
            return true;
        }
        if (this.exponent != real.exponent) {
            return this.exponent < real.exponent;
        }
        return this.mantissa < real.mantissa;
    }

    public void scalbn(int n) {
        if (this.exponent < 0 || this.mantissa == 0L) {
            return;
        }
        this.exponent += n;
        if (this.exponent < 0) {
            if (n < 0) {
                this.makeZero(this.sign);
            } else {
                this.makeInfinity(this.sign);
            }
        }
    }

    public void nextafter(Real real) {
        if (this.exponent < 0 && this.mantissa != 0L || real.exponent < 0 && real.mantissa != 0L) {
            this.makeNan();
            return;
        }
        if (this.exponent < 0 && this.mantissa == 0L && real.exponent < 0 && real.mantissa == 0L && this.sign == real.sign) {
            return;
        }
        int n = -this.compare(real);
        if (n == 0) {
            return;
        }
        if (this.exponent == 0 && this.mantissa == 0L) {
            this.mantissa = Real.MIN.mantissa;
            this.exponent = Real.MIN.exponent;
            this.sign = Real.MIN.sign;
            this.sign = (byte)(n < 0 ? 1 : 0);
            return;
        }
        if (this.exponent < 0 && this.mantissa == 0L) {
            this.mantissa = Real.MAX.mantissa;
            this.exponent = Real.MAX.exponent;
            this.sign = Real.MAX.sign;
            this.sign = (byte)(n >= 0 ? 1 : 0);
            return;
        }
        if (this.sign == 0 ^ n < 0) {
            ++this.mantissa;
        } else {
            if (this.mantissa == 0x4000000000000000L) {
                this.mantissa <<= 1;
                --this.exponent;
            }
            --this.mantissa;
        }
        this.normalize();
    }

    public void floor() {
        if (this.exponent < 0 || this.mantissa == 0L) {
            return;
        }
        if (this.exponent < 0x40000000) {
            if (this.sign == 0) {
                this.makeZero(this.sign);
            } else {
                this.exponent = Real.ONE.exponent;
                this.mantissa = Real.ONE.mantissa;
            }
            return;
        }
        int n = 1073741886 - this.exponent;
        if (n <= 0) {
            return;
        }
        if (this.sign != 0) {
            this.mantissa += (1L << n) - 1L;
        }
        this.mantissa &= (1L << n) - 1L ^ 0xFFFFFFFFFFFFFFFFL;
        if (this.sign != 0) {
            this.normalize();
        }
    }

    public void ceil() {
        this.neg();
        this.floor();
        this.neg();
    }

    public void round() {
        if (this.exponent < 0 || this.mantissa == 0L) {
            return;
        }
        if (this.exponent < 0x3FFFFFFF) {
            this.makeZero(this.sign);
            return;
        }
        int n = 1073741886 - this.exponent;
        if (n <= 0) {
            return;
        }
        this.mantissa += 1L << n - 1;
        this.mantissa &= (1L << n) - 1L ^ 0xFFFFFFFFFFFFFFFFL;
        this.normalize();
    }

    public void trunc() {
        if (this.exponent < 0 || this.mantissa == 0L) {
            return;
        }
        if (this.exponent < 0x40000000) {
            this.makeZero(this.sign);
            return;
        }
        int n = 1073741886 - this.exponent;
        if (n <= 0) {
            return;
        }
        this.mantissa &= (1L << n) - 1L ^ 0xFFFFFFFFFFFFFFFFL;
        this.normalize();
    }

    public void frac() {
        if (this.exponent < 0 || this.mantissa == 0L || this.exponent < 0x40000000) {
            return;
        }
        int n = 1073741886 - this.exponent;
        if (n <= 0) {
            this.makeZero(this.sign);
            return;
        }
        this.mantissa &= (1L << n) - 1L;
        this.normalize();
    }

    public int toInteger() {
        if (this.exponent == 0 && this.mantissa == 0L || this.exponent < 0 && this.mantissa != 0L) {
            return 0;
        }
        if (this.exponent < 0 && this.mantissa == 0L) {
            if (this.sign == 0) {
                return Integer.MAX_VALUE;
            }
            return -2147483647;
        }
        if (this.exponent < 0x40000000) {
            return 0;
        }
        int n = 1073741886 - this.exponent;
        if (n < 32) {
            if (this.sign == 0) {
                return Integer.MAX_VALUE;
            }
            return -2147483647;
        }
        return this.sign == 0 ? (int)(this.mantissa >>> n) : -((int)(this.mantissa >>> n));
    }

    public boolean isIntegral() {
        if (this.exponent < 0 && this.mantissa != 0L) {
            return false;
        }
        if (this.exponent == 0 && this.mantissa == 0L || this.exponent < 0 && this.mantissa == 0L) {
            return true;
        }
        if (this.exponent < 0x40000000) {
            return false;
        }
        int n = 1073741886 - this.exponent;
        if (n <= 0) {
            return true;
        }
        return (this.mantissa & (1L << n) - 1L) == 0L;
    }

    public boolean isOdd() {
        if (this.exponent < 0 || this.mantissa == 0L || this.exponent < 0x40000000 || this.exponent > 1073741886) {
            return false;
        }
        int n = 1073741886 - this.exponent;
        return (this.mantissa >>> n & 1L) != 0L;
    }

    public void add(Real real) {
        long l;
        int n;
        byte by;
        if (this.exponent < 0 && this.mantissa != 0L || real.exponent < 0 && real.mantissa != 0L) {
            this.makeNan();
            return;
        }
        if (this.exponent < 0 && this.mantissa == 0L || real.exponent < 0 && real.mantissa == 0L) {
            if (this.exponent < 0 && this.mantissa == 0L && real.exponent < 0 && real.mantissa == 0L && this.sign != real.sign) {
                this.makeNan();
            } else {
                this.makeInfinity(this.exponent < 0 && this.mantissa == 0L ? this.sign : real.sign);
            }
            return;
        }
        if (this.exponent == 0 && this.mantissa == 0L || real.exponent == 0 && real.mantissa == 0L) {
            if (this.exponent == 0 && this.mantissa == 0L) {
                this.mantissa = real.mantissa;
                this.exponent = real.exponent;
                this.sign = real.sign;
            }
            if (this.exponent == 0 && this.mantissa == 0L) {
                this.sign = 0;
            }
            return;
        }
        if (this.exponent > real.exponent || this.exponent == real.exponent && this.mantissa >= real.mantissa) {
            by = real.sign;
            n = real.exponent;
            l = real.mantissa;
        } else {
            by = this.sign;
            n = this.exponent;
            l = this.mantissa;
            this.sign = real.sign;
            this.exponent = real.exponent;
            this.mantissa = real.mantissa;
        }
        int n2 = this.exponent - n;
        if (n2 >= 64) {
            return;
        }
        if (this.sign == by) {
            this.mantissa += l >>> n2;
            if (this.mantissa >= 0L && n2 > 0 && (l >>> n2 - 1 & 1L) != 0L) {
                ++this.mantissa;
            }
            if (this.mantissa < 0L) {
                this.mantissa = this.mantissa + 1L >>> 1;
                ++this.exponent;
                if (this.exponent < 0) {
                    this.makeInfinity(this.sign);
                    return;
                }
            }
        } else {
            if (n2 > 0) {
                this.mantissa <<= 1;
                --this.exponent;
                --n2;
            }
            l = -l;
            this.mantissa += l >> n2;
            if (this.mantissa >= 0L && n2 > 0 && (l >>> n2 - 1 & 1L) != 0L) {
                ++this.mantissa;
            }
            if (this.mantissa < 0L) {
                this.mantissa = this.mantissa + 1L >>> 1;
                ++this.exponent;
            } else {
                if (magicRounding && this.mantissa >= 0L && this.mantissa <= 7L) {
                    this.mantissa = 0L;
                }
                this.normalize();
            }
        }
        if (this.exponent == 0 && this.mantissa == 0L) {
            this.sign = 0;
        }
    }

    public long add128(long l, Real real, long l2) {
        long l3;
        long l4;
        int n;
        byte by;
        if (this.exponent < 0 && this.mantissa != 0L || real.exponent < 0 && real.mantissa != 0L) {
            this.makeNan();
            return 0L;
        }
        if (this.exponent < 0 && this.mantissa == 0L || real.exponent < 0 && real.mantissa == 0L) {
            if (this.exponent < 0 && this.mantissa == 0L && real.exponent < 0 && real.mantissa == 0L && this.sign != real.sign) {
                this.makeNan();
            } else {
                this.makeInfinity(this.exponent < 0 && this.mantissa == 0L ? this.sign : real.sign);
            }
            return 0L;
        }
        if (this.exponent == 0 && this.mantissa == 0L || real.exponent == 0 && real.mantissa == 0L) {
            if (this.exponent == 0 && this.mantissa == 0L) {
                this.mantissa = real.mantissa;
                this.exponent = real.exponent;
                this.sign = real.sign;
                l = l2;
            }
            if (this.exponent == 0 && this.mantissa == 0L) {
                this.sign = 0;
            }
            return l;
        }
        if (this.exponent > real.exponent || this.exponent == real.exponent && this.mantissa > real.mantissa || this.exponent == real.exponent && this.mantissa == real.mantissa && l >>> 1 >= l2 >>> 1) {
            by = real.sign;
            n = real.exponent;
            l4 = real.mantissa;
            l3 = l2;
        } else {
            by = this.sign;
            n = this.exponent;
            l4 = this.mantissa;
            l3 = l;
            this.sign = real.sign;
            this.exponent = real.exponent;
            this.mantissa = real.mantissa;
            l = l2;
        }
        int n2 = this.exponent - n;
        if (n2 >= 127) {
            return l;
        }
        if (n2 >= 64) {
            l3 = l4 >>> n2 - 64;
            l4 = 0L;
        } else if (n2 > 0) {
            l3 = (l3 >>> n2) + (l4 << 64 - n2);
            l4 >>>= n2;
        }
        l >>>= 1;
        l3 >>>= 1;
        if (this.sign == by) {
            this.mantissa += (l += l3) >>> 63;
            this.mantissa += l4;
        } else {
            this.mantissa -= (l -= l3) >>> 63;
            this.mantissa -= l4;
            if (this.mantissa == 0L && l >= 0L && l <= 31L) {
                l = 0L;
            }
        }
        l <<= 1;
        l = this.normalize128(l);
        if (this.exponent == 0 && this.mantissa == 0L) {
            this.sign = 0;
        }
        return l;
    }

    public void sub(Real real) {
        Real.tmp0.mantissa = real.mantissa;
        Real.tmp0.exponent = real.exponent;
        Real.tmp0.sign = (byte)(real.sign ^ 1);
        this.add(tmp0);
    }

    public void mul(int n) {
        if (this.exponent < 0 && this.mantissa != 0L) {
            return;
        }
        if (n < 0) {
            this.sign = (byte)(this.sign ^ 1);
            n = -n;
        }
        if (this.exponent == 0 && this.mantissa == 0L || n == 0) {
            if (this.exponent < 0 && this.mantissa == 0L) {
                this.makeNan();
            } else {
                this.makeZero(this.sign);
            }
            return;
        }
        if (this.exponent < 0 && this.mantissa == 0L) {
            return;
        }
        int n2 = n;
        n2 |= n2 >> 1;
        n2 |= n2 >> 2;
        n2 |= n2 >> 4;
        n2 |= n2 >> 8;
        n2 |= n2 >> 16;
        n2 = clz_tab[n2 * 130329821 >>> 27];
        this.exponent += 31 - n2;
        n <<= n2;
        if (this.exponent < 0) {
            this.makeInfinity(this.sign);
            return;
        }
        long l = this.mantissa & Integer.MAX_VALUE;
        long l2 = this.mantissa >>> 31;
        long l3 = (long)n & 0xFFFFFFFFL;
        this.mantissa = l2 * l3;
        int n3 = this.mantissa < 0L ? 0 : 0x40000000;
        this.mantissa += l * l3 + (long)n3 >>> 31;
        if (this.mantissa < 0L) {
            this.mantissa = this.mantissa + 1L >>> 1;
            ++this.exponent;
            if (this.exponent < 0) {
                this.makeInfinity(this.sign);
            }
        }
    }

    public void mul(Real real) {
        if (this.exponent < 0 && this.mantissa != 0L || real.exponent < 0 && real.mantissa != 0L) {
            this.makeNan();
            return;
        }
        this.sign = (byte)(this.sign ^ real.sign);
        if (this.exponent == 0 && this.mantissa == 0L || real.exponent == 0 && real.mantissa == 0L) {
            if (this.exponent < 0 && this.mantissa == 0L || real.exponent < 0 && real.mantissa == 0L) {
                this.makeNan();
            } else {
                this.makeZero(this.sign);
            }
            return;
        }
        if (this.exponent < 0 && this.mantissa == 0L || real.exponent < 0 && real.mantissa == 0L) {
            this.makeInfinity(this.sign);
            return;
        }
        long l = this.mantissa & Integer.MAX_VALUE;
        long l2 = this.mantissa >>> 31;
        long l3 = real.mantissa & Integer.MAX_VALUE;
        long l4 = real.mantissa >>> 31;
        this.mantissa = l2 * l4;
        int n = this.mantissa < 0L ? 0 : 0x40000000;
        this.mantissa += l * l4 + l2 * l3 + (l * l3 >>> 31) + (long)n >>> 31;
        int n2 = real.exponent;
        this.exponent += n2 - 0x40000000;
        if (this.exponent < 0 && (this.exponent != -1 || n2 >= 0x40000000 || this.mantissa >= 0L)) {
            if (n2 < 0x40000000) {
                this.makeZero(this.sign);
            } else {
                this.makeInfinity(this.sign);
            }
            return;
        }
        if (this.mantissa < 0L) {
            this.mantissa = this.mantissa + 1L >>> 1;
            ++this.exponent;
            if (this.exponent < 0) {
                this.makeInfinity(this.sign);
            }
        }
    }

    public long mul128(long l, Real real, long l2) {
        if (this.exponent < 0 && this.mantissa != 0L || real.exponent < 0 && real.mantissa != 0L) {
            this.makeNan();
            return 0L;
        }
        this.sign = (byte)(this.sign ^ real.sign);
        if (this.exponent == 0 && this.mantissa == 0L || real.exponent == 0 && real.mantissa == 0L) {
            if (this.exponent < 0 && this.mantissa == 0L || real.exponent < 0 && real.mantissa == 0L) {
                this.makeNan();
            } else {
                this.makeZero(this.sign);
            }
            return 0L;
        }
        if (this.exponent < 0 && this.mantissa == 0L || real.exponent < 0 && real.mantissa == 0L) {
            this.makeInfinity(this.sign);
            return 0L;
        }
        int n = real.exponent;
        this.exponent += n - 0x40000000;
        if (this.exponent < 0) {
            if (n < 0x40000000) {
                this.makeZero(this.sign);
            } else {
                this.makeInfinity(this.sign);
            }
            return 0L;
        }
        long l3 = 0xFFFFFFFFL;
        long l4 = l & l3;
        long l5 = l >>> 32;
        long l6 = this.mantissa & l3;
        long l7 = this.mantissa >>> 32;
        long l8 = l2 & l3;
        long l9 = l2 >>> 32;
        long l10 = real.mantissa & l3;
        long l11 = real.mantissa >>> 32;
        l4 = (l7 * l8 >>> 2) + (l6 * l9 >>> 2) + (l5 * l10 >>> 2) + (l4 * l11 >>> 2) + 0x60000000L >>> 28;
        l8 = l6 * l10;
        l5 = ((l4 += ((l5 *= l11) << 2 & l3) + (l8 << 2 & l3) + ((l9 *= l7) << 2 & l3)) >>> 32) + (l5 >>> 30) + (l8 >>> 30) + (l9 >>> 30);
        l = ((l5 += ((l6 *= l11) << 2 & l3) + ((l10 *= l7) << 2 & l3)) << 32) + (l4 &= l3);
        this.mantissa = (l7 * l11 << 2) + (l5 >>> 32) + (l6 >>> 30) + (l10 >>> 30);
        l = this.normalize128(l);
        return l;
    }

    private void mul10() {
        if (this.exponent < 0 || this.mantissa == 0L) {
            return;
        }
        this.mantissa += this.mantissa + 2L >>> 2;
        this.exponent += 3;
        if (this.mantissa < 0L) {
            this.mantissa = this.mantissa + 1L >>> 1;
            ++this.exponent;
        }
        if (this.exponent < 0) {
            this.makeInfinity(this.sign);
        }
    }

    public void sqr() {
        this.sign = 0;
        if (this.exponent < 0 || this.mantissa == 0L) {
            return;
        }
        int n = this.exponent;
        this.exponent += this.exponent - 0x40000000;
        if (this.exponent < 0) {
            if (n < 0x40000000) {
                this.makeZero(this.sign);
            } else {
                this.makeInfinity(this.sign);
            }
            return;
        }
        long l = this.mantissa & Integer.MAX_VALUE;
        long l2 = this.mantissa >>> 31;
        this.mantissa = l2 * l2;
        int n2 = this.mantissa < 0L ? 0 : 0x40000000;
        this.mantissa += (l * l2 << 1) + (l * l >>> 31) + (long)n2 >>> 31;
        if (this.mantissa < 0L) {
            this.mantissa = this.mantissa + 1L >>> 1;
            ++this.exponent;
            if (this.exponent < 0) {
                this.makeInfinity(this.sign);
            }
        }
    }

    public void div(int n) {
        if (this.exponent < 0 && this.mantissa != 0L) {
            return;
        }
        if (n < 0) {
            this.sign = (byte)(this.sign ^ 1);
            n = -n;
        }
        if (this.exponent < 0 && this.mantissa == 0L) {
            return;
        }
        if (this.exponent == 0 && this.mantissa == 0L) {
            if (n == 0) {
                this.makeNan();
            }
            return;
        }
        if (n == 0) {
            this.makeInfinity(this.sign);
            return;
        }
        long l = (long)n & 0xFFFFFFFFL;
        long l2 = this.mantissa % l;
        this.mantissa /= l;
        int n2 = 0;
        int n3 = (int)(this.mantissa >>> 32);
        if (n3 == 0) {
            n2 = 32;
            n3 = (int)this.mantissa;
        }
        n3 |= n3 >> 1;
        n3 |= n3 >> 2;
        n3 |= n3 >> 4;
        n3 |= n3 >> 8;
        n3 |= n3 >> 16;
        this.mantissa <<= (n2 += clz_tab[n3 * 130329821 >>> 27] - 1);
        l2 <<= n2;
        this.exponent -= n2;
        l2 = (l2 + l / 2L) / l;
        this.mantissa += l2;
        if (this.exponent < 0) {
            this.makeZero(this.sign);
        }
    }

    public static long ldiv(long l, long l2) {
        int n = (int)(0x400000000000L / ((l2 >>> 40) + 1L));
        int n2 = (int)(l >>> 40);
        l <<= 20;
        int n3 = (int)((long)n2 * (long)n >>> 26);
        long l3 = n3;
        n2 = (int)((l -= (long)n3 * l2) >>> 39);
        l <<= 21;
        n3 = (int)((long)n2 * (long)n >>> 26);
        l3 = (l3 << 21) + (long)n3;
        n2 = (int)((l -= (long)n3 * l2) >>> 39);
        l <<= 21;
        n3 = (int)((long)n2 * (long)n >>> 26);
        l3 = (l3 << 21) + (long)n3;
        if ((l -= (long)n3 * l2) < 0L || l >= l2) {
            ++l3;
            l -= l2;
        }
        if ((l <<= 1) < 0L || l >= l2) {
            ++l3;
        }
        return l3;
    }

    public void div(Real real) {
        if (this.exponent < 0 && this.mantissa != 0L || real.exponent < 0 && real.mantissa != 0L) {
            this.makeNan();
            return;
        }
        this.sign = (byte)(this.sign ^ real.sign);
        if (this.exponent < 0 && this.mantissa == 0L) {
            if (real.exponent < 0 && real.mantissa == 0L) {
                this.makeNan();
            }
            return;
        }
        if (real.exponent < 0 && real.mantissa == 0L) {
            this.makeZero(this.sign);
            return;
        }
        if (this.exponent == 0 && this.mantissa == 0L) {
            if (real.exponent == 0 && real.mantissa == 0L) {
                this.makeNan();
            }
            return;
        }
        if (real.exponent == 0 && real.mantissa == 0L) {
            this.makeInfinity(this.sign);
            return;
        }
        this.exponent += 0x40000000 - real.exponent;
        if (this.mantissa < real.mantissa) {
            this.mantissa <<= 1;
            --this.exponent;
        }
        if (this.exponent < 0) {
            if (real.exponent >= 0x40000000) {
                this.makeZero(this.sign);
            } else {
                this.makeInfinity(this.sign);
            }
            return;
        }
        if (real.mantissa == 0x4000000000000000L) {
            return;
        }
        this.mantissa = Real.ldiv(this.mantissa, real.mantissa);
    }

    public void recip() {
        if (this.exponent < 0 && this.mantissa != 0L) {
            return;
        }
        if (this.exponent < 0 && this.mantissa == 0L) {
            this.makeZero(this.sign);
            return;
        }
        if (this.exponent == 0 && this.mantissa == 0L) {
            this.makeInfinity(this.sign);
            return;
        }
        this.exponent = Integer.MIN_VALUE - this.exponent;
        if (this.mantissa == 0x4000000000000000L) {
            if (this.exponent < 0) {
                this.makeInfinity(this.sign);
            }
            return;
        }
        --this.exponent;
        this.mantissa = Real.ldiv(Long.MIN_VALUE, this.mantissa);
    }

    public long recip128(long l) {
        if (this.exponent < 0 && this.mantissa != 0L) {
            return 0L;
        }
        if (this.exponent < 0 && this.mantissa == 0L) {
            this.makeZero(this.sign);
            return 0L;
        }
        if (this.exponent == 0 && this.mantissa == 0L) {
            this.makeInfinity(this.sign);
            return 0L;
        }
        byte by = this.sign;
        this.sign = 0;
        if (this.mantissa == 0x4000000000000000L && l == 0L) {
            this.exponent = Integer.MIN_VALUE - this.exponent;
            if (this.exponent < 0) {
                this.makeInfinity(by);
            }
            return 0L;
        }
        int n = 0x40000000 - this.exponent;
        this.exponent = 0x40000000;
        Real.recipTmp.mantissa = this.mantissa;
        Real.recipTmp.exponent = this.exponent;
        Real.recipTmp.sign = this.sign;
        long l2 = l;
        recipTmp.neg();
        this.recip();
        Real.recipTmp2.mantissa = this.mantissa;
        Real.recipTmp2.exponent = this.exponent;
        Real.recipTmp2.sign = this.sign;
        l = this.mul128(0L, recipTmp, l2);
        l = this.add128(l, ONE, 0L);
        l = this.mul128(l, recipTmp2, 0L);
        l = this.add128(l, recipTmp2, 0L);
        this.scalbn(n);
        if (!this.isNan()) {
            this.sign = by;
        }
        return l;
    }

    private void modInternal(Real real, long l) {
        Real.tmp0.mantissa = real.mantissa;
        Real.tmp0.exponent = real.exponent;
        Real.tmp0.sign = real.sign;
        long l2 = tmp0.recip128(l);
        l2 = tmp0.mul128(l2, this, 0L);
        if (Real.tmp0.exponent > 1073741886) {
            this.makeZero(real.sign);
            return;
        }
        if (Real.tmp0.sign != 0 && (l2 < 0L || l2 > 31L) || Real.tmp0.sign == 0 && l2 < 0L && l2 > -32L) {
            ++Real.tmp0.mantissa;
            tmp0.normalize();
        }
        tmp0.floor();
        tmp0.neg();
        l2 = tmp0.mul128(0L, real, l);
        l2 = this.add128(0L, tmp0, l2);
        this.roundFrom128(l2);
    }

    public void add(int n) {
        tmp0.assign(n);
        this.add(tmp0);
    }

    private void rsqrtInternal() {
        Real.recipTmp.mantissa = this.mantissa;
        Real.recipTmp.exponent = this.exponent;
        Real.recipTmp.sign = this.sign;
        recipTmp.neg();
        this.mantissa = 5647513932722601984L - (this.mantissa >>> 2);
        boolean bl = (this.exponent & 1) != 0;
        this.exponent = 0x60000000 - (this.exponent >> 1);
        this.normalize();
        if (bl) {
            this.mul(SQRT1_2);
        }
        int n = 0;
        while (n < 4) {
            Real.recipTmp2.mantissa = this.mantissa;
            Real.recipTmp2.exponent = this.exponent;
            Real.recipTmp2.sign = this.sign;
            this.sqr();
            this.mul(recipTmp);
            this.add(ONE);
            this.scalbn(-1);
            this.mul(recipTmp2);
            this.add(recipTmp2);
            ++n;
        }
    }

    public void rsqrt() {
        if (this.exponent < 0 && this.mantissa != 0L) {
            return;
        }
        if (this.exponent == 0 && this.mantissa == 0L) {
            this.makeInfinity(0);
            return;
        }
        if (this.sign != 0) {
            this.makeNan();
            return;
        }
        if (this.exponent < 0 && this.mantissa == 0L) {
            this.makeZero(this.sign);
            return;
        }
        this.rsqrtInternal();
    }

    public void sqrt() {
        if (this.exponent < 0 && this.mantissa != 0L) {
            return;
        }
        if (this.exponent == 0 && this.mantissa == 0L) {
            this.sign = 0;
            return;
        }
        if (this.sign != 0) {
            this.makeNan();
            return;
        }
        if (this.exponent < 0 && this.mantissa == 0L) {
            return;
        }
        Real.sqrtTmp.mantissa = this.mantissa;
        Real.sqrtTmp.exponent = this.exponent;
        Real.sqrtTmp.sign = this.sign;
        sqrtTmp.rsqrtInternal();
        this.mul(sqrtTmp);
    }

    private void exp2Internal(long l) {
        if (this.exponent < 0 && this.mantissa != 0L) {
            return;
        }
        if (this.exponent < 0 && this.mantissa == 0L) {
            if (this.sign != 0) {
                this.makeZero(0);
            }
            return;
        }
        if (this.exponent == 0 && this.mantissa == 0L) {
            this.mantissa = Real.ONE.mantissa;
            this.exponent = Real.ONE.exponent;
            this.sign = Real.ONE.sign;
            return;
        }
        Real.expTmp.mantissa = this.mantissa;
        Real.expTmp.exponent = this.exponent;
        Real.expTmp.sign = this.sign;
        if (Real.expTmp.sign != 0 && l != 0L) {
            ++Real.expTmp.mantissa;
            expTmp.normalize();
        }
        expTmp.floor();
        int n = expTmp.toInteger();
        if (n >= 0x40000000) {
            this.makeInfinity(this.sign);
            return;
        }
        if (n < -1073741824) {
            this.makeZero(this.sign);
            return;
        }
        expTmp.neg();
        l = this.add128(l, expTmp, 0L);
        expTmp.assign(0, 0x3FFFFFFF, 6393154322601327829L);
        l = this.mul128(l, expTmp, -1949537693445031080L);
        this.roundFrom128(l);
        Real.expTmp.mantissa = this.mantissa;
        Real.expTmp.exponent = this.exponent;
        Real.expTmp.sign = this.sign;
        Real.expTmp2.mantissa = Real.ONE.mantissa;
        Real.expTmp2.exponent = Real.ONE.exponent;
        Real.expTmp2.sign = Real.ONE.sign;
        int n2 = 18;
        while (n2 >= 2) {
            expTmp2.mul(n2);
            this.add(expTmp2);
            this.mul(expTmp);
            --n2;
        }
        this.div(expTmp2);
        this.add(ONE);
        this.exponent += n;
    }

    public void exp() {
        expTmp.assign(0, 0x40000000, 6653256548922161245L);
        long l = this.mul128(0L, expTmp, -2358760956788564156L);
        this.exp2Internal(l);
    }

    private void lnInternal() {
        Real.expTmp.mantissa = this.mantissa;
        Real.expTmp.exponent = this.exponent;
        Real.expTmp.sign = this.sign;
        expTmp.add(ONE);
        this.sub(ONE);
        this.div(expTmp);
        Real.expTmp.mantissa = this.mantissa;
        Real.expTmp.exponent = this.exponent;
        Real.expTmp.sign = this.sign;
        Real.expTmp2.mantissa = this.mantissa;
        Real.expTmp2.exponent = this.exponent;
        Real.expTmp2.sign = this.sign;
        expTmp2.sqr();
        this.mantissa = Real.ONE.mantissa;
        this.exponent = Real.ONE.exponent;
        this.sign = Real.ONE.sign;
        Real.expTmp3.mantissa = Real.ONE.mantissa;
        Real.expTmp3.exponent = Real.ONE.exponent;
        Real.expTmp3.sign = Real.ONE.sign;
        int n = 37;
        while (n >= 3) {
            this.mul(expTmp2);
            this.mul(n - 2);
            expTmp3.mul(n);
            this.add(expTmp3);
            n -= 2;
        }
        this.mul(expTmp);
        this.div(expTmp3);
        this.scalbn(1);
    }

    public void ln() {
        if (this.exponent < 0 && this.mantissa != 0L) {
            return;
        }
        if (this.sign != 0) {
            this.makeNan();
            return;
        }
        if (this.exponent == 0 && this.mantissa == 0L) {
            this.makeInfinity(1);
            return;
        }
        if (this.exponent < 0 && this.mantissa == 0L) {
            return;
        }
        int n = this.exponent - 0x40000000;
        this.exponent = 0x40000000;
        this.lnInternal();
        expTmp.assign(n);
        expTmp.mul(LN2);
        this.add(expTmp);
    }

    public void log10() {
        if (this.exponent < 0 && this.mantissa != 0L) {
            return;
        }
        if (this.sign != 0) {
            this.makeNan();
            return;
        }
        if (this.exponent == 0 && this.mantissa == 0L) {
            this.makeInfinity(1);
            return;
        }
        if (this.exponent < 0 && this.mantissa == 0L) {
            return;
        }
        int n = this.exponent - 0x40000000;
        this.exponent = 0x40000000;
        this.lnInternal();
        expTmp.assign(n);
        expTmp.mul(LN2);
        this.add(expTmp);
        this.mul(LOG10E);
    }

    public int lowPow10() {
        if (this.exponent < 0 || this.mantissa == 0L) {
            return 0;
        }
        Real.tmp2.mantissa = this.mantissa;
        Real.tmp2.exponent = this.exponent;
        Real.tmp2.sign = this.sign;
        int n = this.exponent - 0x40000000;
        n = n < 0 ? -((int)((long)(-n) * 1292913987L + 0xFFFFFFFFL >> 32)) : (int)((long)n * 1292913987L >> 32);
        this.mantissa = Real.TEN.mantissa;
        this.exponent = Real.TEN.exponent;
        this.sign = Real.TEN.sign;
        this.pow(n);
        Real.tmp3.mantissa = this.mantissa;
        Real.tmp3.exponent = this.exponent;
        Real.tmp3.sign = this.sign;
        tmp3.mul10();
        if (tmp3.compare(tmp2) <= 0) {
            ++n;
            this.mantissa = Real.tmp3.mantissa;
            this.exponent = Real.tmp3.exponent;
            this.sign = Real.tmp3.sign;
        }
        return n;
    }

    public void pow(int n) {
        boolean bl = false;
        if (n < 0) {
            n = -n;
            bl = true;
        }
        long l = 0L;
        long l2 = 0L;
        Real.expTmp.mantissa = this.mantissa;
        Real.expTmp.exponent = this.exponent;
        Real.expTmp.sign = this.sign;
        this.mantissa = Real.ONE.mantissa;
        this.exponent = Real.ONE.exponent;
        this.sign = Real.ONE.sign;
        while (n != 0) {
            if ((n & 1) != 0) {
                l = this.mul128(l, expTmp, l2);
            }
            l2 = expTmp.mul128(l2, expTmp, l2);
            n >>>= 1;
        }
        if (bl) {
            l = this.recip128(l);
        }
        this.roundFrom128(l);
    }

    public void pow(Real real) {
        if (real.exponent == 0 && real.mantissa == 0L) {
            this.mantissa = Real.ONE.mantissa;
            this.exponent = Real.ONE.exponent;
            this.sign = Real.ONE.sign;
            return;
        }
        if (this.exponent < 0 && this.mantissa != 0L || real.exponent < 0 && real.mantissa != 0L) {
            this.makeNan();
            return;
        }
        if (real.compare(ONE) == 0) {
            return;
        }
        if (real.exponent < 0 && real.mantissa == 0L) {
            Real.tmp1.mantissa = this.mantissa;
            Real.tmp1.exponent = this.exponent;
            Real.tmp1.sign = this.sign;
            tmp1.abs();
            int n = tmp1.compare(ONE);
            if (n > 0) {
                if (real.sign == 0) {
                    this.makeInfinity(0);
                } else {
                    this.makeZero();
                }
            } else if (n < 0) {
                if (real.sign != 0) {
                    this.makeInfinity(0);
                } else {
                    this.makeZero();
                }
            } else {
                this.makeNan();
            }
            return;
        }
        if (this.exponent == 0 && this.mantissa == 0L) {
            if (this.sign == 0) {
                if (real.sign == 0) {
                    this.makeZero();
                } else {
                    this.makeInfinity(0);
                }
            } else if (real.isIntegral() && real.isOdd()) {
                if (real.sign == 0) {
                    this.makeZero(1);
                } else {
                    this.makeInfinity(1);
                }
            } else if (real.sign == 0) {
                this.makeZero();
            } else {
                this.makeInfinity(0);
            }
            return;
        }
        if (this.exponent < 0 && this.mantissa == 0L) {
            if (this.sign == 0) {
                if (real.sign == 0) {
                    this.makeInfinity(0);
                } else {
                    this.makeZero();
                }
            } else if (real.isIntegral()) {
                if (real.isOdd()) {
                    if (real.sign == 0) {
                        this.makeInfinity(1);
                    } else {
                        this.makeZero(1);
                    }
                } else if (real.sign == 0) {
                    this.makeInfinity(0);
                } else {
                    this.makeZero();
                }
            } else {
                this.makeNan();
            }
            return;
        }
        if (real.isIntegral() && real.exponent <= 1073741854) {
            this.pow(real.toInteger());
            return;
        }
        byte by = 0;
        if (this.sign != 0) {
            if (real.isIntegral()) {
                if (real.isOdd()) {
                    by = 1;
                }
            } else {
                this.makeNan();
                return;
            }
            this.sign = 0;
        }
        Real.tmp1.mantissa = real.mantissa;
        Real.tmp1.exponent = real.exponent;
        Real.tmp1.sign = real.sign;
        if (Real.tmp1.exponent <= 1073741854) {
            Real.tmp2.mantissa = Real.tmp1.mantissa;
            Real.tmp2.exponent = Real.tmp1.exponent;
            Real.tmp2.sign = Real.tmp1.sign;
            tmp2.floor();
            Real.tmp3.mantissa = this.mantissa;
            Real.tmp3.exponent = this.exponent;
            Real.tmp3.sign = this.sign;
            tmp3.pow(tmp2.toInteger());
            tmp1.sub(tmp2);
        } else {
            Real.tmp3.mantissa = Real.ONE.mantissa;
            Real.tmp3.exponent = Real.ONE.exponent;
            Real.tmp3.sign = Real.ONE.sign;
        }
        int n = this.exponent - 0x40000000;
        this.exponent = 0x40000000;
        this.lnInternal();
        tmp2.assign(0, 0x40000000, 6653256548922161245L);
        long l = this.mul128(0L, tmp2, -2358760956788564156L);
        tmp2.assign(n);
        l = this.add128(l, tmp2, 0L);
        l = tmp1.mul128(0L, this, l);
        tmp1.exp2Internal(l);
        this.mantissa = Real.tmp1.mantissa;
        this.exponent = Real.tmp1.exponent;
        this.sign = Real.tmp1.sign;
        this.mul(tmp3);
        if (this.exponent >= 0 || this.mantissa == 0L) {
            this.sign = by;
        }
    }

    private void sinInternal() {
        Real.tmp1.mantissa = this.mantissa;
        Real.tmp1.exponent = this.exponent;
        Real.tmp1.sign = this.sign;
        Real.tmp2.mantissa = this.mantissa;
        Real.tmp2.exponent = this.exponent;
        Real.tmp2.sign = this.sign;
        tmp2.sqr();
        tmp2.neg();
        this.mantissa = Real.ONE.mantissa;
        this.exponent = Real.ONE.exponent;
        this.sign = Real.ONE.sign;
        Real.tmp3.mantissa = Real.ONE.mantissa;
        Real.tmp3.exponent = Real.ONE.exponent;
        Real.tmp3.sign = Real.ONE.sign;
        int n = 19;
        while (n >= 3) {
            this.mul(tmp2);
            tmp3.mul(n * (n - 1));
            this.add(tmp3);
            n -= 2;
        }
        this.mul(tmp1);
        this.div(tmp3);
    }

    private void cosInternal() {
        Real.tmp1.mantissa = this.mantissa;
        Real.tmp1.exponent = this.exponent;
        Real.tmp1.sign = this.sign;
        Real.tmp2.mantissa = this.mantissa;
        Real.tmp2.exponent = this.exponent;
        Real.tmp2.sign = this.sign;
        tmp2.sqr();
        tmp2.neg();
        this.mantissa = Real.tmp2.mantissa;
        this.exponent = Real.tmp2.exponent;
        this.sign = Real.tmp2.sign;
        Real.tmp3.mantissa = Real.ONE.mantissa;
        Real.tmp3.exponent = Real.ONE.exponent;
        Real.tmp3.sign = Real.ONE.sign;
        int n = 18;
        while (n >= 4) {
            tmp3.mul(n * (n - 1));
            this.add(tmp3);
            this.mul(tmp2);
            n -= 2;
        }
        tmp3.scalbn(1);
        this.div(tmp3);
        this.add(ONE);
    }

    public void sin() {
        if (this.exponent < 0 || this.mantissa == 0L) {
            if (this.exponent != 0 || this.mantissa != 0L) {
                this.makeNan();
            }
            return;
        }
        boolean bl = false;
        if (this.sign != 0) {
            this.abs();
            bl = true;
        }
        if (this.compare(PI2) > 0) {
            this.modInternal(PI2, 7089564414062235241L);
        }
        if (this.compare(PI) > 0) {
            this.sub(PI2);
            this.neg();
            boolean bl2 = bl = !bl;
        }
        if (this.compare(PI_2) > 0) {
            this.sub(PI);
            this.neg();
        }
        if (this.compare(PI_4) > 0) {
            this.sub(PI_2);
            this.neg();
            this.cosInternal();
        } else {
            this.sinInternal();
        }
        if (bl) {
            this.neg();
        }
        if (this.exponent == 0 && this.mantissa == 0L) {
            this.abs();
        }
    }

    public void cos() {
        if (this.exponent == 0 && this.mantissa == 0L) {
            this.mantissa = Real.ONE.mantissa;
            this.exponent = Real.ONE.exponent;
            this.sign = Real.ONE.sign;
            return;
        }
        if (this.sign != 0) {
            this.abs();
        }
        if (this.compare(PI_4) < 0) {
            this.cosInternal();
        } else {
            this.add(PI_2);
            this.sin();
        }
    }

    public void tan() {
        Real.tmp4.mantissa = this.mantissa;
        Real.tmp4.exponent = this.exponent;
        Real.tmp4.sign = this.sign;
        tmp4.cos();
        this.sin();
        this.div(tmp4);
    }

    public void asin() {
        Real.tmp1.mantissa = this.mantissa;
        Real.tmp1.exponent = this.exponent;
        Real.tmp1.sign = this.sign;
        this.sqr();
        this.neg();
        this.add(ONE);
        this.rsqrt();
        this.mul(tmp1);
        this.atan();
    }

    public void acos() {
        boolean bl = this.sign != 0;
        this.abs();
        Real.tmp1.mantissa = this.mantissa;
        Real.tmp1.exponent = this.exponent;
        Real.tmp1.sign = this.sign;
        this.sqr();
        this.neg();
        this.add(ONE);
        this.sqrt();
        this.div(tmp1);
        this.atan();
        if (bl) {
            this.neg();
            this.add(PI);
        }
    }

    private void atanInternal() {
        Real.tmp1.mantissa = this.mantissa;
        Real.tmp1.exponent = this.exponent;
        Real.tmp1.sign = this.sign;
        Real.tmp2.mantissa = this.mantissa;
        Real.tmp2.exponent = this.exponent;
        Real.tmp2.sign = this.sign;
        tmp2.sqr();
        tmp2.neg();
        this.mantissa = Real.ONE.mantissa;
        this.exponent = Real.ONE.exponent;
        this.sign = Real.ONE.sign;
        Real.tmp3.mantissa = Real.ONE.mantissa;
        Real.tmp3.exponent = Real.ONE.exponent;
        Real.tmp3.sign = Real.ONE.sign;
        int n = 45;
        while (n >= 3) {
            this.mul(tmp2);
            this.mul(n - 2);
            tmp3.mul(n);
            this.add(tmp3);
            n -= 2;
        }
        this.mul(tmp1);
        this.div(tmp3);
    }

    public void atan() {
        if (this.exponent == 0 && this.mantissa == 0L || this.exponent < 0 && this.mantissa != 0L) {
            return;
        }
        if (this.exponent < 0 && this.mantissa == 0L) {
            byte by = this.sign;
            this.mantissa = Real.PI_2.mantissa;
            this.exponent = Real.PI_2.exponent;
            this.sign = Real.PI_2.sign;
            this.sign = by;
            return;
        }
        byte by = this.sign;
        this.sign = 0;
        boolean bl = false;
        if (this.compare(ONE) > 0) {
            bl = true;
            this.recip();
        }
        Real.tmp1.mantissa = Real.SQRT2.mantissa;
        Real.tmp1.exponent = Real.SQRT2.exponent;
        Real.tmp1.sign = Real.SQRT2.sign;
        tmp1.sub(ONE);
        boolean bl2 = false;
        if (this.compare(tmp1) > 0) {
            bl2 = true;
            Real.tmp2.mantissa = this.mantissa;
            Real.tmp2.exponent = this.exponent;
            Real.tmp2.sign = this.sign;
            this.sub(tmp1);
            tmp2.mul(tmp1);
            tmp2.add(ONE);
            this.div(tmp2);
        }
        this.atanInternal();
        if (bl2) {
            this.add(PI_8);
        }
        if (bl) {
            this.neg();
            this.add(PI_2);
        }
        this.sign = by;
    }

    public void atan2(Real real) {
        if (this.exponent < 0 && this.mantissa != 0L || real.exponent < 0 && real.mantissa != 0L || this.exponent < 0 && this.mantissa == 0L && real.exponent < 0 && real.mantissa == 0L) {
            this.makeNan();
            return;
        }
        if (this.exponent == 0 && this.mantissa == 0L && real.exponent == 0 && real.mantissa == 0L) {
            return;
        }
        byte by = this.sign;
        byte by2 = real.sign;
        this.sign = 0;
        real.sign = 0;
        this.div(real);
        this.atan();
        if (by2 != 0) {
            this.neg();
            this.add(PI);
        }
        this.sign = by;
    }

    private static int floorDiv(int n, int n2) {
        if (n >= 0) {
            return n / n2;
        }
        return -((-n + n2 - 1) / n2);
    }

    private static int floorMod(int n, int n2) {
        if (n >= 0) {
            return n % n2;
        }
        return n + (-n + n2 - 1) / n2 * n2;
    }

    private int digit(char c, int n, boolean bl) {
        int n2 = -1;
        if (c >= '0' && c <= '9') {
            n2 = c - 48;
        } else if (c >= 'A' && c <= 'F') {
            n2 = c - 65 + 10;
        }
        if (n2 >= n) {
            return -1;
        }
        if (bl) {
            n2 ^= n - 1;
        }
        return n2;
    }

    private void shiftUp(int n) {
        if (n == 2) {
            this.scalbn(1);
        } else if (n == 8) {
            this.scalbn(3);
        } else if (n == 16) {
            this.scalbn(4);
        } else {
            this.mul10();
        }
    }

    private void atof(String string, int n) {
        int n2;
        this.makeZero();
        int n3 = string.length();
        int n4 = 0;
        byte by = 0;
        boolean bl = false;
        while (n4 < n3 && string.charAt(n4) == ' ') {
            ++n4;
        }
        if (n4 < n3 && string.charAt(n4) == '-') {
            by = 1;
            ++n4;
        } else if (n4 < n3 && string.charAt(n4) == '+') {
            ++n4;
        } else if (n4 < n3 && string.charAt(n4) == '/') {
            bl = true;
            by = 1;
            ++n4;
        }
        while (n4 < n3 && (n2 = this.digit(string.charAt(n4), n, bl)) >= 0) {
            this.shiftUp(n);
            this.add(n2);
            ++n4;
        }
        if (n4 < n3 && (string.charAt(n4) == '.' || string.charAt(n4) == ',')) {
            ++n4;
            Real.tmp2.mantissa = Real.ONE.mantissa;
            Real.tmp2.exponent = Real.ONE.exponent;
            Real.tmp2.sign = Real.ONE.sign;
            while (n4 < n3 && (n2 = this.digit(string.charAt(n4), n, bl)) >= 0) {
                tmp2.shiftUp(n);
                this.shiftUp(n);
                this.add(n2);
                ++n4;
            }
            if (bl) {
                this.add(ONE);
            }
            this.div(tmp2);
        } else if (bl) {
            this.add(ONE);
        }
        while (n4 < n3 && string.charAt(n4) == ' ') {
            ++n4;
        }
        if (n4 < n3 && (string.charAt(n4) == 'e' || string.charAt(n4) == 'E')) {
            int n5 = 0;
            boolean bl2 = false;
            if (++n4 < n3 && string.charAt(n4) == '-') {
                bl2 = true;
                ++n4;
            } else if (n4 < n3 && string.charAt(n4) == '+') {
                ++n4;
            }
            while (n4 < n3 && string.charAt(n4) >= '0' && string.charAt(n4) <= '9') {
                if (n5 < 400000000) {
                    n5 = n5 * 10 + (string.charAt(n4) - 48);
                }
                ++n4;
            }
            if (bl2) {
                n5 = -n5;
            }
            if (n == 2) {
                this.scalbn(n5);
            } else if (n == 8) {
                this.scalbn(n5 * 3);
            } else if (n == 16) {
                this.scalbn(n5 * 4);
            } else {
                if (this.exponent > 300000000 || this.exponent < -300000000) {
                    Real.tmp1.mantissa = Real.TEN.mantissa;
                    Real.tmp1.exponent = Real.TEN.exponent;
                    Real.tmp1.sign = Real.TEN.sign;
                    tmp1.pow(n5 / 2);
                    this.mul(tmp1);
                    n5 -= n5 / 2;
                }
                Real.tmp1.mantissa = Real.TEN.mantissa;
                Real.tmp1.exponent = Real.TEN.exponent;
                Real.tmp1.sign = Real.TEN.sign;
                tmp1.pow(n5);
                this.mul(tmp1);
            }
        }
        this.sign = by;
    }

    private void normalizeBCD() {
        if (this.mantissa == 0L) {
            this.exponent = 0;
            return;
        }
        int n = 0;
        int n2 = 0;
        while (n2 < 64) {
            int n3 = (int)(this.mantissa >>> n2 & 0xFL) + n;
            n = 0;
            if (n3 >= 10) {
                n3 -= 10;
                n = 1;
            }
            this.mantissa &= 15L << n2 ^ 0xFFFFFFFFFFFFFFFFL;
            this.mantissa += (long)n3 << n2;
            n2 += 4;
        }
        if (n != 0) {
            if ((int)(this.mantissa & 0xFL) >= 5) {
                this.mantissa += 16L;
            }
            this.mantissa >>>= 4;
            this.mantissa += 0x1000000000000000L;
            ++this.exponent;
            if ((int)(this.mantissa & 0xFL) >= 10) {
                this.normalizeBCD();
            }
        }
        while (this.mantissa >>> 60 == 0L) {
            this.mantissa <<= 4;
            --this.exponent;
        }
    }

    private void toBCD() {
        Real.tmp1.mantissa = this.mantissa;
        Real.tmp1.exponent = this.exponent;
        Real.tmp1.sign = this.sign;
        tmp1.abs();
        Real.tmp2.mantissa = Real.tmp1.mantissa;
        Real.tmp2.exponent = Real.tmp1.exponent;
        Real.tmp2.sign = Real.tmp1.sign;
        this.exponent = tmp1.lowPow10();
        if (this.exponent > 300000000 || this.exponent < -300000000) {
            Real.tmp1.mantissa = Real.TEN.mantissa;
            Real.tmp1.exponent = Real.TEN.exponent;
            Real.tmp1.sign = Real.TEN.sign;
            tmp1.pow(this.exponent / 2);
            tmp2.div(tmp1);
            Real.tmp1.mantissa = Real.TEN.mantissa;
            Real.tmp1.exponent = Real.TEN.exponent;
            Real.tmp1.sign = Real.TEN.sign;
            tmp1.pow(this.exponent - this.exponent / 2);
        }
        tmp2.div(tmp1);
        this.mantissa = 0L;
        int n = 60;
        while (n >= 0) {
            Real.tmp1.mantissa = Real.tmp2.mantissa;
            Real.tmp1.exponent = Real.tmp2.exponent;
            Real.tmp1.sign = Real.tmp2.sign;
            tmp1.floor();
            this.mantissa += (long)tmp1.toInteger() << n;
            tmp2.sub(tmp1);
            tmp2.mul10();
            n -= 4;
        }
        if (tmp2.compare(FIVE) >= 0) {
            ++this.mantissa;
        }
        this.normalizeBCD();
    }

    private boolean testCarryWhenRounded(int n, int n2, int n3) {
        if (this.mantissa >= 0L) {
            return false;
        }
        int n4 = 64 - n3 * n2;
        if (n4 <= 0) {
            return false;
        }
        Real.tmp5.mantissa = this.mantissa;
        Real.tmp5.exponent = this.exponent;
        Real.tmp5.sign = this.sign;
        if (n == 10) {
            Real.tmp5.mantissa += 5L << n4 - 4;
            tmp5.normalizeBCD();
        } else {
            Real.tmp5.mantissa += 1L << n4 - 1;
        }
        if (Real.tmp5.mantissa >= 0L) {
            this.mantissa = 1L << 64 - n2;
            ++this.exponent;
            return true;
        }
        return false;
    }

    private void round(int n, int n2, int n3) {
        if (this.exponent == 0 && this.mantissa == 0L) {
            return;
        }
        int n4 = 64 - n3 * n2;
        if (n4 <= 0) {
            return;
        }
        long l = this.mantissa;
        if (n == 10) {
            this.mantissa += 5L << n4 - 4;
            this.normalizeBCD();
        } else {
            this.mantissa += 1L << n4 - 1;
        }
        if (l < 0L && this.mantissa >= 0L) {
            this.mantissa = 1L << 64 - n2;
            ++this.exponent;
        }
    }

    private String align(StringBuffer stringBuffer, NumberFormat numberFormat) {
        block4: {
            block5: {
                block3: {
                    if (numberFormat.align != 1) break block3;
                    while (stringBuffer.length() < numberFormat.maxwidth) {
                        stringBuffer.append(' ');
                    }
                    break block4;
                }
                if (numberFormat.align != 2) break block5;
                while (stringBuffer.length() < numberFormat.maxwidth) {
                    stringBuffer.insert(0, ' ');
                }
                break block4;
            }
            if (numberFormat.align != 3) break block4;
            while (stringBuffer.length() < numberFormat.maxwidth) {
                stringBuffer.append(' ');
                if (stringBuffer.length() >= numberFormat.maxwidth) continue;
                stringBuffer.insert(0, ' ');
            }
        }
        return stringBuffer.toString();
    }

    private String ftoa(NumberFormat numberFormat) {
        char c;
        int n;
        int n2;
        int n3;
        int n4;
        int n5;
        ftoaBuf.setLength(0);
        if (this.exponent < 0 && this.mantissa != 0L) {
            ftoaBuf.append("nan");
            return this.align(ftoaBuf, numberFormat);
        }
        if (this.exponent < 0 && this.mantissa == 0L) {
            ftoaBuf.append(this.sign != 0 ? "-inf" : "inf");
            return this.align(ftoaBuf, numberFormat);
        }
        switch (numberFormat.base) {
            case 2: {
                n5 = 1;
                n4 = 8;
                break;
            }
            case 8: {
                n5 = 3;
                n4 = 1000;
                break;
            }
            case 16: {
                n5 = 4;
                n4 = 4;
                break;
            }
            default: {
                n5 = 4;
                n4 = 3;
            }
        }
        if (numberFormat.thousand == '\u0000') {
            n4 = 1000;
        }
        int n6 = 64;
        Real.tmp4.mantissa = this.mantissa;
        Real.tmp4.exponent = this.exponent;
        Real.tmp4.sign = this.sign;
        if (this.exponent == 0 && this.mantissa == 0L) {
            Real.tmp4.exponent = 0;
            if (numberFormat.base != 10) {
                Real.tmp4.sign = 0;
            }
        } else if (numberFormat.base == 10) {
            tmp4.toBCD();
        } else {
            if (Real.tmp4.sign != 0) {
                Real.tmp4.mantissa = -Real.tmp4.mantissa;
                if (Real.tmp4.mantissa >>> 62 == 3L) {
                    Real.tmp4.mantissa <<= 1;
                    --Real.tmp4.exponent;
                    --n6;
                }
            }
            Real.tmp4.exponent -= 0x3FFFFFFF;
            n3 = n5 - 1 - Real.floorMod(Real.tmp4.exponent, n5);
            Real.tmp4.exponent = Real.floorDiv(Real.tmp4.exponent, n5);
            if (n3 == n5 - 1) {
                Real.tmp4.mantissa <<= 1;
                --Real.tmp4.exponent;
                --n6;
            } else if (n3 > 0) {
                Real.tmp4.mantissa = Real.tmp4.mantissa + (1L << n3 - 1) >>> n3;
                if (Real.tmp4.sign != 0) {
                    Real.tmp4.mantissa |= Long.MIN_VALUE >> n3 - 1;
                }
            }
        }
        n3 = (n6 + n5 - 1) / n5;
        int n7 = 0;
        do {
            n = numberFormat.maxwidth - 1;
            c = '\u0000';
            if (numberFormat.base != 10) {
                c = '\u0001';
            } else if (Real.tmp4.sign != 0) {
                --n;
            }
            boolean bl = false;
            switch (numberFormat.fse) {
                case 2: {
                    n2 = numberFormat.precision + 1;
                    bl = true;
                    break;
                }
                case 3: {
                    n7 = Real.floorMod(Real.tmp4.exponent, 3);
                    n2 = numberFormat.precision + 1 + n7;
                    bl = true;
                    break;
                }
                default: {
                    n2 = 1000;
                    if (numberFormat.fse == 1) {
                        n2 = numberFormat.precision + 1;
                    }
                    if (Real.tmp4.exponent + 1 > n - (Real.tmp4.exponent + c) / n4 - c + (numberFormat.removePoint ? 1 : 0) || Real.tmp4.exponent + 1 > n3 || -Real.tmp4.exponent >= n || -Real.tmp4.exponent >= n2) {
                        bl = true;
                        break;
                    }
                    n7 = Real.tmp4.exponent;
                    n2 += Real.tmp4.exponent;
                    if (Real.tmp4.exponent > 0) {
                        n -= (Real.tmp4.exponent + c) / n4;
                    }
                    if (!numberFormat.removePoint || Real.tmp4.exponent != n - c) break;
                    ++n;
                }
            }
            if (c != '\u0000' && n7 >= 0) {
                n -= c;
            }
            ftoaExp.setLength(0);
            if (bl) {
                ftoaExp.append('e');
                ftoaExp.append(Real.tmp4.exponent - n7);
                n -= ftoaExp.length();
            }
            if (n2 > n3) {
                n2 = n3;
            }
            if (n2 > n) {
                n2 = n;
            }
            if (n2 > n + n7) {
                n2 = n + n7;
            }
            if (n2 > 0) continue;
            n2 = 1;
        } while (tmp4.testCarryWhenRounded(numberFormat.base, n5, n2));
        tmp4.round(numberFormat.base, n5, n2);
        if (Real.tmp4.sign != 0 && numberFormat.base == 10) {
            ftoaBuf.append('-');
        }
        n = n7;
        char c2 = c = numberFormat.base == 10 || Real.tmp4.sign == 0 ? (char)'0' : hexChar.charAt(numberFormat.base - 1);
        if (n7 < 0) {
            ftoaBuf.append(c);
            ftoaBuf.append(numberFormat.point);
            while (n7 < -1) {
                ftoaBuf.append(c);
                ++n7;
            }
        }
        while (n2 > 0) {
            ftoaBuf.append(hexChar.charAt((int)(Real.tmp4.mantissa >>> 64 - n5)));
            Real.tmp4.mantissa <<= n5;
            if (n7 > 0 && n7 % n4 == 0) {
                ftoaBuf.append(numberFormat.thousand);
            }
            if (n7 == 0) {
                ftoaBuf.append(numberFormat.point);
            }
            --n2;
            --n7;
        }
        if (numberFormat.fse == 0) {
            while (ftoaBuf.charAt(ftoaBuf.length() - 1) == '0') {
                ftoaBuf.setLength(ftoaBuf.length() - 1);
            }
        }
        if (numberFormat.removePoint && ftoaBuf.charAt(ftoaBuf.length() - 1) == numberFormat.point) {
            ftoaBuf.setLength(ftoaBuf.length() - 1);
        }
        ftoaBuf.append(ftoaExp.toString());
        if (numberFormat.base != 10) {
            while (ftoaBuf.length() < numberFormat.maxwidth) {
                if (++n > 0 && n % n4 == 0) {
                    ftoaBuf.insert(0, numberFormat.thousand);
                }
                if (ftoaBuf.length() >= numberFormat.maxwidth) continue;
                ftoaBuf.insert(0, c);
            }
            if (ftoaBuf.charAt(0) == numberFormat.thousand) {
                ftoaBuf.deleteCharAt(0);
            }
        }
        return this.align(ftoaBuf, numberFormat);
    }

    public String toString() {
        Real.tmpFormat.base = 10;
        return this.ftoa(tmpFormat);
    }

    public String toString(int n) {
        Real.tmpFormat.base = n;
        return this.ftoa(tmpFormat);
    }

    public String toString(NumberFormat numberFormat) {
        return this.ftoa(numberFormat);
    }

    public static class NumberFormat {
        public int base = 10;
        public int maxwidth = 30;
        public int precision = 16;
        public int fse = 0;
        public char point = (char)46;
        public boolean removePoint = true;
        public char thousand = '\u0000';
        public int align = 0;
        public static final int FSE_NONE = 0;
        public static final int FSE_FIX = 1;
        public static final int FSE_SCI = 2;
        public static final int FSE_ENG = 3;
        public static final int ALIGN_NONE = 0;
        public static final int ALIGN_LEFT = 1;
        public static final int ALIGN_RIGHT = 2;
        public static final int ALIGN_CENTER = 3;

        NumberFormat() {
        }
    }
}

