/*
 * Decompiled with CFR 0.152.
 */
package z;

import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.util.Vector;
import javax.microedition.lcdui.Graphics;
import z.PWBitMapLab;

public class PWNanoFont {
    public PWBitMapLab theBm;
    public int fontHeight;
    public int lineSpacing;
    public int charSpacing;
    public int spaceWidth;
    public static byte[][] BitMap;
    private static char[] chars;
    private int color;
    public static final int _Default_Writing_Speed_ = 10;
    private int desiredChar;
    private int writingSpeed;
    private int rectX;
    private int rectY;
    private int rectWidth;
    private int rectHeight;
    private int anchor;
    private long initTime;
    private short[][] textLineInfo;
    private int numLines;
    private int firstLine;
    private int tToWait;
    private String text;

    public static PWNanoFont loadBMFont(byte[] data) {
        return PWNanoFont.load(data, null, false, 0);
    }

    public static PWNanoFont load(byte[] data, int[] palettesToLoad, boolean cachePalettes, int sizeBuffer) {
        if (data == null) {
            System.out.println("data is null");
        }
        PWNanoFont font = new PWNanoFont();
        int i = 0;
        try {
            ByteArrayInputStream bais = new ByteArrayInputStream(data);
            DataInputStream dis = new DataInputStream(bais);
            byte versionFont = dis.readByte();
            ++i;
            font.fontHeight = dis.readByte();
            ++i;
            font.lineSpacing = dis.readByte();
            ++i;
            font.charSpacing = dis.readByte();
            font.charSpacing = 0;
            ++i;
            font.spaceWidth = dis.readByte();
            font.spaceWidth = 12;
            ++i;
            System.out.println("spaceSize" + font.spaceWidth);
            int charQuantity = dis.readInt();
            System.out.println("" + charQuantity);
            i += 4;
            chars = new char[charQuantity];
            int fontSize = 24;
            BitMap = new byte[charQuantity][fontSize];
            for (int j = 0; j < charQuantity; ++j) {
                PWNanoFont.chars[j] = dis.readChar();
                i += 2;
            }
            for (int m = 0; m < charQuantity; ++m) {
                for (int n = 0; n < fontSize; ++n) {
                    PWNanoFont.BitMap[m][n] = dis.readByte();
                }
            }
            font.initialize();
            font.theBm = new PWBitMapLab(BitMap);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return font;
    }

    private void initialize() {
        PWNanoFont.sortChars(0, chars.length - 1);
    }

    private static void sortChars(int low, int high) {
        int left = low;
        int right = high;
        char half = chars[(low + high) / 2];
        while (true) {
            if (chars[left] < half && left < high) {
                ++left;
                continue;
            }
            while (half < chars[right] && right > low) {
                --right;
            }
            if (left <= right) {
                char x = chars[left];
                byte[] x2 = BitMap[left];
                PWNanoFont.chars[left] = chars[right];
                PWNanoFont.BitMap[left] = BitMap[right];
                PWNanoFont.chars[right] = x;
                PWNanoFont.BitMap[right] = x2;
                ++left;
                --right;
            }
            if (left > right) break;
        }
        if (low < right) {
            PWNanoFont.sortChars(low, right);
        }
        if (left < high) {
            PWNanoFont.sortChars(left, high);
        }
    }

    public void selectColor(int number) {
        this.theBm.setPalette(number);
    }

    public short[][] drawString(Graphics graphics, String text, int x, int y, int width, int height, int anchor) {
        return this.drawString(graphics, text.toCharArray(), x, y, width, height, anchor);
    }

    public short[][] drawString(Graphics graphics, char[] data, int x, int y, int width, int height, int anchor) {
        short[][] mLineData = this.getLineData(data, width);
        this.drawFastString(graphics, data, x, y, width, height, anchor, mLineData);
        return mLineData;
    }

    public int drawString(Graphics graphics, String text, int x, int y, int anchor) {
        return this.drawString(graphics, text.toCharArray(), x, y, anchor);
    }

    public int drawString(Graphics graphics, char[] data, int x, int y, int anchor) {
        if ((anchor & 0x10) != 0) {
            y += this.fontHeight;
        } else if ((anchor & 0x20) != 0) {
            y -= this.lineSpacing;
        } else if ((anchor & 2) != 0) {
            y += this.fontHeight / 2;
        }
        int textWidth = 0;
        if ((anchor & 8) != 0) {
            textWidth = this.getLineWidth(data);
            x -= textWidth;
        } else if ((anchor & 1) != 0) {
            textWidth = this.getLineWidth(data);
            x -= textWidth / 2;
        }
        if (textWidth == 0) {
            for (int i = 0; i < data.length; ++i) {
                textWidth = textWidth + this.drawChar(graphics, data[i], x + textWidth, y) + this.charSpacing;
            }
        } else {
            for (int i = 0; i < data.length; ++i) {
                x = x + this.drawChar(graphics, data[i], x, y) + this.charSpacing;
            }
        }
        return textWidth;
    }

    public void drawFastString(Graphics graphics, char[] data, short[][] mLineData, int x, int y, int width, int anchor, int firstLine, int linesToDraw) {
        int maxLines = firstLine + linesToDraw;
        if (maxLines > mLineData.length) {
            maxLines = mLineData.length;
        }
        y += this.fontHeight;
        if ((anchor & 8) != 0) {
            x += width;
        } else if ((anchor & 1) != 0) {
            x += width / 2;
        }
        for (int i = firstLine; i < maxLines; ++i) {
            if (mLineData[i][2] != 0) {
                this.drawFastString(graphics, data, x, y, anchor, mLineData[i]);
            }
            y = y + this.lineSpacing + this.fontHeight;
        }
    }

    public short[][] drawFastString(Graphics graphics, char[] data, int x, int y, int width, int height, int anchor, short[][] mLineData) {
        int textHeight;
        int maxLines = height / this.fontHeight;
        if (maxLines > 1 && height % this.fontHeight != 0) {
            --maxLines;
        }
        if (mLineData.length < maxLines) {
            maxLines = mLineData.length;
        }
        int n = textHeight = maxLines == 1 ? maxLines * this.fontHeight : maxLines * (this.lineSpacing + this.fontHeight);
        y = (anchor & 0x20) != 0 ? (y -= textHeight) : ((anchor & 2) != 0 ? y + this.fontHeight + (height - textHeight >> 1) : (y += this.fontHeight));
        if ((anchor & 8) != 0) {
            x += width;
        } else if ((anchor & 1) != 0) {
            x += width / 2;
        }
        for (int i = 0; i < maxLines; ++i) {
            if (mLineData[i][2] != 0) {
                this.drawFastString(graphics, data, x, y, anchor, mLineData[i]);
            }
            y = y + this.lineSpacing + this.fontHeight;
        }
        return mLineData;
    }

    public void drawFastString(Graphics graphics, char[] text, int x, int y, int anchor, short[] lineData) {
        if ((anchor & 8) != 0) {
            x -= lineData[2];
        } else if ((anchor & 1) != 0) {
            x -= lineData[2] / 2;
        }
        for (int i = lineData[0]; i < lineData[1] + 1; ++i) {
            x = x + this.drawChar(graphics, text[i], x, y) + this.charSpacing;
        }
    }

    public int drawChar(Graphics g, char character, int x, int y) {
        if (character == ' ') {
            return this.spaceWidth;
        }
        int charIndex = PWNanoFont.binarySearchOnChars(character, 0, chars.length - 1);
        if (charIndex == -1) {
            return 0;
        }
        this.theBm.drawChar(charIndex, g, x, y);
        if (character >= '\u4e00') {
            return 14;
        }
        return 7;
    }

    public short[][] getLineData(char[] text, int width) {
        if (width <= 14 + this.charSpacing) {
            width = 14 + this.charSpacing + 1;
        }
        Vector<short[]> result = new Vector<short[]>();
        int index = 0;
        short[] currentLine = new short[]{0, 0, 0};
        int lineWidth = 0;
        int wordWidth = 0;
        int savePos = 0;
        int saveWidth = 0;
        while (index < text.length) {
            wordWidth = 0;
            savePos = 0;
            saveWidth = 0;
            for (lineWidth = 0; lineWidth < width - 14 - this.charSpacing && index < text.length; lineWidth += this.getCharacterWidth(text[index]) + this.charSpacing, ++index) {
                if (text[index] == '\n') {
                    ++index;
                    break;
                }
                if (text[index] == ' ') {
                    savePos = index;
                    saveWidth = lineWidth;
                    wordWidth = 0;
                }
                wordWidth += this.getCharacterWidth(text[index]) + this.charSpacing;
            }
            if (saveWidth != 0 && index < text.length && text[index] != '\n') {
                lineWidth = saveWidth;
                index = savePos;
            }
            currentLine[1] = (short)(index - 1);
            currentLine[2] = (short)lineWidth;
            result.addElement(currentLine);
            if (saveWidth != 0 && index < text.length && text[index] != '\n') {
                ++index;
            }
            currentLine = new short[]{(short)index, (short)index, 0};
        }
        short[][] ret = new short[result.size()][];
        for (int i = 0; i < result.size(); ++i) {
            short[] data = (short[])result.elementAt(i);
            ret[i] = new short[3];
            ret[i][0] = data[0];
            ret[i][1] = data[1];
            ret[i][2] = data[2];
        }
        return ret;
    }

    public int getLineWidth(char[] text) {
        if (text.length < 1) {
            return 0;
        }
        int totalWidth = 0;
        totalWidth += this.getCharacterWidth(text[0]);
        for (int i = 1; i < text.length; ++i) {
            char auxChar = text[i];
            totalWidth = totalWidth + this.getCharacterWidth(auxChar) + this.charSpacing;
        }
        return totalWidth;
    }

    private int getCharacterWidth(char character) {
        if (character == ' ') {
            return this.spaceWidth;
        }
        int charIndex = PWNanoFont.binarySearchOnChars(character, 0, chars.length - 1);
        if (charIndex < 0) {
            return 0;
        }
        if (character >= '\u4e00') {
            return 14;
        }
        return 7;
    }

    private static int binarySearchOnChars(char character, int left, int right) {
        if (right < left) {
            return -1;
        }
        int mid = (left + right) / 2;
        if (chars[mid] == character) {
            return mid;
        }
        if (character < chars[mid]) {
            return PWNanoFont.binarySearchOnChars(character, left, mid - 1);
        }
        return PWNanoFont.binarySearchOnChars(character, mid + 1, right);
    }

    public final void setInitTime(long time) {
        this.initTime = time;
        this.desiredChar = 0;
    }

    public final void setTextToRender(String aText, int x, int y, int width, int height, int anAnchorPoint) {
        this.text = aText;
        this.rectX = x;
        this.rectY = y;
        this.rectWidth = width;
        this.rectHeight = height;
        this.anchor = anAnchorPoint;
        this.textLineInfo = this.getLineData(this.text.toCharArray(), this.rectWidth);
        this.numLines = height / (this.fontHeight + this.lineSpacing);
        this.firstLine = 0;
        this.tToWait = 6000;
    }

    public final void setWritingSpeed(int speed) {
        this.writingSpeed = speed <= 0 ? 10 : speed;
    }

    public final boolean drawDynamicText(Graphics g, long actualTime) {
        this.desiredChar = (int)((actualTime - this.initTime) * (long)this.writingSpeed / 1000L);
        this.drawFastString(g, this.text.toCharArray(), this.textLineInfo, this.rectX, this.rectY, this.rectWidth, this.anchor, this.firstLine, this.numLines);
        if (actualTime - this.initTime > (long)this.tToWait) {
            this.firstLine += this.numLines;
            this.initTime = actualTime;
        }
        return this.firstLine < this.textLineInfo.length;
    }

    public final void passPage(long actualTime) {
        this.firstLine += this.numLines;
        this.initTime = actualTime;
    }

    public final void draw(Graphics g, long actualTime) {
        this.desiredChar = (int)((actualTime - this.initTime) * (long)this.writingSpeed / 1000L);
        if (this.text == null) {
            return;
        }
        this.drawString(g, this.text.toCharArray(), this.rectX, this.rectY, this.rectWidth, this.rectHeight, this.anchor);
    }

    public static PWNanoFont load(byte[] resource) {
        return PWNanoFont.load(resource, null, true, 50);
    }
}

