/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.microedition.svg;

import java.util.Vector;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Displayable;
import javax.microedition.m2g.SVGEventListener;
import javax.microedition.m2g.SVGImage;
import org.netbeans.microedition.svg.SVGAnimatorWrapper;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.svg.SVGAnimationElement;
import org.w3c.dom.svg.SVGElement;

public class SVGMenu
extends SVGAnimatorWrapper {
    private static final String FOCUSINANIM_PREFFIX = "focusInAnim_";
    private static final String FOCUSOUTANIM_PREFIX = "focusOutAnim_";
    public static final Command SELECT_COMMAND = new Command("SELECT_COMMAND", 8, 0);
    public static final int SELECTED_INDEX_NONE = -1;
    private static final int NO_FOCUS = -1;
    private Vector menuElements;
    private Document svgDocument;
    private int currentFocus = -1;
    private Display display;

    public SVGMenu(SVGImage svgImage, Display display) {
        super(svgImage, display);
        this.svgDocument = svgImage.getDocument();
        this.menuElements = new Vector();
        this.display = display;
        this.setResetAnimationWhenStopped(false);
        this.setSVGEventListener(new SvgMenuEventListener());
        this.setFullScreenMode(true);
    }

    public void addMenuElement(String svgElementId) {
        this.addMenuElement(svgElementId, 8);
    }

    public String getMenuElementID(int index) throws IndexOutOfBoundsException {
        if (index < 0 || index >= this.menuElements.size()) {
            throw new IndexOutOfBoundsException("Wrong index for menu element: " + index);
        }
        return ((MenuElement)this.menuElements.elementAt((int)index)).focusableElement.getId();
    }

    private void addMenuElement(String svgElementId, int gameActionId) {
        MenuElement element = new MenuElement();
        element.focusableElement = (SVGElement)this.svgDocument.getElementById(svgElementId);
        element.gameActionId = gameActionId;
        Element animElement = this.svgDocument.getElementById(FOCUSINANIM_PREFFIX + svgElementId);
        if (animElement instanceof SVGAnimationElement) {
            element.focusInAnimation = (SVGAnimationElement)animElement;
        }
        if ((animElement = this.svgDocument.getElementById(FOCUSOUTANIM_PREFIX + svgElementId)) instanceof SVGAnimationElement) {
            element.focusOutAnimation = (SVGAnimationElement)animElement;
        }
        this.menuElements.addElement(element);
        this.resetFocus();
    }

    public int getSelectedIndex() {
        return this.currentFocus;
    }

    private void focusOn(int currentFocus, int nextFocus) {
        MenuElement currentElement = this.getMenuElementAt(currentFocus);
        MenuElement nextElement = this.getMenuElementAt(nextFocus);
        if (currentElement != null) {
            if (currentElement.focusInAnimation != null) {
                this.stopAnimation(currentElement.focusInAnimation);
            }
            if (currentElement.focusOutAnimation != null) {
                this.startAnimation(currentElement.focusOutAnimation);
            }
        }
        if (nextElement != null) {
            if (nextElement.focusOutAnimation != null) {
                this.stopAnimation(nextElement.focusOutAnimation);
            }
            if (nextElement.focusInAnimation != null) {
                this.getSVGImage().focusOn(null);
                this.startAnimation(nextElement.focusInAnimation);
            } else {
                this.getSVGImage().focusOn(nextElement.focusableElement);
            }
        } else {
            this.getSVGImage().focusOn(null);
        }
    }

    private MenuElement getMenuElementAt(int index) {
        if (index >= 0 && index < this.menuElements.size()) {
            return (MenuElement)this.menuElements.elementAt(index);
        }
        return null;
    }

    private void startAnimation(final SVGAnimationElement svgAnimationElement) {
        Runnable runnable = new Runnable(){

            public void run() {
                svgAnimationElement.beginElementAt(0.0f);
            }
        };
        this.invokeLaterSafely(runnable);
    }

    private void stopAnimation(final SVGAnimationElement svgAnimationElement) {
        Runnable runnable = new Runnable(){

            public void run() {
                svgAnimationElement.endElementAt(0.0f);
            }
        };
        this.invokeLaterSafely(runnable);
    }

    public void resetFocus() {
        this.focusOn(this.currentFocus, 0);
        this.currentFocus = 0;
    }

    public void focusNext() {
        int nextFocus = this.currentFocus;
        nextFocus = nextFocus + 1 != this.menuElements.size() ? ++nextFocus : 0;
        this.focusOn(this.currentFocus, nextFocus);
        this.currentFocus = nextFocus;
    }

    public void focusPrev() {
        int nextFocus = this.currentFocus;
        if (nextFocus == 0) {
            nextFocus = this.menuElements.size();
        }
        this.focusOn(this.currentFocus, --nextFocus);
        this.currentFocus = nextFocus;
    }

    private static class MenuElement {
        SVGElement focusableElement;
        int gameActionId;
        SVGAnimationElement focusInAnimation;
        SVGAnimationElement focusOutAnimation;

        private MenuElement() {
        }
    }

    private class SvgMenuEventListener
    implements SVGEventListener {
        private SvgMenuEventListener() {
        }

        public void keyPressed(int keyCode) {
            int gameAction = SVGMenu.this.getSvgCanvas().getGameAction(keyCode);
            if (gameAction == 1 || gameAction == 2) {
                SVGMenu.this.getAnimator().invokeLater(new Runnable(){

                    public void run() {
                        SVGMenu.this.focusPrev();
                    }
                });
            } else if (gameAction == 6 || gameAction == 5) {
                SVGMenu.this.getAnimator().invokeLater(new Runnable(){

                    public void run() {
                        SVGMenu.this.focusNext();
                    }
                });
            }
            MenuElement currentMenuElement = SVGMenu.this.getMenuElementAt(SVGMenu.this.currentFocus);
            if (currentMenuElement != null && gameAction == currentMenuElement.gameActionId) {
                this.fireSelectCommandAction();
            }
        }

        private void fireSelectCommandAction() {
            CommandListener commandListener = SVGMenu.this.getCommandListener();
            if (commandListener != null) {
                commandListener.commandAction(SELECT_COMMAND, (Displayable)SVGMenu.this);
            }
        }

        public void keyReleased(int keyCode) {
        }

        public void pointerPressed(int x, int y) {
        }

        public void pointerReleased(int x, int y) {
        }

        public void hideNotify() {
        }

        public void showNotify() {
        }

        public void sizeChanged(int width, int height) {
        }
    }
}

