/*
 * Decompiled with CFR 0.152.
 */
package com.renderedideas.game;

import com.renderedideas.game.PrintConsole;
import java.util.Vector;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class Bitmap {
    public Image image;
    public static boolean applyShadow = false;
    public static Bitmap shadow = null;

    public Bitmap() {
    }

    public Bitmap(String path) {
        if (!path.endsWith(".png")) {
            path = path + ".png";
        }
        if (!path.startsWith("/")) {
            path = "/" + path;
        }
        try {
            this.image = Image.createImage((String)path);
            if (applyShadow) {
                this.image = Bitmap.multiplyBitmaps((Bitmap)this, (Bitmap)Bitmap.shadow).image;
            }
        }
        catch (Exception e2) {
            PrintConsole.print("Error:platform:Bitmap:constructor:" + path + ":" + e2);
        }
    }

    public Bitmap(Image image) {
        this.image = image;
    }

    public int getWidth() {
        return this.image.getWidth();
    }

    public int getHeight() {
        return this.image.getHeight();
    }

    public void getRGB(int[] rgbData, int offset, int scanlength, int x, int y, int width, int height) {
        this.image.getRGB(rgbData, offset, scanlength, x, y, width, height);
    }

    public static Bitmap createRGBImage(int[] rgb, int width, int height, boolean processAlpha) {
        Bitmap bitmap = new Bitmap();
        bitmap.image = Image.createRGBImage((int[])rgb, (int)width, (int)height, (boolean)processAlpha);
        return bitmap;
    }

    public static void drawBitmap(Graphics target, Bitmap bitmap, int x, int y) {
        target.drawImage(bitmap.image, x, y, 0);
    }

    public static void drawBitmap(Graphics target, Image image, int x, int y) {
        target.drawImage(image, x, y, 0);
    }

    public static int[] getRGB(Bitmap bitmap) {
        int[] data = new int[bitmap.getWidth() * bitmap.getHeight()];
        bitmap.image.getRGB(data, 0, bitmap.getWidth(), 0, 0, bitmap.getWidth(), bitmap.getHeight());
        return data;
    }

    public static byte[] getRGB_byte(Bitmap bitmap) {
        int[] array = Bitmap.getRGB(bitmap);
        byte[] b2 = new byte[array.length * 3];
        int k = 0;
        for (int i = 0; i < array.length; ++i) {
            b2[k++] = (byte)(array[i] >> 16 & 0xFF);
            b2[k++] = (byte)(array[i] >> 8 & 0xFF);
            b2[k++] = (byte)(array[i] & 0xFF);
        }
        return b2;
    }

    public static void fillColor(Graphics graphics, int x, int y, int width, int height, int r, int g, int b2) {
        graphics.setColor(r, g, b2);
        graphics.fillRect(x, y, width, height);
    }

    public static void drawString(Graphics graphics, String str, int x, int y, int r, int g, int b2) {
        graphics.setColor(r, g, b2);
        graphics.drawString(str, x, y, 0);
    }

    public static int getStringWidth(String str) {
        Font font = Font.getDefaultFont();
        return font.stringWidth(str);
    }

    public static int drawMultilineString(Graphics graphics, String str, int x, int y, int width) {
        Bitmap.fillColor(graphics, x, y, width, Bitmap.getMultilineStringHeight(str, width), 190, 0, 0);
        graphics.setColor(234, 255, 0);
        Font font = Font.getFont((int)0, (int)1, (int)16);
        graphics.setFont(font);
        Vector lines = Bitmap.wrap(str, font, width);
        for (int i = 0; i < lines.size(); ++i) {
            int liney = y + i * font.getHeight();
            graphics.drawString((String)lines.elementAt(i), x, liney, 0);
            graphics.drawLine(x, liney + font.getHeight(), x + font.stringWidth(((String)lines.elementAt(i)).trim()), liney + font.getHeight());
        }
        return y + lines.size() * font.getHeight();
    }

    public static int drawMultilineString2(Graphics graphics, String str, int x, int y, int width) {
        graphics.setColor(255, 255, 255);
        Font font = Font.getFont((int)0, (int)1, (int)16);
        graphics.setFont(font);
        Vector lines = Bitmap.wrap(str, font, width);
        for (int i = 0; i < lines.size(); ++i) {
            int liney = y + i * font.getHeight();
            graphics.drawString((String)lines.elementAt(i), x, liney, 0);
        }
        return y + lines.size() * font.getHeight();
    }

    public static int getMultilineStringHeight(String str, int width) {
        Font font = Font.getFont((int)0, (int)1, (int)16);
        Vector lines = Bitmap.wrap(str, font, width);
        return lines.size() * font.getHeight();
    }

    static Vector wrap(String text, Font font, int width) {
        Vector<String> result = new Vector<String>();
        if (text == null) {
            return result;
        }
        boolean hasMore = true;
        int current = 0;
        int lineBreak = -1;
        int nextSpace = -1;
        while (hasMore) {
            int linewidth;
            do {
                if ((lineBreak = nextSpace) == text.length() - 1) {
                    hasMore = false;
                    break;
                }
                nextSpace = text.indexOf(32, lineBreak + 1);
                if (nextSpace != -1) continue;
                nextSpace = text.length() - 1;
            } while ((linewidth = font.substringWidth(text, current, nextSpace - current)) <= width);
            String line = text.substring(current, lineBreak + 1);
            result.addElement(line);
            current = lineBreak + 1;
        }
        return result;
    }

    public static Bitmap combineBitmaps(Bitmap bitmap1, Bitmap bitmap2) {
        Image resultImage = Image.createImage((int)bitmap1.getWidth(), (int)bitmap1.getHeight());
        Graphics graphics = resultImage.getGraphics();
        Bitmap.drawBitmap(graphics, bitmap1, 0, 0);
        Bitmap.drawBitmap(graphics, bitmap2, 0, 0);
        return new Bitmap(resultImage);
    }

    public static Bitmap multiplyBitmaps(Bitmap bitmap1, Bitmap bitmap2) {
        int[] rgb_b1 = Bitmap.getRGB(bitmap1);
        int[] rgb_b2 = Bitmap.getRGB(bitmap2);
        int[] rgb_multiplied = new int[rgb_b1.length];
        for (int i = 0; i < rgb_b1.length; ++i) {
            int pixel_b1 = rgb_b1[i];
            int alpha_b1 = (pixel_b1 & 0xFF000000) >> 24;
            int red_b1 = (pixel_b1 & 0xFF0000) >> 16;
            int green_b1 = (pixel_b1 & 0xFF00) >> 8;
            int blue_b1 = pixel_b1 & 0xFF;
            int pixel_b2 = rgb_b2[i];
            int alpha_b2 = (pixel_b2 & 0xFF000000) >> 24;
            int red_b2 = (pixel_b2 & 0xFF0000) >> 16;
            int green_b2 = (pixel_b2 & 0xFF00) >> 8;
            int blue_b2 = pixel_b2 & 0xFF;
            int red_m = red_b1 * red_b2 / 255;
            int green_m = green_b1 * green_b2 / 255;
            int blue_m = blue_b1 * blue_b2 / 255;
            int alpha_m = alpha_b1;
            red_m = Math.min(Math.max(0, red_m), 255);
            green_m = Math.min(Math.max(0, green_m), 255);
            blue_m = Math.min(Math.max(0, blue_m), 255);
            rgb_multiplied[i] = (alpha_m << 24) + (red_m << 16) + (green_m << 8) + blue_m;
        }
        return new Bitmap(Image.createRGBImage((int[])rgb_multiplied, (int)bitmap1.getWidth(), (int)bitmap1.getHeight(), (boolean)true));
    }
}

