/*
 * Decompiled with CFR 0.152.
 */
package com.renderedideas.game;

import com.renderedideas.game.AdManager;
import com.renderedideas.game.GameMIDlet;
import com.renderedideas.game.PrintConsole;
import java.io.DataInputStream;
import java.io.InputStream;
import java.io.OutputStream;
import javax.microedition.io.Connector;
import javax.microedition.io.HttpConnection;
import javax.microedition.lcdui.Alert;
import javax.microedition.lcdui.AlertType;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Displayable;

public class PlatformService {
    public static void exit() {
        GameMIDlet.instance.exit();
    }

    public static boolean isAccelerometerAvailable() {
        return GameMIDlet.instance.isAccelerometerAvailable();
    }

    public static void startAccelerometer() {
        GameMIDlet.instance.startAccelerometer();
    }

    public static void stopAccelerometer() {
        GameMIDlet.instance.stopAccelerometer();
    }

    public static void setFPS(int fps) {
        if (GameMIDlet.instance.gameCanvas != null) {
            GameMIDlet.instance.gameCanvas.setFps(fps);
        }
    }

    public static void setBgFPS(int fps) {
        if (GameMIDlet.instance.gameCanvas != null) {
            GameMIDlet.instance.gameCanvas.setBgFps(fps);
        }
    }

    public static int getWidth() {
        return GameMIDlet.instance.getWidth();
    }

    public static int getHeight() {
        return GameMIDlet.instance.getHeight();
    }

    public static void preventScreenSleep() {
        GameMIDlet.instance.preventScreenSleep();
    }

    public static void allowScreenSleep() {
        GameMIDlet.instance.allowScreenSleep();
    }

    public static void showRateAppDialog() {
        GameMIDlet.instance.rateMyApp();
    }

    public static void showYesNoDialog(String title, String message) {
        GameMIDlet.instance.showYesNoDialog(title, message);
    }

    public static void openURL(String url) {
        try {
            if (GameMIDlet.instance.platformRequest(url)) {
                GameMIDlet.instance.exit();
            } else {
                GameMIDlet.instance.gameCanvas.hideNotify();
            }
        }
        catch (Exception e2) {
            PrintConsole.print("error:PlatformService.openURL->" + e2);
        }
    }

    public static void errorQuit(String error) {
        Alert alert = new Alert("Error", error, null, AlertType.ERROR);
        Command ok = new Command("Close", 4, 1);
        alert.setTimeout(-2);
        alert.addCommand(ok);
        alert.setCommandListener((CommandListener)GameMIDlet.instance);
        GameMIDlet.instance.display.setCurrent((Displayable)alert);
    }

    public static String getScoresFromServer(String url, String topName, String topScore) {
        HttpConnection httpConn = null;
        DataInputStream is = null;
        OutputStream os = null;
        try {
            int chr;
            String customUA = "CustomUA: device=" + GameMIDlet.urlEncode(System.getProperty("microedition.platform"));
            httpConn = (HttpConnection)Connector.open((String)url);
            httpConn.setRequestMethod("POST");
            if (httpConn.getRequestProperty("User-Agent") == null) {
                httpConn.setRequestProperty("User-Agent", customUA);
            }
            httpConn.setRequestProperty("Accept_Language", "en-US");
            httpConn.setRequestProperty("Content-Type", "application/x-www-form-urlencoded");
            StringBuffer sb = new StringBuffer();
            os = httpConn.openOutputStream();
            if (topName.equals("")) {
                topName = "Player";
            }
            String params = "fname=" + topName + "&score=" + topScore;
            os.write(params.getBytes());
            is = httpConn.openDataInputStream();
            while ((chr = ((InputStream)is).read()) != -1) {
                sb.append((char)chr);
            }
            return new String(sb);
        }
        catch (Exception e2) {
            PrintConsole.print("error in conn:" + e2);
            return null;
        }
    }

    public static void sleepThread(int time) {
        try {
            Thread.sleep(time);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static float nextFloat(int n) {
        return GameMIDlet.instance.random.nextFloat() * (float)n;
    }

    public static int nextInt(int n) {
        return GameMIDlet.instance.random.nextInt(n);
    }

    public static long currentTimeMillis() {
        return System.currentTimeMillis();
    }

    public static void getUserInput() {
        GameMIDlet.instance.getUserInput();
    }

    public static void downloadAd() {
        AdManager.downloadAd();
    }

    public static void downloadHouseAd() {
        AdManager.downloadHouseAd();
    }

    public static void showAd() {
        GameMIDlet.instance.showAd();
    }

    public static void showMessageBox(String title, String message) {
        GameMIDlet.instance.showMessageBox(title, message);
    }

    public static void showFeedbackForm() {
        GameMIDlet.instance.showFeedbackForm();
    }

    public static long getTotalMemory() {
        return Runtime.getRuntime().totalMemory();
    }

    public static boolean isTouchSupported() {
        return GameMIDlet.instance.isTouchSupported();
    }

    public static void enableGestures() {
        GameMIDlet.instance.enableGestures();
    }

    public static void disableGestures() {
        GameMIDlet.instance.disableGestures();
    }

    public static void showStore() {
        if (GameMIDlet.instance.iapProvider != null) {
            GameMIDlet.instance.iapProvider.showStore();
        }
    }

    public static void buyGame() {
        if (GameMIDlet.instance.iapProvider != null) {
            GameMIDlet.instance.iapProvider.buyGame();
        }
    }
}

