/*
 * Decompiled with CFR 0.152.
 */
package com.renderedideas.superbike3d;

import com.renderedideas.game.DictionaryKeyValue;
import com.renderedideas.game.PlatformService;
import com.renderedideas.game.Sound;
import com.renderedideas.superbike3d.Constant;
import com.renderedideas.superbike3d.Game;
import com.renderedideas.superbike3d.MyCanvas;
import com.renderedideas.superbike3d.Ted;

public class SoundManager {
    public static DictionaryKeyValue sounds;

    public static void loadSounds() {
        if (Game.volume == 0) {
            return;
        }
        sounds = new DictionaryKeyValue();
        if (MyCanvas.game.maxPlayers == 1) {
            SoundManager.add(Constant.BACKGROUNDMUSIC_SOUND, 100, "/audio/run" + PlatformService.nextInt(2), -1);
            return;
        }
        if (MyCanvas.game.maxPlayers == 2) {
            SoundManager.add(Constant.BACKGROUNDMUSIC_SOUND, 100, "/audio/run" + PlatformService.nextInt(2), -1);
            SoundManager.add(Constant.COPSIREN_SOUND, 100, "/audio/cop_siren", -1);
            return;
        }
        if (MyCanvas.game.maxPlayers == 3) {
            SoundManager.add(Constant.BACKGROUNDMUSIC_SOUND, 100, "/audio/run" + PlatformService.nextInt(2), -1);
            SoundManager.add(Constant.COPSIREN_SOUND, 100, "/audio/cop_siren", -1);
            if (!Ted.game.soundMixing) {
                return;
            }
            SoundManager.add(Constant.HIT_SOUND, 100, "/audio/hit", 1);
            return;
        }
        if (MyCanvas.game.maxPlayers == 4) {
            SoundManager.add(Constant.BACKGROUNDMUSIC_SOUND, 100, "/audio/run" + PlatformService.nextInt(2), -1);
            SoundManager.add(Constant.COPSIREN_SOUND, 100, "/audio/cop_siren", -1);
            if (!Ted.game.soundMixing) {
                return;
            }
            SoundManager.add(Constant.HIT_SOUND, 100, "/audio/hit", 1);
            SoundManager.add(Constant.SKID_SOUND, 40, "/audio/skid", 1);
            return;
        }
        SoundManager.add(Constant.BACKGROUNDMUSIC_SOUND, 100, "/audio/run" + PlatformService.nextInt(2), -1);
        SoundManager.add(Constant.COPSIREN_SOUND, 100, "/audio/cop_siren", -1);
        if (!Ted.game.soundMixing) {
            return;
        }
        SoundManager.add(Constant.HIT_SOUND, 100, "/audio/hit", 1);
        SoundManager.add(Constant.SKID_SOUND, 40, "/audio/skid", 1);
        SoundManager.add(Constant.COIN_SOUND, 40, "/audio/coin", 1);
    }

    public static void add(Integer id, int soundVolume, String filePath, int loopCount) {
        if (sounds.containsKey(id) || Game.volume == 0 || sounds == null) {
            return;
        }
        sounds.put(id, new Sound(soundVolume, filePath, loopCount));
    }

    public static void remove(Integer id) {
        if (Game.volume == 0 || sounds == null) {
            return;
        }
        Sound sound = (Sound)sounds.remove(id);
        if (sound != null) {
            sound.unload();
            sound = null;
        }
    }

    public static void play(Integer id) {
        if (Game.volume == 0 || sounds == null) {
            return;
        }
        Sound sound = (Sound)sounds.get(id);
        if (sound != null) {
            sound.play();
        }
    }

    public static void stop(Integer id) {
        if (Game.volume == 0 || sounds == null) {
            return;
        }
        Sound sound = (Sound)sounds.get(id);
        if (sound != null) {
            sound.stop();
        }
    }

    public static void removeAll() {
        if (Game.volume == 0 || sounds == null) {
            return;
        }
        Object[] objects = sounds.getAllValues();
        for (int i = 0; i < objects.length; ++i) {
            Sound s = (Sound)objects[i];
            s.unload();
            Object var2_2 = null;
        }
        sounds.clear();
        sounds = null;
    }
}

