/*
 * Decompiled with CFR 0.152.
 */
package com.renderedideas.game;

import InneractiveSDK.IADView;
import com.renderedideas.game.GameMIDlet;
import com.renderedideas.game.PrintConsole;
import java.io.DataInputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Vector;
import javax.microedition.io.Connector;
import javax.microedition.io.HttpConnection;
import javax.microedition.lcdui.Canvas;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class AdManager
extends Canvas
implements Runnable {
    public static int width;
    public static int height;
    static int adType;
    static final int NORMAL_AD = 1;
    static final int HOUSE_AD = 2;
    static AdManager adManager;
    public static Image adImage;
    public static String adURL;
    public static String adText;
    public static boolean newAdLoaded;
    public static Image houseAdImage;
    public static String houseAdURL;
    public static String houseAdText;
    public static boolean houseAdLoaded;

    public void run() {
        switch (adType) {
            case 1: {
                Vector adData;
                newAdLoaded = false;
                AdManager.refreshAd();
                if (newAdLoaded || (adData = IADView.getBannerAdData(GameMIDlet.instance, "RenderedIdeas_HighwayRacing3D_Nokia")) == null) break;
                adImage = (Image)adData.elementAt(0);
                adURL = (String)adData.elementAt(1);
                adText = "";
                newAdLoaded = true;
                break;
            }
            case 2: {
                houseAdLoaded = false;
                AdManager.refreshHouseAd();
                break;
            }
            default: {
                return;
            }
        }
    }

    private AdManager() {
        this.setFullScreenMode(true);
        width = this.getWidth();
        height = this.getHeight();
        adManager = this;
    }

    public static void downloadAd() {
        if (GameMIDlet.bought) {
            return;
        }
        new AdManager();
        adType = 1;
        Thread downloadThread = new Thread(adManager);
        downloadThread.start();
    }

    public static void downloadHouseAd() {
        if (GameMIDlet.bought) {
            return;
        }
        new AdManager();
        adType = 2;
        Thread downloadThread = new Thread(adManager);
        downloadThread.start();
    }

    public static boolean refreshAd() {
        HttpConnection httpConn = null;
        String aid = "" + GameMIDlet.instance.getAppProperty("MIDlet-Name");
        aid = AdManager.replace(aid, " ", "_");
        String h = "" + height;
        String w = "" + width;
        String url = "http://ri-mobile.com/adManager/ad.php?platform=j2me&aid=" + aid + "&h=" + h + "&w=" + w + "&touch=" + adManager.hasPointerEvents();
        InputStream is = null;
        OutputStream os = null;
        PrintConsole.print("requesting..." + url);
        try {
            httpConn = (HttpConnection)Connector.open((String)url);
            httpConn.setRequestMethod("GET");
            int respCode = httpConn.getResponseCode();
            if (respCode == 200) {
                int chr;
                StringBuffer sb = new StringBuffer();
                os = httpConn.openOutputStream();
                is = httpConn.openDataInputStream();
                while ((chr = is.read()) != -1) {
                    sb.append((char)chr);
                }
                PrintConsole.print(sb.toString());
                adURL = AdManager.getURL(new String(sb));
                adText = AdManager.getText(new String(sb));
                if (!adText.trim().equals("")) {
                    newAdLoaded = true;
                }
                adImage = AdManager.getImage(new String(sb));
                newAdLoaded = true;
            } else {
                PrintConsole.print("Error in opening HTTP Connection. Error#" + respCode);
            }
        }
        catch (Exception e2) {
            if (newAdLoaded) {
                adImage = null;
            }
            PrintConsole.print("error in conn:" + e2);
        }
        try {
            if (is != null) {
                is.close();
            }
            if (os != null) {
                os.close();
            }
            if (httpConn != null) {
                httpConn.close();
            }
        }
        catch (Exception e3) {
            // empty catch block
        }
        return false;
    }

    public static boolean refreshHouseAd() {
        HttpConnection httpConn = null;
        String aid = "" + GameMIDlet.instance.getAppProperty("MIDlet-Name");
        aid = AdManager.replace(aid, " ", "_");
        String h = "" + height;
        String w = "" + width;
        String url = "http://ri-mobile.com/houseAd/nokia/ad.php?aid=" + aid + "&h=" + h + "&w=" + w + "&touch=" + adManager.hasPointerEvents();
        InputStream is = null;
        OutputStream os = null;
        PrintConsole.print("requesting..." + url);
        try {
            httpConn = (HttpConnection)Connector.open((String)url);
            httpConn.setRequestMethod("GET");
            int respCode = httpConn.getResponseCode();
            if (respCode == 200) {
                int chr;
                StringBuffer sb = new StringBuffer();
                os = httpConn.openOutputStream();
                is = httpConn.openDataInputStream();
                while ((chr = is.read()) != -1) {
                    sb.append((char)chr);
                }
                PrintConsole.print(sb.toString());
                houseAdURL = AdManager.getURL(new String(sb));
                houseAdText = AdManager.getText(new String(sb));
                if (!houseAdText.trim().equals("")) {
                    houseAdLoaded = true;
                }
                houseAdImage = AdManager.getImage(new String(sb));
                houseAdLoaded = true;
            } else {
                PrintConsole.print("Error in opening HTTP Connection. Error#" + respCode);
            }
        }
        catch (Exception e2) {
            if (houseAdLoaded) {
                houseAdImage = null;
            }
            PrintConsole.print("error in conn:" + e2);
        }
        try {
            if (is != null) {
                is.close();
            }
            if (os != null) {
                os.close();
            }
            if (httpConn != null) {
                httpConn.close();
            }
        }
        catch (Exception e3) {
            // empty catch block
        }
        return false;
    }

    public static String getURL(String response) throws Exception {
        if (response.indexOf("No Ad") != -1) {
            throw new Exception("no Ad");
        }
        int start = response.indexOf("<a");
        start = response.indexOf("href=", start);
        int end = response.indexOf("\"", start + 6);
        String url = response.substring(start + 6, end);
        url = AdManager.replace(url, "&amp;", "&");
        return url;
    }

    public static String getText(String response) throws Exception {
        int end;
        if (response.indexOf("No Ad") != -1) {
            throw new Exception("no Ad");
        }
        int start = response.indexOf("<text");
        if ((start = response.indexOf("value=", start)) + 7 == (end = response.indexOf("\"", start + 7))) {
            return "";
        }
        String text = response.substring(start + 7, end);
        return text;
    }

    static String replace(String str, String pattern, String replace) {
        int s = 0;
        int e2 = 0;
        StringBuffer result = new StringBuffer();
        while ((e2 = str.indexOf(pattern, s)) >= 0) {
            result.append(str.substring(s, e2));
            result.append(replace);
            s = e2 + pattern.length();
        }
        result.append(str.substring(s));
        return result.toString();
    }

    public static Image getImage(String response) throws Exception {
        int end;
        if (response.indexOf("No Ad") != -1) {
            throw new Exception("no Ad");
        }
        int start = response.indexOf("<img");
        if ((start = response.indexOf("src=", start)) + 5 == (end = response.indexOf("\"", start + 5))) {
            throw new Exception("no Ad");
        }
        String imageURL = response.substring(start + 5, end);
        return AdManager.loadImageFromURL(imageURL);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Image loadImageFromURL(String url) throws IOException {
        HttpConnection hpc = null;
        FilterInputStream dis = null;
        try {
            hpc = (HttpConnection)Connector.open((String)url);
            int length = (int)hpc.getLength();
            byte[] data = new byte[length];
            dis = new DataInputStream(hpc.openInputStream());
            ((DataInputStream)dis).readFully(data);
            Image image = Image.createImage((byte[])data, (int)0, (int)data.length);
            return image;
        }
        finally {
            if (hpc != null) {
                hpc.close();
            }
            if (dis != null) {
                dis.close();
            }
        }
    }

    protected void paint(Graphics g) {
    }

    static {
        adType = -1;
        adImage = null;
        adURL = "noAd";
        adText = "";
        newAdLoaded = false;
        houseAdImage = null;
        houseAdURL = "noAd";
        houseAdText = "";
        houseAdLoaded = false;
    }
}

