/*
 * Decompiled with CFR 0.152.
 */
package com.renderedideas.game;

import com.renderedideas.game.Bitmap;
import com.renderedideas.game.GameMIDlet;
import com.renderedideas.superbike3d.Game;
import javax.microedition.lcdui.Canvas;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Graphics;

public class GameCanvas
extends Canvas
implements Runnable,
CommandListener {
    final int LEFTSOFT_KEY;
    final int RIGHTSOFT_KEY;
    final int MIDDLESOFT_KEY;
    final int KEYNUM_1;
    final int KEYNUM_2;
    final int KEYNUM_3;
    final int KEYNUM_4;
    final int KEYNUM_5;
    final int KEYNUM_6;
    final int KEYNUM_7;
    final int KEYNUM_8;
    final int KEYNUM_9;
    final int KEYNUM_0;
    final int UPKEY;
    final int DOWNKEY;
    final int LEFTKEY;
    final int RIGHTKEY;
    public final int LEFTSWIPE;
    public final int RIGHTSWIPE;
    public final int UPSWIPE;
    public final int DOWNSWIPE;
    GameMIDlet gamemidlet;
    Thread mainThread;
    boolean running = true;
    Game game;
    int possibleFps = 0;
    int period;
    int fps;
    int bgFps = this.fps = 30;
    boolean wrongOrientation = false;

    public GameCanvas(GameMIDlet gamemidlet) {
        this.LEFTSOFT_KEY = 101;
        this.RIGHTSOFT_KEY = 102;
        this.MIDDLESOFT_KEY = 103;
        this.KEYNUM_1 = 104;
        this.KEYNUM_2 = 105;
        this.KEYNUM_3 = 106;
        this.KEYNUM_4 = 107;
        this.KEYNUM_5 = 108;
        this.KEYNUM_6 = 109;
        this.KEYNUM_7 = 110;
        this.KEYNUM_8 = 111;
        this.KEYNUM_9 = 112;
        this.KEYNUM_0 = 113;
        this.UPKEY = 114;
        this.DOWNKEY = 115;
        this.LEFTKEY = 116;
        this.RIGHTKEY = 117;
        this.LEFTSWIPE = 118;
        this.RIGHTSWIPE = 119;
        this.UPSWIPE = 120;
        this.DOWNSWIPE = 121;
        this.game = new Game();
        this.gamemidlet = gamemidlet;
        this.mainThread = new Thread(this);
        this.mainThread.start();
        this.setFullScreenMode(true);
        this.sizeChanged(this.getWidth(), this.getHeight());
        if (this.hasPointerEvents()) {
            this.addCommand(new Command("Back", 2, 1));
            this.setCommandListener(this);
        }
    }

    public void run() {
        this.game.loadContent();
        this.period = 1000 / this.fps;
        long previousTime = System.currentTimeMillis();
        while (this.running) {
            long sleepTime;
            long timeDiff;
            long beforeTime = System.currentTimeMillis();
            if (this.gamemidlet.messageBoxComplete) {
                this.game.messageBoxComplete();
                this.gamemidlet.messageBoxComplete = false;
            }
            if (!this.wrongOrientation) {
                this.game.update((float)(beforeTime - previousTime) / 1000.0f);
            }
            if (this.game.isLoadingScreen) {
                this.startLoadingThread();
            }
            previousTime = System.currentTimeMillis();
            this.repaint();
            this.serviceRepaints();
            if (this.gamemidlet.myGesture != null) {
                this.gamemidlet.myGesture.process();
            }
            if ((timeDiff = System.currentTimeMillis() - beforeTime) != 0L) {
                this.game.actualDeviceFps((int)((long)(1000 / this.fps * 100) / timeDiff));
            }
            if ((sleepTime = (long)this.period - timeDiff) <= 5L) {
                sleepTime = 10L;
            }
            try {
                Thread.sleep(sleepTime);
            }
            catch (Exception e2) {}
        }
    }

    public void startLoadingThread() {
        Thread t = new Thread(){

            public void run() {
                while (GameCanvas.this.game.isLoadingScreen) {
                    GameCanvas.this.repaint();
                    GameCanvas.this.serviceRepaints();
                    try {
                        Thread.sleep(500L);
                    }
                    catch (Exception exception) {}
                }
            }
        };
        t.start();
    }

    public void setFps(int FPS) {
        this.fps = FPS;
    }

    public void setBgFps(int FPS) {
        this.bgFps = FPS;
    }

    public void paint(Graphics g) {
        if (!this.wrongOrientation) {
            this.game.paint(g);
        } else {
            g.setColor(0, 0, 0);
            g.fillRect(0, 0, this.getWidth(), this.getHeight());
            g.setColor(255, 255, 255);
            Bitmap.drawMultilineString2(g, "Please rotate your device", this.getWidth() / 10, this.getHeight() / 2 - Bitmap.getMultilineStringHeight("Please rotate your device.", this.getWidth() * 8 / 10) / 2, this.getWidth() * 8 / 10);
        }
    }

    public void keyPressed(int i) {
        if (this.wrongOrientation) {
            return;
        }
        int j = this.getGameAction(i);
        if (j == 1) {
            this.game.keyPressed(114);
        } else if (j == 6) {
            this.game.keyPressed(115);
        } else if (j == 2) {
            this.game.keyPressed(116);
        } else if (j == 5) {
            this.game.keyPressed(117);
        } else if (i == 53 || i == -6 || i == -10) {
            this.game.keyPressed(101);
        } else if (i == -5) {
            this.game.keyPressed(103);
        } else if (i == -7 || i == 49) {
            this.game.keyPressed(102);
        } else if (i == 49 || i == 114) {
            this.game.keyPressed(104);
        } else if (i == 50 || i == 116) {
            this.game.keyPressed(105);
        } else if (i == 51 || i == 121) {
            this.game.keyPressed(106);
        } else if (i == 52 || i == 102) {
            this.game.keyPressed(107);
        } else if (i == 53 || i == 103) {
            this.game.keyPressed(108);
        } else if (i == 54 || i == 104) {
            this.game.keyPressed(109);
        } else if (i == 55 || i == 118) {
            this.game.keyPressed(110);
        } else if (i == 56 || i == 98) {
            this.game.keyPressed(111);
        } else if (i == 57 || i == 110) {
            this.game.keyPressed(112);
        } else if (i == 48 || i == 109) {
            this.game.keyPressed(113);
        }
    }

    public void keyReleased(int i) {
        if (this.wrongOrientation) {
            return;
        }
        int j = this.getGameAction(i);
        if (j == 1) {
            this.game.keyReleased(114);
        } else if (j == 6) {
            this.game.keyReleased(115);
        } else if (j == 2) {
            this.game.keyReleased(116);
        } else if (j == 5) {
            this.game.keyReleased(117);
        } else if (i == 53 || i == -5 || i == -6 || i == -10) {
            this.game.keyReleased(101);
        } else if (i == -7 || i == 49) {
            this.game.keyReleased(102);
        } else if (i == 49 || i == 114) {
            this.game.keyReleased(104);
        } else if (i == 50 || i == 116) {
            this.game.keyReleased(105);
        } else if (i == 51 || i == 121) {
            this.game.keyReleased(106);
        } else if (i == 52 || i == 102) {
            this.game.keyReleased(107);
        } else if (i == 53 || i == 103) {
            this.game.keyReleased(108);
        } else if (i == 54 || i == 104) {
            this.game.keyReleased(109);
        } else if (i == 55 || i == 118) {
            this.game.keyReleased(110);
        } else if (i == 56 || i == 98) {
            this.game.keyReleased(111);
        } else if (i == 57 || i == 110) {
            this.game.keyReleased(112);
        } else if (i == 48 || i == 109) {
            this.game.keyReleased(113);
        }
    }

    public void keyRepeated(int i) {
        if (this.wrongOrientation) {
            return;
        }
        int j = this.getGameAction(i);
        if (j == 1) {
            this.game.keyRepeated(114);
        } else if (j == 6) {
            this.game.keyRepeated(115);
        } else if (j == 2) {
            this.game.keyRepeated(116);
        } else if (j == 5) {
            this.game.keyRepeated(117);
        } else if (i == 53 || i == -5 || i == -6 || i == -10) {
            this.game.keyRepeated(101);
        } else if (i == -7 || i == 49) {
            this.game.keyRepeated(102);
        } else if (i == 49 || i == 114) {
            this.game.keyRepeated(104);
        } else if (i == 50 || i == 116) {
            this.game.keyRepeated(105);
        } else if (i == 51 || i == 121) {
            this.game.keyRepeated(106);
        } else if (i == 52 || i == 102) {
            this.game.keyRepeated(107);
        } else if (i == 53 || i == 103) {
            this.game.keyRepeated(108);
        } else if (i == 54 || i == 104) {
            this.game.keyRepeated(109);
        } else if (i == 55 || i == 118) {
            this.game.keyRepeated(110);
        } else if (i == 56 || i == 98) {
            this.game.keyRepeated(111);
        } else if (i == 57 || i == 110) {
            this.game.keyRepeated(112);
        } else if (i == 48 || i == 109) {
            this.game.keyRepeated(113);
        }
    }

    public void pointerPressed(int xx, int yy) {
        if (this.wrongOrientation) {
            return;
        }
        this.game.pointerPressed(xx, yy);
        if (this.gamemidlet.myGesture != null) {
            this.gamemidlet.myGesture.addPoint(xx, yy);
        }
    }

    public void pointerReleased(int xx, int yy) {
        if (this.wrongOrientation) {
            return;
        }
        this.game.pointerReleased(xx, yy);
        if (this.gamemidlet.myGesture != null) {
            this.gamemidlet.myGesture.addPoint(xx, yy);
            this.gamemidlet.myGesture.touchRelease();
        }
    }

    public void pointerDragged(int xx, int yy) {
        if (this.wrongOrientation) {
            return;
        }
        this.game.pointerDragged(xx, yy);
        if (this.gamemidlet.myGesture != null) {
            this.gamemidlet.myGesture.addPoint(xx, yy);
        }
    }

    public void hideNotify() {
        this.game.pause();
        this.period = 1000 / this.bgFps;
    }

    public void showNotify() {
        this.game.resume();
        this.period = 1000 / this.fps;
    }

    protected void sizeChanged(int newWidth, int newHeight) {
        String orientation = this.gamemidlet.getAppProperty("Nokia-MIDlet-App-Orientation");
        if (orientation == null) {
            return;
        }
        if (orientation.equals("portrait")) {
            if (newWidth > newHeight) {
                this.wrongOrientation = true;
                this.hideNotify();
            } else {
                this.wrongOrientation = false;
                this.showNotify();
            }
        } else if (orientation.equals("landscape")) {
            if (newWidth < newHeight) {
                this.wrongOrientation = true;
                this.hideNotify();
            } else {
                this.wrongOrientation = false;
                this.showNotify();
            }
        }
    }

    public void commandAction(Command c2, Displayable d2) {
        if (c2.getCommandType() == 2) {
            this.game.onBackKey();
        }
    }

    public void handleSwipe(int direction) {
        this.game.handleSwipe(direction);
    }
}

