/*
 * Decompiled with CFR 0.152.
 */
package com.renderedideas.superbike3d;

import com.renderedideas.game.AdManager;
import com.renderedideas.game.Bitmap;
import com.renderedideas.game.PlatformService;
import com.renderedideas.superbike3d.Game;
import com.renderedideas.superbike3d.MyFont;
import com.renderedideas.superbike3d.SuperCanvas;
import javax.microedition.lcdui.Graphics;

class HouseAdCanvas
extends SuperCanvas {
    boolean disable = false;
    Bitmap close;
    Game game;

    HouseAdCanvas(Game g) {
        this.game = g;
        this.close = new Bitmap("/close");
    }

    public void update(float deltaTime) {
    }

    public void paint(Graphics g) {
        if (this.disable) {
            return;
        }
        Bitmap.fillColor(g, 0, 0, Game.width, Game.height, 0, 0, 0);
        if (AdManager.houseAdImage != null) {
            Bitmap.drawBitmap(g, AdManager.houseAdImage, Game.width / 2 - AdManager.houseAdImage.getWidth() / 2, Game.height / 2 - AdManager.houseAdImage.getHeight() / 2);
        }
        if (!AdManager.houseAdText.trim().equals("")) {
            if (AdManager.houseAdImage != null) {
                Bitmap.drawMultilineString(g, AdManager.houseAdText, Game.width / 10, Game.height / 2 + AdManager.houseAdImage.getHeight() / 2, Game.width * 8 / 10);
            } else {
                Bitmap.drawMultilineString(g, AdManager.houseAdText, Game.width / 10, Game.height / 2 - Bitmap.getMultilineStringHeight(AdManager.houseAdText, Game.width * 8 / 10) / 2, Game.width * 8 / 10);
            }
        }
        if (PlatformService.isTouchSupported()) {
            Bitmap.drawBitmap(g, this.close, Game.width - this.close.getWidth(), 0);
        } else {
            MyFont.drawString(" Go", g, 0, Game.height - MyFont.stringHeight());
            MyFont.drawString("Exit", g, Game.width - MyFont.stringWidth("Exit "), Game.height - MyFont.stringHeight());
        }
    }

    public void keyPressed(int i) {
        if (this.disable) {
            return;
        }
        if (i == 101 || i == 103) {
            this.game.playSelectSound();
            PlatformService.openURL(AdManager.houseAdURL);
            PlatformService.sleepThread(1000);
            PlatformService.exit();
        } else if (i == 102) {
            this.game.playSelectSound();
            PlatformService.exit();
            return;
        }
    }

    public void keyReleased(int key) {
    }

    public void keyRepeated(int key) {
    }

    public void pointerPressed(int xx, int yy) {
        if (this.disable) {
            return;
        }
        if (xx >= Game.width - this.close.getWidth() && yy <= this.close.getHeight()) {
            this.game.playSelectSound();
            PlatformService.exit();
            return;
        }
        if (AdManager.houseAdImage != null) {
            if (xx >= Game.width / 2 - AdManager.houseAdImage.getWidth() / 2) {
                if (xx <= Game.width / 2 - AdManager.houseAdImage.getWidth() / 2 + AdManager.houseAdImage.getWidth()) {
                    if (yy >= Game.height / 2 - AdManager.houseAdImage.getHeight() / 2) {
                        if (yy <= Game.height / 2 - AdManager.houseAdImage.getHeight() / 2 + AdManager.houseAdImage.getHeight()) {
                            this.game.playSelectSound();
                            PlatformService.openURL(AdManager.houseAdURL);
                            PlatformService.sleepThread(1000);
                            PlatformService.exit();
                        }
                    }
                }
            }
        }
        if (!AdManager.houseAdText.trim().equals("")) {
            if (AdManager.houseAdImage != null) {
                if (yy >= Game.height / 2 + AdManager.houseAdImage.getHeight() / 2) {
                    if (yy <= Game.height / 2 + AdManager.houseAdImage.getHeight() / 2 + Bitmap.getMultilineStringHeight(AdManager.houseAdText, Game.width * 8 / 10)) {
                        this.game.playSelectSound();
                        PlatformService.openURL(AdManager.houseAdURL);
                        PlatformService.sleepThread(1000);
                        PlatformService.exit();
                    }
                }
            } else if (yy >= Game.height / 2 - Bitmap.getMultilineStringHeight(AdManager.houseAdText, Game.width * 8 / 10) / 2) {
                if (yy <= Game.height / 2 + Bitmap.getMultilineStringHeight(AdManager.houseAdText, Game.width * 8 / 10) / 2) {
                    this.game.playSelectSound();
                    PlatformService.openURL(AdManager.houseAdURL);
                    PlatformService.sleepThread(1000);
                    PlatformService.exit();
                }
            }
        }
    }

    public void pointerReleased(int xx, int yy) {
    }

    public void pointerDragged(int xx, int yy) {
    }

    public void pause() {
    }

    public void resume() {
    }

    public void onBackKey() {
        this.game.playSelectSound();
        PlatformService.exit();
    }

    public void deallocate() {
    }

    public void handleSwipe(int direction) {
    }
}

