/*
 * Decompiled with CFR 0.152.
 */
package com.renderedideas.superbike3d;

import com.renderedideas.game.Bitmap;
import com.renderedideas.game.PlatformService;
import com.renderedideas.game.Sound;
import com.renderedideas.game.Storage;
import com.renderedideas.superbike3d.FontsBig;
import com.renderedideas.superbike3d.Game;
import com.renderedideas.superbike3d.MyFont;
import com.renderedideas.superbike3d.SuperCanvas;
import javax.microedition.lcdui.Graphics;

class MenuCanvas
extends SuperCanvas {
    Game game;
    Bitmap background;
    Bitmap aboutScreen;
    Bitmap storeScreen;
    Bitmap backImage;
    Bitmap helpScreen;
    Bitmap deactivateOption;
    Bitmap selectorImage;
    Bitmap buyImage;
    Bitmap purchasedImage;
    Bitmap bike;
    Bitmap car;
    Bitmap truck;
    Bitmap taxi;
    Bitmap menuButtons;
    boolean disable;
    boolean about;
    boolean enableSound;
    boolean help;
    boolean store;
    boolean selectVehicle;
    static Sound bgSound;
    int selector = 2;

    public MenuCanvas(Game g) {
        this.game = g;
        this.selectVehicle = false;
        this.store = false;
        this.help = false;
        this.enableSound = false;
        this.about = false;
        this.disable = false;
        this.enableSound = Game.volume != 0;
        this.background = new Bitmap("/menu.png");
        this.helpScreen = Game.accelerometerSupported ? new Bitmap("/help.png") : new Bitmap("/help_keys.png");
        this.backImage = new Bitmap("/back_button.png");
        this.buyImage = new Bitmap("/buy_button.png");
        this.deactivateOption = new Bitmap("/deactivate.png");
        this.selectorImage = new Bitmap("/selector.png");
        this.purchasedImage = new Bitmap("/purchased.png");
        this.menuButtons = Game.isIAPSupported && Storage.readData("bought").toLowerCase().equals("false") ? new Bitmap("/menu_buttons_iap.png") : new Bitmap("/menu_buttons.png");
        if (Game.volume != 0) {
            if (bgSound != null) {
                bgSound.reload();
            } else {
                bgSound = new Sound(50, "/audio/menu", -1);
            }
            bgSound.play();
        }
    }

    public void update(float deltaTime) {
    }

    public void paint(Graphics g) {
        if (this.disable) {
            return;
        }
        if (this.selectVehicle) {
            if (this.car == null) {
                this.storeScreen = null;
                this.aboutScreen = null;
                this.car = new Bitmap("/car.png");
                this.taxi = new Bitmap("/taxi.png");
                this.truck = new Bitmap("/truck.png");
                this.bike = new Bitmap("/bike.png");
            }
            Bitmap.fillColor(g, 0, 0, Game.width, Game.height, 0, 0, 0);
            FontsBig.drawString("Select Vehicle", g, Game.width / 2 - FontsBig.stringWidth("Select Vehicle") / 2, Game.height / 4);
            Bitmap.drawBitmap(g, this.taxi, 0, Game.height / 2 - this.taxi.getHeight() / 2);
            if (Game.item1Purchased) {
                Bitmap.drawBitmap(g, this.car, Game.width / 4, Game.height / 2 - this.car.getHeight() / 2);
            }
            if (Game.item2Purchased) {
                Bitmap.drawBitmap(g, this.truck, Game.width / 2, Game.height / 2 - this.truck.getHeight() / 2);
            }
            if (Game.item3Purchased) {
                Bitmap.drawBitmap(g, this.bike, Game.width * 3 / 4, Game.height / 2 - this.bike.getHeight() / 2);
            }
            if (!(PlatformService.isTouchSupported() || this.about || this.help)) {
                this.drawSelector(g);
            }
            return;
        }
        Bitmap.drawBitmap(g, this.background, 0, 0);
        Bitmap.drawBitmap(g, this.menuButtons, Game.width / 2 - this.menuButtons.getWidth() / 2, Game.height * 67 / 100);
        if (!this.enableSound) {
            Bitmap.drawBitmap(g, this.deactivateOption, 83, 284);
        }
        if (this.about) {
            if (this.aboutScreen == null) {
                this.storeScreen = null;
                this.aboutScreen = new Bitmap("/about.png");
            }
            Bitmap.drawBitmap(g, this.aboutScreen, 0, 0);
            Bitmap.drawBitmap(g, this.backImage, 0, Game.height - this.backImage.getHeight());
        } else if (this.store) {
            if (this.storeScreen == null) {
                this.aboutScreen = null;
                this.storeScreen = new Bitmap("/store.png");
            }
            Bitmap.drawBitmap(g, this.storeScreen, 0, 0);
            Bitmap.drawBitmap(g, this.backImage, 0, Game.height - this.backImage.getHeight());
            if (Game.isIAPSupported) {
                Bitmap.drawBitmap(g, this.buyImage, Game.width / 2 - this.buyImage.getWidth() / 2, Game.height - this.buyImage.getHeight());
            }
            MyFont.drawString(Game.totalCoins + "", g, Game.width - MyFont.stringWidth(Game.totalCoins + "") - Game.width * 10 / 100, Game.height / 100);
            MyFont.drawString(Storage.readData("startingHealth") + "", g, Game.width - MyFont.stringWidth(Storage.readData("startingHealth") + "") - Game.width * 10 / 100, Game.height - MyFont.stringHeight() - (int)((float)Game.height * 1.5f / 100.0f));
        } else if (this.help) {
            Bitmap.drawBitmap(g, this.helpScreen, 0, 0);
            Bitmap.drawBitmap(g, this.backImage, 0, Game.height - this.backImage.getHeight());
        }
        if (!(PlatformService.isTouchSupported() || this.about || this.help)) {
            this.drawSelector(g);
        }
        if (this.store && Game.item1Purchased) {
            Bitmap.drawBitmap(g, this.purchasedImage, Game.width - this.purchasedImage.getWidth(), 20 * Game.height / 100);
        }
        if (this.store && Game.item2Purchased) {
            Bitmap.drawBitmap(g, this.purchasedImage, Game.width - this.purchasedImage.getWidth(), 39 * Game.height / 100);
        }
        if (this.store && Game.item3Purchased) {
            Bitmap.drawBitmap(g, this.purchasedImage, Game.width - this.purchasedImage.getWidth(), 58 * Game.height / 100);
        }
    }

    public void keyPressed(int i) {
        if (this.disable) {
            return;
        }
        if (i == 101) {
            if (this.store) {
                this.store = false;
                this.selector = 3;
            } else if (!PlatformService.isTouchSupported()) {
                this.processSelector();
            }
        } else if (i == 102 || i == 103) {
            if (!PlatformService.isTouchSupported()) {
                this.processSelector();
            }
        } else if (i == 115 || i == 117) {
            if (this.selectVehicle) {
                ++this.selector;
                if (this.selector > 4) {
                    this.selector = 1;
                }
                if (this.selector == 2 && !Game.item1Purchased) {
                    ++this.selector;
                }
                if (this.selector == 3 && !Game.item2Purchased) {
                    ++this.selector;
                }
                if (this.selector == 4 && !Game.item3Purchased) {
                    this.selector = 1;
                }
                return;
            }
            if (this.store) {
                ++this.selector;
                if (!Game.isIAPSupported && this.selector == 5) {
                    this.selector = 1;
                }
                if (this.selector > 5) {
                    this.selector = 1;
                }
                if (this.selector == 1 && Game.item1Purchased) {
                    ++this.selector;
                }
                if (this.selector == 2 && Game.item2Purchased) {
                    ++this.selector;
                }
                if (this.selector == 3 && Game.item3Purchased) {
                    ++this.selector;
                }
                return;
            }
            ++this.selector;
            if ((!Game.isIAPSupported || Storage.readData("bought").toLowerCase().equals("true")) && this.selector == 4) {
                ++this.selector;
            }
            if (this.selector > 10) {
                this.selector = 1;
            }
        } else if (i == 114 || i == 116) {
            if (this.selectVehicle) {
                --this.selector;
                if (this.selector <= 0) {
                    this.selector = 4;
                }
                if (this.selector == 4 && !Game.item3Purchased) {
                    --this.selector;
                }
                if (this.selector == 3 && !Game.item2Purchased) {
                    --this.selector;
                }
                if (this.selector == 2 && !Game.item1Purchased) {
                    --this.selector;
                }
                return;
            }
            if (this.store) {
                --this.selector;
                if (this.selector <= 0) {
                    this.selector = 5;
                }
                if (!Game.isIAPSupported && this.selector == 5) {
                    --this.selector;
                }
                if (this.selector == 3 && Game.item3Purchased) {
                    --this.selector;
                }
                if (this.selector == 2 && Game.item2Purchased) {
                    --this.selector;
                }
                if (this.selector == 1 && Game.item1Purchased) {
                    this.selector = 4;
                }
                return;
            }
            --this.selector;
            if ((!Game.isIAPSupported || Storage.readData("bought").toLowerCase().equals("true")) && this.selector == 4) {
                --this.selector;
            }
            if (this.selector <= 0) {
                this.selector = 10;
            }
        }
    }

    public void keyReleased(int key) {
    }

    public void keyRepeated(int i) {
    }

    public void hideNotify() {
    }

    public void showNotify() {
    }

    /*
     * Enabled aggressive block sorting
     */
    public void pointerPressed(int xx, int yy) {
        if (this.disable) {
            return;
        }
        yy = yy * 400 / 320;
        if (this.selectVehicle) {
            if (xx >= 0) {
                if (xx <= Game.width / 4) {
                    if (yy >= Game.height / 2 - this.bike.getHeight() / 2) {
                        if (yy <= Game.height / 2 + this.bike.getHeight() / 2) {
                            Game.startVehicle = "taxi";
                            this.disable = true;
                            this.game.play();
                            return;
                        }
                    }
                }
            }
            if (Game.item1Purchased) {
                if (xx > Game.width / 4) {
                    if (xx <= Game.width / 2) {
                        if (yy >= Game.height / 2 - this.bike.getHeight() / 2) {
                            if (yy <= Game.height / 2 + this.bike.getHeight() / 2) {
                                Game.startVehicle = "car";
                                this.disable = true;
                                this.game.play();
                                return;
                            }
                        }
                    }
                }
            }
            if (Game.item2Purchased) {
                if (xx >= Game.width / 2) {
                    if (xx <= Game.width * 3 / 4) {
                        if (yy >= Game.height / 2 - this.bike.getHeight() / 2) {
                            if (yy <= Game.height / 2 + this.bike.getHeight() / 2) {
                                Game.startVehicle = "truck";
                                this.disable = true;
                                this.game.play();
                                return;
                            }
                        }
                    }
                }
            }
            if (!Game.item3Purchased) return;
            if (xx < Game.width * 3 / 4) return;
            if (xx > Game.width) return;
            if (yy < Game.height / 2 - this.bike.getHeight() / 2) return;
            if (yy > Game.height / 2 + this.bike.getHeight() / 2) return;
            Game.startVehicle = "bike";
            this.disable = true;
            this.game.play();
            return;
        }
        if (this.store) {
            if (xx >= Game.width / 2 - this.buyImage.getWidth() / 2) {
                if (xx <= Game.width / 2 + this.buyImage.getWidth() / 2) {
                    if (yy >= Game.height - this.buyImage.getHeight()) {
                        if (Game.isIAPSupported) {
                            this.game.openIAPStore();
                            return;
                        }
                    }
                }
            }
            if (xx >= 190 && yy >= 70 && yy <= 120 && !Game.item1Purchased) {
                Game.buyItem(1);
                return;
            }
            if (xx >= 190 && yy >= 150 && yy <= 190 && !Game.item2Purchased) {
                Game.buyItem(2);
                return;
            }
            if (xx >= 190 && yy >= 220 && yy <= 270 && !Game.item3Purchased) {
                Game.buyItem(3);
                return;
            }
            if (xx >= 190 && yy >= 290 && yy <= 340) {
                Game.buyItem(4);
                return;
            }
            if (xx > 50) return;
            if (yy < 350) return;
            this.game.playSelectSound();
            this.store = false;
            this.help = false;
            this.about = false;
            return;
        }
        if (xx >= 200 && yy <= 40) {
            this.game.playSelectSound();
            this.game.exit();
            return;
        }
        if ((this.about || this.help || this.store) && xx <= 50 && yy >= 350) {
            this.game.playSelectSound();
            this.store = false;
            this.help = false;
            this.about = false;
            return;
        }
        if (xx <= 43 && yy >= 350) {
            this.game.playSelectSound();
            this.about = true;
            return;
        }
        if (xx >= 43 && xx <= 81 && yy >= 350) {
            this.game.playSelectSound();
            this.help = true;
            return;
        }
        if (xx >= 81 && xx <= 118 && yy >= 350) {
            if (this.enableSound) {
                this.enableSound = false;
                bgSound.stop();
                bgSound.unload();
                Game.volume = 0;
                return;
            }
            this.game.playSelectSound();
            this.enableSound = true;
            if (bgSound != null) {
                bgSound.reload();
            } else {
                bgSound = new Sound(50, "/audio/menu", -1);
            }
            bgSound.play();
            Game.volume = 100;
            return;
        }
        if (xx >= 118 && xx <= 156 && yy >= 350) {
            this.game.playSelectSound();
            PlatformService.openURL("http://renderedideas.com/fb/facebook.php");
            return;
        }
        if (xx >= 156 && xx <= 194 && yy >= 350) {
            this.game.playSelectSound();
            PlatformService.showFeedbackForm();
            return;
        }
        if (xx >= 194 && yy >= 350) {
            this.game.playSelectSound();
            this.disable = true;
            this.game.setScore();
            return;
        }
        if (Game.isIAPSupported && Storage.readData("bought").toLowerCase().equals("false") && xx >= 0 && xx <= 80 && yy >= 250 && yy <= 330) {
            this.game.playSelectSound();
            Game.startLevel = 1;
            if (!(Game.item1Purchased || Game.item2Purchased || Game.item3Purchased)) {
                this.disable = true;
                this.game.play();
                return;
            }
            this.selectVehicle = true;
            return;
        }
        if (Game.isIAPSupported && Storage.readData("bought").toLowerCase().equals("false") && xx >= 80 && xx <= 160 && yy >= 250 && yy <= 330) {
            this.game.playSelectSound();
            this.help = false;
            this.about = false;
            this.store = true;
            this.selector = 4;
            return;
        }
        if (Game.isIAPSupported && Storage.readData("bought").toLowerCase().equals("false") && xx >= 160 && xx <= 240 && yy >= 250 && yy <= 330) {
            this.game.removeAds = true;
            PlatformService.showYesNoDialog("Remove Ads", "Do you want to make a purchase to remove ads? Internet connection will not be required to start this game after purchase.");
            return;
        }
        if (xx >= 40 && xx <= 120 && yy >= 250 && yy <= 330) {
            this.game.playSelectSound();
            Game.startLevel = 1;
            if (!(Game.item1Purchased || Game.item2Purchased || Game.item3Purchased)) {
                this.disable = true;
                this.game.play();
                return;
            }
            this.selectVehicle = true;
            return;
        }
        if (xx < 120) return;
        if (xx > 200) return;
        if (yy < 250) return;
        if (yy > 330) return;
        this.game.playSelectSound();
        this.help = false;
        this.about = false;
        this.store = true;
        this.selector = 4;
    }

    public void pointerReleased(int xx, int yy) {
    }

    public void pointerDragged(int xx, int yy) {
    }

    public void pause() {
        if (bgSound != null) {
            if (Game.volume != 0) {
                bgSound.stop();
            }
        }
    }

    public void resume() {
        if (bgSound != null) {
            if (Game.volume != 0) {
                bgSound.play();
            }
        }
    }

    public void onBackKey() {
        if (this.about || this.help || this.store) {
            this.help = false;
            this.about = false;
            this.store = false;
        } else {
            this.game.playSelectSound();
            this.game.exit();
        }
    }

    public void deallocate() {
        Game.volume = this.enableSound ? 100 : 0;
        if (bgSound != null) {
            bgSound.stop();
            bgSound.unload();
        }
        this.menuButtons = null;
        this.taxi = null;
        this.truck = null;
        this.car = null;
        this.bike = null;
        this.purchasedImage = null;
        this.buyImage = null;
        this.selectorImage = null;
        this.deactivateOption = null;
        this.helpScreen = null;
        this.backImage = null;
        this.storeScreen = null;
        this.aboutScreen = null;
        this.background = null;
        Storage.saveData("volume", Game.volume + "");
    }

    private void drawSelector(Graphics g) {
        if (this.selectVehicle) {
            switch (this.selector) {
                case 1: {
                    Bitmap.drawBitmap(g, this.selectorImage, 0, Game.height / 2 - this.car.getHeight() / 2);
                    break;
                }
                case 2: {
                    Bitmap.drawBitmap(g, this.selectorImage, Game.width / 4, Game.height / 2 - this.car.getHeight() / 2);
                    break;
                }
                case 3: {
                    Bitmap.drawBitmap(g, this.selectorImage, Game.width / 2, Game.height / 2 - this.car.getHeight() / 2);
                    break;
                }
                case 4: {
                    Bitmap.drawBitmap(g, this.selectorImage, Game.width * 3 / 4, Game.height / 2 - this.car.getHeight() / 2);
                }
            }
            return;
        }
        if (this.store) {
            switch (this.selector) {
                case 1: {
                    Bitmap.drawBitmap(g, this.selectorImage, 190, 60);
                    break;
                }
                case 2: {
                    Bitmap.drawBitmap(g, this.selectorImage, 190, 130);
                    break;
                }
                case 3: {
                    Bitmap.drawBitmap(g, this.selectorImage, 190, 190);
                    break;
                }
                case 4: {
                    Bitmap.drawBitmap(g, this.selectorImage, 190, 255);
                    break;
                }
                case 5: {
                    if (!Game.isIAPSupported) break;
                    Bitmap.drawBitmap(g, this.selectorImage, Game.width / 2 - this.buyImage.getWidth() / 2 - this.selectorImage.getWidth(), Game.height - this.buyImage.getHeight() / 2 - this.selectorImage.getHeight() / 2);
                }
            }
            return;
        }
        switch (this.selector) {
            case 1: {
                Bitmap.drawBitmap(g, this.selectorImage, 192, 2);
                break;
            }
            case 2: {
                if (Game.isIAPSupported && Storage.readData("bought").toLowerCase().equals("false")) {
                    Bitmap.drawBitmap(g, this.selectorImage, 0, 230);
                    break;
                }
                Bitmap.drawBitmap(g, this.selectorImage, 30, 230);
                break;
            }
            case 3: {
                if (Game.isIAPSupported && Storage.readData("bought").toLowerCase().equals("false")) {
                    Bitmap.drawBitmap(g, this.selectorImage, 90, 230);
                    break;
                }
                Bitmap.drawBitmap(g, this.selectorImage, 110, 230);
                break;
            }
            case 4: {
                if (!Game.isIAPSupported || !Storage.readData("bought").toLowerCase().equals("false")) break;
                Bitmap.drawBitmap(g, this.selectorImage, 170, 230);
                break;
            }
            case 5: {
                Bitmap.drawBitmap(g, this.selectorImage, 0, 300);
                break;
            }
            case 6: {
                Bitmap.drawBitmap(g, this.selectorImage, 34, 300);
                break;
            }
            case 7: {
                Bitmap.drawBitmap(g, this.selectorImage, 70, 300);
                break;
            }
            case 8: {
                Bitmap.drawBitmap(g, this.selectorImage, 105, 300);
                break;
            }
            case 9: {
                Bitmap.drawBitmap(g, this.selectorImage, 144, 300);
                break;
            }
            case 10: {
                Bitmap.drawBitmap(g, this.selectorImage, 182, 300);
            }
        }
    }

    private void processSelector() {
        if (this.about || this.help) {
            this.help = false;
            this.about = false;
            this.game.playSelectSound();
            return;
        }
        if (this.selectVehicle) {
            switch (this.selector) {
                case 1: {
                    Game.startVehicle = "taxi";
                    this.disable = true;
                    this.game.play();
                    break;
                }
                case 2: {
                    if (!Game.item1Purchased) break;
                    Game.startVehicle = "car";
                    this.disable = true;
                    this.game.play();
                    break;
                }
                case 3: {
                    if (!Game.item2Purchased) break;
                    Game.startVehicle = "truck";
                    this.disable = true;
                    this.game.play();
                    break;
                }
                case 4: {
                    if (!Game.item3Purchased) break;
                    Game.startVehicle = "bike";
                    this.disable = true;
                    this.game.play();
                }
            }
            return;
        }
        if (this.store) {
            switch (this.selector) {
                case 1: {
                    Game.buyItem(1);
                    break;
                }
                case 2: {
                    Game.buyItem(2);
                    break;
                }
                case 3: {
                    Game.buyItem(3);
                    break;
                }
                case 4: {
                    Game.buyItem(4);
                    break;
                }
                case 5: {
                    this.game.openIAPStore();
                }
            }
            return;
        }
        switch (this.selector) {
            case 1: {
                this.game.playSelectSound();
                this.game.exit();
                break;
            }
            case 2: {
                this.game.playSelectSound();
                this.selector = 1;
                Game.startLevel = 1;
                if (Game.item1Purchased || Game.item2Purchased || Game.item3Purchased) {
                    this.selectVehicle = true;
                    break;
                }
                this.disable = true;
                this.game.play();
                break;
            }
            case 3: {
                this.game.playSelectSound();
                this.help = false;
                this.about = false;
                this.store = true;
                this.selector = 4;
                break;
            }
            case 4: {
                this.game.removeAds = true;
                PlatformService.showYesNoDialog("Remove Ads", "Do you want to make a purchase to remove ads? Internet connection will not be required to start this game after purchase.");
                break;
            }
            case 5: {
                this.about = true;
                this.game.playSelectSound();
                break;
            }
            case 6: {
                this.help = true;
                this.game.playSelectSound();
                break;
            }
            case 7: {
                if (this.enableSound) {
                    this.enableSound = false;
                    bgSound.stop();
                    bgSound.unload();
                    Game.volume = 0;
                    break;
                }
                this.game.playSelectSound();
                this.enableSound = true;
                if (bgSound != null) {
                    bgSound.reload();
                } else {
                    bgSound = new Sound(50, "/audio/menu", -1);
                }
                bgSound.play();
                Game.volume = 100;
                break;
            }
            case 8: {
                this.game.playSelectSound();
                PlatformService.openURL("http://renderedideas.com/fb/facebook.php");
                break;
            }
            case 9: {
                this.game.playSelectSound();
                PlatformService.showFeedbackForm();
                break;
            }
            case 10: {
                this.game.playSelectSound();
                this.disable = true;
                this.game.setScore();
            }
        }
    }

    public void handleSwipe(int direction) {
    }
}

