/*
 * Decompiled with CFR 0.152.
 */
package com.renderedideas.superbike3d;

import com.renderedideas.game.Bitmap;
import com.renderedideas.game.PlatformService;
import com.renderedideas.superbike3d.Constant;
import com.renderedideas.superbike3d.Game;
import com.renderedideas.superbike3d.ImageSet;
import com.renderedideas.superbike3d.Message;
import com.renderedideas.superbike3d.MyCanvas;
import com.renderedideas.superbike3d.SoundManager;
import com.renderedideas.superbike3d.Sprite3D;
import com.renderedideas.superbike3d.Ted;
import com.renderedideas.superbike3d.Utility3D;
import com.renderedideas.superbike3d.models.Car2Model;
import com.renderedideas.superbike3d.models.CarModel;
import com.renderedideas.superbike3d.models.CoinModel;
import com.renderedideas.superbike3d.models.CopCarModel;
import com.renderedideas.superbike3d.models.FirstAidModel;
import com.renderedideas.superbike3d.models.GlobeLightModel;
import com.renderedideas.superbike3d.models.MagnetModel;
import com.renderedideas.superbike3d.models.Model;
import com.renderedideas.superbike3d.models.NitrousModel;
import com.renderedideas.superbike3d.models.PlayerBikeModel;
import com.renderedideas.superbike3d.models.PlayerCarModel;
import com.renderedideas.superbike3d.models.PlayerTaxiModel;
import com.renderedideas.superbike3d.models.PlayerTruckModel;
import com.renderedideas.superbike3d.models.RoadModel;
import com.renderedideas.superbike3d.models.StreetLightModel;
import com.renderedideas.superbike3d.models.Suv1Model;
import com.renderedideas.superbike3d.models.Suv2Model;
import com.renderedideas.superbike3d.models.Suv3Model;
import com.renderedideas.superbike3d.models.Suv4Model;
import com.renderedideas.superbike3d.models.TrafficSignalModel;
import com.renderedideas.superbike3d.models.TreeModel;
import com.renderedideas.superbike3d.models.TruckModel;
import java.util.Vector;
import javax.microedition.m3g.Graphics3D;

public class Sprite3DManager {
    Vector sprites = new Vector();
    public static Model carModel;
    public static Model car2Model;
    public static Model suv1Model;
    public static Model suv2Model;
    public static Model suv3Model;
    public static Model suv4Model;
    public static Model truckModel;
    public static Model roadModel;
    public static Model treeModel;
    public static Model globeLightModel;
    public static Model streetLightModel;
    public static Model coinModel;
    public static Model trafficSignalModel;
    public static Model firstAidModel;
    public static Model copCarModel;
    public static Model magnetModel;
    public static Model nitrousModel;
    public static Model playerModel;
    public static byte[] lights;
    public static byte[] lights_off;
    public static byte[] redLight;
    public static byte[] blueLight;
    public static byte[] redLight_off;
    public static byte[] blueLight_off;

    Sprite3DManager() {
        String[] playerTextures;
        if (Ted.isNight) {
            Bitmap.shadow = new Bitmap("/textures/shadow.png");
            Bitmap.applyShadow = true;
        }
        String[] carModelTextures = new String[]{"/textures/car1/blue", "/textures/car1/red", "/textures/car1/white", "/textures/car1/yellow"};
        carModel = new CarModel(carModelTextures);
        Game.loadingCounter = 20;
        String[] car2ModelTextures = new String[]{"/textures/car2/red", "/textures/car2/white"};
        car2Model = new Car2Model(car2ModelTextures);
        Game.loadingCounter = 30;
        String[] suv1ModelTextures = new String[]{"/textures/suv1/blue"};
        suv1Model = new Suv1Model(suv1ModelTextures);
        Game.loadingCounter = 35;
        String[] suv2ModelTextures = new String[]{"/textures/suv2/silver"};
        suv2Model = new Suv2Model(suv2ModelTextures);
        String[] suv3ModelTextures = new String[]{"/textures/suv3/gold"};
        suv3Model = new Suv3Model(suv3ModelTextures);
        String[] suv4ModelTextures = new String[]{"/textures/suv4/green"};
        suv4Model = new Suv4Model(suv4ModelTextures);
        Game.loadingCounter = 40;
        String[] truckModelTextures = new String[]{"/textures/truck/white"};
        truckModel = new TruckModel(truckModelTextures);
        Sprite3DManager.truckModel.dimensions = Utility3D.scalarMul(2.3f, Sprite3DManager.truckModel.dimensions);
        if (!Ted.game.slowDevice) {
            String[] treeModelTextures = new String[]{"/textures/tree.png"};
            treeModel = new TreeModel(treeModelTextures);
            Game.loadingCounter = 50;
            String[] globeModelTextures = new String[]{"/textures/objects/lights.png"};
            globeLightModel = new GlobeLightModel(globeModelTextures);
            streetLightModel = new StreetLightModel(globeModelTextures);
        }
        String[] trafficSignalTexture = new String[]{"/textures/objects/lights.png"};
        trafficSignalModel = new TrafficSignalModel(trafficSignalTexture);
        String[] coinModelTextures = new String[]{"/textures/coin.png"};
        coinModel = new CoinModel(coinModelTextures);
        Sprite3DManager.coinModel.dimensions = Ted.game.slowDevice ? Utility3D.scalarMul(0.4f, 0.4f, 1.0f, Sprite3DManager.coinModel.dimensions) : Utility3D.scalarMul(0.4f, 0.4f, 0.8f, Sprite3DManager.coinModel.dimensions);
        Game.loadingCounter = 55;
        String[] firstAidModelTextures = new String[]{"/textures/objects/aid.png"};
        firstAidModel = new FirstAidModel(firstAidModelTextures);
        Sprite3DManager.firstAidModel.dimensions = Utility3D.scalarMul(0.3f, Sprite3DManager.firstAidModel.dimensions);
        String[] magnetModelTextures = new String[]{"/textures/objects/magnet.png"};
        Game.loadingCounter = 60;
        magnetModel = new MagnetModel(magnetModelTextures);
        Sprite3DManager.magnetModel.dimensions = Utility3D.scalarMul(0.3f, Sprite3DManager.magnetModel.dimensions);
        String[] copCarModelTextures = new String[]{"/textures/cop_car.png"};
        copCarModel = new CopCarModel(copCarModelTextures);
        Sprite3DManager.copCarModel.dimensions = Utility3D.scalarMul(0.8f, Sprite3DManager.copCarModel.dimensions);
        Game.loadingCounter = 65;
        if (Game.startVehicle.equals("taxi")) {
            playerTextures = new String[]{"/textures/player/taxi.png"};
            playerModel = new PlayerTaxiModel(playerTextures);
        } else if (Game.startVehicle.equals("car")) {
            playerTextures = new String[]{"/textures/player/car.png"};
            playerModel = new PlayerCarModel(playerTextures);
        } else if (Game.startVehicle.equals("truck")) {
            playerTextures = new String[]{"/textures/player/truck.png"};
            playerModel = new PlayerTruckModel(playerTextures);
        } else if (Game.startVehicle.equals("bike")) {
            playerTextures = new String[]{"/textures/player/bike.png"};
            playerModel = new PlayerBikeModel(playerTextures);
        }
        if (Ted.isNight) {
            Bitmap.shadow = null;
            Bitmap.applyShadow = false;
        }
        Game.loadingCounter = 75;
        if (!MyCanvas.game.slowDevice) {
            String[] roadModelTextures = new String[]{"/textures/road_texture1.png"};
            roadModel = new RoadModel(roadModelTextures);
        }
        String[] nitrousModelTextures = new String[]{"/textures/objects/nitrous.png", "/textures/objects/nitrous2.png", "/textures/objects/nitrous3.png"};
        nitrousModel = new NitrousModel(nitrousModelTextures);
        Game.loadingCounter = 85;
        lights = Bitmap.getRGB_byte(new Bitmap("/textures/yellow.png"));
        lights_off = Bitmap.getRGB_byte(new Bitmap("/textures/pink.png"));
        redLight = Bitmap.getRGB_byte(new Bitmap("/textures/red.png"));
        blueLight = Bitmap.getRGB_byte(new Bitmap("/textures/blue.png"));
        redLight_off = Bitmap.getRGB_byte(ImageSet.getImageRegion(new Bitmap("/textures/cop_car.png"), 45, 2, 8, 3));
        blueLight_off = Bitmap.getRGB_byte(ImageSet.getImageRegion(new Bitmap("/textures/cop_car.png"), 27, 2, 8, 3));
        Game.loadingCounter = 90;
    }

    public static void deallocate() {
        playerModel = null;
        nitrousModel = null;
        magnetModel = null;
        copCarModel = null;
        firstAidModel = null;
        trafficSignalModel = null;
        coinModel = null;
        streetLightModel = null;
        globeLightModel = null;
        treeModel = null;
        roadModel = null;
        truckModel = null;
        suv4Model = null;
        suv3Model = null;
        suv2Model = null;
        suv1Model = null;
        car2Model = null;
        carModel = null;
        blueLight_off = null;
        redLight_off = null;
        blueLight = null;
        redLight = null;
        lights_off = null;
        lights = null;
    }

    public void addSprite(Sprite3D model) {
        this.sprites.addElement(model);
    }

    public void removeSprite(Sprite3D model) {
        this.sprites.removeElement(model);
    }

    public void removeAllSprites() {
        for (int i = 0; i < this.sprites.size(); ++i) {
            Sprite3D s = (Sprite3D)this.sprites.elementAt(i);
            if (s.turnProbability == -1) continue;
            s.setLightsOff();
        }
        this.sprites.removeAllElements();
    }

    public void updateSprites() {
        for (int i = 0; i < this.sprites.size(); ++i) {
            Sprite3D s = (Sprite3D)this.sprites.elementAt(i);
            if (!s.update()) continue;
            if ((s.id == 226 || s.id == 225) && --Ted.totalCopsInScene <= 0) {
                SoundManager.stop(Constant.COPSIREN_SOUND);
                if (!Ted.game.soundMixing) {
                    SoundManager.play(Constant.BACKGROUNDMUSIC_SOUND);
                }
            }
            this.sprites.removeElement(s);
            s = null;
            --i;
        }
    }

    public void drawSprites(Graphics3D m3d) {
        for (int i = 0; i < this.sprites.size(); ++i) {
            Sprite3D s = (Sprite3D)this.sprites.elementAt(i);
            s.draw(m3d);
        }
    }

    public void checkCollision() {
        for (int i = 0; i < this.sprites.size(); ++i) {
            Sprite3D s = (Sprite3D)this.sprites.elementAt(i);
            if (!s.isCollisionEnabled || s.forceCount > 0) continue;
            float spriteDimensionX = s.model.dimensions[0];
            float spriteDimensionZ = s.model.dimensions[2];
            float spriteX = Utility3D.getPositionX(s.transform3d) - spriteDimensionX / 2.0f;
            float spriteZ = Utility3D.getPositionZ(s.transform3d) - spriteDimensionZ / 2.0f;
            float playerX = Utility3D.getPositionX(Ted.playerSprite3d.transform3d) - Ted.playerSprite3d.model.dimensions[0] / 2.0f;
            float playerZ = Utility3D.getPositionZ(Ted.playerSprite3d.transform3d) - Ted.playerSprite3d.model.dimensions[2] / 2.0f;
            if (s.id == 225) {
                float temp = spriteDimensionX;
                spriteDimensionX = spriteDimensionZ;
                spriteDimensionZ = temp;
                spriteX -= 0.5f;
            }
            if (!(playerX <= spriteX + spriteDimensionX) || !(spriteX <= playerX + Ted.playerSprite3d.model.dimensions[0]) || !(playerZ <= spriteZ + spriteDimensionZ) || !(spriteZ <= playerZ + Ted.playerSprite3d.model.dimensions[2])) continue;
            if (s.id == 222) {
                s.contextValue = 99;
                s.isCollisionEnabled = false;
                SoundManager.play(Constant.COIN_SOUND);
                ++Ted.coinsCollected;
                continue;
            }
            if (s.id == 224) {
                s.isCollisionEnabled = false;
                s.contextValue = 99;
                SoundManager.play(Constant.COIN_SOUND);
                Ted.playerEnergy += 20;
                continue;
            }
            if (s.id == 227) {
                s.isCollisionEnabled = false;
                s.contextValue = 99;
                SoundManager.play(Constant.COIN_SOUND);
                Ted.magnetTimer = 300;
                continue;
            }
            if (Math.abs(playerX - spriteX) > Math.abs(playerZ - spriteZ)) {
                s.forceX = playerX > spriteX ? -0.15f : 0.15f;
                s.forceZ = -0.05f;
            } else if (playerZ < spriteZ) {
                s.forceX = playerX > spriteX ? -0.15f : 0.15f;
                s.forceZ = -0.05f;
            } else if (s.id == 225 || Ted.nitrousCounter > 0.0f) {
                if (playerX > spriteX) {
                    s.forceX = -0.25f;
                    s.rotationY = 20.0f;
                } else {
                    s.forceX = 0.25f;
                    s.rotationY = -20.0f;
                }
                s.velocity = 0.0f;
                s.forceZ = -0.35f;
                if (Ted.nitrousCounter <= 0.0f) {
                    Ted.playerEnergy = Ted.playerSprite3d.model instanceof PlayerCarModel && (s.id == 226 || s.id == 225) ? (Ted.playerEnergy -= 10) : (Ted.playerSprite3d.model instanceof PlayerTruckModel ? (Ted.playerEnergy -= 5) : (Ted.playerEnergy -= 20));
                }
            } else {
                Ted.playerEnergy = Ted.playerSprite3d.model instanceof PlayerCarModel && (s.id == 226 || s.id == 225) ? (Ted.playerEnergy -= 10) : (Ted.playerSprite3d.model instanceof PlayerTruckModel ? (Ted.playerEnergy -= 5) : (Ted.playerEnergy -= 20));
                s.forceZ = -0.35f;
                s.forceX = 0.15f;
            }
            s.forceCount = 10;
            if (Ted.nitrousCounter <= 0.0f) {
                Ted.playerEnergy = Ted.playerSprite3d.model instanceof PlayerCarModel && (s.id == 226 || s.id == 225) ? (Ted.playerEnergy -= 10) : (Ted.playerSprite3d.model instanceof PlayerTruckModel ? (Ted.playerEnergy -= 5) : (Ted.playerEnergy -= 20));
            }
            if (s.id == 226) {
                s.isCollisionEnabled = false;
                Ted.slip = 0.05f;
            }
            if (Ted.playerEnergy <= 0) {
                Ted.playerEnergy = 0;
                MyCanvas.mr.crashed();
                return;
            }
            SoundManager.play(Constant.HIT_SOUND);
            if (s.id == 226 || PlatformService.nextInt(2) != 0) continue;
            MyCanvas.mr.messages.addElement(new Message(Ted.appreciateTexts[PlatformService.nextInt(Ted.appreciateTexts.length)], Game.width / 2, Game.height / 6, Game.height / 6 - 20, 1));
        }
    }

    boolean isVehicleAlreadyOnLane(int lane, Sprite3D refSprite) {
        for (int i = 0; i < this.sprites.size(); ++i) {
            Sprite3D s = (Sprite3D)this.sprites.elementAt(i);
            if (s.currentLane != lane && s.moveToLane != lane || !s.isCollisionEnabled) continue;
            float spriteZ1 = Utility3D.getPositionZ(s.transform3d) - s.model.dimensions[2] / 2.0f;
            float spriteZ2 = Utility3D.getPositionZ(s.transform3d) + s.model.dimensions[2] / 2.0f;
            float refSpriteZ1 = Utility3D.getPositionZ(refSprite.transform3d) - refSprite.model.dimensions[2] / 2.0f;
            float refSpriteZ2 = Utility3D.getPositionZ(refSprite.transform3d) + refSprite.model.dimensions[2] / 2.0f;
            if (!(refSpriteZ1 >= spriteZ1 && refSpriteZ1 <= spriteZ2) && (!(refSpriteZ2 >= spriteZ1) || !(refSpriteZ2 <= spriteZ2))) continue;
            return true;
        }
        return false;
    }

    float isVehicleInFront(Sprite3D refSprite, float range) {
        int lane = refSprite.currentLane;
        for (int i = 0; i < this.sprites.size(); ++i) {
            float distance;
            float refSpriteZ1;
            float spriteZ2;
            Sprite3D s = (Sprite3D)this.sprites.elementAt(i);
            if (s.currentLane != lane && s.moveToLane != lane || !s.isCollisionEnabled || (spriteZ2 = Utility3D.getPositionZ(s.transform3d) + s.model.dimensions[2] / 2.0f) > (refSpriteZ1 = Utility3D.getPositionZ(refSprite.transform3d) - refSprite.model.dimensions[2] / 2.0f) || !((distance = refSpriteZ1 - spriteZ2) < range)) continue;
            return s.velocity;
        }
        return -1.0f;
    }

    public void removeAllCollidableSprites() {
        for (int i = 0; i < this.sprites.size(); ++i) {
            Sprite3D s = (Sprite3D)this.sprites.elementAt(i);
            if (!s.isCollisionEnabled || s.id == 222 || s.id == 227 || s.id == 224) continue;
            this.sprites.removeElement(s);
            --i;
        }
    }
}

