/*
 * Decompiled with CFR 0.152.
 */
package com.renderedideas.superbike3d;

import com.renderedideas.game.PrintConsole;
import javax.microedition.m3g.Transform;

public class Utility3D {
    public static float dotProduct(float[] v, float[] u) {
        return v[0] * u[0] + v[1] * u[1] + v[2] * u[2];
    }

    public static float[][] transpose(float[][] matrix) {
        int m = matrix.length;
        int n = matrix[0].length;
        float[][] transpose = new float[n][m];
        for (int c2 = 0; c2 < m; ++c2) {
            for (int d2 = 0; d2 < n; ++d2) {
                transpose[d2][c2] = matrix[c2][d2];
            }
        }
        return transpose;
    }

    public static float[] crossProduct(float[] v, float[] u) {
        float[] newVec = new float[]{v[1] * u[2] - v[2] * u[1], v[2] * u[0] - v[0] * u[2], v[0] * u[1] - v[1] * u[0]};
        return newVec;
    }

    public static float length(float[] v) {
        return (float)Math.sqrt(v[0] * v[0] + v[1] * v[1] + v[2] * v[2]);
    }

    public static float[] sub(float[] v, float[] u) {
        float[] newVec = new float[]{v[0] - u[0], v[1] - u[1], v[2] - u[2]};
        return newVec;
    }

    public static float[] normalize(float[] v) {
        float len = Utility3D.length(v);
        float[] newVec = new float[]{v[0] / len, v[1] / len, v[2] / len};
        return newVec;
    }

    public static float[] scalarMul(float scalar, float[] v) {
        float[] newVector = new float[]{v[0] * scalar, v[1] * scalar, v[2] * scalar};
        return newVector;
    }

    public static float[] scalarMul(float scalarX, float scalarY, float scalarZ, float[] v) {
        float[] newVector = new float[]{v[0] * scalarX, v[1] * scalarY, v[2] * scalarZ};
        return newVector;
    }

    public static void printVector(float[] v) {
        PrintConsole.print("(" + v[0] + ", " + v[1] + ", " + v[2] + ")");
    }

    public static float getPositionX(Transform transform) {
        float[] matrix = new float[16];
        transform.get(matrix);
        return matrix[3];
    }

    public static float getPositionY(Transform transform) {
        float[] matrix = new float[16];
        transform.get(matrix);
        return matrix[7];
    }

    public static float getPositionZ(Transform transform) {
        float[] matrix = new float[16];
        transform.get(matrix);
        return matrix[11];
    }

    public static float getRotationX(Transform transform) {
        float[] matrix = new float[16];
        transform.get(matrix);
        return matrix[5];
    }

    public static void postRotateAboutLocalAxis(Transform t, float angleX, float angleY, float angleZ) {
        float zCordinate;
        float yCordinate;
        float xCordinate;
        float[] matrix;
        if (angleX != 0.0f) {
            matrix = new float[16];
            t.get(matrix);
            xCordinate = matrix[3];
            yCordinate = matrix[7];
            zCordinate = matrix[11];
            matrix[11] = 0.0f;
            matrix[7] = 0.0f;
            matrix[3] = 0.0f;
            t.set(matrix);
            t.postRotate(angleX, 1.0f, 0.0f, 0.0f);
            t.get(matrix);
            matrix[3] = xCordinate;
            matrix[7] = yCordinate;
            matrix[11] = zCordinate;
            t.set(matrix);
        }
        if (angleY != 0.0f) {
            matrix = new float[16];
            t.get(matrix);
            xCordinate = matrix[3];
            yCordinate = matrix[7];
            zCordinate = matrix[11];
            matrix[11] = 0.0f;
            matrix[7] = 0.0f;
            matrix[3] = 0.0f;
            t.set(matrix);
            t.postRotate(angleY, 0.0f, 1.0f, 0.0f);
            t.get(matrix);
            matrix[3] = xCordinate;
            matrix[7] = yCordinate;
            matrix[11] = zCordinate;
            t.set(matrix);
        }
        if (angleZ != 0.0f) {
            matrix = new float[16];
            t.get(matrix);
            xCordinate = matrix[3];
            yCordinate = matrix[7];
            zCordinate = matrix[11];
            matrix[11] = 0.0f;
            matrix[7] = 0.0f;
            matrix[3] = 0.0f;
            t.set(matrix);
            t.postRotate(angleZ, 0.0f, 0.0f, 1.0f);
            t.get(matrix);
            matrix[3] = xCordinate;
            matrix[7] = yCordinate;
            matrix[11] = zCordinate;
            t.set(matrix);
        }
    }

    public static void postTranslateAboutGlobalAxis(Transform t, float x, float y, float z) {
        float[] matrix;
        if (x != 0.0f) {
            matrix = new float[16];
            t.get(matrix);
            matrix[3] = matrix[3] + x;
            t.set(matrix);
        }
        if (y != 0.0f) {
            matrix = new float[16];
            t.get(matrix);
            matrix[7] = matrix[7] + y;
            t.set(matrix);
        }
        if (z != 0.0f) {
            matrix = new float[16];
            t.get(matrix);
            matrix[11] = matrix[11] + z;
            t.set(matrix);
        }
    }

    public static void postRotateAboutLineParallelToXaxisInXYplane(Transform t, float yIntercept, float angle) {
        float[] matrix = new float[16];
        t.get(matrix);
        float xCordinate = matrix[3];
        float yCordinate = matrix[7];
        float zCordinate = matrix[11];
        matrix[11] = 0.0f;
        matrix[7] = 0.0f;
        matrix[3] = 0.0f;
        matrix[7] = yIntercept;
        t.set(matrix);
        t.postRotate(angle, 1.0f, 0.0f, 0.0f);
        t.get(matrix);
        matrix[3] = xCordinate;
        matrix[7] = yCordinate;
        matrix[11] = zCordinate;
        t.set(matrix);
    }

    public static void postTranslateAboutGlobalAxis(Transform t, float[] vector) {
        float[] matrix;
        if (vector[0] != 0.0f) {
            matrix = new float[16];
            t.get(matrix);
            matrix[3] = matrix[3] + vector[0];
            t.set(matrix);
        }
        if (vector[1] != 0.0f) {
            matrix = new float[16];
            t.get(matrix);
            matrix[7] = matrix[7] + vector[1];
            t.set(matrix);
        }
        if (vector[2] != 0.0f) {
            matrix = new float[16];
            t.get(matrix);
            matrix[11] = matrix[11] + vector[2];
            t.set(matrix);
        }
    }

    public static void setTranslate(Transform t, float x, float y, float z) {
        float[] matrix = new float[16];
        t.get(matrix);
        matrix[3] = x;
        matrix[7] = y;
        matrix[11] = z;
        t.set(matrix);
    }

    public static void setTranslate(Transform t, float[] position) {
        float[] matrix = new float[16];
        t.get(matrix);
        matrix[3] = position[0];
        matrix[7] = position[1];
        matrix[11] = position[2];
        t.set(matrix);
    }

    public static void setTranslateX(Transform t, float x) {
        float[] matrix = new float[16];
        t.get(matrix);
        matrix[3] = x;
        t.set(matrix);
    }

    public static void setTranslateY(Transform t, float y) {
        float[] matrix = new float[16];
        t.get(matrix);
        matrix[7] = y;
        t.set(matrix);
    }

    public static void setTranslateZ(Transform t, float z) {
        float[] matrix = new float[16];
        t.get(matrix);
        matrix[11] = z;
        t.set(matrix);
    }

    public static void setScaleX(Transform t, float x) {
        float[] matrix = new float[16];
        t.get(matrix);
        matrix[12] = x;
        t.set(matrix);
    }

    public static void setScaleZ(Transform t, float z) {
        float[] matrix = new float[16];
        t.get(matrix);
        matrix[14] = z;
        t.set(matrix);
    }

    public static void printPosition(Transform t) {
        PrintConsole.print("(" + Utility3D.getPositionX(t) + "," + Utility3D.getPositionY(t) + "," + Utility3D.getPositionZ(t) + ")");
    }

    public static float[] getPosition(Transform t) {
        float[] vector = new float[]{Utility3D.getPositionX(t), Utility3D.getPositionY(t), Utility3D.getPositionZ(t)};
        return vector;
    }

    public static float[] getVector(float x, float y, float z) {
        float[] vector = new float[]{x, y, z};
        return vector;
    }

    public static short[] scaleArrayElements(short[] array, float scaleFactor) {
        short[] newArray = new short[array.length];
        for (int i = 0; i < array.length; ++i) {
            newArray[i] = (short)((float)array[i] * scaleFactor);
        }
        return newArray;
    }

    public static short[] scaleArrayElements(short[] array, float scaleX, float scaleY, float scaleZ) {
        short[] newArray = new short[array.length];
        for (int i = 0; i < array.length; i += 3) {
            newArray[i] = (short)((float)array[i] * scaleX);
            newArray[i + 1] = (short)((float)array[i + 1] * scaleY);
            newArray[i + 2] = (short)((float)array[i + 2] * scaleZ);
        }
        return newArray;
    }

    public static short[] translateArrayElements(short[] array, float x, float y, float z) {
        short[] newArray = new short[array.length];
        for (int i = 0; i < array.length; i += 3) {
            newArray[i] = (short)((float)array[i] + x * 255.0f);
            newArray[i + 1] = (short)((float)array[i + 1] + y * 255.0f);
            newArray[i + 2] = (short)((float)array[i + 2] + z * 255.0f);
        }
        return newArray;
    }
}

