/*
 * Decompiled with CFR 0.152.
 */
package com.renderedideas.superbike3d.models;

import com.renderedideas.game.Bitmap;
import com.renderedideas.superbike3d.Tools;
import com.renderedideas.superbike3d.Utility3D;
import com.renderedideas.superbike3d.models.Model;
import javax.microedition.m3g.Appearance;
import javax.microedition.m3g.Image2D;
import javax.microedition.m3g.Material;
import javax.microedition.m3g.PolygonMode;
import javax.microedition.m3g.Texture2D;
import javax.microedition.m3g.TriangleStripArray;
import javax.microedition.m3g.VertexArray;
import javax.microedition.m3g.VertexBuffer;

public class TruckModel
extends Model {
    public TruckModel(String[] textures) {
        this.textures = textures;
        try {
            this.loadModel();
        }
        catch (Exception e2) {
            e2.printStackTrace();
        }
    }

    void loadModel() throws Exception {
        this.dimensions = Tools.getDimensions(this.getVerts());
        this.dimensions = Utility3D.scalarMul(0.65f, this.dimensions);
        this.makeGeometry();
        this.app = new Appearance[this.textures.length];
        for (int i = 0; i < this.textures.length; ++i) {
            this.app[i] = this.makeAppearance(this.textures[i]);
        }
    }

    void makeGeometry() {
        short[] verts = this.getVerts();
        verts = Utility3D.scaleArrayElements(verts, 0.65f);
        VertexArray va = new VertexArray(verts.length / 3, 3, 2);
        va.set(0, verts.length / 3, verts);
        byte[] norms = this.getNormals();
        VertexArray normArray = new VertexArray(norms.length / 3, 3, 1);
        normArray.set(0, norms.length / 3, norms);
        short[] tcs = this.getTexCoordsRev();
        VertexArray texArray = new VertexArray(tcs.length / 2, 2, 2);
        texArray.set(0, tcs.length / 2, tcs);
        this.vertBuf = new VertexBuffer();
        float[] pbias = new float[]{0.003921569f, 0.003921569f, 0.003921569f};
        this.vertBuf.setPositions(va, 0.007843138f, pbias);
        this.vertBuf.setNormals(normArray);
        this.vertBuf.setTexCoords(0, texArray, 0.003921569f, null);
        this.idxBuf = new TriangleStripArray(0, this.getStripLengths());
    }

    short[] getTexCoordsRev() {
        short[] tcs = this.getTexCoords();
        for (int i = 1; i < tcs.length; i += 2) {
            tcs[i] = (short)(255 - tcs[i]);
        }
        return tcs;
    }

    Appearance makeAppearance(String texturePath) throws Exception {
        Bitmap im = new Bitmap(texturePath);
        Image2D image2D = new Image2D(99, im.getWidth(), im.getHeight());
        image2D.set(0, 0, im.getWidth(), im.getHeight(), Bitmap.getRGB_byte(im));
        Texture2D tex = new Texture2D(image2D);
        tex.setFiltering(208, 210);
        tex.setWrapping(240, 240);
        tex.setBlending(228);
        Appearance app = new Appearance();
        app.setTexture(0, tex);
        app.setMaterial(this.setMatColours());
        PolygonMode polygonMode = new PolygonMode();
        polygonMode.setCulling(160);
        app.setPolygonMode(polygonMode);
        return app;
    }

    short[] getVerts() {
        return Tools.loadArrayFromFile("/models/truck/vertices.dat", 2772);
    }

    byte[] getNormals() {
        return Tools.loadArrayFromFile_returnByte("/models/truck/normals.dat", 2772);
    }

    short[] getTexCoords() {
        return Tools.loadArrayFromFile("/models/truck/texture.dat", 1848);
    }

    int[] getStripLengths() {
        return Tools.loadArrayFromFile_returnInt("/models/truck/strip.dat", 308);
    }

    Material setMatColours() {
        Material mat = new Material();
        mat.setColor(1024, -1);
        mat.setColor(4096, 0);
        mat.setColor(2048, -8684677);
        mat.setColor(8192, 0xE6E6E6);
        mat.setShininess(1.0f);
        return mat;
    }
}

