/*
 * Decompiled with CFR 0.152.
 */
package com.gamelion.speedx;

import com.gamelion.speedx.Debug;
import com.gamelion.speedx.IFont;
import java.io.IOException;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class BitmapFont
extends DefaultHandler
implements IFont {
    private static final int GLYPH_HASH_SIZE = 255;
    private static final int KERNING_HASH_SIZE = 255;
    private static final String PAIR_ELEMENT_NAME = "pair";
    private static final String CHAR_ELEMENT_NAME = "char";
    private static final String GL_FONT_ELEMENT_NAME = "GLFont";
    private static final String CHARACTERS_ELEMENT_NAME = "characters";
    private static final String KERNING_ELEMENT_NAME = "kerning";
    private static final String CODE_ATTRIBUTE = "code";
    private static final String X_ATTRIBUTE = "x";
    private static final String Y_ATTRIBUTE = "y";
    private static final String WIDTH_ATTRIBUTE = "width";
    private static final String HEIGHT_ATTRIBUTE = "height";
    private static final String LEFT_ATTRIBUTE = "left";
    private static final String RIGHT_ATTRIBUTE = "right";
    private static final String DISTANCE_ATTRIBUTE = "distance";
    private static final String LINKED_FILE_ATTRIBUTE = "linkedFile";
    private Image glyphsImage;
    private GlyphInfo[] glyphsHashtable;
    private KerningInfo[] kerningHashtable;
    private int height;

    public BitmapFont(String descriptorFile) {
        this.parseDescriptor(descriptorFile);
    }

    public int charWidth(char c) {
        GlyphInfo glyph = this.findGlyph(c);
        if (glyph != null) {
            return glyph.width;
        }
        return 0;
    }

    public int stringWidth(String str) {
        int len = str.length();
        int width = 0;
        for (int i = 0; i < len; ++i) {
            char chr = str.charAt(i);
            GlyphInfo glyph = this.findGlyph(chr);
            int kerning = 0;
            if (i < len - 1) {
                kerning = this.findKerning(chr, str.charAt(i + 1));
            }
            width += glyph.width - kerning;
        }
        return width;
    }

    public int height() {
        return this.height;
    }

    public void drawString(Graphics g, String str, int x, int y, int anchor) {
        if ((anchor & 9) != 0) {
            int width = this.stringWidth(str);
            if ((anchor & 8) != 0) {
                x -= width;
            } else if ((anchor & 1) != 0) {
                x -= width / 2;
            }
        }
        if ((anchor & 0x20) != 0) {
            y -= this.height;
        } else if ((anchor & 2) != 0) {
            y -= this.height / 2;
        } else if ((anchor & 0x40) != 0) {
            Debug.warn("Baseline not supported in bitmap fonts");
        }
        int len = str.length();
        for (int i = 0; i < len; ++i) {
            char chr = str.charAt(i);
            GlyphInfo glyph = this.findGlyph(chr);
            int kerning = 0;
            g.drawRegion(this.glyphsImage, glyph.x, glyph.y, glyph.width, glyph.height, 0, x, y, 20);
            if (i < len - 1) {
                kerning = this.findKerning(chr, str.charAt(i + 1));
            }
            x += glyph.width - kerning;
        }
    }

    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        if (qName.equals(CHARACTERS_ELEMENT_NAME)) {
            this.glyphsHashtable = new GlyphInfo[255];
        } else if (qName.equals(KERNING_ELEMENT_NAME)) {
            this.kerningHashtable = new KerningInfo[255];
        } else if (qName.equals(CHAR_ELEMENT_NAME)) {
            this.insertGlyph(this.attributeAsInt(attributes, CODE_ATTRIBUTE), this.attributeAsInt(attributes, X_ATTRIBUTE), this.attributeAsInt(attributes, Y_ATTRIBUTE), this.attributeAsInt(attributes, WIDTH_ATTRIBUTE), this.attributeAsInt(attributes, HEIGHT_ATTRIBUTE));
        } else if (qName.equals(PAIR_ELEMENT_NAME)) {
            this.insertKerningPair(this.attributeAsInt(attributes, LEFT_ATTRIBUTE), this.attributeAsInt(attributes, RIGHT_ATTRIBUTE), this.attributeAsInt(attributes, DISTANCE_ATTRIBUTE));
        } else if (qName.equals(GL_FONT_ELEMENT_NAME)) {
            String linkedFile = "/" + attributes.getValue(LINKED_FILE_ATTRIBUTE);
            try {
                Debug.trace("Loading glyphs images " + linkedFile);
                this.glyphsImage = Image.createImage((String)linkedFile);
            }
            catch (IOException ex) {
                Debug.error(ex, "failed to load glyph image " + linkedFile);
            }
        }
    }

    private void insertGlyph(int code, int x, int y, int width, int height) {
        int slot;
        GlyphInfo glyph = new GlyphInfo();
        glyph.code = (char)code;
        glyph.x = x;
        glyph.y = y;
        glyph.width = width;
        glyph.height = height;
        if (height > this.height) {
            this.height = height;
        }
        if (this.glyphsHashtable[slot = code % 255] != null) {
            glyph.next = this.glyphsHashtable[slot];
            this.glyphsHashtable[slot] = glyph;
        } else {
            this.glyphsHashtable[slot] = glyph;
        }
    }

    private void insertKerningPair(int leftCode, int rightCode, int distance) {
        KerningInfo pair = new KerningInfo();
        pair.left = (char)leftCode;
        pair.right = (char)rightCode;
        pair.distance = distance;
        int slot = this.kerningPairHash(pair.left, pair.right) % 255;
        if (this.kerningHashtable[slot] != null) {
            pair.next = this.kerningHashtable[slot];
            this.kerningHashtable[slot] = pair;
        } else {
            this.kerningHashtable[slot] = pair;
        }
    }

    private GlyphInfo findGlyph(char code) {
        int slot = code % 255;
        GlyphInfo glyph = this.glyphsHashtable[slot];
        while (glyph != null) {
            if (glyph.code == code) {
                return glyph;
            }
            glyph = glyph.next;
        }
        Debug.warn("glyph  \\u" + Integer.toHexString(code) + " not found");
        return null;
    }

    private int findKerning(char left, char right) {
        if (this.kerningHashtable == null) {
            return 0;
        }
        int slot = this.kerningPairHash(left, right) % 255;
        KerningInfo kern = this.kerningHashtable[slot];
        while (kern != null) {
            if (kern.left == left && kern.right == right) {
                return kern.distance;
            }
            kern = kern.next;
        }
        return 0;
    }

    private int kerningPairHash(char left, char right) {
        return left << 16 | right;
    }

    private int attributeAsInt(Attributes attrs, String name) {
        return Integer.parseInt(attrs.getValue(name));
    }

    private void parseDescriptor(String descriptorFile) {
        try {
            SAXParserFactory factory = SAXParserFactory.newInstance();
            factory.setValidating(false);
            factory.setNamespaceAware(false);
            SAXParser parser = factory.newSAXParser();
            InputSource source = new InputSource(this.getClass().getResourceAsStream(descriptorFile));
            parser.parse(source, (DefaultHandler)this);
        }
        catch (IOException ex) {
            Debug.error(ex, "io exception while parsing " + descriptorFile);
        }
        catch (ParserConfigurationException ex) {
            Debug.error(ex, "Failed to create parser for " + descriptorFile);
        }
        catch (SAXException ex) {
            Debug.error(ex, "Failed to parse " + descriptorFile);
        }
    }

    class KerningInfo {
        KerningInfo next;
        public char left;
        public char right;
        public int distance;

        KerningInfo() {
        }
    }

    class GlyphInfo {
        GlyphInfo next;
        public char code;
        public int x;
        public int y;
        public int width;
        public int height;

        GlyphInfo() {
        }
    }
}

