/*
 * Decompiled with CFR 0.152.
 */
package com.gamelion.speedx.menu;

import com.gamelion.speedx.Debug;
import com.gamelion.speedx.IFont;
import com.gamelion.speedx.menu.IDialogListener;
import com.gamelion.speedx.textdisplay.RichTextDisplay;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class Dialog {
    private static final int BORDER_WIDTH = 2;
    private static final int SCROLLER_WIDTH = 2;
    private static final int BORDER_COLOR = 16766720;
    private static final float BOX_SLIDE_TIME = 1.4f;
    private static final float TEXT_SLIDE_TIME = 1.5f;
    private static final int KEYBOARD_SCROLL_DELTA = 25;
    private String title;
    private IFont titleFont;
    private RichTextDisplay content;
    private int titleX;
    private int titleY;
    private int closeButtonX;
    private int closeButtonY;
    private int closeButtonWidth;
    private int closeButtonHeight;
    private int clientX;
    private int clientY;
    private int clientWidth;
    private int clientHeight;
    private int width;
    private int height;
    private int blackBoxWidth;
    private int x;
    private int y;
    private int maxHeight;
    private Image textBuffer;
    private Image closeButton;
    private boolean boxSlideAnim;
    private boolean textSlideAnim;
    private float timer;
    private int slideDelta;
    private boolean pointerDownInCloseButtonArea;
    private int scrollY;
    private int anchorY;
    private IDialogListener listener;

    public Dialog(IDialogListener listener) {
        this.listener = listener;
        try {
            this.closeButton = Image.createImage((String)"/close_button.png");
        }
        catch (Exception ex) {
            Debug.error(ex, "Failed to load close button image");
        }
    }

    public void setTitle(String title, IFont font) {
        this.title = title;
        this.titleFont = font;
    }

    public void setContent(RichTextDisplay text) {
        this.content = text;
    }

    public void open(int clientWidth, int clientHeight) {
        this.clientWidth = clientWidth;
        this.clientHeight = clientHeight;
        this.titleX = 2;
        this.titleY = 2;
        this.clientX = 4;
        this.clientY = 2 + this.titleFont.height() + 4;
        this.width = clientWidth + 4 + 2 + 2;
        this.closeButtonHeight = this.closeButton.getHeight();
        this.closeButtonWidth = this.closeButton.getWidth() + 4;
        this.closeButtonX = this.width - this.closeButtonWidth;
        this.closeButtonY = this.titleY + (this.titleFont.height() - this.closeButtonHeight) / 2;
        this.blackBoxWidth = clientWidth;
        this.maxHeight = clientHeight + this.clientY + 4;
        this.x = (240 - this.width) / 2;
        this.slideDelta = 1;
        this.scrollY = 0;
        if (this.textBuffer != null) {
            if (this.textBuffer.getWidth() != clientWidth || this.textBuffer.getHeight() != clientHeight) {
                this.createTextBuffer(clientWidth, clientHeight);
            }
        } else {
            this.createTextBuffer(clientWidth, clientHeight);
        }
        this.repaintTextBuffer();
        this.boxSlideAnim = true;
        this.textSlideAnim = false;
        this.timer = 0.0f;
    }

    public void close() {
    }

    public void update(float dt) {
        if (this.boxSlideAnim) {
            this.height = (int)((float)this.maxHeight * this.timer / 1.4f);
            if (this.slideDelta < 0) {
                this.height = this.maxHeight - this.height;
            }
            if (this.timer > 1.4f) {
                int n = this.height = this.slideDelta > 0 ? this.maxHeight : 0;
                if (this.slideDelta < 0) {
                    this.listener.onDialogClosed();
                }
                this.timer = 0.0f;
                this.boxSlideAnim = false;
                boolean bl = this.textSlideAnim = this.slideDelta > 0;
            }
        }
        if (this.textSlideAnim) {
            this.blackBoxWidth = this.clientWidth - (int)(this.timer * (float)this.clientWidth / 1.5f);
            if (this.slideDelta < 0) {
                this.blackBoxWidth = this.clientWidth - this.blackBoxWidth;
            }
            if (this.timer > 1.5f) {
                this.blackBoxWidth = this.slideDelta > 0 ? 0 : this.blackBoxWidth;
                this.timer = 0.0f;
                this.boxSlideAnim = this.slideDelta < 0;
                this.textSlideAnim = false;
            }
        }
        this.y = (320 - this.height) / 2;
        this.timer += dt;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void render(Graphics g) {
        try {
            g.translate(this.x, this.y);
            g.setClip(this.clientX, this.clientY, this.clientWidth, this.clientHeight);
            g.drawImage(this.textBuffer, this.clientX, this.clientY, 20);
            g.setColor(0);
            g.fillRect(this.clientX + this.clientWidth - this.blackBoxWidth, this.clientY, this.blackBoxWidth, this.clientHeight);
            g.setClip(0, 0, this.width, this.height);
            g.setColor(16766720);
            g.fillRect(0, 0, this.width, this.clientY);
            g.fillRect(0, this.clientY, 2, this.clientHeight + 2);
            g.fillRect(this.width - 2, this.clientY, 2, this.clientHeight + 2);
            g.fillRect(0, this.height - 2, this.width, 2);
            g.drawImage(this.closeButton, this.closeButtonX, this.closeButtonY, 20);
            this.titleFont.drawString(g, this.title, this.titleX, this.titleY, 20);
        }
        finally {
            g.translate(-this.x, -this.y);
        }
    }

    public void onPointerPressed(int x, int y) {
        if (this.inCloseButtonArea(x, y) && this.canHandleEvents()) {
            this.pointerDownInCloseButtonArea = true;
            return;
        }
        this.anchorY = y;
    }

    public void onPointerReleased(int x, int y) {
        if (this.inCloseButtonArea(x, y) && this.pointerDownInCloseButtonArea && this.canHandleEvents()) {
            this.startCloseAnim();
            return;
        }
        this.pointerDownInCloseButtonArea = false;
    }

    public void onPointerDragged(int x, int y) {
        if (this.canHandleEvents()) {
            this.scrollY += y - this.anchorY;
            this.anchorY = y;
            this.clampScroll();
            this.repaintTextBuffer();
        }
    }

    public void onKeyReleased(int code) {
        if (this.canHandleEvents()) {
            boolean repaint = false;
            if (code == 50) {
                this.scrollY += 25;
                repaint = true;
            } else if (code == 56) {
                this.scrollY -= 25;
                repaint = true;
            } else if (code == 53) {
                this.startCloseAnim();
            }
            if (repaint) {
                this.clampScroll();
                this.repaintTextBuffer();
            }
        }
    }

    private void createTextBuffer(int width, int height) {
        this.textBuffer = Image.createImage((int)width, (int)height);
    }

    private void repaintTextBuffer() {
        Graphics g = this.textBuffer.getGraphics();
        g.setColor(0);
        g.fillRect(0, 0, this.clientWidth, this.clientHeight);
        g.translate(0, this.scrollY);
        this.content.paint(g);
        g.translate(0, -this.scrollY);
    }

    private boolean inCloseButtonArea(int x, int y) {
        return (x -= this.x) >= this.closeButtonX && x <= this.closeButtonX + this.closeButtonWidth && (y -= this.y) >= this.closeButtonY && y <= this.closeButtonY + this.closeButtonHeight;
    }

    private void clampScroll() {
        if (this.scrollY > 0) {
            this.scrollY = 0;
        } else if (this.scrollY < -this.content.height() + this.clientHeight / 2) {
            this.scrollY = -this.content.height() + this.clientHeight / 2;
        }
    }

    private void startCloseAnim() {
        this.slideDelta = -1;
        this.timer = 0.0f;
        this.textSlideAnim = true;
        this.pointerDownInCloseButtonArea = false;
    }

    private boolean canHandleEvents() {
        return !this.boxSlideAnim && !this.textSlideAnim;
    }
}

