/*
 * Decompiled with CFR 0.152.
 */
package com.gamelion.speedx.game;

import com.gamelion.speedx.game.Vector3f;

public class Matrix4f {
    public float[][] m = new float[4][4];

    public void setIdentity() {
        for (int row = 0; row < 4; ++row) {
            for (int col = 0; col < 4; ++col) {
                this.m[row][col] = row == col ? 1.0f : 0.0f;
            }
        }
    }

    public void setRotation(float roll, float pitch, float yaw) {
        float sinRoll = (float)Math.sin(roll);
        float sinPitch = (float)Math.sin(pitch);
        float sinYaw = (float)Math.sin(yaw);
        float cosRoll = (float)Math.cos(roll);
        float cosPitch = (float)Math.cos(pitch);
        float cosYaw = (float)Math.cos(yaw);
        this.m[0][0] = cosYaw * cosPitch;
        this.m[0][1] = cosYaw * sinPitch * sinRoll - sinYaw * cosRoll;
        this.m[0][2] = cosYaw * sinPitch * cosRoll + sinYaw * sinRoll;
        this.m[1][0] = sinYaw * cosPitch;
        this.m[1][1] = sinYaw * sinPitch * sinRoll + cosYaw * cosRoll;
        this.m[1][2] = sinYaw * sinPitch * cosRoll - cosYaw * sinRoll;
        this.m[2][0] = -sinPitch;
        this.m[2][1] = cosPitch * sinRoll;
        this.m[2][2] = cosPitch * cosRoll;
    }

    public void setTranslation(float x, float y, float z) {
        this.m[0][3] = x;
        this.m[1][3] = y;
        this.m[2][3] = z;
    }

    public void setupRotate(float roll, float pitch, float yaw) {
        this.setRotation(roll, pitch, yaw);
        this.setTranslation(0.0f, 0.0f, 0.0f);
        this.m[3][0] = 0.0f;
        this.m[3][1] = 0.0f;
        this.m[3][2] = 0.0f;
        this.m[3][3] = 1.0f;
    }

    public void setupRotate(float angle, float x, float y, float z) {
        this.setupRotate(x * angle, y * angle, z * angle);
    }

    public void setupRotate(float angle, Vector3f n) {
        this.setupRotate(angle, n.x, n.y, n.z);
    }

    public Vector3f rotate(Vector3f dst, Vector3f src) {
        float x = src.x * this.m[0][0] + src.y * this.m[0][1] + src.z * this.m[0][2] + this.m[0][3];
        float y = src.x * this.m[1][0] + src.y * this.m[1][1] + src.z * this.m[1][2] + this.m[1][3];
        float z = src.x * this.m[2][0] + src.y * this.m[2][1] + src.z * this.m[2][2] + this.m[2][3];
        dst.x = x;
        dst.y = y;
        dst.z = z;
        return dst;
    }

    public void setupRotation(Vector3f a, float s, float c) {
        float t = 1.0f - c;
        this.m[0][0] = c + a.x * a.x * t;
        this.m[1][1] = c + a.y * a.y * t;
        this.m[2][2] = c + a.z * a.z * t;
        float tmp1 = a.x * a.y * t;
        float tmp2 = a.z * s;
        this.m[1][0] = tmp1 + tmp2;
        this.m[0][1] = tmp1 - tmp2;
        tmp1 = a.x * a.z * t;
        tmp2 = a.y * s;
        this.m[2][0] = tmp1 - tmp2;
        this.m[0][2] = tmp1 + tmp2;
        tmp1 = a.y * a.z * t;
        tmp2 = a.x * s;
        this.m[2][1] = tmp1 + tmp2;
        this.m[1][2] = tmp1 - tmp2;
        this.m[2][3] = 0.0f;
        this.m[1][3] = 0.0f;
        this.m[0][3] = 0.0f;
        this.m[3][2] = 0.0f;
        this.m[3][1] = 0.0f;
        this.m[3][0] = 0.0f;
        this.m[3][3] = 1.0f;
    }

    public void transform(Vector3f dst, Vector3f v) {
        float x = v.x * this.m[0][0] + v.y * this.m[0][1] + v.z * this.m[0][2] + this.m[0][3];
        float y = v.x * this.m[1][0] + v.y * this.m[1][1] + v.z * this.m[1][2] + this.m[1][3];
        float z = v.x * this.m[2][0] + v.y * this.m[2][1] + v.z * this.m[2][2] + this.m[2][3];
        dst.x = x;
        dst.y = y;
        dst.z = z;
    }

    public Matrix4f() {
        this.setIdentity();
    }
}

