/*
 * Decompiled with CFR 0.152.
 */
package com.gamelion.speedx.menu;

import com.gamelion.speedx.Debug;
import com.gamelion.speedx.IFont;
import com.gamelion.speedx.IGameState;
import com.gamelion.speedx.Settings;
import com.gamelion.speedx.SpeedXMIDlet;
import com.gamelion.speedx.menu.Dialog;
import com.gamelion.speedx.menu.IDialogListener;
import com.gamelion.speedx.menu.IOptionIds;
import com.gamelion.speedx.menu.IOptionsListListener;
import com.gamelion.speedx.menu.LabelsAtlas;
import com.gamelion.speedx.menu.OptionsList;
import com.gamelion.speedx.menu.Particles;
import com.gamelion.speedx.textdisplay.RichTextDisplay;
import java.io.InputStream;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import javax.microedition.m3g.Background;
import javax.microedition.m3g.Camera;
import javax.microedition.m3g.Graphics3D;
import javax.microedition.m3g.Transform;
import javax.microedition.media.Manager;
import javax.microedition.media.Player;

public class Menu
implements IGameState,
IOptionsListListener,
IDialogListener,
IOptionIds {
    private static final int TEXT_WIDTH = 200;
    private static final int TEXT_HEIGHT = 200;
    private static final int LOGO_Y = 20;
    private static final int STATE_NONE = -1;
    private static final int STATE_MAIN = 0;
    private static final int STATE_OPTIONS = 1;
    private static final int STATE_DIFFICULTY = 2;
    private static final int STATE_HELP = 3;
    private static final int STATE_ABOUT = 4;
    private static final int STATE_SOUND_QUESTION = 5;
    private SpeedXMIDlet midlet;
    private int state;
    private int newState;
    private int nextState;
    private Graphics3D graphics3d;
    private int screenWidth;
    private int screenHeight;
    private Background background;
    private Particles particles;
    private Camera perspectiveCamera;
    private Transform perspectiveCameraTransform;
    private Camera parallelCamera;
    private Transform parallelCameraTransform;
    private OptionsList mainMenu;
    private OptionsList difficultiesMenu;
    private OptionsList optionsMenu;
    private OptionsList currentMenu;
    private OptionsList enableSoundsMenu;
    private Dialog dialog;
    private RichTextDisplay helpText;
    private RichTextDisplay aboutText;
    private Image logo;
    private boolean firstRun = true;
    private Player msxPlayer;
    private boolean startGame;
    private int difficulty;

    public Menu(SpeedXMIDlet midlet) {
        this.midlet = midlet;
    }

    public void onEnter() {
        this.state = -1;
        this.startGame = false;
        if (this.firstRun) {
            this.midlet.soundPool().setEnabled(false);
            this.setState(5);
            this.firstRun = false;
        } else {
            this.setState(0);
        }
    }

    public void onLeave() {
    }

    public void onUpdate(float dt) {
        this.updateStateChanges();
        this.particles.onUpdate(dt);
        if (this.currentMenu != null) {
            this.currentMenu.update(dt);
        } else {
            this.dialog.update(dt);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onRepaint(Graphics g) {
        try {
            this.graphics3d.bindTarget((Object)g);
            this.graphics3d.clear(this.background);
            this.graphics3d.setCamera(this.perspectiveCamera, this.perspectiveCameraTransform);
            this.particles.onRepaint(this.graphics3d);
            this.graphics3d.setCamera(this.parallelCamera, this.parallelCameraTransform);
            if (this.currentMenu != null) {
                this.currentMenu.render(this.graphics3d);
            }
        }
        finally {
            this.graphics3d.releaseTarget();
        }
        g.drawImage(this.logo, this.screenWidth / 2, 20, 17);
        if (this.currentMenu == null) {
            this.dialog.render(g);
        }
    }

    public void onPointerPressed(int x, int y) {
        if (this.currentMenu != null) {
            this.currentMenu.onPointerPressed(x, y);
        } else {
            this.dialog.onPointerPressed(x, y);
        }
    }

    public void onPointerDragged(int x, int y) {
        if (this.currentMenu != null) {
            this.currentMenu.onPointerDragged(x, y);
        } else {
            this.dialog.onPointerDragged(x, y);
        }
    }

    public void onPointerReleased(int x, int y) {
        if (this.currentMenu != null) {
            this.currentMenu.onPointerReleased(x, y);
        } else {
            this.dialog.onPointerReleased(x, y);
        }
    }

    public void onKeyPressed(int code) {
    }

    public void onKeyReleased(int code) {
        if (this.currentMenu != null) {
            this.currentMenu.onKeyReleased(code);
        } else {
            this.dialog.onKeyReleased(code);
        }
    }

    public void onFocusChanged(boolean focused) {
    }

    public void onOptionClicked(int id) {
        if (id == 0) {
            this.nextState = 0;
        }
        if (id == 2) {
            this.nextState = 1;
        } else if (id == 1) {
            this.nextState = 2;
        } else if (id == 4) {
            this.nextState = 4;
        } else if (id == 3) {
            this.nextState = 3;
        } else if (id == 6) {
            this.midlet.stop();
        } else if (id == 10) {
            this.startGame = true;
            this.difficulty = 0;
        } else if (id == 11) {
            this.startGame = true;
            this.difficulty = 1;
        } else if (id == 12) {
            this.startGame = true;
            this.difficulty = 2;
        } else if (id == 13) {
            this.startGame = true;
            this.difficulty = 3;
        } else if (id == 30) {
            this.midlet.markAfterSoundQuestion();
            Settings settings = this.midlet.settings();
            settings.setSoundState(true);
            settings.setMusicState(true);
            this.optionsMenu.setOptionState(20, true);
            this.optionsMenu.setOptionState(21, true);
            this.midlet.soundPool().setEnabled(true);
            this.nextState = 0;
            this.startAudio();
        } else if (id == 31) {
            this.midlet.markAfterSoundQuestion();
            Settings settings = this.midlet.settings();
            settings.setSoundState(false);
            settings.setMusicState(false);
            this.midlet.soundPool().setEnabled(false);
            this.optionsMenu.setOptionState(20, false);
            this.optionsMenu.setOptionState(21, false);
            this.nextState = 0;
        }
        this.playClick();
        if (this.currentMenu != null) {
            this.currentMenu.hide(-1);
        }
    }

    public void onOptionStateChanged(int id, boolean state) {
        Settings settings = this.midlet.settings();
        if (id == 20) {
            settings.setSoundState(state);
            this.midlet.soundPool().setEnabled(state);
        } else if (id == 21) {
            settings.setMusicState(state);
            if (state) {
                this.startAudio();
            } else {
                this.stopAudio();
            }
        } else if (id == 22) {
            settings.setVibrationsState(state);
        } else if (id == 23) {
            settings.setInvertState(state);
        } else if (id == 24) {
            // empty if block
        }
        this.playClick();
    }

    public void onOptionIndexChanged(int id, int index) {
        this.playClick();
        if (id == 25) {
            this.midlet.settings().setSensitivity(index);
        }
    }

    public void onMenuVisible() {
    }

    public void onMenuHidden() {
        if (this.startGame) {
            this.midlet.startGame(this.difficulty);
        } else {
            this.setState(this.nextState);
        }
    }

    public void onDialogClosed() {
        this.setState(0);
    }

    public void setup() {
        Debug.trace("Menu setup");
        this.loadImages();
        this.setupM3g();
        this.setupCameras();
        this.particles = new Particles(this.midlet.texturePool().getTexture("particle"));
        this.createMenuPanes();
        this.createTextPanes();
    }

    private void setupM3g() {
        this.graphics3d = Graphics3D.getInstance();
        this.background = new Background();
        this.background.setColor(0);
        this.background.setColorClearEnable(true);
        this.background.setDepthClearEnable(true);
    }

    private void setupCameras() {
        this.perspectiveCamera = new Camera();
        this.screenWidth = this.midlet.canvas().getWidth();
        this.screenHeight = this.midlet.canvas().getHeight();
        float aspect = (float)this.screenWidth / (float)this.screenHeight;
        this.perspectiveCamera.setPerspective(80.0f, aspect, 0.05f, 80.0f);
        this.perspectiveCameraTransform = new Transform();
        this.perspectiveCameraTransform.postScale(1.0f, 1.0f, -1.0f);
        this.parallelCamera = new Camera();
        this.parallelCamera.setParallel((float)this.screenHeight, aspect, 0.05f, 80.0f);
        this.parallelCameraTransform = new Transform();
        this.parallelCameraTransform.postTranslate((float)(this.screenWidth / 2), (float)(this.screenHeight / 2), 0.0f);
        this.parallelCameraTransform.postScale(1.0f, -1.0f, -1.0f);
    }

    private void loadImages() {
        try {
            this.logo = Image.createImage((String)"/logo.png");
        }
        catch (Exception ex) {
            Debug.error(ex, "Failed to load menu images");
        }
    }

    private void createMenuPanes() {
        LabelsAtlas atlas = this.midlet.labelsAtlas();
        IFont optionsFont = this.midlet.fontPool().getFont("options");
        int menuTop = this.logo.getHeight() + 40;
        this.mainMenu = new OptionsList(atlas, this, menuTop, optionsFont);
        this.mainMenu.addOption(1, "new game");
        this.mainMenu.addOption(2, "options");
        this.mainMenu.addOption(3, "help");
        this.mainMenu.addOption(4, "about");
        this.mainMenu.addOption(6, "exit");
        this.difficultiesMenu = new OptionsList(atlas, this, menuTop, optionsFont);
        this.difficultiesMenu.addOption(10, "casual");
        this.difficultiesMenu.addOption(11, "easy");
        this.difficultiesMenu.addOption(12, "standard");
        this.difficultiesMenu.addOption(13, "extreme");
        this.difficultiesMenu.addOption(0, "back");
        Settings settings = this.midlet.settings();
        this.optionsMenu = new OptionsList(atlas, this, menuTop, optionsFont);
        this.optionsMenu.addOption(20, "sounds", settings.soundEnabled());
        this.optionsMenu.addOption(21, "music", settings.musicEnabled());
        this.optionsMenu.addOption(22, "vibrations", settings.vibrationsEnabled());
        this.optionsMenu.addOption(0, "back");
        this.enableSoundsMenu = new OptionsList(atlas, this, 160, optionsFont);
        this.enableSoundsMenu.addOption(30, "yes");
        this.enableSoundsMenu.addOption(31, "no");
        this.enableSoundsMenu.setTitle("use sounds?");
        this.helpText = new RichTextDisplay();
        this.helpText.setFontPool(this.midlet.fontPool());
        this.helpText.layout(this.helpText(), 200);
        this.aboutText = new RichTextDisplay();
        this.aboutText.setFontPool(this.midlet.fontPool());
        this.aboutText.layout(this.aboutText(), 200);
    }

    private void createTextPanes() {
        this.dialog = new Dialog(this);
    }

    private void setState(int newState) {
        this.newState = newState;
    }

    private void updateStateChanges() {
        if (this.newState == -1) {
            return;
        }
        this.state = this.newState;
        this.newState = -1;
        switch (this.state) {
            case 0: {
                this.currentMenu = this.mainMenu;
                break;
            }
            case 1: {
                this.currentMenu = this.optionsMenu;
                break;
            }
            case 2: {
                this.currentMenu = this.difficultiesMenu;
                break;
            }
            case 3: {
                this.currentMenu = null;
                this.dialog.setTitle("Help", this.midlet.fontPool().getFont("options"));
                this.dialog.setContent(this.helpText);
                break;
            }
            case 4: {
                this.currentMenu = null;
                this.dialog.setTitle("About", this.midlet.fontPool().getFont("options"));
                this.dialog.setContent(this.aboutText);
                break;
            }
            case 5: {
                this.currentMenu = this.enableSoundsMenu;
            }
        }
        if (this.currentMenu != null) {
            this.currentMenu.show();
        } else {
            this.dialog.open(200, 200);
        }
    }

    public void startAudio() {
        try {
            if (this.midlet.settings().musicEnabled()) {
                this.msxPlayer = Manager.createPlayer((InputStream)this.getClass().getResourceAsStream("/msx.mid"), (String)"audio/midi");
                this.msxPlayer.setLoopCount(-1);
                this.msxPlayer.start();
            }
        }
        catch (Exception ex) {
            Debug.error(ex, "Failed to start music");
        }
    }

    public void stopAudio() {
        try {
            if (this.msxPlayer != null) {
                this.msxPlayer.stop();
                this.msxPlayer.deallocate();
                this.msxPlayer = null;
            }
        }
        catch (Exception ex) {
            Debug.error("Failed to stop music");
        }
    }

    private void playClick() {
        this.midlet.soundPool().play("click");
    }

    private String helpText() {
        return "[font options][align left] Game rules[break][font small] [break][font small] [align justify]The objective of the game is to survive as long as possible.[break]You steer your ship left by tapping the left side of screen or pressing the [lbracket]4[rbracket] key.[break]You steer your ship right by tapping the right side of screen or pressing the [lbracket]6[rbracket] key.[break][break]Avoid obstacles and the track edge. Collect bonuses and shields.[break][break]Activate bonuses by tapping the icon in upper left corner or by pressing the [lbracket]1[rbracket] key. You can use a bonus only once and have one at a time. Shields are activated automatically.[break]During each race there are also hazard zones. See below for the complete list. You can also pause the game by tapping the pause icon or by pressing the [lbracket]3[rbracket] key.[break][font options][break]Bonuses[break][font small][break][font medium]Shield[break][font small]Orange fields. Can be used to destroy obstacles. One shield is needed to break a cube obstacle, two are required to destroy a beam. Shields deplete with time. Player can hold up to four shields.[break][break][font medium]Quake[break][font small]Red fields. Destroy all visible obstacles when activated.[break][break][font medium]Time dilatation[break][font small]Blue fields. Slows down the game.[break][break][font medium]Space fold[break][font small]Green fields. End hazard zones when activated. If triggered outside hazard zone, this bonus has no effect.[break][break][font options]Hazard zones[break][font small][break][font medium]Blackout[break][font small]Tunnel is rendered in negative, trails are not visible.[break][break][font medium]Gravity well[break][font small]Visibility is very limited, vision is distorted, external force makes it necessary to adjust movements.[break][break][font medium]Dark nebula[break][font small]Cubes are in negative, tunnel intensity changes over time.[break][break][font medium]Hue shift[break][font small]Full of different colors.[break][break][font medium]Plasma cloud[break][font small]You can encounter a plasma vortex here. A collision with such an obstacle takes away one shield and resets any bonus.";
    }

    private String aboutText() {
        return "[align center]SpeedX 3D [break][align center]ver. " + this.midlet.version() + "[break]" + "[align left]Created by" + "[align center]Bytestorm.pl" + "[break]" + "[align left]Developed" + "[align left]and published by" + "[align center]Gamelion Studios";
    }
}

