/*
 * Decompiled with CFR 0.152.
 */
package de.mef.menu;

import de.mef.menu.Anchored;
import de.mef.menu.Scrollable;
import de.mef.util.Handset;
import de.mef.util.KeyListener;
import de.mef.util.Refreshable;
import java.util.Vector;
import javax.microedition.lcdui.Graphics;

public final class ScrollBox
extends Anchored
implements Refreshable,
Scrollable,
KeyListener {
    private Vector content;
    private int contentHeight;
    private int contentWidth;
    private int scrollX;
    private int scrollY;
    private int intervalStart;
    private int intervalEnd;
    private int intervalY;
    private int scrollSpeed = DEFAULT_SCROLL_SPEED;
    private int alignment;
    public static int DEFAULT_SCROLL_SPEED = 12;

    private void calcInterval() {
        int n;
        int n2 = 0;
        this.intervalStart = 0;
        this.intervalEnd = this.content.size();
        for (n = 0; n < this.content.size(); ++n) {
            this.intervalY = n2;
            if ((n2 += ((Anchored)this.content.elementAt(n)).getHeight()) <= this.scrollY) continue;
            this.intervalStart = n;
            break;
        }
        n2 = 0;
        ++n;
        while (n < this.content.size()) {
            if ((n2 += ((Anchored)this.content.elementAt(n)).getHeight()) > this.height) {
                this.intervalEnd = n + 1;
                return;
            }
            ++n;
        }
    }

    private void calcDimensions() {
        this.contentHeight = 0;
        this.contentWidth = 0;
        for (int i = 0; i < this.content.size(); ++i) {
            Anchored anchored = (Anchored)this.content.elementAt(i);
            if (this.contentWidth < anchored.getWidth()) {
                this.contentWidth = anchored.getWidth();
            }
            this.contentHeight += anchored.getHeight();
        }
    }

    public final void addElement(Anchored anchored) {
        if (anchored != null) {
            this.content.addElement(anchored);
        }
        this.calcDimensions();
        this.calcInterval();
    }

    public final void keyPressed(int n) {
        if (n == Handset.LEFT || n == Handset.NUM4) {
            this.scroll(4);
        }
        if (n == Handset.RIGHT || n == Handset.NUM6) {
            this.scroll(8);
        }
        if (n == Handset.UP || n == Handset.NUM2) {
            this.scroll(2);
        }
        if (n == Handset.DOWN || n == Handset.NUM8) {
            this.scroll(1);
        }
    }

    public final void keyReleased(int n) {
    }

    public final void keyRepeated(int n) {
        this.keyPressed(n);
    }

    public ScrollBox(int n, int n2) {
        this.width = n;
        this.height = n2;
        this.content = new Vector(32, 32);
        this.scrollSpeed = 12;
        this.alignment = 20;
    }

    public final void scrollTo(int n, int n2) {
        this.scrollX = n;
        this.scrollY = n2;
        if (this.scrollX > this.contentWidth - this.width) {
            this.scrollX = this.contentWidth - this.width;
        }
        if (this.scrollX < 0) {
            this.scrollX = 0;
        }
        if (this.scrollY > this.contentHeight - this.height) {
            this.scrollY = this.contentHeight - this.height;
        }
        if (this.scrollY < 0) {
            this.scrollY = 0;
        }
        this.calcInterval();
    }

    public final void refresh() {
        for (int i = 0; i < this.content.size(); ++i) {
            ((Anchored)this.content.elementAt(i)).refresh();
        }
        this.scrollTo(0, 0);
        this.calcDimensions();
        this.calcInterval();
    }

    protected final void display(Graphics graphics) {
        int n = this.intervalY;
        int n2 = graphics.getClipX();
        int n3 = graphics.getClipY();
        int n4 = graphics.getClipWidth();
        int n5 = graphics.getClipHeight();
        graphics.setClip(0, 0, this.width, this.height);
        graphics.translate(-this.scrollX, -this.scrollY);
        for (int i = this.intervalStart; i < this.intervalEnd; ++i) {
            int n6;
            int n7;
            int n8;
            Graphics graphics2;
            Anchored anchored;
            Anchored anchored2 = (Anchored)this.content.elementAt(i);
            switch (this.alignment & 0xD) {
                case 1: {
                    anchored = anchored2;
                    graphics2 = graphics;
                    n8 = this.width / 2;
                    n7 = n;
                    n6 = 17;
                    break;
                }
                case 8: {
                    anchored = anchored2;
                    graphics2 = graphics;
                    n8 = this.width;
                    n7 = n;
                    n6 = 24;
                    break;
                }
                default: {
                    anchored = anchored2;
                    graphics2 = graphics;
                    n8 = 0;
                    n7 = n;
                    n6 = 20;
                }
            }
            anchored.paint(graphics2, n8, n7, n6);
            n += anchored2.getHeight();
        }
        graphics.translate(this.scrollX, this.scrollY);
        graphics.setClip(n2, n3, n4, n5);
        if (Anchored.DEBUG) {
            graphics.setFont(Handset.fnt_small);
            graphics.setColor(0xFFFF00);
            graphics.drawString(this.intervalStart + " - " + this.intervalEnd, this.width / 2, this.height / 2, 17);
        }
    }

    public final void setAlignment(int n) {
        this.alignment = n;
    }

    public final int getScrollX() {
        return this.scrollX;
    }

    public final int getScrollY() {
        return this.scrollY;
    }

    public final int getRangeX() {
        return this.contentWidth;
    }

    public final int getRangeY() {
        return this.contentHeight;
    }

    public final int getWindowX() {
        return this.width;
    }

    public final int getWindowY() {
        return this.height;
    }

    private void scroll(int n) {
        if ((n & 4) != 0) {
            this.scrollX -= this.scrollSpeed;
        }
        if ((n & 8) != 0) {
            this.scrollX += this.scrollSpeed;
        }
        if ((n & 1) != 0) {
            this.scrollY += this.scrollSpeed;
        }
        if ((n & 2) != 0) {
            this.scrollY -= this.scrollSpeed;
        }
        if (this.scrollX > this.contentWidth - this.width) {
            this.scrollX = this.contentWidth - this.width;
        }
        if (this.scrollX < 0) {
            this.scrollX = 0;
        }
        if (this.scrollY > this.contentHeight - this.height) {
            this.scrollY = this.contentHeight - this.height;
        }
        if (this.scrollY < 0) {
            this.scrollY = 0;
        }
        this.calcInterval();
    }
}

