/*
 * Decompiled with CFR 0.152.
 */
package com.renderedideas.game;

import com.renderedideas.game.PrintConsole;
import java.io.InputStream;
import javax.microedition.media.Manager;
import javax.microedition.media.Player;
import javax.microedition.media.control.VolumeControl;

public class Sound {
    Player player;
    int volume;
    String path;
    int loopCount;
    boolean isReloaded;
    static /* synthetic */ Class class$com$renderedideas$game$Sound;

    public static int maxPrefetchedPlayers() {
        int i;
        int count = 0;
        Player[] players = new Player[20];
        for (i = 0; i < players.length; ++i) {
            try {
                InputStream in = null;
                in = (class$com$renderedideas$game$Sound == null ? Sound.class$("com.renderedideas.game.Sound") : class$com$renderedideas$game$Sound).getResourceAsStream("/audio/coin.wav");
                players[i] = Manager.createPlayer((InputStream)in, (String)"audio/x-wav");
                players[i].realize();
                players[i].prefetch();
                ++count;
                continue;
            }
            catch (Exception e2) {
                if (e2.toString().toLowerCase().indexOf("maximum") != -1) break;
            }
        }
        for (i = 0; i < count; ++i) {
            players[i].deallocate();
            players[i].close();
            players[i] = null;
        }
        players = null;
        return count;
    }

    public Sound(int volume, String path, int loopCount) {
        this.volume = volume;
        this.path = path;
        this.loopCount = loopCount;
        this.isReloaded = false;
        this.load(volume, path, loopCount);
    }

    public boolean load(int soundVolume, String filePath, int loopCount) {
        try {
            String protocol;
            String format;
            InputStream in = null;
            VolumeControl vc = null;
            if (filePath.endsWith("click") || filePath.endsWith("skid") || filePath.endsWith("hit") || filePath.endsWith("coin") || filePath.endsWith("cop_siren") || filePath.endsWith("chatter")) {
                format = ".wav";
                protocol = "audio/x-wav";
            } else if (this.isAudioFormatSupported("audio/x-ms-wma")) {
                format = ".wma";
                protocol = "audio/x-ms-wma";
            } else if (this.isAudioFormatSupported("audio/m4a")) {
                format = ".aac";
                protocol = "audio/m4a";
            } else if (this.isAudioFormatSupported("audio/aac")) {
                format = ".aac";
                protocol = "audio/aac";
            } else {
                return false;
            }
            in = (class$com$renderedideas$game$Sound == null ? (class$com$renderedideas$game$Sound = Sound.class$("com.renderedideas.game.Sound")) : class$com$renderedideas$game$Sound).getResourceAsStream(filePath + format);
            this.player = Manager.createPlayer((InputStream)in, (String)protocol);
            this.player.setLoopCount(loopCount);
            this.player.realize();
            vc = (VolumeControl)this.player.getControl("VolumeControl");
            if (vc != null) {
                vc.setLevel(soundVolume);
            }
            this.player.prefetch();
            vc = null;
            return true;
        }
        catch (Exception e2) {
            PrintConsole.print("errorSoundLoad->Sound:" + e2);
            return false;
        }
    }

    public void reload() {
        this.unload();
        this.load(this.volume, this.path, this.loopCount);
    }

    public boolean unload() {
        try {
            if (this.player != null) {
                if (this.player.getState() == 400) {
                    this.player.stop();
                }
                this.player.deallocate();
                this.player.close();
                this.player = null;
                System.gc();
            }
            return true;
        }
        catch (Exception e2) {
            PrintConsole.print("errorSoundUnload->Sound:" + e2);
            return false;
        }
    }

    public void play() {
        Thread t = new Thread(new Runnable(){

            public void run() {
                try {
                    Sound.this.player.start();
                    Sound.this.isReloaded = false;
                }
                catch (Exception e2) {
                    PrintConsole.print("errorSoundPlay->Sound:" + e2);
                    if (!Sound.this.isReloaded) {
                        Sound.this.reload();
                        Sound.this.isReloaded = true;
                        Sound.this.play();
                    }
                    Sound.this.isReloaded = false;
                }
            }
        });
        t.start();
    }

    public void stop() {
        Thread t = new Thread(new Runnable(){

            public void run() {
                try {
                    if (Sound.this.player.getState() == 400) {
                        Sound.this.player.stop();
                    }
                }
                catch (Exception e2) {
                    PrintConsole.print("errorSoundStop->Sound:" + e2);
                }
            }
        });
        t.start();
    }

    public boolean isAudioFormatSupported(String str) {
        String[] formats = Manager.getSupportedContentTypes(null);
        for (int i = 0; i < formats.length; ++i) {
            if (!str.trim().equalsIgnoreCase(formats[i].trim())) continue;
            return true;
        }
        return false;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

