/*
 * Decompiled with CFR 0.152.
 */
package com.renderedideas.superbike3d;

import com.renderedideas.game.Bitmap;
import com.renderedideas.game.PrintConsole;
import javax.microedition.lcdui.Graphics;

public class ImageSet {
    int totalStates;
    Bitmap[][] stateFrames;
    int[] stateAnimTime;

    public ImageSet(int numStates) {
        this.stateAnimTime = new int[numStates];
        this.stateFrames = new Bitmap[numStates][];
    }

    public final void addState(Bitmap[] frames, int animTime) {
        int state = this.totalStates++;
        this.stateAnimTime[state] = animTime;
        this.stateFrames[state] = frames;
    }

    public static final void draw(Graphics target, Bitmap image, int targetX, int targetY) {
        Bitmap.drawBitmap(target, image, targetX, targetY);
    }

    public static final Bitmap loadClippedImage(String filename, int originX, int originY, int width, int height) {
        Bitmap fileImage = ImageSet.loadImage(filename);
        return ImageSet.getImageRegion(fileImage, originX, originY, width, height);
    }

    public static final Bitmap loadClippedImage(String filename, int originX, int originY) {
        Bitmap fileImage = ImageSet.loadImage(filename);
        if (originX == 0 && originY == 0) {
            return fileImage;
        }
        return ImageSet.getImageRegion(fileImage, originX, originY, fileImage.getWidth(), fileImage.getHeight());
    }

    public static final Bitmap getImageRegion(Bitmap source, int x, int y, int width, int height) {
        int[] rgb = new int[width * height];
        source.getRGB(rgb, 0, width, x, y, width, height);
        if (x + width > source.getWidth() || y + height > source.getHeight()) {
            PrintConsole.print("Warning: attempting extract using (" + x + "," + y + "," + width + "," + height + ") when image is " + "(" + source.getWidth() + "," + source.getHeight() + ")");
        }
        Bitmap result = Bitmap.createRGBImage(rgb, width, height, true);
        return result;
    }

    public static final Bitmap[] extractFrames(Bitmap sourceImage, int sourceX, int sourceY, int framesWide, int framesHigh, int frameWidth, int frameHeight) {
        Bitmap[] frames = new Bitmap[framesWide * framesHigh];
        int frameCount = 0;
        for (int fy = 0; fy < framesHigh; ++fy) {
            for (int fx = 0; fx < framesWide; ++fx) {
                frames[frameCount++] = ImageSet.getImageRegion(sourceImage, sourceX + fx * frameWidth, sourceY + fy * frameHeight, frameWidth, frameHeight);
            }
        }
        return frames;
    }

    public static final Bitmap loadImage(String fname) {
        return new Bitmap(fname);
    }
}

