/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.phone.ri.sensor;

import com.nokia.mid.appl.sa.tool.Log;
import com.nokia.phone.ri.sensor.SensorManagerImpl;
import com.nokia.sensor.interfaces.ChannelInfo;
import com.nokia.sensor.interfaces.Data;

final class DataImpl
implements Data {
    private int bufferSize;
    private final ChannelInfo channel;
    private boolean isTimestampIncluded = false;
    private boolean isUncertaintyIncluded = false;
    private boolean isValidityIncluded = false;
    private int last = 0;
    private long startTime;
    private double[] doubleValues = new double[0];
    private int[] intValues = new int[0];
    private Object[] objectValues = new Object[0];
    private int[] timestamps = new int[0];
    private SimpleBitSet validities = null;

    DataImpl(ChannelInfo channel) {
        this.channel = channel;
    }

    DataImpl(ChannelInfo channel, int bufferSize, boolean isTimestampIncluded, boolean isUncertaintyIncluded, boolean isValidityIncluded) {
        this.channel = channel;
        this.bufferSize = bufferSize;
        switch (channel.getDataType()) {
            case 1: {
                this.doubleValues = new double[bufferSize];
                break;
            }
            case 2: {
                this.intValues = new int[bufferSize];
                break;
            }
            default: {
                this.objectValues = new Object[bufferSize];
            }
        }
        this.isTimestampIncluded = isTimestampIncluded;
        if (isTimestampIncluded) {
            this.timestamps = new int[bufferSize];
        }
        this.isUncertaintyIncluded = isUncertaintyIncluded;
        this.isValidityIncluded = isValidityIncluded;
        if (isValidityIncluded) {
            this.validities = new SimpleBitSet(bufferSize);
        }
    }

    DataImpl(ChannelInfo channel, Object values, int[] timestamps, boolean[] validities) {
        this.channel = channel;
        this.bufferSize = 1;
        this.timestamps = timestamps;
        int l2 = validities.length;
        this.validities = new SimpleBitSet(l2);
        int i2 = 0;
        while (i2 < l2) {
            if (validities[i2]) {
                this.validities.set(i2);
            } else {
                this.validities.clear(i2);
            }
            ++i2;
        }
        if (values instanceof int[]) {
            this.intValues = (int[])values;
            return;
        }
        if (values instanceof double[]) {
            this.doubleValues = (double[])values;
            return;
        }
        this.objectValues = (Object[])values;
    }

    DataImpl(ChannelInfo channel, Object values, long startTime, int[] timestamps, boolean[] validities) {
        this.channel = channel;
        this.startTime = startTime;
        this.bufferSize = 1;
        this.timestamps = timestamps;
        this.isTimestampIncluded = true;
        this.isUncertaintyIncluded = true;
        this.isValidityIncluded = true;
        int l2 = validities.length;
        this.validities = new SimpleBitSet(l2);
        int i2 = 0;
        while (i2 < l2) {
            if (validities[i2]) {
                this.validities.set(i2);
            } else {
                this.validities.clear(i2);
            }
            ++i2;
        }
        if (values instanceof int[]) {
            this.intValues = (int[])values;
            return;
        }
        if (values instanceof double[]) {
            this.doubleValues = (double[])values;
            return;
        }
        this.objectValues = (Object[])values;
    }

    public ChannelInfo getChannelInfo() {
        return this.channel;
    }

    public double[] getDoubleValues() {
        if (this.getChannelInfo().getDataType() != 1) {
            throw new IllegalStateException("getDoubleValues() called - call " + this.getRightMethod() + " instead.");
        }
        return this.doubleValues;
    }

    public int[] getIntValues() {
        if (this.getChannelInfo().getDataType() != 2) {
            throw new IllegalStateException();
        }
        return this.intValues;
    }

    public long getTimestamp(int index) {
        if (!this.isTimestampIncluded()) {
            throw new IllegalStateException("Timestamp cannot be got");
        }
        if (this.timestamps.length - 1 < index) {
            throw new IndexOutOfBoundsException();
        }
        return this.startTime + (long)this.timestamps[index];
    }

    public float getUncertainty(int index) {
        if (!this.isUncertaintyIncluded()) {
            throw new IllegalStateException("Uncertainty cannot be got");
        }
        switch (this.channel.getDataType()) {
            case 1: {
                return (float)Math.abs((double)this.channel.getAccuracy() * this.doubleValues[index]);
            }
            case 2: {
                return Math.abs(this.channel.getAccuracy() * (float)this.intValues[index]);
            }
        }
        return -1.0f;
    }

    public Object[] getObjectValues() {
        if (this.getChannelInfo().getDataType() != 4) {
            throw new IllegalStateException();
        }
        return this.objectValues;
    }

    public boolean isValid(int index) {
        if (!this.isValidityIncluded()) {
            throw new IllegalStateException("Validity cannot be got.");
        }
        if (index == -1) {
            throw new IndexOutOfBoundsException("Data.isValid() called with index -1");
        }
        if (this.validities.getSize() - 1 < index) {
            throw new IndexOutOfBoundsException("Data.isValid() called with index " + index + ", however, there are " + this.validities.getSize() + " items.");
        }
        return this.validities.get(index);
    }

    void addDoubleValue(double value, boolean validity) {
        block7: {
            try {
                this.doubleValues[this.last] = value;
                if (this.last == 0) {
                    this.startTime = System.currentTimeMillis();
                }
                if (this.isTimestampIncluded) {
                    int n2 = this.timestamps[this.last] = this.last == 0 ? 0 : (int)(System.currentTimeMillis() - this.startTime);
                }
                if (this.isValidityIncluded) {
                    if (validity) {
                        this.validities.set(this.last);
                    } else {
                        this.validities.clear(this.last);
                    }
                }
                ++this.last;
            }
            catch (Exception e2) {
                if (!SensorManagerImpl.isDebug) break block7;
                Log.note("DataImpl:addDoubleValue to doubleValues at posistion " + this.last + " with max length " + this.doubleValues.length + ". " + e2.getMessage());
            }
        }
    }

    void addIntValue(int value, boolean validity) {
        this.intValues[this.last] = value;
        if (this.last == 0) {
            this.startTime = System.currentTimeMillis();
        }
        if (this.isTimestampIncluded) {
            int n2 = this.timestamps[this.last] = this.last == 0 ? 0 : (int)(System.currentTimeMillis() - this.startTime);
        }
        if (this.isValidityIncluded) {
            if (validity) {
                this.validities.set(this.last);
            } else {
                this.validities.clear(this.last);
            }
        }
        ++this.last;
    }

    void addObjectValue(Object value, float uncertainty, boolean validity) {
        this.objectValues[this.last] = value;
        if (this.last == 0) {
            this.startTime = System.currentTimeMillis();
        }
        if (this.isTimestampIncluded) {
            int n2 = this.timestamps[this.last] = this.last == 0 ? 0 : (int)(System.currentTimeMillis() - this.startTime);
        }
        if (this.isValidityIncluded) {
            if (validity) {
                this.validities.set(this.last);
            } else {
                this.validities.clear(this.last);
            }
        }
        ++this.last;
    }

    void set(int bufferSize, boolean isTimestampIncluded, boolean isUncertaintyIncluded, boolean isValidityIncluded) {
        if (!this.isChanged(bufferSize, isTimestampIncluded, isUncertaintyIncluded, isValidityIncluded)) {
            switch (this.channel.getDataType()) {
                case 2: {
                    int i2 = 0;
                    while (i2 < bufferSize) {
                        this.intValues[i2] = 0;
                        if (isValidityIncluded) {
                            if (this.validities == null) {
                                this.validities = new SimpleBitSet();
                            } else {
                                this.validities.clear(i2);
                            }
                        }
                        ++i2;
                    }
                    break;
                }
                case 1: {
                    int i3 = 0;
                    while (i3 < bufferSize) {
                        this.doubleValues[i3] = 0.0;
                        if (isValidityIncluded) {
                            if (this.validities == null) {
                                this.validities = new SimpleBitSet();
                            } else {
                                this.validities.clear(i3);
                            }
                        }
                        ++i3;
                    }
                    break;
                }
                case 4: {
                    int i4 = 0;
                    while (i4 < bufferSize) {
                        this.objectValues[i4] = null;
                        if (isValidityIncluded) {
                            if (this.validities == null) {
                                this.validities = new SimpleBitSet();
                            } else {
                                this.validities.clear(i4);
                            }
                        }
                        ++i4;
                    }
                    break;
                }
            }
            return;
        }
        if (bufferSize != this.getBufferSize()) {
            this.setBufferSize(bufferSize);
            switch (this.channel.getDataType()) {
                case 2: {
                    this.intValues = new int[bufferSize];
                    break;
                }
                case 1: {
                    this.doubleValues = new double[bufferSize];
                    break;
                }
                case 4: {
                    this.objectValues = new Object[bufferSize];
                }
            }
            this.setTimestampIncluded(isTimestampIncluded);
            this.timestamps = new int[bufferSize];
            this.setUncertaintyIncluded(isUncertaintyIncluded);
            this.setValidityIncluded(isValidityIncluded);
            if (isValidityIncluded) {
                if (this.validities == null) {
                    this.validities = new SimpleBitSet(bufferSize);
                } else {
                    this.validities.setSize(bufferSize);
                    int i5 = 0;
                    while (i5 < bufferSize) {
                        this.validities.clear(i5);
                        ++i5;
                    }
                }
            }
            return;
        }
        if (isTimestampIncluded != this.isTimestampIncluded()) {
            this.setTimestampIncluded(isTimestampIncluded);
            if (isTimestampIncluded) {
                this.timestamps = new int[bufferSize];
            }
        }
        if (isUncertaintyIncluded != this.isUncertaintyIncluded()) {
            this.setUncertaintyIncluded(isUncertaintyIncluded);
        }
        if (isValidityIncluded != this.isValidityIncluded()) {
            this.setValidityIncluded(isValidityIncluded);
            if (isValidityIncluded) {
                if (this.validities == null) {
                    this.validities = new SimpleBitSet(bufferSize);
                } else {
                    this.validities.setSize(bufferSize);
                    int i6 = 0;
                    while (i6 < bufferSize) {
                        this.validities.clear(i6);
                        ++i6;
                    }
                }
            }
        }
    }

    synchronized void setLast(int last) {
        this.last = last;
    }

    void truncate() {
        if (this.last == this.bufferSize - 1) {
            return;
        }
        int dataType = this.channel.getDataType();
        switch (dataType) {
            case 1: {
                double[] tmpDoubleValues = new double[this.last];
                System.arraycopy(this.doubleValues, 0, tmpDoubleValues, 0, this.last);
                this.doubleValues = tmpDoubleValues;
                break;
            }
            case 2: {
                int[] tmpIntValues = new int[this.last];
                System.arraycopy(this.intValues, 0, tmpIntValues, 0, this.last);
                this.intValues = tmpIntValues;
                break;
            }
            case 4: {
                Object[] tmpValues = new Object[this.last];
                System.arraycopy(this.objectValues, 0, tmpValues, 0, this.last);
                this.objectValues = tmpValues;
            }
        }
        if (this.isTimestampIncluded) {
            int[] tmpTimestamps = new int[this.last];
            System.arraycopy(this.timestamps, 0, tmpTimestamps, 0, this.last);
            this.timestamps = tmpTimestamps;
        }
        if (this.isValidityIncluded) {
            this.validities.truncate(this.last);
        }
    }

    static DataImpl valueOf(ChannelInfo channel, Object value, int[] timestamps, boolean[] validities) {
        return new DataImpl(channel, value, timestamps, validities);
    }

    private synchronized int getBufferSize() {
        return this.bufferSize;
    }

    private String getRightMethod() {
        switch (this.channel.getDataType()) {
            case 2: {
                return "getIntValues()";
            }
            case 1: {
                return "getDoubleValues()";
            }
            case 4: {
                return "getObjectValues()";
            }
        }
        return "";
    }

    private boolean isChanged(int size, boolean isTimestampIncluded, boolean isUncertaintyIncluded, boolean isValidityIncluded) {
        if (size != this.getBufferSize()) {
            return true;
        }
        if (isTimestampIncluded != this.isTimestampIncluded()) {
            return true;
        }
        if (isUncertaintyIncluded != this.isUncertaintyIncluded()) {
            return true;
        }
        return isValidityIncluded ^ this.isValidityIncluded();
    }

    private synchronized boolean isTimestampIncluded() {
        return this.isTimestampIncluded;
    }

    private synchronized boolean isUncertaintyIncluded() {
        return this.isUncertaintyIncluded;
    }

    private synchronized boolean isValidityIncluded() {
        return this.isValidityIncluded;
    }

    private synchronized void setBufferSize(int bufferSize) {
        this.bufferSize = bufferSize;
    }

    private synchronized void setTimestampIncluded(boolean isTimestampIncluded) {
        this.isTimestampIncluded = isTimestampIncluded;
    }

    private synchronized void setUncertaintyIncluded(boolean isUncertaintyIncluded) {
        this.isUncertaintyIncluded = isUncertaintyIncluded;
    }

    private synchronized void setValidityIncluded(boolean isValidityIncluded) {
        this.isValidityIncluded = isValidityIncluded;
    }

    private static final class SimpleBitSet {
        private static final int BITS_PER_INT = 32;
        public static final int INITIAL_CAPACITY = 256;
        private int[] data;
        private int size;

        public SimpleBitSet() {
            this(256);
        }

        public SimpleBitSet(int count) {
            int num = count / 32;
            if (count % 32 != 0) {
                ++num;
            }
            this.data = new int[num];
            this.setSize(count);
        }

        public void clear(int n2) {
            if (n2 >= this.getSize()) {
                throw new IndexOutOfBoundsException("Bad bit number " + n2);
            }
            int index = n2 / 32;
            int offset = n2 % 32;
            int n3 = index;
            this.data[n3] = this.data[n3] & ~(1 << offset);
        }

        public boolean get(int n2) {
            if (n2 >= this.getSize()) {
                throw new IndexOutOfBoundsException("Bit number out of range");
            }
            int index = n2 / 32;
            int offset = n2 % 32;
            boolean value = (this.data[index] & 1 << offset) != 0;
            return value;
        }

        public int getCapacity() {
            return this.data.length * 32;
        }

        public int getSize() {
            return this.size;
        }

        public void set(int n2) {
            if (n2 >= this.getSize()) {
                throw new IndexOutOfBoundsException("Bad bit number " + n2);
            }
            int index = n2 / 32;
            int offset = n2 % 32;
            int n3 = index;
            this.data[n3] = this.data[n3] | 1 << offset;
        }

        void setSize(int sizeInBits) {
            this.size = sizeInBits;
        }

        void truncate(int n2) {
            if (n2 > this.getSize()) {
                return;
            }
            int num = n2 / 32;
            if (n2 % 32 != 0) {
                ++num;
            }
            int[] newData = new int[num];
            System.arraycopy(this.data, 0, newData, 0, num);
            this.data = newData;
            this.setSize(n2);
        }
    }
}

